/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.internal;

import java.io.Serializable;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrameWriterV2;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.NamedRelation;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.UnresolvedIdentifier;
import org.apache.spark.sql.catalyst.analysis.UnresolvedIdentifier$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.plans.logical.AppendData;
import org.apache.spark.sql.catalyst.plans.logical.AppendData$;
import org.apache.spark.sql.catalyst.plans.logical.CreateTableAsSelect;
import org.apache.spark.sql.catalyst.plans.logical.CreateTableAsSelect$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.OptionList;
import org.apache.spark.sql.catalyst.plans.logical.OverwriteByExpression;
import org.apache.spark.sql.catalyst.plans.logical.OverwriteByExpression$;
import org.apache.spark.sql.catalyst.plans.logical.OverwritePartitionsDynamic;
import org.apache.spark.sql.catalyst.plans.logical.OverwritePartitionsDynamic$;
import org.apache.spark.sql.catalyst.plans.logical.ReplaceTableAsSelect;
import org.apache.spark.sql.catalyst.plans.logical.ReplaceTableAsSelect$;
import org.apache.spark.sql.catalyst.plans.logical.TableSpecBase;
import org.apache.spark.sql.catalyst.plans.logical.UnresolvedTableSpec;
import org.apache.spark.sql.connector.catalog.TableWritePrivilege;
import org.apache.spark.sql.connector.expressions.ClusterByTransform;
import org.apache.spark.sql.connector.expressions.FieldReference$;
import org.apache.spark.sql.connector.expressions.LogicalExpressions$;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.QueryExecution$;
import org.apache.spark.sql.internal.PartitionTransform$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Experimental
@ScalaSignature(bytes="\u0006\u0005\t-c\u0001B\u0015+\u0005UB\u0001\"\u0013\u0001\u0003\u0002\u0003\u0006IA\u0013\u0005\t+\u0002\u0011\t\u0011)A\u0005-\"1\u0011\f\u0001C\u0001YiCqa\u0018\u0001C\u0002\u0013%\u0001\r\u0003\u0004q\u0001\u0001\u0006I!\u0019\u0005\bc\u0002\u0011\r\u0011\"\u0003s\u0011\u00191\b\u0001)A\u0005g\"9q\u000f\u0001b\u0001\n\u0013A\bbBA\u0002\u0001\u0001\u0006I!\u001f\u0005\n\u0003\u000b\u0001!\u0019!C\u0005\u0003\u000fA\u0001\"!\b\u0001A\u0003%\u0011\u0011\u0002\u0005\n\u0003?\u0001\u0001\u0019!C\u0005\u0003CA\u0011\"!\u000b\u0001\u0001\u0004%I!a\u000b\t\u0011\u0005]\u0002\u0001)Q\u0005\u0003GA\u0011\"!\u000f\u0001\u0005\u0004%I!a\u000f\t\u0011\u00055\u0003\u0001)A\u0005\u0003{A\u0011\"a\u0014\u0001\u0005\u0004%I!a\u000f\t\u0011\u0005E\u0003\u0001)A\u0005\u0003{A\u0011\"a\u0015\u0001\u0001\u0004%I!!\u0016\t\u0013\u0005-\u0004\u00011A\u0005\n\u00055\u0004\u0002CA9\u0001\u0001\u0006K!a\u0016\t\u0013\u0005M\u0004\u00011A\u0005\n\u0005U\u0004\"CA@\u0001\u0001\u0007I\u0011BAA\u0011!\t)\t\u0001Q!\n\u0005]\u0004bBAD\u0001\u0011\u0005\u0013\u0011\u0012\u0005\b\u0003\u001f\u0003A\u0011IAI\u0011\u001d\tI\u0004\u0001C!\u00037Cq!!\u000f\u0001\t\u0003\n9\u000bC\u0004\u0002:\u0002!\t%a/\t\u000f\u0005\r\u0007\u0001\"\u0011\u0002F\"9\u0011\u0011\u001e\u0001\u0005B\u0005-\bbBA}\u0001\u0011%\u00111 \u0005\b\u0003{\u0004A\u0011IA~\u0011\u001d\ty\u0010\u0001C!\u0003wDqA!\u0001\u0001\t\u0003\nY\u0010C\u0004\u0003\u0004\u0001!\t!a?\t\u000f\tm\u0001\u0001\"\u0001\u0003\u001e!9!Q\u0005\u0001\u0005\u0002\u0005m\bb\u0002B\u0015\u0001\u0011%!1\u0006\u0005\b\u0005c\u0001A\u0011\u0002B\u001a\u0005U!\u0015\r^1Ge\u0006lWm\u0016:ji\u0016\u0014hKM%na2T!a\u000b\u0017\u0002\u0011%tG/\u001a:oC2T!!\f\u0018\u0002\u0007M\fHN\u0003\u00020a\u0005)1\u000f]1sW*\u0011\u0011GM\u0001\u0007CB\f7\r[3\u000b\u0003M\n1a\u001c:h\u0007\u0001)\"AN\u001f\u0014\u0005\u00019\u0004c\u0001\u001d:w5\tA&\u0003\u0002;Y\t\tB)\u0019;b\rJ\fW.Z,sSR,'O\u0016\u001a\u0011\u0005qjD\u0002\u0001\u0003\u0006}\u0001\u0011\ra\u0010\u0002\u0002)F\u0011\u0001I\u0012\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0002\u0007\u0006)1oY1mC&\u0011QI\u0011\u0002\b\u001d>$\b.\u001b8h!\t\tu)\u0003\u0002I\u0005\n\u0019\u0011I\\=\u0002\u000bQ\f'\r\\3\u0011\u0005-\u0013fB\u0001'Q!\ti%)D\u0001O\u0015\tyE'\u0001\u0004=e>|GOP\u0005\u0003#\n\u000ba\u0001\u0015:fI\u00164\u0017BA*U\u0005\u0019\u0019FO]5oO*\u0011\u0011KQ\u0001\u0003IN\u00042\u0001O,<\u0013\tAFFA\u0004ECR\f7/\u001a;\u0002\rqJg.\u001b;?)\rYVL\u0018\t\u00049\u0002YT\"\u0001\u0016\t\u000b%\u001b\u0001\u0019\u0001&\t\u000bU\u001b\u0001\u0019\u0001,\u0002\u0005\u00114W#A1\u0011\u0005\tlgBA2l\u001d\t!'N\u0004\u0002fS:\u0011a\r\u001b\b\u0003\u001b\u001eL\u0011aM\u0005\u0003cIJ!a\f\u0019\n\u00055r\u0013B\u00017-\u0003\u001d\u0001\u0018mY6bO\u0016L!A\\8\u0003\u0013\u0011\u000bG/\u0019$sC6,'B\u00017-\u0003\r!g\rI\u0001\rgB\f'o[*fgNLwN\\\u000b\u0002gB\u0011\u0001\b^\u0005\u0003k2\u0012Ab\u00159be.\u001cVm]:j_:\fQb\u001d9be.\u001cVm]:j_:\u0004\u0013!\u0003;bE2,g*Y7f+\u0005I\bc\u0001>\u007f\u0015:\u001110 \b\u0003\u001brL\u0011aQ\u0005\u0003Y\nK1a`A\u0001\u0005\r\u0019V-\u001d\u0006\u0003Y\n\u000b!\u0002^1cY\u0016t\u0015-\\3!\u0003-awnZ5dC2\u0004F.\u00198\u0016\u0005\u0005%\u0001\u0003BA\u0006\u00033i!!!\u0004\u000b\t\u0005=\u0011\u0011C\u0001\bY><\u0017nY1m\u0015\u0011\t\u0019\"!\u0006\u0002\u000bAd\u0017M\\:\u000b\u0007\u0005]A&\u0001\u0005dCR\fG._:u\u0013\u0011\tY\"!\u0004\u0003\u00171{w-[2bYBc\u0017M\\\u0001\rY><\u0017nY1m!2\fg\u000eI\u0001\taJ|g/\u001b3feV\u0011\u00111\u0005\t\u0005\u0003\u0006\u0015\"*C\u0002\u0002(\t\u0013aa\u00149uS>t\u0017\u0001\u00049s_ZLG-\u001a:`I\u0015\fH\u0003BA\u0017\u0003g\u00012!QA\u0018\u0013\r\t\tD\u0011\u0002\u0005+:LG\u000fC\u0005\u000265\t\t\u00111\u0001\u0002$\u0005\u0019\u0001\u0010J\u0019\u0002\u0013A\u0014xN^5eKJ\u0004\u0013aB8qi&|gn]\u000b\u0003\u0003{\u0001b!a\u0010\u0002J)SUBAA!\u0015\u0011\t\u0019%!\u0012\u0002\u000f5,H/\u00192mK*\u0019\u0011q\t\"\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002L\u0005\u0005#a\u0002%bg\"l\u0015\r]\u0001\t_B$\u0018n\u001c8tA\u0005Q\u0001O]8qKJ$\u0018.Z:\u0002\u0017A\u0014x\u000e]3si&,7\u000fI\u0001\ra\u0006\u0014H/\u001b;j_:LgnZ\u000b\u0003\u0003/\u0002R!QA\u0013\u00033\u0002BA\u001f@\u0002\\A!\u0011QLA4\u001b\t\tyF\u0003\u0003\u0002b\u0005\r\u0014aC3yaJ,7o]5p]NT1!!\u001a-\u0003%\u0019wN\u001c8fGR|'/\u0003\u0003\u0002j\u0005}#!\u0003+sC:\u001chm\u001c:n\u0003A\u0001\u0018M\u001d;ji&|g.\u001b8h?\u0012*\u0017\u000f\u0006\u0003\u0002.\u0005=\u0004\"CA\u001b)\u0005\u0005\t\u0019AA,\u00035\u0001\u0018M\u001d;ji&|g.\u001b8hA\u0005Q1\r\\;ti\u0016\u0014\u0018N\\4\u0016\u0005\u0005]\u0004#B!\u0002&\u0005e\u0004\u0003BA/\u0003wJA!! \u0002`\t\u00112\t\\;ti\u0016\u0014()\u001f+sC:\u001chm\u001c:n\u00039\u0019G.^:uKJLgnZ0%KF$B!!\f\u0002\u0004\"I\u0011QG\f\u0002\u0002\u0003\u0007\u0011qO\u0001\fG2,8\u000f^3sS:<\u0007%A\u0003vg&tw\r\u0006\u0003\u0002\f\u00065U\"\u0001\u0001\t\r\u0005}\u0011\u00041\u0001K\u0003\u0019y\u0007\u000f^5p]R1\u00111RAJ\u0003/Ca!!&\u001b\u0001\u0004Q\u0015aA6fs\"1\u0011\u0011\u0014\u000eA\u0002)\u000bQA^1mk\u0016$B!a#\u0002\u001e\"9\u0011\u0011H\u000eA\u0002\u0005}\u0005CBAQ\u0003GS%*\u0004\u0002\u0002F%!\u0011QUA#\u0005\ri\u0015\r\u001d\u000b\u0005\u0003\u0017\u000bI\u000bC\u0004\u0002:q\u0001\r!a+\u0011\r\u00055\u0016q\u0017&K\u001b\t\tyK\u0003\u0003\u00022\u0006M\u0016\u0001B;uS2T!!!.\u0002\t)\fg/Y\u0005\u0005\u0003K\u000by+A\u0007uC\ndW\r\u0015:pa\u0016\u0014H/\u001f\u000b\u0007\u0003\u0017\u000bi,!1\t\r\u0005}V\u00041\u0001K\u0003!\u0001(o\u001c9feRL\bBBAM;\u0001\u0007!*A\u0007qCJ$\u0018\u000e^5p]\u0016$')\u001f\u000b\u0007\u0003\u0017\u000b9-!5\t\u000f\u0005%g\u00041\u0001\u0002L\u000611m\u001c7v[:\u00042\u0001OAg\u0013\r\ty\r\f\u0002\u0007\u0007>dW/\u001c8\t\u000f\u0005Mg\u00041\u0001\u0002V\u000691m\u001c7v[:\u001c\b#B!\u0002X\u0006-\u0017bAAm\u0005\nQAH]3qK\u0006$X\r\u001a )\u0007y\ti\u000e\u0005\u0003\u0002`\u0006\u0015XBAAq\u0015\r\t\u0019OQ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAt\u0003C\u0014qA^1sCJ<7/A\u0005dYV\u001cH/\u001a:CsR1\u00111RAw\u0003cDa!a< \u0001\u0004Q\u0015aB2pY:\u000bW.\u001a\u0005\b\u0003g|\u0002\u0019AA{\u0003!\u0019w\u000e\u001c(b[\u0016\u001c\b\u0003B!\u0002X*C3aHAo\u0003Q1\u0018\r\\5eCR,\u0007+\u0019:uSRLwN\\5oOR\u0011\u0011QF\u0001\u0007GJ,\u0017\r^3\u0002\u000fI,\u0007\u000f\\1dK\u0006y1M]3bi\u0016|%OU3qY\u0006\u001cW-\u0001\u0004baB,g\u000e\u001a\u0015\u0006I\t\u001d!\u0011\u0004\t\u0006\u0003\n%!QB\u0005\u0004\u0005\u0017\u0011%A\u0002;ie><8\u000f\u0005\u0003\u0003\u0010\tUQB\u0001B\t\u0015\u0011\u0011\u0019\"!\u0006\u0002\u0011\u0005t\u0017\r\\=tSNLAAa\u0006\u0003\u0012\t!bj\\*vG\"$\u0016M\u00197f\u000bb\u001cW\r\u001d;j_:\u001c#A!\u0004\u0002\u0013=4XM]<sSR,G\u0003BA\u0017\u0005?AqA!\t&\u0001\u0004\tY-A\u0005d_:$\u0017\u000e^5p]\"*QEa\u0002\u0003\u001a\u0005\u0019rN^3soJLG/\u001a)beRLG/[8og\"*aEa\u0002\u0003\u001a\u0005Q!/\u001e8D_6l\u0017M\u001c3\u0015\t\u00055\"Q\u0006\u0005\b\u0005_9\u0003\u0019AA\u0005\u0003\u001d\u0019w.\\7b]\u0012\fq\"\u001b8uKJt\u0017\r\u001c*fa2\f7-\u001a\u000b\u0005\u0003[\u0011)\u0004C\u0004\u00038!\u0002\rA!\u000f\u0002\u0011=\u00148I]3bi\u0016\u00042!\u0011B\u001e\u0013\r\u0011iD\u0011\u0002\b\u0005>|G.Z1oQ\r\u0001!\u0011\t\t\u0005\u0005\u0007\u00129%\u0004\u0002\u0003F)\u0019\u00111\u001d\u0018\n\t\t%#Q\t\u0002\r\u000bb\u0004XM]5nK:$\u0018\r\u001c")
public final class DataFrameWriterV2Impl<T>
extends DataFrameWriterV2<T> {
    private final Dataset<Row> df;
    private final SparkSession sparkSession;
    private final Seq<String> tableName;
    private final LogicalPlan logicalPlan;
    private Option<String> provider;
    private final HashMap<String, String> options;
    private final HashMap<String, String> properties;
    private Option<Seq<Transform>> partitioning;
    private Option<ClusterByTransform> clustering;

    public DataFrameWriterV2Impl<T> partitionedBy(Column column, Column ... columns) {
        return this.partitionedBy(column, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])columns));
    }

    public DataFrameWriterV2Impl<T> clusterBy(String colName, String ... colNames) {
        return this.clusterBy(colName, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])colNames));
    }

    private Dataset<Row> df() {
        return this.df;
    }

    private SparkSession sparkSession() {
        return this.sparkSession;
    }

    private Seq<String> tableName() {
        return this.tableName;
    }

    private LogicalPlan logicalPlan() {
        return this.logicalPlan;
    }

    private Option<String> provider() {
        return this.provider;
    }

    private void provider_$eq(Option<String> x$1) {
        this.provider = x$1;
    }

    private HashMap<String, String> options() {
        return this.options;
    }

    private HashMap<String, String> properties() {
        return this.properties;
    }

    private Option<Seq<Transform>> partitioning() {
        return this.partitioning;
    }

    private void partitioning_$eq(Option<Seq<Transform>> x$1) {
        this.partitioning = x$1;
    }

    private Option<ClusterByTransform> clustering() {
        return this.clustering;
    }

    private void clustering_$eq(Option<ClusterByTransform> x$1) {
        this.clustering = x$1;
    }

    public DataFrameWriterV2Impl<T> using(String provider) {
        this.provider_$eq((Option<String>)new Some((Object)provider));
        return this;
    }

    public DataFrameWriterV2Impl<T> option(String key, String value) {
        this.options().put((Object)key, (Object)value);
        return this;
    }

    public DataFrameWriterV2Impl<T> options(Map<String, String> options) {
        options.foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                return this.options().put((Object)key, (Object)value);
            }
            throw new MatchError((Object)tuple2);
        });
        return this;
    }

    public DataFrameWriterV2Impl<T> options(java.util.Map<String, String> options) {
        this.options((Map)CollectionConverters$.MODULE$.MapHasAsScala(options).asScala());
        return this;
    }

    public DataFrameWriterV2Impl<T> tableProperty(String property, String value) {
        this.properties().put((Object)property, (Object)value);
        return this;
    }

    public DataFrameWriterV2Impl<T> partitionedBy(Column column, Seq<Column> columns) {
        Column column2 = column;
        Seq asTransforms = (Seq)((IterableOps)((IterableOps)columns.$plus$colon((Object)column2)).map((Function1 & Serializable)e -> this.sparkSession().expression((Column)e))).map((Function1 & Serializable)x0$1 -> {
            SeqOps seqOps;
            Seq seq;
            Option<Seq<Expression>> option;
            SeqOps seqOps2;
            Seq seq2;
            Option<Seq<Expression>> option2;
            Expression attr;
            SeqOps seqOps3;
            Seq seq3;
            Option<Seq<Expression>> option3;
            Expression attr2;
            SeqOps seqOps4;
            Seq seq4;
            Option<Seq<Expression>> option4;
            Expression attr3;
            SeqOps seqOps5;
            Seq seq5;
            Option<Seq<Expression>> option5;
            Expression attr4;
            SeqOps seqOps6;
            Seq seq6;
            Option<Seq<Expression>> option6;
            Expression expression = x0$1;
            if (expression != null && !(option6 = PartitionTransform$.MODULE$.YEARS().unapply(expression)).isEmpty() && (seq6 = (Seq)option6.get()) != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps6 = package$.MODULE$.Seq().unapplySeq((SeqOps)seq6)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps6)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps6), 1) == 0 && (attr4 = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps6), 0)) instanceof Attribute) {
                Attribute attribute = (Attribute)attr4;
                return LogicalExpressions$.MODULE$.years(DataFrameWriterV2Impl.ref$1(attribute.name()));
            }
            if (expression != null && !(option5 = PartitionTransform$.MODULE$.MONTHS().unapply(expression)).isEmpty() && (seq5 = (Seq)option5.get()) != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps5 = package$.MODULE$.Seq().unapplySeq((SeqOps)seq5)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps5)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps5), 1) == 0 && (attr3 = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps5), 0)) instanceof Attribute) {
                Attribute attribute = (Attribute)attr3;
                return LogicalExpressions$.MODULE$.months(DataFrameWriterV2Impl.ref$1(attribute.name()));
            }
            if (expression != null && !(option4 = PartitionTransform$.MODULE$.DAYS().unapply(expression)).isEmpty() && (seq4 = (Seq)option4.get()) != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps4 = package$.MODULE$.Seq().unapplySeq((SeqOps)seq4)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 1) == 0 && (attr2 = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 0)) instanceof Attribute) {
                Attribute attribute = (Attribute)attr2;
                return LogicalExpressions$.MODULE$.days(DataFrameWriterV2Impl.ref$1(attribute.name()));
            }
            if (expression != null && !(option3 = PartitionTransform$.MODULE$.HOURS().unapply(expression)).isEmpty() && (seq3 = (Seq)option3.get()) != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps3 = package$.MODULE$.Seq().unapplySeq((SeqOps)seq3)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 1) == 0 && (attr = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 0)) instanceof Attribute) {
                Attribute attribute = (Attribute)attr;
                return LogicalExpressions$.MODULE$.hours(DataFrameWriterV2Impl.ref$1(attribute.name()));
            }
            if (expression != null && !(option2 = PartitionTransform$.MODULE$.BUCKET().unapply(expression)).isEmpty() && (seq2 = (Seq)option2.get()) != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = package$.MODULE$.Seq().unapplySeq((SeqOps)seq2)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 2) == 0) {
                Expression expression2 = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0);
                Expression attr5 = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1);
                if (expression2 instanceof Literal) {
                    Literal literal = (Literal)expression2;
                    Object numBuckets = literal.value();
                    DataType dataType = literal.dataType();
                    if (numBuckets instanceof Integer) {
                        int n = BoxesRunTime.unboxToInt((Object)numBuckets);
                        if (IntegerType$.MODULE$.equals(dataType) && attr5 instanceof Attribute) {
                            Attribute attribute = (Attribute)attr5;
                            return LogicalExpressions$.MODULE$.bucket(n, (NamedReference[])((Object[])new NamedReference[]{DataFrameWriterV2Impl.ref$1(attribute.name())}));
                        }
                    }
                }
            }
            if (expression != null && !(option = PartitionTransform$.MODULE$.BUCKET().unapply(expression)).isEmpty() && (seq = (Seq)option.get()) != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                Expression numBuckets = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                Expression e = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                throw QueryCompilationErrors$.MODULE$.invalidBucketsNumberError(numBuckets.toString(), e.toString());
            }
            if (expression instanceof Attribute) {
                Attribute attribute = (Attribute)expression;
                return LogicalExpressions$.MODULE$.identity(DataFrameWriterV2Impl.ref$1(attribute.name()));
            }
            throw QueryCompilationErrors$.MODULE$.invalidPartitionTransformationError(expression);
        });
        this.partitioning_$eq((Option<Seq<Transform>>)new Some((Object)asTransforms));
        this.validatePartitioning();
        return this;
    }

    public DataFrameWriterV2Impl<T> clusterBy(String colName, Seq<String> colNames) {
        String string = colName;
        this.clustering_$eq((Option<ClusterByTransform>)new Some((Object)new ClusterByTransform((Seq)((IterableOps)colNames.$plus$colon((Object)string)).map((Function1 & Serializable)col -> FieldReference$.MODULE$.apply(col)))));
        this.validatePartitioning();
        return this;
    }

    private void validatePartitioning() {
        if (this.partitioning().nonEmpty() && this.clustering().nonEmpty()) {
            throw QueryCompilationErrors$.MODULE$.clusterByWithPartitionedBy();
        }
    }

    public void create() {
        UnresolvedTableSpec tableSpec = new UnresolvedTableSpec(this.properties().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), this.provider(), new OptionList((Seq)package$.MODULE$.Seq().empty()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, false);
        this.runCommand((LogicalPlan)new CreateTableAsSelect((LogicalPlan)new UnresolvedIdentifier(this.tableName(), UnresolvedIdentifier$.MODULE$.apply$default$2()), (Seq)((IterableOps)this.partitioning().getOrElse((Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty())).$plus$plus(this.clustering()), this.logicalPlan(), (TableSpecBase)tableSpec, this.options().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), false, CreateTableAsSelect$.MODULE$.apply$default$7()));
    }

    public void replace() {
        this.internalReplace(false);
    }

    public void createOrReplace() {
        this.internalReplace(true);
    }

    public void append() throws NoSuchTableException {
        AppendData append = AppendData$.MODULE$.byName((NamedRelation)new UnresolvedRelation(this.tableName(), UnresolvedRelation$.MODULE$.apply$default$2(), UnresolvedRelation$.MODULE$.apply$default$3()).requireWritePrivileges((Seq)new .colon.colon((Object)TableWritePrivilege.INSERT, (List)Nil$.MODULE$)), this.logicalPlan(), this.options().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        this.runCommand((LogicalPlan)append);
    }

    public void overwrite(Column condition) throws NoSuchTableException {
        OverwriteByExpression overwrite = OverwriteByExpression$.MODULE$.byName((NamedRelation)new UnresolvedRelation(this.tableName(), UnresolvedRelation$.MODULE$.apply$default$2(), UnresolvedRelation$.MODULE$.apply$default$3()).requireWritePrivileges((Seq)new .colon.colon((Object)TableWritePrivilege.INSERT, (List)new .colon.colon((Object)TableWritePrivilege.DELETE, (List)Nil$.MODULE$))), this.logicalPlan(), this.sparkSession().expression(condition), this.options().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        this.runCommand((LogicalPlan)overwrite);
    }

    public void overwritePartitions() throws NoSuchTableException {
        OverwritePartitionsDynamic dynamicOverwrite = OverwritePartitionsDynamic$.MODULE$.byName((NamedRelation)new UnresolvedRelation(this.tableName(), UnresolvedRelation$.MODULE$.apply$default$2(), UnresolvedRelation$.MODULE$.apply$default$3()).requireWritePrivileges((Seq)new .colon.colon((Object)TableWritePrivilege.INSERT, (List)new .colon.colon((Object)TableWritePrivilege.DELETE, (List)Nil$.MODULE$))), this.logicalPlan(), this.options().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        this.runCommand((LogicalPlan)dynamicOverwrite);
    }

    private void runCommand(LogicalPlan command) {
        QueryExecution qe = new QueryExecution(this.sparkSession(), command, this.df().queryExecution().tracker(), QueryExecution$.MODULE$.$lessinit$greater$default$4(), QueryExecution$.MODULE$.$lessinit$greater$default$5());
        qe.assertCommandExecuted();
    }

    private void internalReplace(boolean orCreate) {
        UnresolvedTableSpec tableSpec = new UnresolvedTableSpec(this.properties().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), this.provider(), new OptionList((Seq)package$.MODULE$.Seq().empty()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, false);
        this.runCommand((LogicalPlan)new ReplaceTableAsSelect((LogicalPlan)new UnresolvedIdentifier(this.tableName(), UnresolvedIdentifier$.MODULE$.apply$default$2()), (Seq)((IterableOps)this.partitioning().getOrElse((Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty())).$plus$plus(this.clustering()), this.logicalPlan(), (TableSpecBase)tableSpec, this.options().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), orCreate, ReplaceTableAsSelect$.MODULE$.apply$default$7()));
    }

    private static final NamedReference ref$1(String name) {
        return LogicalExpressions$.MODULE$.parseReference(name);
    }

    public DataFrameWriterV2Impl(String table, Dataset<T> ds) {
        this.df = ds.toDF();
        this.sparkSession = ds.sparkSession();
        this.tableName = this.sparkSession().sessionState().sqlParser().parseMultipartIdentifier(table);
        this.logicalPlan = this.df().queryExecution().logical();
        this.provider = None$.MODULE$;
        this.options = new HashMap();
        this.properties = new HashMap();
        this.partitioning = None$.MODULE$;
        this.clustering = None$.MODULE$;
    }
}

