/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.internal;

import java.io.Serializable;
import org.apache.spark.SparkRuntimeException;
import org.apache.spark.SparkRuntimeException$;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.MergeIntoWriter;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation$;
import org.apache.spark.sql.catalyst.plans.logical.Assignment;
import org.apache.spark.sql.catalyst.plans.logical.DeleteAction;
import org.apache.spark.sql.catalyst.plans.logical.InsertAction;
import org.apache.spark.sql.catalyst.plans.logical.InsertStarAction;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.MergeAction;
import org.apache.spark.sql.catalyst.plans.logical.MergeIntoTable;
import org.apache.spark.sql.catalyst.plans.logical.MergeIntoTable$;
import org.apache.spark.sql.catalyst.plans.logical.UpdateAction;
import org.apache.spark.sql.catalyst.plans.logical.UpdateStarAction;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.functions$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Growable;
import scala.reflect.ScalaSignature;

@Experimental
@ScalaSignature(bytes="\u0006\u0005\u0005\u0005f\u0001B\u000e\u001d\u0001\u001dB\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0011\"A1\n\u0001B\u0001B\u0003%A\n\u0003\u0004P\u0001\u0011\u0005a\u0004\u0015\u0005\b-\u0002\u0011\r\u0011\"\u0003X\u0011\u00199\u0007\u0001)A\u00051\"A\u0001\u000e\u0001b\u0001\n\u0003q\u0012\u000e\u0003\u0004n\u0001\u0001\u0006IA\u001b\u0005\b]\u0002\u0011\r\u0011\"\u0003p\u0011\u0019A\b\u0001)A\u0005a\"9\u0011\u0010\u0001b\u0001\n\u0013Q\bbBA\u0006\u0001\u0001\u0006Ia\u001f\u0005\u000b\u0003\u001b\u0001!\u0019!C\u0001=\u0005=\u0001\u0002CA\u0014\u0001\u0001\u0006I!!\u0005\t\u0015\u0005%\u0002A1A\u0005\u0002y\ty\u0001\u0003\u0005\u0002,\u0001\u0001\u000b\u0011BA\t\u0011)\ti\u0003\u0001b\u0001\n\u0003q\u0012q\u0002\u0005\t\u0003_\u0001\u0001\u0015!\u0003\u0002\u0012!9\u0011\u0011\u0007\u0001\u0005\u0002\u0005M\u0002\u0002CA\u001e\u0001\u0011Ec$!\u0010\t\u0011\u0005%\u0003\u0001\"\u0015\u001f\u0003\u0017B\u0001\"!\u0017\u0001\t#r\u00121\f\u0005\t\u0003S\u0002A\u0011\u000b\u0010\u0002l!A\u00111\u000f\u0001\u0005Ry\t)\bC\u0004\u0002|\u0001!I!! \t\u000f\u0005\u0015\u0005\u0001\"\u0003\u0002\b\n\u0019R*\u001a:hK&sGo\\,sSR,'/S7qY*\u0011QDH\u0001\tS:$XM\u001d8bY*\u0011q\u0004I\u0001\u0004gFd'BA\u0011#\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0019C%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002K\u0005\u0019qN]4\u0004\u0001U\u0011\u0001fL\n\u0003\u0001%\u00022AK\u0016.\u001b\u0005q\u0012B\u0001\u0017\u001f\u0005=iUM]4f\u0013:$xn\u0016:ji\u0016\u0014\bC\u0001\u00180\u0019\u0001!Q\u0001\r\u0001C\u0002E\u0012\u0011\u0001V\t\u0003ea\u0002\"a\r\u001c\u000e\u0003QR\u0011!N\u0001\u0006g\u000e\fG.Y\u0005\u0003oQ\u0012qAT8uQ&tw\r\u0005\u00024s%\u0011!\b\u000e\u0002\u0004\u0003:L\u0018!\u0002;bE2,\u0007CA\u001fE\u001d\tq$\t\u0005\u0002@i5\t\u0001I\u0003\u0002BM\u00051AH]8pizJ!a\u0011\u001b\u0002\rA\u0013X\rZ3g\u0013\t)eI\u0001\u0004TiJLgn\u001a\u0006\u0003\u0007R\n!\u0001Z:\u0011\u0007)JU&\u0003\u0002K=\t9A)\u0019;bg\u0016$\u0018AA8o!\tQS*\u0003\u0002O=\t11i\u001c7v[:\fa\u0001P5oSRtD\u0003B)T)V\u00032A\u0015\u0001.\u001b\u0005a\u0002\"B\u001e\u0005\u0001\u0004a\u0004\"B$\u0005\u0001\u0004A\u0005\"B&\u0005\u0001\u0004a\u0015A\u00013g+\u0005A\u0006CA-e\u001d\tQ&M\u0004\u0002\\C:\u0011A\f\u0019\b\u0003;~s!a\u00100\n\u0003\u0015J!a\t\u0013\n\u0005\u0005\u0012\u0013BA\u0010!\u0013\t\u0019g$A\u0004qC\u000e\\\u0017mZ3\n\u0005\u00154'!\u0003#bi\u00064%/Y7f\u0015\t\u0019g$A\u0002eM\u0002\nAb\u001d9be.\u001cVm]:j_:,\u0012A\u001b\t\u0003U-L!\u0001\u001c\u0010\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002\u001bM\u0004\u0018M]6TKN\u001c\u0018n\u001c8!\u0003%!\u0018M\u00197f\u001d\u0006lW-F\u0001q!\r\tX\u000f\u0010\b\u0003eRt!aP:\n\u0003UJ!a\u0019\u001b\n\u0005Y<(aA*fc*\u00111\rN\u0001\u000bi\u0006\u0014G.\u001a(b[\u0016\u0004\u0013a\u00037pO&\u001c\u0017\r\u001c)mC:,\u0012a\u001f\t\u0004y\u0006\u001dQ\"A?\u000b\u0005y|\u0018a\u00027pO&\u001c\u0017\r\u001c\u0006\u0005\u0003\u0003\t\u0019!A\u0003qY\u0006t7OC\u0002\u0002\u0006y\t\u0001bY1uC2L8\u000f^\u0005\u0004\u0003\u0013i(a\u0003'pO&\u001c\u0017\r\u001c)mC:\fA\u0002\\8hS\u000e\fG\u000e\u00157b]\u0002\na\"\\1uG\",G-Q2uS>t7/\u0006\u0002\u0002\u0012A1\u00111CA\u000f\u0003Ci!!!\u0006\u000b\t\u0005]\u0011\u0011D\u0001\b[V$\u0018M\u00197f\u0015\r\tY\u0002N\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0010\u0003+\u0011aAQ;gM\u0016\u0014\bc\u0001?\u0002$%\u0019\u0011QE?\u0003\u00175+'oZ3BGRLwN\\\u0001\u0010[\u0006$8\r[3e\u0003\u000e$\u0018n\u001c8tA\u0005\tbn\u001c;NCR\u001c\u0007.\u001a3BGRLwN\\:\u0002%9|G/T1uG\",G-Q2uS>t7\u000fI\u0001\u001a]>$X*\u0019;dQ\u0016$')_*pkJ\u001cW-Q2uS>t7/\u0001\u000eo_Rl\u0015\r^2iK\u0012\u0014\u0015pU8ve\u000e,\u0017i\u0019;j_:\u001c\b%A\u0003nKJ<W\r\u0006\u0002\u00026A\u00191'a\u000e\n\u0007\u0005eBG\u0001\u0003V]&$\u0018!C5og\u0016\u0014H/\u00117m)\rI\u0013q\b\u0005\b\u0003\u0003\"\u0002\u0019AA\"\u0003%\u0019wN\u001c3ji&|g\u000e\u0005\u00034\u0003\u000bb\u0015bAA$i\t1q\n\u001d;j_:\fa!\u001b8tKJ$H#B\u0015\u0002N\u0005=\u0003bBA!+\u0001\u0007\u00111\t\u0005\b\u0003#*\u0002\u0019AA*\u0003\ri\u0017\r\u001d\t\u0006{\u0005UC\bT\u0005\u0004\u0003/2%aA'ba\u0006IQ\u000f\u001d3bi\u0016\fE\u000e\u001c\u000b\u0006S\u0005u\u0013q\f\u0005\b\u0003\u00032\u0002\u0019AA\"\u0011\u001d\t\tG\u0006a\u0001\u0003G\n!C\\8u\u001b\u0006$8\r[3e\u0005f\u001cv.\u001e:dKB\u00191'!\u001a\n\u0007\u0005\u001dDGA\u0004C_>dW-\u00198\u0002\rU\u0004H-\u0019;f)\u001dI\u0013QNA8\u0003cBq!!\u0011\u0018\u0001\u0004\t\u0019\u0005C\u0004\u0002R]\u0001\r!a\u0015\t\u000f\u0005\u0005t\u00031\u0001\u0002d\u00051A-\u001a7fi\u0016$R!KA<\u0003sBq!!\u0011\u0019\u0001\u0004\t\u0019\u0005C\u0004\u0002ba\u0001\r!a\u0019\u00021\u0005\u0004\b/\u001a8e+B$\u0017\r^3EK2,G/Z!di&|g\u000eF\u0003*\u0003\u007f\n\u0019\tC\u0004\u0002\u0002f\u0001\r!!\t\u0002\r\u0005\u001cG/[8o\u0011\u001d\t\t'\u0007a\u0001\u0003G\n\u0001#\\1q)>\f5o]5h]6,g\u000e^:\u0015\t\u0005%\u0015\u0011\u0013\t\u0005cV\fY\tE\u0002}\u0003\u001bK1!a$~\u0005)\t5o]5h]6,g\u000e\u001e\u0005\b\u0003#R\u0002\u0019AA*Q\r\u0001\u0011Q\u0013\t\u0005\u0003/\u000bi*\u0004\u0002\u0002\u001a*\u0019\u00111\u0014\u0011\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002 \u0006e%\u0001D#ya\u0016\u0014\u0018.\\3oi\u0006d\u0007")
public class MergeIntoWriterImpl<T>
extends MergeIntoWriter<T> {
    private final Column on;
    private final Dataset<Row> df;
    private final SparkSession sparkSession;
    private final Seq<String> tableName;
    private final LogicalPlan logicalPlan;
    private final Buffer<MergeAction> matchedActions;
    private final Buffer<MergeAction> notMatchedActions;
    private final Buffer<MergeAction> notMatchedBySourceActions;

    private Dataset<Row> df() {
        return this.df;
    }

    public SparkSession sparkSession() {
        return this.sparkSession;
    }

    private Seq<String> tableName() {
        return this.tableName;
    }

    private LogicalPlan logicalPlan() {
        return this.logicalPlan;
    }

    public Buffer<MergeAction> matchedActions() {
        return this.matchedActions;
    }

    public Buffer<MergeAction> notMatchedActions() {
        return this.notMatchedActions;
    }

    public Buffer<MergeAction> notMatchedBySourceActions() {
        return this.notMatchedBySourceActions;
    }

    public void merge() {
        if (this.matchedActions().isEmpty() && this.notMatchedActions().isEmpty() && this.notMatchedBySourceActions().isEmpty()) {
            throw new SparkRuntimeException("NO_MERGE_ACTION_SPECIFIED", Predef$.MODULE$.Map().empty(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
        }
        MergeIntoTable merge = new MergeIntoTable((LogicalPlan)new UnresolvedRelation(this.tableName(), UnresolvedRelation$.MODULE$.apply$default$2(), UnresolvedRelation$.MODULE$.apply$default$3()).requireWritePrivileges(MergeIntoTable$.MODULE$.getWritePrivileges(this.matchedActions(), this.notMatchedActions(), this.notMatchedBySourceActions())), this.logicalPlan(), this.sparkSession().RichColumn(this.on).expr(), this.matchedActions().toSeq(), this.notMatchedActions().toSeq(), this.notMatchedBySourceActions().toSeq(), this.schemaEvolutionEnabled());
        QueryExecution qe = this.sparkSession().sessionState().executePlan((LogicalPlan)merge, this.sparkSession().sessionState().executePlan$default$2());
        qe.assertCommandExecuted();
    }

    public MergeIntoWriter<T> insertAll(Option<Column> condition) {
        this.notMatchedActions().$plus$eq((Object)new InsertStarAction(condition.map((Function1 & Serializable)x$1 -> this.sparkSession().RichColumn((Column)x$1).expr())));
        return this;
    }

    public MergeIntoWriter<T> insert(Option<Column> condition, Map<String, Column> map) {
        this.notMatchedActions().$plus$eq((Object)new InsertAction(condition.map((Function1 & Serializable)x$2 -> this.sparkSession().RichColumn((Column)x$2).expr()), this.mapToAssignments(map)));
        return this;
    }

    public MergeIntoWriter<T> updateAll(Option<Column> condition, boolean notMatchedBySource) {
        return this.appendUpdateDeleteAction((MergeAction)new UpdateStarAction(condition.map((Function1 & Serializable)x$3 -> this.sparkSession().RichColumn((Column)x$3).expr())), notMatchedBySource);
    }

    public MergeIntoWriter<T> update(Option<Column> condition, Map<String, Column> map, boolean notMatchedBySource) {
        return this.appendUpdateDeleteAction((MergeAction)new UpdateAction(condition.map((Function1 & Serializable)x$4 -> this.sparkSession().RichColumn((Column)x$4).expr()), this.mapToAssignments(map)), notMatchedBySource);
    }

    public MergeIntoWriter<T> delete(Option<Column> condition, boolean notMatchedBySource) {
        return this.appendUpdateDeleteAction((MergeAction)new DeleteAction(condition.map((Function1 & Serializable)x$5 -> this.sparkSession().RichColumn((Column)x$5).expr())), notMatchedBySource);
    }

    private MergeIntoWriter<T> appendUpdateDeleteAction(MergeAction action, boolean notMatchedBySource) {
        Growable growable = notMatchedBySource ? this.notMatchedBySourceActions().$plus$eq((Object)action) : this.matchedActions().$plus$eq((Object)action);
        return this;
    }

    private Seq<Assignment> mapToAssignments(Map<String, Column> map) {
        return ((IterableOnceOps)map.map((Function1 & Serializable)x -> new Assignment(this.sparkSession().RichColumn(functions$.MODULE$.expr((String)x._1())).expr(), this.sparkSession().RichColumn((Column)x._2()).expr()))).toSeq();
    }

    public MergeIntoWriterImpl(String table, Dataset<T> ds, Column on) {
        this.on = on;
        this.df = ds.toDF();
        this.sparkSession = ds.sparkSession();
        this.tableName = this.sparkSession().sessionState().sqlParser().parseMultipartIdentifier(table);
        this.logicalPlan = this.df().queryExecution().logical();
        this.matchedActions = (Buffer)Buffer$.MODULE$.empty();
        this.notMatchedActions = (Buffer)Buffer$.MODULE$.empty();
        this.notMatchedBySourceActions = (Buffer)Buffer$.MODULE$.empty();
    }
}

