/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.NonEmptyNamespaceException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.jdbc.DB2Dialect$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcSQLQueryBuilder;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.jdbc.NoLegacyJDBCError;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.SetOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\tUh\u0001B\u001b7\t\u0006CQ!\u0019\u0001\u0005\u0002\tDQ\u0001\u001a\u0001\u0005B\u0015Dqa\u001d\u0001C\u0002\u0013%A\u000fC\u0004\u0002\n\u0001\u0001\u000b\u0011B;\t\u0011\u0005-\u0001A1A\u0005\nQDq!!\u0004\u0001A\u0003%Q\u000f\u0003\u0005\u0002\u0010\u0001\u0011\r\u0011\"\u0003u\u0011\u001d\t\t\u0002\u0001Q\u0001\nUDq!a\u0005\u0001\t\u0003\n)B\u0002\u0004\u0002\u001c\u0001\u0001\u0011Q\u0004\u0005\u0007C*!\t!a\n\t\u000f\u0005-\"\u0002\"\u0011\u0002.!9\u0011q\b\u0006\u0005B\u0005\u0005\u0003bBA#\u0001\u0011\u0005\u0013q\t\u0005\b\u0003G\u0002A\u0011IA3\u0011\u001d\t\t\n\u0001C!\u0003'Cq!!)\u0001\t\u0003\n\u0019\u000bC\u0004\u0002(\u0002!\t%!+\t\u0013\u0005M\u0006!%A\u0005\u0002\u0005U\u0006bBAf\u0001\u0011\u0005\u0013Q\u001a\u0005\b\u0003G\u0004A\u0011IAs\u0011\u001d\t\u0019\u0010\u0001C!\u0003kDq!a@\u0001\t\u0003\u0012\t\u0001C\u0004\u0003\b\u0001!\tE!\u0003\t\u000f\t=\u0002\u0001\"\u0011\u00032!9!q\u0007\u0001\u0005B\te\u0002b\u0002B#\u0001\u0011\u0005#q\t\u0004\u0007\u0005\u001b\u0002\u0001Aa\u0014\t\u0013\t]CD!A!\u0002\u0013\u0011\u0005B\u0003B-9\t\u0005\t\u0015!\u0003\u0003\\!1\u0011\r\bC\u0001\u0005[BqA!\u001e\u001d\t\u0003\u00129\bC\u0004\u0003z\u0001!\tEa\u001f\t\u000f\t}\u0004\u0001\"\u0011\u0003\u0002\"9!1\u0011\u0001\u0005B\t\u0005\u0005\u0002\u0003BC\u0001\u0005\u0005I\u0011\u00012\t\u0013\t\u001d\u0005!!A\u0005B\t%\u0005\"\u0003BF\u0001\u0005\u0005I\u0011\u0001BG\u0011%\u0011y\tAA\u0001\n\u0003\u0011\t\nC\u0005\u0003\u001e\u0002\t\t\u0011\"\u0011\u0003 \"I!\u0011\u0016\u0001\u0002\u0002\u0013\u0005!1\u0016\u0005\n\u0005_\u0003\u0011\u0011!C!\u0005cC\u0011B!.\u0001\u0003\u0003%\tEa.\t\u0013\te\u0006!!A\u0005B\tm\u0006\"\u0003B_\u0001\u0005\u0005I\u0011\tB`\u000f%\u0011\u0019MNA\u0001\u0012\u0013\u0011)M\u0002\u00056m\u0005\u0005\t\u0012\u0002Bd\u0011\u0019\tw\u0006\"\u0001\u0003`\"I!\u0011X\u0018\u0002\u0002\u0013\u0015#1\u0018\u0005\t\u0005C|\u0013\u0011!CAE\"I!1]\u0018\u0002\u0002\u0013\u0005%Q\u001d\u0005\n\u0005W|\u0013\u0011!C\u0005\u0005[\u0014!\u0002\u0012\"3\t&\fG.Z2u\u0015\t9\u0004(\u0001\u0003kI\n\u001c'BA\u001d;\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003wq\nQa\u001d9be.T!!\u0010 \u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0014aA8sO\u000e\u00011C\u0002\u0001C\r2{U\u000b\u0005\u0002D\t6\ta'\u0003\u0002Fm\tY!\n\u001a2d\t&\fG.Z2u!\t9%*D\u0001I\u0015\tI\u0005(\u0001\u0005dCR\fG._:u\u0013\tY\u0005JA\u0007T#2\u001buN\u001c4IK2\u0004XM\u001d\t\u0003\u00076K!A\u0014\u001c\u0003#9{G*Z4bGfTEIQ\"FeJ|'\u000f\u0005\u0002Q'6\t\u0011KC\u0001S\u0003\u0015\u00198-\u00197b\u0013\t!\u0016KA\u0004Qe>$Wo\u0019;\u0011\u0005YsfBA,]\u001d\tA6,D\u0001Z\u0015\tQ\u0006)\u0001\u0004=e>|GOP\u0005\u0002%&\u0011Q,U\u0001\ba\u0006\u001c7.Y4f\u0013\ty\u0006M\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002^#\u00061A(\u001b8jiz\"\u0012a\u0019\t\u0003\u0007\u0002\t\u0011bY1o\u0011\u0006tG\r\\3\u0015\u0005\u0019L\u0007C\u0001)h\u0013\tA\u0017KA\u0004C_>dW-\u00198\t\u000b)\u0014\u0001\u0019A6\u0002\u0007U\u0014H\u000e\u0005\u0002ma:\u0011QN\u001c\t\u00031FK!a\\)\u0002\rA\u0013X\rZ3g\u0013\t\t(O\u0001\u0004TiJLgn\u001a\u0006\u0003_F\u000bQ\u0005Z5ti&t7\r^+ogV\u0004\bo\u001c:uK\u0012\fum\u001a:fO\u0006$XMR;oGRLwN\\:\u0016\u0003U\u00042A^>~\u001b\u00059(B\u0001=z\u0003%IW.\\;uC\ndWM\u0003\u0002{#\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005q<(aA*fiB\u0019a0a\u0002\u000e\u0003}TA!!\u0001\u0002\u0004\u0005!A.\u00198h\u0015\t\t)!\u0001\u0003kCZ\f\u0017BA9\u0000\u0003\u0019\"\u0017n\u001d;j]\u000e$XK\\:vaB|'\u000f^3e\u0003\u001e<'/Z4bi\u00164UO\\2uS>t7\u000fI\u0001\u001cgV\u0004\bo\u001c:uK\u0012\fum\u001a:fO\u0006$XMR;oGRLwN\\:\u00029M,\b\u000f]8si\u0016$\u0017iZ4sK\u001e\fG/\u001a$v]\u000e$\u0018n\u001c8tA\u0005\u00112/\u001e9q_J$X\r\u001a$v]\u000e$\u0018n\u001c8t\u0003M\u0019X\u000f\u001d9peR,GMR;oGRLwN\\:!\u0003MI7oU;qa>\u0014H/\u001a3Gk:\u001cG/[8o)\r1\u0017q\u0003\u0005\u0007\u00033I\u0001\u0019A6\u0002\u0011\u0019,hn\u0019(b[\u0016\u0014Q\u0002\u0012\"3'Fc%)^5mI\u0016\u00148c\u0001\u0006\u0002 A!\u0011\u0011EA\u0012\u001b\u0005\u0001\u0011bAA\u0013\t\nq!\n\u0012\"D'Fc%)^5mI\u0016\u0014HCAA\u0015!\r\t\tCC\u0001\u0017m&\u001c\u0018\u000e^!hOJ,w-\u0019;f\rVt7\r^5p]R91.a\f\u00022\u0005U\u0002BBA\r\u0019\u0001\u00071\u000e\u0003\u0004\u000241\u0001\rAZ\u0001\u000bSN$\u0015n\u001d;j]\u000e$\bbBA\u001c\u0019\u0001\u0007\u0011\u0011H\u0001\u0007S:\u0004X\u000f^:\u0011\tA\u000bYd[\u0005\u0004\u0003{\t&!B!se\u0006L\u0018a\u00053jC2,7\r\u001e$v]\u000e$\u0018n\u001c8OC6,GcA6\u0002D!1\u0011\u0011D\u0007A\u0002-\f\u0011cY8na&dW-\u0012=qe\u0016\u001c8/[8o)\u0011\tI%a\u0014\u0011\tA\u000bYe[\u0005\u0004\u0003\u001b\n&AB(qi&|g\u000eC\u0004\u0002R9\u0001\r!a\u0015\u0002\t\u0015D\bO\u001d\t\u0005\u0003+\ny&\u0004\u0002\u0002X)!\u0011\u0011LA.\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0007\u0005u\u0003(A\u0005d_:tWm\u0019;pe&!\u0011\u0011MA,\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0010O\u0016$8)\u0019;bYf\u001cH\u000fV=qKRQ\u0011qMA;\u0003\u007f\n\u0019)a\"\u0011\u000bA\u000bY%!\u001b\u0011\t\u0005-\u0014\u0011O\u0007\u0003\u0003[R1!a\u001c9\u0003\u0015!\u0018\u0010]3t\u0013\u0011\t\u0019(!\u001c\u0003\u0011\u0011\u000bG/\u0019+za\u0016Dq!a\u001e\u0010\u0001\u0004\tI(A\u0004tc2$\u0016\u0010]3\u0011\u0007A\u000bY(C\u0002\u0002~E\u00131!\u00138u\u0011\u0019\t\ti\u0004a\u0001W\u0006AA/\u001f9f\u001d\u0006lW\rC\u0004\u0002\u0006>\u0001\r!!\u001f\u0002\tML'0\u001a\u0005\b\u0003\u0013{\u0001\u0019AAF\u0003\tiG\r\u0005\u0003\u0002l\u00055\u0015\u0002BAH\u0003[\u0012q\"T3uC\u0012\fG/\u0019\"vS2$WM]\u0001\fO\u0016$(\n\u0012\"D)f\u0004X\r\u0006\u0003\u0002\u0016\u0006u\u0005#\u0002)\u0002L\u0005]\u0005cA\"\u0002\u001a&\u0019\u00111\u0014\u001c\u0003\u0011)#'m\u0019+za\u0016Dq!a(\u0011\u0001\u0004\tI'\u0001\u0002ei\u0006A\u0012n]\"bg\u000e\fG-\u001b8h)J,hnY1uKR\u000b'\r\\3\u0015\u0005\u0005\u0015\u0006\u0003\u0002)\u0002L\u0019\f\u0001cZ3u)J,hnY1uKF+XM]=\u0015\u000b-\fY+a,\t\r\u00055&\u00031\u0001l\u0003\u0015!\u0018M\u00197f\u0011%\t\tL\u0005I\u0001\u0002\u0004\t)+A\u0004dCN\u001c\u0017\rZ3\u00025\u001d,G\u000f\u0016:v]\u000e\fG/Z)vKJLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005]&\u0006BAS\u0003s[#!a/\u0011\t\u0005u\u0016qY\u0007\u0003\u0003\u007fSA!!1\u0002D\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u000b\f\u0016AC1o]>$\u0018\r^5p]&!\u0011\u0011ZA`\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\fe\u0016t\u0017-\\3UC\ndW\rF\u0003l\u0003\u001f\fy\u000eC\u0004\u0002RR\u0001\r!a5\u0002\u0011=dG\rV1cY\u0016\u0004B!!6\u0002\\6\u0011\u0011q\u001b\u0006\u0005\u00033\fY&A\u0004dCR\fGn\\4\n\t\u0005u\u0017q\u001b\u0002\u000b\u0013\u0012,g\u000e^5gS\u0016\u0014\bbBAq)\u0001\u0007\u00111[\u0001\t]\u0016<H+\u00192mK\u0006Ar-\u001a;Va\u0012\fG/Z\"pYVlg\u000eV=qKF+XM]=\u0015\u000f-\f9/a;\u0002p\"1\u0011\u0011^\u000bA\u0002-\f\u0011\u0002^1cY\u0016t\u0015-\\3\t\r\u00055X\u00031\u0001l\u0003)\u0019w\u000e\\;n]:\u000bW.\u001a\u0005\u0007\u0003c,\u0002\u0019A6\u0002\u00179,w\u000fR1uCRK\b/Z\u0001 O\u0016$X\u000b\u001d3bi\u0016\u001cu\u000e\\;n]:+H\u000e\\1cS2LG/_)vKJLHcB6\u0002x\u0006e\u00181 \u0005\u0007\u0003S4\u0002\u0019A6\t\r\u00055h\u00031\u0001l\u0011\u0019\tiP\u0006a\u0001M\u0006Q\u0011n\u001d(vY2\f'\r\\3\u00021I,Wn\u001c<f'\u000eDW-\\1D_6lWM\u001c;Rk\u0016\u0014\u0018\u0010F\u0002l\u0005\u0007AaA!\u0002\u0018\u0001\u0004Y\u0017AB:dQ\u0016l\u0017-A\tdY\u0006\u001c8/\u001b4z\u000bb\u001cW\r\u001d;j_:$\"Ba\u0003\u0003\u0014\tu!\u0011\u0005B\u0016!\u0011\u0011iAa\u0004\u000e\u0003aJ1A!\u00059\u0005E\te.\u00197zg&\u001cX\t_2faRLwN\u001c\u0005\b\u0005+A\u0002\u0019\u0001B\f\u0003\u0005)\u0007c\u0001,\u0003\u001a%\u0019!1\u00041\u0003\u0013QC'o\\<bE2,\u0007B\u0002B\u00101\u0001\u00071.\u0001\u0006feJ|'o\u00117bgNDqAa\t\u0019\u0001\u0004\u0011)#A\tnKN\u001c\u0018mZ3QCJ\fW.\u001a;feN\u0004R\u0001\u001cB\u0014W.L1A!\u000bs\u0005\ri\u0015\r\u001d\u0005\u0007\u0005[A\u0002\u0019A6\u0002\u0017\u0011,7o\u0019:jaRLwN\\\u0001\u000bIJ|\u0007oU2iK6\fG#B6\u00034\tU\u0002B\u0002B\u00033\u0001\u00071\u000e\u0003\u0004\u00022f\u0001\rAZ\u0001\u000fO\u0016$H*[7ji\u000ec\u0017-^:f)\rY'1\b\u0005\b\u0005{Q\u0002\u0019\u0001B \u0003\u0015a\u0017.\\5u!\rq(\u0011I\u0005\u0004\u0005\u0007z(aB%oi\u0016<WM]\u0001\u0010O\u0016$xJ\u001a4tKR\u001cE.Y;tKR\u00191N!\u0013\t\u000f\t-3\u00041\u0001\u0003@\u00051qN\u001a4tKR\u0014!\u0003\u0012\"3'Fc\u0015+^3ss\n+\u0018\u000e\u001c3feN\u0019AD!\u0015\u0011\u0007\r\u0013\u0019&C\u0002\u0003VY\u00121C\u00133cGN\u000bF*U;fef\u0014U/\u001b7eKJ\fq\u0001Z5bY\u0016\u001cG/A\u0004paRLwN\\:\u0011\t\tu#\u0011N\u0007\u0003\u0005?R1a\u000eB1\u0015\u0011\u0011\u0019G!\u001a\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0004\u0005OB\u0014!C3yK\u000e,H/[8o\u0013\u0011\u0011YGa\u0018\u0003\u0017)#%iQ(qi&|gn\u001d\u000b\u0007\u0005_\u0012\tHa\u001d\u0011\u0007\u0005\u0005B\u0004\u0003\u0004\u0003X}\u0001\rA\u0011\u0005\b\u00053z\u0002\u0019\u0001B.\u0003\u0015\u0011W/\u001b7e)\u0005Y\u0017AF4fi*#'mY*R\u0019F+XM]=Ck&dG-\u001a:\u0015\t\tE#Q\u0010\u0005\b\u00053\n\u0003\u0019\u0001B.\u00035\u0019X\u000f\u001d9peR\u001cH*[7jiV\ta-\u0001\btkB\u0004xN\u001d;t\u001f\u001a47/\u001a;\u0002\t\r|\u0007/_\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0003u\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u001f\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!1\u0013BM!\r\u0001&QS\u0005\u0004\u0005/\u000b&aA!os\"I!1T\u0014\u0002\u0002\u0003\u0007\u0011\u0011P\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t\u0005\u0006C\u0002BR\u0005K\u0013\u0019*D\u0001z\u0013\r\u00119+\u001f\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002g\u0005[C\u0011Ba'*\u0003\u0003\u0005\rAa%\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0004{\nM\u0006\"\u0003BNU\u0005\u0005\t\u0019AA=\u0003!A\u0017m\u001d5D_\u0012,GCAA=\u0003!!xn\u0015;sS:<G#A?\u0002\r\u0015\fX/\u00197t)\r1'\u0011\u0019\u0005\n\u00057k\u0013\u0011!a\u0001\u0005'\u000b!\u0002\u0012\"3\t&\fG.Z2u!\t\u0019ufE\u00030\u0005\u0013\u0014)\u000eE\u0003\u0003L\nE7-\u0004\u0002\u0003N*\u0019!qZ)\u0002\u000fI,h\u000e^5nK&!!1\u001bBg\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g\u000e\r\t\u0005\u0005/\u0014i.\u0004\u0002\u0003Z*!!1\\A\u0002\u0003\tIw.C\u0002`\u00053$\"A!2\u0002\u000b\u0005\u0004\b\u000f\\=\u0002\u000fUt\u0017\r\u001d9msR\u0019aMa:\t\u0011\t%8'!AA\u0002\r\f1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011y\u000fE\u0002\u007f\u0005cL1Aa=\u0000\u0005\u0019y%M[3di\u0002")
public class DB2Dialect
extends JdbcDialect
implements SQLConfHelper,
NoLegacyJDBCError,
Product {
    private final Set<String> org$apache$spark$sql$jdbc$DB2Dialect$$distinctUnsupportedAggregateFunctions;
    private final Set<String> supportedAggregateFunctions;
    private final Set<String> supportedFunctions;

    public static boolean unapply(DB2Dialect x$0) {
        return DB2Dialect$.MODULE$.unapply(x$0);
    }

    public static DB2Dialect apply() {
        return DB2Dialect$.MODULE$.apply();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:db2");
    }

    public Set<String> org$apache$spark$sql$jdbc$DB2Dialect$$distinctUnsupportedAggregateFunctions() {
        return this.org$apache$spark$sql$jdbc$DB2Dialect$$distinctUnsupportedAggregateFunctions;
    }

    private Set<String> supportedAggregateFunctions() {
        return this.supportedAggregateFunctions;
    }

    private Set<String> supportedFunctions() {
        return this.supportedFunctions;
    }

    @Override
    public boolean isSupportedFunction(String funcName) {
        return this.supportedFunctions().contains((Object)funcName);
    }

    @Override
    public Option<String> compileExpression(Expression expr) {
        Some some;
        DB2SQLBuilder db2SQLBuilder = new DB2SQLBuilder(this);
        try {
            some = new Some((Object)db2SQLBuilder.build(expr));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(throwable2)) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Error occurs while compiling V2 expression", throwable2);
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        int n = sqlType;
        switch (n) {
            case 5: {
                if (this.conf().legacyDB2numericMappingEnabled()) break;
                return Option$.MODULE$.apply((Object)ShortType$.MODULE$);
            }
            case 7: {
                return Option$.MODULE$.apply((Object)FloatType$.MODULE$);
            }
            case 1111: {
                String string = typeName;
                switch (string == null ? 0 : string.hashCode()) {
                    case 87031: {
                        if (!"XML".equals(string)) break;
                        return Option$.MODULE$.apply((Object)StringType$.MODULE$);
                    }
                    case 1345372058: {
                        if (!"DECFLOAT".equals(string)) break;
                        return Option$.MODULE$.apply((Object)new DecimalType(38, 18));
                    }
                }
                if (string.startsWith("TIMESTAMP")) {
                    return Option$.MODULE$.apply((Object)TimestampType$.MODULE$);
                }
                return None$.MODULE$;
            }
        }
        return None$.MODULE$;
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        boolean bl = false;
        DataType dataType = null;
        DataType dataType2 = dt;
        if (StringType$.MODULE$.equals(dataType2)) {
            return Option$.MODULE$.apply((Object)new JdbcType("CLOB", 2005));
        }
        if (BooleanType$.MODULE$.equals(dataType2)) {
            bl = true;
            dataType = dataType2;
            if (this.conf().legacyDB2BooleanMappingEnabled()) {
                return Option$.MODULE$.apply((Object)new JdbcType("CHAR(1)", 1));
            }
        }
        if (bl) {
            return Option$.MODULE$.apply((Object)new JdbcType("BOOLEAN", 16));
        }
        if (ShortType$.MODULE$.equals(dataType2) ? true : ByteType$.MODULE$.equals(dataType2)) {
            return new Some((Object)new JdbcType("SMALLINT", 5));
        }
        return None$.MODULE$;
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public String getTruncateQuery(String table, Option<Object> cascade) {
        return "TRUNCATE TABLE " + table + " IMMEDIATE";
    }

    @Override
    public Option<Object> getTruncateQuery$default$2() {
        return this.isCascadingTruncateTable();
    }

    @Override
    public String renameTable(Identifier oldTable, Identifier newTable) {
        return "RENAME TABLE " + this.getFullyQualifiedQuotedTableName(oldTable) + " TO " + this.getFullyQualifiedQuotedTableName(newTable);
    }

    @Override
    public String getUpdateColumnTypeQuery(String tableName, String columnName, String newDataType) {
        return "ALTER TABLE " + tableName + " ALTER COLUMN " + this.quoteIdentifier(columnName) + " SET DATA TYPE " + newDataType;
    }

    @Override
    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        String nullable = isNullable ? "DROP NOT NULL" : "SET NOT NULL";
        return "ALTER TABLE " + tableName + " ALTER COLUMN " + this.quoteIdentifier(columnName) + " " + nullable;
    }

    @Override
    public String removeSchemaCommentQuery(String schema) {
        return "COMMENT ON SCHEMA " + this.quoteIdentifier(schema) + " IS ''";
    }

    @Override
    public AnalysisException classifyException(Throwable e, String errorClass, Map<String, String> messageParameters, String description) {
        Throwable throwable = e;
        if (throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            String string = sQLException.getSQLState();
            switch (string == null ? 0 : string.hashCode()) {
                case 49567064: {
                    if (!"42710".equals(string)) break;
                    String string2 = errorClass;
                    String string3 = "FAILED_JDBC.RENAME_TABLE";
                    if (string2 != null ? !string2.equals(string3) : string3 != null) break;
                    String newTable = (String)messageParameters.apply((Object)"newName");
                    throw QueryCompilationErrors$.MODULE$.tableAlreadyExistsError(newTable);
                }
                case 49568276: {
                    if (!"42893".equals(string)) break;
                    throw new NonEmptyNamespaceException((String[])Option$.MODULE$.option2Iterable(messageParameters.get((Object)"namespace")).toArray(ClassTag$.MODULE$.apply(String.class)), sQLException.getMessage(), (Option)new Some((Object)e));
                }
            }
            return NoLegacyJDBCError.classifyException$(this, e, errorClass, messageParameters, description);
        }
        return NoLegacyJDBCError.classifyException$(this, e, errorClass, messageParameters, description);
    }

    @Override
    public String dropSchema(String schema, boolean cascade) {
        if (cascade) {
            return "DROP SCHEMA " + this.quoteIdentifier(schema) + " CASCADE";
        }
        return "DROP SCHEMA " + this.quoteIdentifier(schema) + " RESTRICT";
    }

    @Override
    public String getLimitClause(Integer limit) {
        if (Predef$.MODULE$.Integer2int(limit) > 0) {
            return "FETCH FIRST " + limit + " ROWS ONLY";
        }
        return "";
    }

    @Override
    public String getOffsetClause(Integer offset) {
        if (Predef$.MODULE$.Integer2int(offset) > 0) {
            return "OFFSET " + offset + " ROWS";
        }
        return "";
    }

    @Override
    public JdbcSQLQueryBuilder getJdbcSQLQueryBuilder(JDBCOptions options) {
        return new DB2SQLQueryBuilder(this, this, options);
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsOffset() {
        return true;
    }

    public DB2Dialect copy() {
        return new DB2Dialect();
    }

    public String productPrefix() {
        return "DB2Dialect";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DB2Dialect;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean equals(Object x$1) {
        Object object = x$1;
        return object instanceof DB2Dialect && ((DB2Dialect)x$1).canEqual(this);
    }

    public DB2Dialect() {
        SQLConfHelper.$init$((SQLConfHelper)this);
        NoLegacyJDBCError.$init$(this);
        Product.$init$((Product)this);
        this.org$apache$spark$sql$jdbc$DB2Dialect$$distinctUnsupportedAggregateFunctions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"COVAR_POP", "COVAR_SAMP", "REGR_INTERCEPT", "REGR_R2", "REGR_SLOPE", "REGR_SXY"}));
        this.supportedAggregateFunctions = (Set)((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"MAX", "MIN", "SUM", "COUNT", "AVG", "VAR_POP", "VAR_SAMP", "STDDEV_POP", "STDDEV_SAMP"}))).$plus$plus(this.org$apache$spark$sql$jdbc$DB2Dialect$$distinctUnsupportedAggregateFunctions());
        this.supportedFunctions = this.supportedAggregateFunctions();
    }

    public class DB2SQLBuilder
    extends JdbcDialect.JDBCSQLBuilder {
        @Override
        public String visitAggregateFunction(String funcName, boolean isDistinct, String[] inputs) {
            if (isDistinct && this.org$apache$spark$sql$jdbc$DB2Dialect$DB2SQLBuilder$$$outer().org$apache$spark$sql$jdbc$DB2Dialect$$distinctUnsupportedAggregateFunctions().contains((Object)funcName)) {
                throw new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_3184", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"class"), (Object)this.getClass().getSimpleName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"funcName"), (Object)funcName)})));
            }
            return super.visitAggregateFunction(funcName, isDistinct, inputs);
        }

        @Override
        public String dialectFunctionName(String funcName) {
            String string = funcName;
            switch (string == null ? 0 : string.hashCode()) {
                case -1782591723: {
                    if (!"COVAR_SAMP".equals(string)) break;
                    return "COVARIANCE_SAMP";
                }
                case -446106967: {
                    if (!"VAR_SAMP".equals(string)) break;
                    return "VARIANCE_SAMP";
                }
                case -102600828: {
                    if (!"STDDEV_POP".equals(string)) break;
                    return "STDDEV";
                }
                case 358136589: {
                    if (!"COVAR_POP".equals(string)) break;
                    return "COVARIANCE";
                }
                case 955438329: {
                    if (!"VAR_POP".equals(string)) break;
                    return "VARIANCE";
                }
                case 1114417534: {
                    if (!"STDDEV_SAMP".equals(string)) break;
                    return "STDDEV_SAMP";
                }
            }
            return super.dialectFunctionName(funcName);
        }

        public /* synthetic */ DB2Dialect org$apache$spark$sql$jdbc$DB2Dialect$DB2SQLBuilder$$$outer() {
            return (DB2Dialect)this.$outer;
        }

        public DB2SQLBuilder(DB2Dialect $outer) {
            super($outer);
        }
    }

    public class DB2SQLQueryBuilder
    extends JdbcSQLQueryBuilder {
        private final JdbcDialect dialect;
        private final JDBCOptions options;
        public final /* synthetic */ DB2Dialect $outer;

        @Override
        public String build() {
            String limitClause = this.dialect.getLimitClause(Predef$.MODULE$.int2Integer(this.limit()));
            String offsetClause = this.dialect.getOffsetClause(Predef$.MODULE$.int2Integer(this.offset()));
            return this.options.prepareQuery() + "SELECT " + this.columnList() + " FROM " + this.options.tableOrQuery() + " " + this.tableSampleClause() + " " + this.whereClause() + " " + this.groupByClause() + " " + this.orderByClause() + " " + offsetClause + " " + limitClause;
        }

        public /* synthetic */ DB2Dialect org$apache$spark$sql$jdbc$DB2Dialect$DB2SQLQueryBuilder$$$outer() {
            return this.$outer;
        }

        public DB2SQLQueryBuilder(DB2Dialect $outer, JdbcDialect dialect, JDBCOptions options) {
            this.dialect = dialect;
            this.options = options;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(dialect, options);
        }
    }
}

