/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.v2.TableSampleInfo;
import org.apache.spark.sql.jdbc.DatabricksDialect$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.jdbc.NoLegacyJDBCError;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005=g\u0001B\u000f\u001f\t&BQa\u0011\u0001\u0005\u0002\u0011CQA\u0012\u0001\u0005B\u001dCQ!\u0016\u0001\u0005BYCQA\u001c\u0001\u0005B=DQA\u001e\u0001\u0005B]DQA\u001f\u0001\u0005BmDQ\u0001 \u0001\u0005BmDQ! \u0001\u0005BmDQA \u0001\u0005B}Dq!!\u0007\u0001\t\u0003\nY\u0002C\u0004\u0002B\u0001!\t%a\u0011\t\u0011\u0005E\u0003!!A\u0005\u0002\u0011C\u0011\"a\u0015\u0001\u0003\u0003%\t%!\u0016\t\u0013\u0005\u0005\u0004!!A\u0005\u0002\u0005\r\u0004\"CA3\u0001\u0005\u0005I\u0011AA4\u0011%\t\u0019\bAA\u0001\n\u0003\n)\bC\u0005\u0002\u0004\u0002\t\t\u0011\"\u0001\u0002\u0006\"I\u0011\u0011\u0012\u0001\u0002\u0002\u0013\u0005\u00131\u0012\u0005\n\u0003\u001f\u0003\u0011\u0011!C!\u0003#C\u0011\"a%\u0001\u0003\u0003%\t%!&\t\u0013\u0005]\u0005!!A\u0005B\u0005eu!CAO=\u0005\u0005\t\u0012BAP\r!ib$!A\t\n\u0005\u0005\u0006BB\"\u0018\t\u0003\tI\fC\u0005\u0002\u0014^\t\t\u0011\"\u0012\u0002\u0016\"A\u00111X\f\u0002\u0002\u0013\u0005E\tC\u0005\u0002>^\t\t\u0011\"!\u0002@\"I\u0011QY\f\u0002\u0002\u0013%\u0011q\u0019\u0002\u0012\t\u0006$\u0018M\u0019:jG.\u001cH)[1mK\u000e$(BA\u0010!\u0003\u0011QGMY2\u000b\u0005\u0005\u0012\u0013aA:rY*\u00111\u0005J\u0001\u0006gB\f'o\u001b\u0006\u0003K\u0019\na!\u00199bG\",'\"A\u0014\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001Qc&M\u001c\u0011\u0005-bS\"\u0001\u0010\n\u00055r\"a\u0003&eE\u000e$\u0015.\u00197fGR\u0004\"aK\u0018\n\u0005Ar\"!\u0005(p\u0019\u0016<\u0017mY=K\t\n\u001bUI\u001d:peB\u0011!'N\u0007\u0002g)\tA'A\u0003tG\u0006d\u0017-\u0003\u00027g\t9\u0001K]8ek\u000e$\bC\u0001\u001dA\u001d\tIdH\u0004\u0002;{5\t1H\u0003\u0002=Q\u00051AH]8pizJ\u0011\u0001N\u0005\u0003\u007fM\nq\u0001]1dW\u0006<W-\u0003\u0002B\u0005\na1+\u001a:jC2L'0\u00192mK*\u0011qhM\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0015\u0003\"a\u000b\u0001\u0002\u0013\r\fg\u000eS1oI2,GC\u0001%L!\t\u0011\u0014*\u0003\u0002Kg\t9!i\\8mK\u0006t\u0007\"\u0002'\u0003\u0001\u0004i\u0015aA;sYB\u0011aJ\u0015\b\u0003\u001fB\u0003\"AO\u001a\n\u0005E\u001b\u0014A\u0002)sK\u0012,g-\u0003\u0002T)\n11\u000b\u001e:j]\u001eT!!U\u001a\u0002\u001f\u001d,GoQ1uC2L8\u000f\u001e+za\u0016$Ra\u00161fO&\u00042A\r-[\u0013\tI6G\u0001\u0004PaRLwN\u001c\t\u00037zk\u0011\u0001\u0018\u0006\u0003;\u0002\nQ\u0001^=qKNL!a\u0018/\u0003\u0011\u0011\u000bG/\u0019+za\u0016DQ!Y\u0002A\u0002\t\fqa]9m)f\u0004X\r\u0005\u00023G&\u0011Am\r\u0002\u0004\u0013:$\b\"\u00024\u0004\u0001\u0004i\u0015\u0001\u0003;za\u0016t\u0015-\\3\t\u000b!\u001c\u0001\u0019\u00012\u0002\tML'0\u001a\u0005\u0006U\u000e\u0001\ra[\u0001\u0003[\u0012\u0004\"a\u00177\n\u00055d&aD'fi\u0006$\u0017\r^1Ck&dG-\u001a:\u0002\u0017\u001d,GO\u0013#C\u0007RK\b/\u001a\u000b\u0003aR\u00042A\r-r!\tY#/\u0003\u0002t=\tA!\n\u001a2d)f\u0004X\rC\u0003v\t\u0001\u0007!,\u0001\u0002ei\u0006y\u0011/^8uK&#WM\u001c;jM&,'\u000f\u0006\u0002Nq\")\u00110\u0002a\u0001\u001b\u000691m\u001c7OC6,\u0017!D:vaB|'\u000f^:MS6LG/F\u0001I\u00039\u0019X\u000f\u001d9peR\u001cxJ\u001a4tKR\f1c];qa>\u0014Ho\u001d+bE2,7+Y7qY\u0016\fabZ3u)\u0006\u0014G.Z*b[BdW\rF\u0002N\u0003\u0003Aq!a\u0001\n\u0001\u0004\t)!\u0001\u0004tC6\u0004H.\u001a\t\u0005\u0003\u000f\t)\"\u0004\u0002\u0002\n)!\u00111BA\u0007\u0003\t1(G\u0003\u0003\u0002\u0010\u0005E\u0011a\u00033bi\u0006\u001cx.\u001e:dKNT1!a\u0005!\u0003%)\u00070Z2vi&|g.\u0003\u0003\u0002\u0018\u0005%!a\u0004+bE2,7+Y7qY\u0016LeNZ8\u0002\u001bM\u001c\u0007.Z7bg\u0016C\u0018n\u001d;t)\u001dA\u0015QDA\u0018\u0003{Aq!a\b\u000b\u0001\u0004\t\t#\u0001\u0003d_:t\u0007\u0003BA\u0012\u0003Wi!!!\n\u000b\u0007\u0005\n9C\u0003\u0002\u0002*\u0005!!.\u0019<b\u0013\u0011\ti#!\n\u0003\u0015\r{gN\\3di&|g\u000eC\u0004\u00022)\u0001\r!a\r\u0002\u000f=\u0004H/[8ogB!\u0011QGA\u001d\u001b\t\t9DC\u0002 \u0003\u001bIA!a\u000f\u00028\tY!\n\u0012\"D\u001fB$\u0018n\u001c8t\u0011\u0019\tyD\u0003a\u0001\u001b\u000611o\u00195f[\u0006\f1\u0002\\5tiN\u001b\u0007.Z7bgR1\u0011QIA'\u0003\u001f\u0002RAMA$\u0003\u0017J1!!\u00134\u0005\u0015\t%O]1z!\u0011\u0011\u0014qI'\t\u000f\u0005}1\u00021\u0001\u0002\"!9\u0011\u0011G\u0006A\u0002\u0005M\u0012\u0001B2paf\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA,!\u0011\tI&a\u0018\u000e\u0005\u0005m#\u0002BA/\u0003O\tA\u0001\\1oO&\u00191+a\u0017\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0003\t\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002j\u0005=\u0004c\u0001\u001a\u0002l%\u0019\u0011QN\u001a\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0002r=\t\t\u00111\u0001c\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u000f\t\u0007\u0003s\ny(!\u001b\u000e\u0005\u0005m$bAA?g\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u0005\u00151\u0010\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002I\u0003\u000fC\u0011\"!\u001d\u0012\u0003\u0003\u0005\r!!\u001b\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003/\ni\t\u0003\u0005\u0002rI\t\t\u00111\u0001c\u0003!A\u0017m\u001d5D_\u0012,G#\u00012\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u0016\u0002\r\u0015\fX/\u00197t)\rA\u00151\u0014\u0005\n\u0003c*\u0012\u0011!a\u0001\u0003S\n\u0011\u0003R1uC\n\u0014\u0018nY6t\t&\fG.Z2u!\tYscE\u0003\u0018\u0003G\u000by\u000bE\u0003\u0002&\u0006-V)\u0004\u0002\u0002(*\u0019\u0011\u0011V\u001a\u0002\u000fI,h\u000e^5nK&!\u0011QVAT\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g\u000e\r\t\u0005\u0003c\u000b9,\u0004\u0002\u00024*!\u0011QWA\u0014\u0003\tIw.C\u0002B\u0003g#\"!a(\u0002\u000b\u0005\u0004\b\u000f\\=\u0002\u000fUt\u0017\r\u001d9msR\u0019\u0001*!1\t\u0011\u0005\r7$!AA\u0002\u0015\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\tI\r\u0005\u0003\u0002Z\u0005-\u0017\u0002BAg\u00037\u0012aa\u00142kK\u000e$\b")
public class DatabricksDialect
extends JdbcDialect
implements NoLegacyJDBCError,
Product {
    public static boolean unapply(DatabricksDialect x$0) {
        return DatabricksDialect$.MODULE$.unapply(x$0);
    }

    public static DatabricksDialect apply() {
        return DatabricksDialect$.MODULE$.apply();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    @Override
    public AnalysisException classifyException(Throwable e, String errorClass, Map<String, String> messageParameters, String description) {
        return NoLegacyJDBCError.classifyException$(this, e, errorClass, messageParameters, description);
    }

    @Override
    public boolean canHandle(String url) {
        return url.startsWith("jdbc:databricks");
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        int n = sqlType;
        switch (n) {
            case -6: {
                return new Some((Object)ByteType$.MODULE$);
            }
            case 5: {
                return new Some((Object)ShortType$.MODULE$);
            }
            case 7: {
                return new Some((Object)FloatType$.MODULE$);
            }
        }
        return None$.MODULE$;
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        DataType dataType = dt;
        if (BooleanType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("BOOLEAN", 16));
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("DOUBLE", 8));
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("STRING", 12));
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("BINARY", -2));
        }
        return None$.MODULE$;
    }

    @Override
    public String quoteIdentifier(String colName) {
        return "`" + colName + "`";
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsOffset() {
        return true;
    }

    @Override
    public boolean supportsTableSample() {
        return true;
    }

    @Override
    public String getTableSample(TableSampleInfo sample) {
        return "TABLESAMPLE (" + (sample.upperBound() - sample.lowerBound()) * (double)100 + ") REPEATABLE (" + sample.seed() + ")";
    }

    @Override
    public boolean schemasExists(Connection conn, JDBCOptions options, String schema) {
        PreparedStatement stmt = conn.prepareStatement("SHOW SCHEMAS");
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            String string = rs.getString(1);
            String string2 = schema;
            if (string != null ? !string.equals(string2) : string2 != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[][] listSchemas(Connection conn, JDBCOptions options) {
        ArrayBuilder schemaBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        PreparedStatement stmt = conn.prepareStatement("SHOW SCHEMAS");
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            schemaBuilder.$plus$eq((Object)new String[]{rs.getString(1)});
        }
        return (String[][])schemaBuilder.result();
    }

    public DatabricksDialect copy() {
        return new DatabricksDialect();
    }

    public String productPrefix() {
        return "DatabricksDialect";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DatabricksDialect;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean equals(Object x$1) {
        Object object = x$1;
        return object instanceof DatabricksDialect && ((DatabricksDialect)x$1).canEqual(this);
    }

    public DatabricksDialect() {
        NoLegacyJDBCError.$init$(this);
        Product.$init$((Product)this);
    }
}

