/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.analysis.IndexAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchIndexException;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;
import org.apache.spark.sql.connector.catalog.index.TableIndex;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.FieldReference$;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.jdbc.H2Dialect$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.jdbc.NoLegacyJDBCError;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.SetOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005\r\u0015a!B\u00193\u0001Rb\u0004\"B,\u0001\t\u0003A\u0006\"\u0002.\u0001\t\u0003Z\u0006bB5\u0001\u0005\u0004%IA\u001b\u0005\u0007u\u0002\u0001\u000b\u0011B6\t\u000fm\u0004!\u0019!C\u0005U\"1A\u0010\u0001Q\u0001\n-Dq! \u0001C\u0002\u0013%!\u000e\u0003\u0004\u007f\u0001\u0001\u0006Ia\u001b\u0005\u0007\u007f\u0002!\t%!\u0001\t\u000f\u0005\u001d\u0001\u0001\"\u0011\u0002\n!9\u0011\u0011\b\u0001\u0005B\u0005m\u0002\"CA%\u0001\t\u0007I\u0011BA&\u0011!\ti\u0007\u0001Q\u0001\n\u00055\u0003bBA8\u0001\u0011\u0005\u0011\u0011\u000f\u0005\b\u0003?\u0002A\u0011IA>\u0011\u001d\tI\t\u0001C\u0001\u0003\u0017Cq!a%\u0001\t\u0003\n)\nC\u0004\u0002J\u0002!\t%a3\t\u000f\u0005E\u0007\u0001\"\u0011\u0002T\"9\u0011Q \u0001\u0005B\u0005}\bb\u0002B\u000b\u0001\u0011%!q\u0003\u0005\b\u0005;\u0001A\u0011\u0002B\u0010\u0011\u001d\u0011)\u0003\u0001C!\u0005OAqAa\u0013\u0001\t\u0003\u0012iE\u0002\u0004\u0003\\\u0001\u0001!Q\f\u0005\u0007/f!\tAa\u001a\t\u000f\t-\u0014\u0004\"\u0011\u0003n!9!1P\r\u0005B\tu\u0004b\u0002BD3\u0011\u0005#\u0011\u0012\u0005\b\u0005\u001f\u0003A\u0011\tBI\u0011\u001d\u0011\u0019\n\u0001C!\u0005#C\u0001B!&\u0001\u0003\u0003%\t\u0001\u0017\u0005\n\u0005/\u0003\u0011\u0011!C!\u00053C\u0011Ba'\u0001\u0003\u0003%\tA!(\t\u0013\t}\u0005!!A\u0005\u0002\t\u0005\u0006\"\u0003BW\u0001\u0005\u0005I\u0011\tBX\u0011%\u0011I\fAA\u0001\n\u0003\u0011Y\fC\u0005\u0003@\u0002\t\t\u0011\"\u0011\u0003B\"I!Q\u0019\u0001\u0002\u0002\u0013\u0005#q\u0019\u0005\n\u0005\u0013\u0004\u0011\u0011!C!\u0005\u0017D\u0011B!4\u0001\u0003\u0003%\tEa4\b\u0015\tM''!A\t\u0002Q\u0012)NB\u00052e\u0005\u0005\t\u0012\u0001\u001b\u0003X\"1qk\u000bC\u0001\u0005_D\u0011B!3,\u0003\u0003%)Ea3\t\u0011\tE8&!A\u0005\u0002bC\u0011Ba=,\u0003\u0003%\tI!>\t\u0013\tm8&!A\u0005\n\tu(!\u0003%3\t&\fG.Z2u\u0015\t\u0019D'\u0001\u0003kI\n\u001c'BA\u001b7\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003oa\nQa\u001d9be.T!!\u000f\u001e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0014aA8sON)\u0001!P!E\u0015B\u0011ahP\u0007\u0002e%\u0011\u0001I\r\u0002\f\u0015\u0012\u00147\rR5bY\u0016\u001cG\u000f\u0005\u0002?\u0005&\u00111I\r\u0002\u0012\u001d>dUmZ1ds*#%iQ#se>\u0014\bCA#I\u001b\u00051%\"A$\u0002\u000bM\u001c\u0017\r\\1\n\u0005%3%a\u0002)s_\u0012,8\r\u001e\t\u0003\u0017Rs!\u0001\u0014*\u000f\u00055\u000bV\"\u0001(\u000b\u0005=\u0003\u0016A\u0002\u001fs_>$hh\u0001\u0001\n\u0003\u001dK!a\u0015$\u0002\u000fA\f7m[1hK&\u0011QK\u0016\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003'\u001a\u000ba\u0001P5oSRtD#A-\u0011\u0005y\u0002\u0011!C2b]\"\u000bg\u000e\u001a7f)\tav\f\u0005\u0002F;&\u0011aL\u0012\u0002\b\u0005>|G.Z1o\u0011\u0015\u0001'\u00011\u0001b\u0003\r)(\u000f\u001c\t\u0003E\u001at!a\u00193\u0011\u000553\u0015BA3G\u0003\u0019\u0001&/\u001a3fM&\u0011q\r\u001b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u00154\u0015!\n3jgRLgn\u0019;V]N,\b\u000f]8si\u0016$\u0017iZ4sK\u001e\fG/\u001a$v]\u000e$\u0018n\u001c8t+\u0005Y\u0007c\u00017rg6\tQN\u0003\u0002o_\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003a\u001a\u000b!bY8mY\u0016\u001cG/[8o\u0013\t\u0011XNA\u0002TKR\u0004\"\u0001^=\u000e\u0003UT!A^<\u0002\t1\fgn\u001a\u0006\u0002q\u0006!!.\u0019<b\u0013\t9W/\u0001\u0014eSN$\u0018N\\2u+:\u001cX\u000f\u001d9peR,G-Q4he\u0016<\u0017\r^3Gk:\u001cG/[8og\u0002\n1d];qa>\u0014H/\u001a3BO\u001e\u0014XmZ1uK\u001a+hn\u0019;j_:\u001c\u0018\u0001H:vaB|'\u000f^3e\u0003\u001e<'/Z4bi\u00164UO\\2uS>t7\u000fI\u0001\u0013gV\u0004\bo\u001c:uK\u00124UO\\2uS>t7/A\ntkB\u0004xN\u001d;fI\u001a+hn\u0019;j_:\u001c\b%A\njgN+\b\u000f]8si\u0016$g)\u001e8di&|g\u000eF\u0002]\u0003\u0007Aa!!\u0002\n\u0001\u0004\t\u0017\u0001\u00034v]\u000et\u0015-\\3\u0002\u001f\u001d,GoQ1uC2L8\u000f\u001e+za\u0016$\"\"a\u0003\u0002\u001e\u0005\u001d\u00121FA\u0018!\u0015)\u0015QBA\t\u0013\r\tyA\u0012\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005M\u0011\u0011D\u0007\u0003\u0003+Q1!a\u00065\u0003\u0015!\u0018\u0010]3t\u0013\u0011\tY\"!\u0006\u0003\u0011\u0011\u000bG/\u0019+za\u0016Dq!a\b\u000b\u0001\u0004\t\t#A\u0004tc2$\u0016\u0010]3\u0011\u0007\u0015\u000b\u0019#C\u0002\u0002&\u0019\u00131!\u00138u\u0011\u0019\tIC\u0003a\u0001C\u0006AA/\u001f9f\u001d\u0006lW\rC\u0004\u0002.)\u0001\r!!\t\u0002\tML'0\u001a\u0005\b\u0003cQ\u0001\u0019AA\u001a\u0003\tiG\r\u0005\u0003\u0002\u0014\u0005U\u0012\u0002BA\u001c\u0003+\u0011q\"T3uC\u0012\fG/\u0019\"vS2$WM]\u0001\fO\u0016$(\n\u0012\"D)f\u0004X\r\u0006\u0003\u0002>\u0005\u0015\u0003#B#\u0002\u000e\u0005}\u0002c\u0001 \u0002B%\u0019\u00111\t\u001a\u0003\u0011)#'m\u0019+za\u0016Dq!a\u0012\f\u0001\u0004\t\t\"\u0001\u0002ei\u0006Ya-\u001e8di&|g.T1q+\t\ti\u0005E\u0004\u0002P\u0005U\u0013-!\u0017\u000e\u0005\u0005E#bAA*o\u0006!Q\u000f^5m\u0013\u0011\t9&!\u0015\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002\\\u0005%TBAA/\u0015\u0011\ty&!\u0019\u0002\u0013\u0019,hn\u0019;j_:\u001c(\u0002BA2\u0003K\nqaY1uC2|wMC\u0002\u0002hQ\n\u0011bY8o]\u0016\u001cGo\u001c:\n\t\u0005-\u0014Q\f\u0002\u0010+:\u0014w.\u001e8e\rVt7\r^5p]\u0006aa-\u001e8di&|g.T1qA\u0005\u0001\"/Z4jgR,'OR;oGRLwN\u001c\u000b\u0007\u00033\n\u0019(a\u001e\t\r\u0005Ud\u00021\u0001b\u0003\u0011q\u0017-\\3\t\u000f\u0005ed\u00021\u0001\u0002Z\u0005\u0011aM\\\u000b\u0003\u0003{\u0002RaSA@\u0003\u0007K1!!!W\u0005\r\u0019V-\u001d\t\u0007\u000b\u0006\u0015\u0015-!\u0017\n\u0007\u0005\u001deI\u0001\u0004UkBdWMM\u0001\u000fG2,\u0017M\u001d$v]\u000e$\u0018n\u001c8t)\t\ti\tE\u0002F\u0003\u001fK1!!%G\u0005\u0011)f.\u001b;\u0002\u0017\r\u0014X-\u0019;f\u0013:$W\r\u001f\u000b\fC\u0006]\u00151TAT\u0003{\u000b)\r\u0003\u0004\u0002\u001aF\u0001\r!Y\u0001\nS:$W\r\u001f(b[\u0016Dq!!(\u0012\u0001\u0004\ty*\u0001\u0006uC\ndW-\u00133f]R\u0004B!!)\u0002$6\u0011\u0011\u0011M\u0005\u0005\u0003K\u000b\tG\u0001\u0006JI\u0016tG/\u001b4jKJDq!!+\u0012\u0001\u0004\tY+A\u0004d_2,XN\\:\u0011\u000b\u0015\u000bi+!-\n\u0007\u0005=fIA\u0003BeJ\f\u0017\u0010\u0005\u0003\u00024\u0006eVBAA[\u0015\u0011\t9,!\u001a\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0005\u0003w\u000b)L\u0001\bOC6,GMU3gKJ,gnY3\t\u000f\u0005}\u0016\u00031\u0001\u0002B\u0006\t2m\u001c7v[:\u001c\bK]8qKJ$\u0018.Z:\u0011\u0011\u0005=\u0013QKAY\u0003\u0007\u0004b!a\u0014\u0002V\u0005\f\u0007bBAd#\u0001\u0007\u00111Y\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001c\u0018!\u00033s_BLe\u000eZ3y)\u0015\t\u0017QZAh\u0011\u0019\tIJ\u0005a\u0001C\"9\u0011Q\u0014\nA\u0002\u0005}\u0015aC5oI\u0016DX\t_5tiN$\u0012\u0002XAk\u0003G\f)/a:\t\u000f\u0005]7\u00031\u0001\u0002Z\u0006!1m\u001c8o!\u0011\tY.a8\u000e\u0005\u0005u'BA\u001bx\u0013\u0011\t\t/!8\u0003\u0015\r{gN\\3di&|g\u000e\u0003\u0004\u0002\u001aN\u0001\r!\u0019\u0005\b\u0003;\u001b\u0002\u0019AAP\u0011\u001d\tIo\u0005a\u0001\u0003W\fqa\u001c9uS>t7\u000f\u0005\u0003\u0002n\u0006eXBAAx\u0015\r\u0019\u0014\u0011\u001f\u0006\u0005\u0003g\f)0A\u0006eCR\f7o\\;sG\u0016\u001c(bAA|i\u0005IQ\r_3dkRLwN\\\u0005\u0005\u0003w\fyOA\u0006K\t\n\u001bu\n\u001d;j_:\u001c\u0018a\u00037jgRLe\u000eZ3yKN$\u0002B!\u0001\u0003\u0010\tE!1\u0003\t\u0006\u000b\u00065&1\u0001\t\u0005\u0005\u000b\u0011Y!\u0004\u0002\u0003\b)!!\u0011BA1\u0003\u0015Ig\u000eZ3y\u0013\u0011\u0011iAa\u0002\u0003\u0015Q\u000b'\r\\3J]\u0012,\u0007\u0010C\u0004\u0002XR\u0001\r!!7\t\u000f\u0005uE\u00031\u0001\u0002 \"9\u0011\u0011\u001e\u000bA\u0002\u0005-\u0018a\u0005;bE2,g*Y7f/&$\bnU2iK6\fGcA1\u0003\u001a!9!1D\u000bA\u0002\u0005}\u0015!B5eK:$\u0018aE5oI\u0016Dh*Y7f/&$\bnU2iK6\fG#B1\u0003\"\t\r\u0002b\u0002B\u000e-\u0001\u0007\u0011q\u0014\u0005\u0007\u000333\u0002\u0019A1\u0002#\rd\u0017m]:jMf,\u0005pY3qi&|g\u000e\u0006\u0006\u0003*\tE\"1\bB \u0005\u000f\u0002BAa\u000b\u0003.5\tA'C\u0002\u00030Q\u0012\u0011#\u00118bYf\u001c\u0018n]#yG\u0016\u0004H/[8o\u0011\u001d\u0011\u0019d\u0006a\u0001\u0005k\t\u0011!\u001a\t\u0004\u0017\n]\u0012b\u0001B\u001d-\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0005\u0007\u0005{9\u0002\u0019A1\u0002\u0015\u0015\u0014(o\u001c:DY\u0006\u001c8\u000fC\u0004\u0003B]\u0001\rAa\u0011\u0002#5,7o]1hKB\u000b'/Y7fi\u0016\u00148\u000fE\u0003c\u0005\u000b\n\u0017-C\u0002\u0002X!DaA!\u0013\u0018\u0001\u0004\t\u0017a\u00033fg\u000e\u0014\u0018\u000e\u001d;j_:\f\u0011cY8na&dW-\u0012=qe\u0016\u001c8/[8o)\u0011\u0011yE!\u0015\u0011\t\u0015\u000bi!\u0019\u0005\b\u0005'B\u0002\u0019\u0001B+\u0003\u0011)\u0007\u0010\u001d:\u0011\t\u0005M&qK\u0005\u0005\u00053\n)L\u0001\u0006FqB\u0014Xm]:j_:\u0014A\u0002\u0013\u001aT#2\u0013U/\u001b7eKJ\u001c2!\u0007B0!\u0011\u0011\tGa\u0019\u000e\u0003\u0001I1A!\u001a@\u00059QEIQ\"T#2\u0013U/\u001b7eKJ$\"A!\u001b\u0011\u0007\t\u0005\u0014$\u0001\fwSNLG/Q4he\u0016<\u0017\r^3Gk:\u001cG/[8o)\u001d\t'q\u000eB9\u0005kBa!!\u0002\u001c\u0001\u0004\t\u0007B\u0002B:7\u0001\u0007A,\u0001\u0006jg\u0012K7\u000f^5oGRDqAa\u001e\u001c\u0001\u0004\u0011I(\u0001\u0004j]B,Ho\u001d\t\u0005\u000b\u00065\u0016-\u0001\u0007wSNLG/\u0012=ue\u0006\u001cG\u000fF\u0003b\u0005\u007f\u0012\u0019\t\u0003\u0004\u0003\u0002r\u0001\r!Y\u0001\u0006M&,G\u000e\u001a\u0005\u0007\u0005\u000bc\u0002\u0019A1\u0002\rM|WO]2f\u0003A1\u0018n]5u'Fce)\u001e8di&|g\u000eF\u0003b\u0005\u0017\u0013i\t\u0003\u0004\u0002\u0006u\u0001\r!\u0019\u0005\b\u0005oj\u0002\u0019\u0001B=\u00035\u0019X\u000f\u001d9peR\u001cH*[7jiV\tA,\u0001\btkB\u0004xN\u001d;t\u001f\u001a47/\u001a;\u0002\t\r|\u0007/_\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0003M\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\t\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!1\u0015BU!\r)%QU\u0005\u0004\u0005O3%aA!os\"I!1V\u0012\u0002\u0002\u0003\u0007\u0011\u0011E\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\tE\u0006C\u0002BZ\u0005k\u0013\u0019+D\u0001p\u0013\r\u00119l\u001c\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002]\u0005{C\u0011Ba+&\u0003\u0003\u0005\rAa)\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0004g\n\r\u0007\"\u0003BVM\u0005\u0005\t\u0019AA\u0011\u0003!A\u0017m\u001d5D_\u0012,GCAA\u0011\u0003!!xn\u0015;sS:<G#A:\u0002\r\u0015\fX/\u00197t)\ra&\u0011\u001b\u0005\n\u0005WK\u0013\u0011!a\u0001\u0005G\u000b\u0011\u0002\u0013\u001aES\u0006dWm\u0019;\u0011\u0005yZ3#B\u0016\u0003Z\n\u0015\b#\u0002Bn\u0005CLVB\u0001Bo\u0015\r\u0011yNR\u0001\beVtG/[7f\u0013\u0011\u0011\u0019O!8\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0007\u0007\u0005\u0003\u0003h\n5XB\u0001Bu\u0015\r\u0011Yo^\u0001\u0003S>L1!\u0016Bu)\t\u0011).A\u0003baBd\u00170A\u0004v]\u0006\u0004\b\u000f\\=\u0015\u0007q\u00139\u0010\u0003\u0005\u0003z>\n\t\u00111\u0001Z\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005\u007f\u00042\u0001^B\u0001\u0013\r\u0019\u0019!\u001e\u0002\u0007\u001f\nTWm\u0019;")
public class H2Dialect
extends JdbcDialect
implements NoLegacyJDBCError,
Product {
    private final Set<String> org$apache$spark$sql$jdbc$H2Dialect$$distinctUnsupportedAggregateFunctions;
    private final Set<String> supportedAggregateFunctions;
    private final Set<String> supportedFunctions;
    private final Map<String, UnboundFunction> functionMap;

    public static boolean unapply(H2Dialect x$0) {
        return H2Dialect$.MODULE$.unapply(x$0);
    }

    public static H2Dialect apply() {
        return H2Dialect$.MODULE$.apply();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:h2");
    }

    public Set<String> org$apache$spark$sql$jdbc$H2Dialect$$distinctUnsupportedAggregateFunctions() {
        return this.org$apache$spark$sql$jdbc$H2Dialect$$distinctUnsupportedAggregateFunctions;
    }

    private Set<String> supportedAggregateFunctions() {
        return this.supportedAggregateFunctions;
    }

    private Set<String> supportedFunctions() {
        return this.supportedFunctions;
    }

    @Override
    public boolean isSupportedFunction(String funcName) {
        return this.supportedFunctions().contains((Object)funcName);
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        int n = sqlType;
        switch (n) {
            case 2: {
                if (size <= 38) break;
                long scale = md != null ? md.build().getLong("scale") : 0L;
                int selectedScale = (int)((double)DecimalType$.MODULE$.MAX_PRECISION() * ((double)scale / (double)size));
                return Option$.MODULE$.apply((Object)new DecimalType(DecimalType$.MODULE$.MAX_PRECISION(), selectedScale));
            }
            case 2013: 
            case 2014: {
                return new Some((Object)TimestampType$.MODULE$);
            }
        }
        return None$.MODULE$;
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        DataType dataType = dt;
        if (StringType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("CLOB", 2005));
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("BOOLEAN", 16));
        }
        if (ShortType$.MODULE$.equals(dataType) ? true : ByteType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("SMALLINT", 5));
        }
        if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            return new Some((Object)new JdbcType("NUMERIC(" + decimalType.precision() + "," + decimalType.scale() + ")", 2));
        }
        return JdbcUtils$.MODULE$.getCommonJDBCType(dt);
    }

    private Map<String, UnboundFunction> functionMap() {
        return this.functionMap;
    }

    public UnboundFunction registerFunction(String name, UnboundFunction fn) {
        return this.functionMap().put(name, fn);
    }

    @Override
    public Seq<Tuple2<String, UnboundFunction>> functions() {
        return CollectionConverters$.MODULE$.MapHasAsScala(this.functionMap()).asScala().toSeq();
    }

    public void clearFunctions() {
        this.functionMap().clear();
    }

    @Override
    public String createIndex(String indexName, Identifier tableIdent, NamedReference[] columns, Map<NamedReference, Map<String, String>> columnsProperties, Map<String, String> properties) {
        String[] columnList = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])columns), (Function1 & Serializable)col -> this.quoteIdentifier((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])col.fieldNames()))), ClassTag$.MODULE$.apply(String.class));
        Tuple2<String, String[]> tuple2 = JdbcUtils$.MODULE$.processIndexProperties(properties, "h2");
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String indexType = (String)tuple2._1();
        String indexType2 = indexType;
        return "CREATE INDEX " + this.quoteIdentifier(indexName) + " " + indexType2 + " ON " + this.tableNameWithSchema(tableIdent) + " (" + Predef$.MODULE$.wrapRefArray((Object[])columnList).mkString(", ") + ")";
    }

    @Override
    public String dropIndex(String indexName, Identifier tableIdent) {
        return "DROP INDEX " + this.indexNameWithSchema(tableIdent, indexName);
    }

    @Override
    public boolean indexExists(Connection conn, String indexName, Identifier tableIdent, JDBCOptions options) {
        String sql = "SELECT * FROM INFORMATION_SCHEMA.INDEXES WHERE TABLE_SCHEMA = '" + ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])tableIdent.namespace())) + "' AND TABLE_NAME = '" + tableIdent.name() + "' AND INDEX_NAME = '" + indexName + "'";
        return JdbcUtils$.MODULE$.checkIfIndexExists(conn, sql, options);
    }

    @Override
    public TableIndex[] listIndexes(Connection conn, Identifier tableIdent, JDBCOptions options) {
        String sql = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         | SELECT\n         |   i.INDEX_CATALOG AS INDEX_CATALOG,\n         |   i.INDEX_SCHEMA AS INDEX_SCHEMA,\n         |   i.INDEX_NAME AS INDEX_NAME,\n         |   i.INDEX_TYPE_NAME AS INDEX_TYPE_NAME,\n         |   i.REMARKS as REMARKS,\n         |   ic.COLUMN_NAME AS COLUMN_NAME\n         | FROM INFORMATION_SCHEMA.INDEXES i, INFORMATION_SCHEMA.INDEX_COLUMNS ic\n         | WHERE i.TABLE_CATALOG = ic.TABLE_CATALOG\n         | AND i.TABLE_SCHEMA = ic.TABLE_SCHEMA\n         | AND i.TABLE_NAME = ic.TABLE_NAME\n         | AND i.INDEX_CATALOG = ic.INDEX_CATALOG\n         | AND i.INDEX_SCHEMA = ic.INDEX_SCHEMA\n         | AND i.INDEX_NAME = ic.INDEX_NAME\n         | AND i.TABLE_NAME = '" + tableIdent.name() + "'\n         | AND i.INDEX_SCHEMA = '" + ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])tableIdent.namespace())) + "'\n         |"));
        ObjectRef indexMap = ObjectRef.create((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        try {
            JdbcUtils$.MODULE$.executeQuery(conn, options, sql, (Function1<ResultSet, BoxedUnit>)(Function1 & Serializable)rs -> {
                H2Dialect.$anonfun$listIndexes$1(indexMap, rs);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception exception) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Cannot retrieved index info.");
        }
        return (TableIndex[])((scala.collection.immutable.Map)indexMap.elem).values().toArray(ClassTag$.MODULE$.apply(TableIndex.class));
    }

    private String tableNameWithSchema(Identifier ident) {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ident.namespace()), (Object)ident.name(), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)colName -> this.quoteIdentifier((String)colName), ClassTag$.MODULE$.apply(String.class))).mkString(".");
    }

    private String indexNameWithSchema(Identifier ident, String indexName) {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ident.namespace()), (Object)indexName, ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)colName -> this.quoteIdentifier((String)colName), ClassTag$.MODULE$.apply(String.class))).mkString(".");
    }

    @Override
    public AnalysisException classifyException(Throwable e, String errorClass, scala.collection.immutable.Map<String, String> messageParameters, String description) {
        block7: {
            Throwable throwable = e;
            if (!(throwable instanceof SQLException)) break block7;
            SQLException sQLException = (SQLException)throwable;
            int n = sQLException.getErrorCode();
            switch (n) {
                case 42101: {
                    Regex regex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\"((?:[^\"\\\\]|\\\\[\\\\\"ntbrf])+)\""));
                    String name = ((Regex.MatchData)regex.findFirstMatchIn((CharSequence)e.getMessage()).get()).group(1);
                    String quotedName = package$.MODULE$.quoteIdentifier(name);
                    throw new TableAlreadyExistsException("TABLE_OR_VIEW_ALREADY_EXISTS", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationName"), (Object)quotedName)})), (Option)new Some((Object)e));
                }
                case 42102: {
                    String relationName = (String)messageParameters.getOrElse((Object)"tableName", (Function0 & Serializable)() -> "");
                    throw new NoSuchTableException("TABLE_OR_VIEW_NOT_FOUND", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationName"), (Object)relationName)})), (Option)new Some((Object)e));
                }
                case 90079: {
                    Regex regex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\"((?:[^\"\\\\]|\\\\[\\\\\"ntbrf])+)\""));
                    String name = ((Regex.MatchData)regex.findFirstMatchIn((CharSequence)e.getMessage()).get()).group(1);
                    String quotedName = package$.MODULE$.quoteIdentifier(name);
                    throw new NoSuchNamespaceException("SCHEMA_NOT_FOUND", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schemaName"), (Object)quotedName)})));
                }
                case 42111: {
                    String string = errorClass;
                    String string2 = "FAILED_JDBC.CREATE_INDEX";
                    if (string != null ? !string.equals(string2) : string2 != null) break;
                    String indexName = (String)messageParameters.apply((Object)"indexName");
                    String tableName = (String)messageParameters.apply((Object)"tableName");
                    throw new IndexAlreadyExistsException(indexName, tableName, (Option)new Some((Object)e));
                }
                case 42112: {
                    String string = errorClass;
                    String string3 = "FAILED_JDBC.DROP_INDEX";
                    if (string != null ? !string.equals(string3) : string3 != null) break;
                    String indexName = (String)messageParameters.apply((Object)"indexName");
                    String tableName = (String)messageParameters.apply((Object)"tableName");
                    throw new NoSuchIndexException(indexName, tableName, (Option)new Some((Object)e));
                }
            }
        }
        return NoLegacyJDBCError.classifyException$(this, e, errorClass, messageParameters, description);
    }

    @Override
    public Option<String> compileExpression(Expression expr) {
        Some some;
        H2SQLBuilder h2SQLBuilder = new H2SQLBuilder(this);
        try {
            some = new Some((Object)h2SQLBuilder.build(expr));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(throwable2)) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Error occurs while compiling V2 expression", throwable2);
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsOffset() {
        return true;
    }

    public H2Dialect copy() {
        return new H2Dialect();
    }

    public String productPrefix() {
        return "H2Dialect";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof H2Dialect;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean equals(Object x$1) {
        Object object = x$1;
        return object instanceof H2Dialect && ((H2Dialect)x$1).canEqual(this);
    }

    public static final /* synthetic */ void $anonfun$listIndexes$1(ObjectRef indexMap$1, ResultSet rs) {
        while (rs.next()) {
            String indexName = rs.getString("INDEX_NAME");
            String colName = rs.getString("COLUMN_NAME");
            String indexType = rs.getString("INDEX_TYPE_NAME");
            String indexComment = rs.getString("REMARKS");
            if (((scala.collection.immutable.Map)indexMap$1.elem).contains((Object)indexName)) {
                TableIndex index = (TableIndex)((scala.collection.immutable.Map)indexMap$1.elem).apply((Object)indexName);
                TableIndex newIndex = new TableIndex(indexName, indexType, (NamedReference[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])index.columns()), (Object)FieldReference$.MODULE$.apply(colName), ClassTag$.MODULE$.apply(NamedReference.class)), index.columnProperties(), index.properties());
                indexMap$1.elem = (scala.collection.immutable.Map)((scala.collection.immutable.Map)indexMap$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)indexName), (Object)newIndex));
                continue;
            }
            Properties properties = new Properties();
            Object object = StringUtils.isNotEmpty((CharSequence)indexComment) ? properties.put("COMMENT", indexComment) : BoxedUnit.UNIT;
            TableIndex index = new TableIndex(indexName, indexType, (NamedReference[])((Object[])new NamedReference[]{FieldReference$.MODULE$.apply(colName)}), new HashMap(), properties);
            indexMap$1.elem = (scala.collection.immutable.Map)((scala.collection.immutable.Map)indexMap$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)indexName), (Object)index));
        }
    }

    public H2Dialect() {
        NoLegacyJDBCError.$init$(this);
        Product.$init$((Product)this);
        this.org$apache$spark$sql$jdbc$H2Dialect$$distinctUnsupportedAggregateFunctions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"COVAR_POP", "COVAR_SAMP", "CORR", "REGR_INTERCEPT", "REGR_R2", "REGR_SLOPE", "REGR_SXY", "MODE", "PERCENTILE_CONT", "PERCENTILE_DISC"}));
        this.supportedAggregateFunctions = (Set)((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"MAX", "MIN", "SUM", "COUNT", "AVG", "VAR_POP", "VAR_SAMP", "STDDEV_POP", "STDDEV_SAMP"}))).$plus$plus(this.org$apache$spark$sql$jdbc$H2Dialect$$distinctUnsupportedAggregateFunctions());
        this.supportedFunctions = (Set)this.supportedAggregateFunctions().$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ABS", "COALESCE", "GREATEST", "LEAST", "RAND", "LOG", "LOG10", "LN", "EXP", "POWER", "SQRT", "FLOOR", "CEIL", "ROUND", "SIN", "SINH", "COS", "COSH", "TAN", "TANH", "COT", "ASIN", "ACOS", "ATAN", "ATAN2", "DEGREES", "RADIANS", "SIGN", "PI", "SUBSTRING", "UPPER", "LOWER", "TRANSLATE", "TRIM", "MD5", "SHA1", "SHA2", "BIT_LENGTH", "CHAR_LENGTH", "CONCAT"})));
        this.functionMap = new ConcurrentHashMap<String, UnboundFunction>();
    }

    public class H2SQLBuilder
    extends JdbcDialect.JDBCSQLBuilder {
        @Override
        public String visitAggregateFunction(String funcName, boolean isDistinct, String[] inputs) {
            if (isDistinct && this.org$apache$spark$sql$jdbc$H2Dialect$H2SQLBuilder$$$outer().org$apache$spark$sql$jdbc$H2Dialect$$distinctUnsupportedAggregateFunctions().contains((Object)funcName)) {
                throw new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_3184", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"class"), (Object)this.getClass().getSimpleName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"funcName"), (Object)funcName)})));
            }
            return super.visitAggregateFunction(funcName, isDistinct, inputs);
        }

        public String visitExtract(String field, String source) {
            String string;
            block5: {
                String string2 = field;
                switch (string2 == null ? 0 : string2.hashCode()) {
                    case -1351979174: {
                        if (!"YEAR_OF_WEEK".equals(string2)) break;
                        string = "ISO_WEEK_YEAR";
                        break block5;
                    }
                    case 2660340: {
                        if (!"WEEK".equals(string2)) break;
                        string = "ISO_WEEK";
                        break block5;
                    }
                    case 2074232729: {
                        if (!"DAY_OF_WEEK".equals(string2)) break;
                        string = "ISO_DAY_OF_WEEK";
                        break block5;
                    }
                }
                string = field;
            }
            String newField = string;
            return "EXTRACT(" + newField + " FROM " + source + ")";
        }

        @Override
        public String visitSQLFunction(String funcName, String[] inputs) {
            if (this.org$apache$spark$sql$jdbc$H2Dialect$H2SQLBuilder$$$outer().isSupportedFunction(funcName)) {
                String string = funcName;
                switch (string == null ? 0 : string.hashCode()) {
                    case 76158: {
                        if (!"MD5".equals(string)) break;
                        return "RAWTOHEX(HASH('MD5', " + Predef$.MODULE$.wrapRefArray((Object[])inputs).mkString(",") + "))";
                    }
                    case 2543909: {
                        if (!"SHA1".equals(string)) break;
                        return "RAWTOHEX(HASH('SHA-1', " + Predef$.MODULE$.wrapRefArray((Object[])inputs).mkString(",") + "))";
                    }
                    case 2543910: {
                        if (!"SHA2".equals(string)) break;
                        return "RAWTOHEX(HASH('SHA-" + inputs[1] + "'," + inputs[0] + "))";
                    }
                }
                return super.visitSQLFunction(funcName, inputs);
            }
            throw new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_3177", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"class"), (Object)this.getClass().getSimpleName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"funcName"), (Object)funcName)})));
        }

        public /* synthetic */ H2Dialect org$apache$spark$sql$jdbc$H2Dialect$H2SQLBuilder$$$outer() {
            return (H2Dialect)this.$outer;
        }

        public H2SQLBuilder(H2Dialect $outer) {
            super($outer);
        }
    }
}

