/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.sql.jdbc.AggregatedDialect;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.NoopDialect$;
import org.apache.spark.util.Utils$;
import scala.Function1;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;

@DeveloperApi
public final class JdbcDialects$ {
    public static final JdbcDialects$ MODULE$ = new JdbcDialects$();
    private static List<JdbcDialect> dialects = Nil$.MODULE$;

    static {
        MODULE$.registerDialects();
    }

    public void registerDialect(JdbcDialect dialect) {
        JdbcDialect jdbcDialect = dialect;
        dialects = dialects.filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)JdbcDialects$.$anonfun$registerDialect$1(dialect, x$3))).$colon$colon((Object)jdbcDialect);
    }

    public void unregisterDialect(JdbcDialect dialect) {
        dialects = dialects.filterNot((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)JdbcDialects$.$anonfun$unregisterDialect$1(dialect, x$4)));
    }

    private void registerDialects() {
        ServiceLoader<JdbcDialect> loader = ServiceLoader.load(JdbcDialect.class, Utils$.MODULE$.getContextOrSparkClassLoader());
        Iterator<JdbcDialect> iter = loader.iterator();
        while (iter.hasNext()) {
            this.registerDialect(iter.next());
        }
    }

    public JdbcDialect get(String url) {
        List matchingDialects = dialects.filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.canHandle(url)));
        int n = matchingDialects.length();
        switch (n) {
            case 0: {
                return NoopDialect$.MODULE$;
            }
            case 1: {
                return (JdbcDialect)matchingDialects.head();
            }
        }
        return new AggregatedDialect((List<JdbcDialect>)matchingDialects);
    }

    public static final /* synthetic */ boolean $anonfun$registerDialect$1(JdbcDialect dialect$1, JdbcDialect x$3) {
        JdbcDialect jdbcDialect = x$3;
        JdbcDialect jdbcDialect2 = dialect$1;
        return !(jdbcDialect != null ? !jdbcDialect.equals(jdbcDialect2) : jdbcDialect2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$unregisterDialect$1(JdbcDialect dialect$2, JdbcDialect x$4) {
        JdbcDialect jdbcDialect = x$4;
        JdbcDialect jdbcDialect2 = dialect$2;
        return !(jdbcDialect != null ? !jdbcDialect.equals(jdbcDialect2) : jdbcDialect2 != null);
    }

    private JdbcDialects$() {
    }
}

