/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.IndexAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchIndexException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.index.TableIndex;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.FieldReference$;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.NullOrdering;
import org.apache.spark.sql.connector.expressions.SortDirection;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcSQLQueryBuilder;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.jdbc.MySQLDialect$;
import org.apache.spark.sql.jdbc.NoLegacyJDBCError;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.SetOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\r=f\u0001B A\t.CQa\u001b\u0001\u0005\u00021DQA\u001c\u0001\u0005B=Dq! \u0001C\u0002\u0013%a\u0010C\u0004\u0002\u001e\u0001\u0001\u000b\u0011B@\t\u0011\u0005}\u0001A1A\u0005\nyDq!!\t\u0001A\u0003%q\u0010\u0003\u0005\u0002$\u0001\u0011\r\u0011\"\u0003\u007f\u0011\u001d\t)\u0003\u0001Q\u0001\n}Dq!a\n\u0001\t\u0003\nIC\u0002\u0004\u00020\u0001\u0001\u0011\u0011\u0007\u0005\u0007W*!\t!a\u000f\t\u000f\u0005}\"\u0002\"\u0011\u0002B!9\u00111\n\u0006\u0005B\u00055\u0003bBA.\u0015\u0011\u0005\u0013Q\f\u0005\b\u0003\u0003SA\u0011IAB\u0011\u001d\tiI\u0003C!\u0003\u001fCq!!&\u000b\t\u0003\n9\nC\u0004\u0002\u001e*!\t%a(\t\u000f\u0005%\u0006\u0001\"\u0011\u0002,\"9\u0011Q\u0018\u0001\u0005B\u0005}\u0006bBAv\u0001\u0011\u0005\u0013Q\u001e\u0005\b\u0003g\u0004A\u0011IA{\u0011\u001d\u0011y\u0002\u0001C!\u0005CAqA!\u000b\u0001\t\u0003\u0012Y\u0003C\u0004\u00030\u0001!\tE!\r\t\u000f\t}\u0002\u0001\"\u0011\u0003B!9!q\n\u0001\u0005B\tE\u0003b\u0002B.\u0001\u0011\u0005#Q\f\u0005\b\u0005O\u0002A\u0011\tB5\u0011\u001d\u00119\b\u0001C!\u0005sBqAa \u0001\t\u0003\u0012\t\tC\u0004\u0003\u0006\u0002!\tEa\"\t\u000f\t}\u0006\u0001\"\u0011\u0003B\"9!1\u001a\u0001\u0005B\t5\u0007b\u0002Bj\u0001\u0011\u0005#Q\u001b\u0005\b\u0005W\u0004A\u0011\tBw\u0011\u001d\u0019\t\u0002\u0001C!\u0007'1aaa\u0007\u0001\u0001\ru\u0001\"CB\u0013M\t\u0005\t\u0015!\u0003M\u0011)\u00119A\nB\u0001B\u0003%!\u0011\u0002\u0005\u0007W\u001a\"\taa\n\t\u000f\r=b\u0005\"\u0011\u00042!911\u0007\u0001\u0005B\rU\u0002bBB\u001d\u0001\u0011\u000531\b\u0005\b\u0007{\u0001A\u0011IB\u001e\u0011!\u0019y\u0004AA\u0001\n\u0003a\u0007\"CB!\u0001\u0005\u0005I\u0011IB\"\u0011%\u0019)\u0005AA\u0001\n\u0003\u00199\u0005C\u0005\u0004J\u0001\t\t\u0011\"\u0001\u0004L!I1q\u000b\u0001\u0002\u0002\u0013\u00053\u0011\f\u0005\n\u0007G\u0002\u0011\u0011!C\u0001\u0007KB\u0011b!\u001b\u0001\u0003\u0003%\tea\u001b\t\u0013\r=\u0004!!A\u0005B\rE\u0004\"CB:\u0001\u0005\u0005I\u0011IB;\u0011%\u00199\bAA\u0001\n\u0003\u001aIhB\u0005\u0004~\u0001\u000b\t\u0011#\u0003\u0004\u0000\u0019Aq\bQA\u0001\u0012\u0013\u0019\t\t\u0003\u0004ls\u0011\u00051\u0011\u0014\u0005\n\u0007gJ\u0014\u0011!C#\u0007kB\u0001ba':\u0003\u0003%\t\t\u001c\u0005\n\u0007;K\u0014\u0011!CA\u0007?C\u0011b!*:\u0003\u0003%Iaa*\u0003\u00195K8+\u0015'ES\u0006dWm\u0019;\u000b\u0005\u0005\u0013\u0015\u0001\u00026eE\u000eT!a\u0011#\u0002\u0007M\fHN\u0003\u0002F\r\u0006)1\u000f]1sW*\u0011q\tS\u0001\u0007CB\f7\r[3\u000b\u0003%\u000b1a\u001c:h\u0007\u0001\u0019b\u0001\u0001'Q-f{\u0006CA'O\u001b\u0005\u0001\u0015BA(A\u0005-QEMY2ES\u0006dWm\u0019;\u0011\u0005E#V\"\u0001*\u000b\u0005M\u0013\u0015\u0001C2bi\u0006d\u0017p\u001d;\n\u0005U\u0013&!D*R\u0019\u000e{gN\u001a%fYB,'\u000f\u0005\u0002N/&\u0011\u0001\f\u0011\u0002\u0012\u001d>dUmZ1ds*#%iQ#se>\u0014\bC\u0001.^\u001b\u0005Y&\"\u0001/\u0002\u000bM\u001c\u0017\r\\1\n\u0005y[&a\u0002)s_\u0012,8\r\u001e\t\u0003A\"t!!\u00194\u000f\u0005\t,W\"A2\u000b\u0005\u0011T\u0015A\u0002\u001fs_>$h(C\u0001]\u0013\t97,A\u0004qC\u000e\\\u0017mZ3\n\u0005%T'\u0001D*fe&\fG.\u001b>bE2,'BA4\\\u0003\u0019a\u0014N\\5u}Q\tQ\u000e\u0005\u0002N\u0001\u0005I1-\u00198IC:$G.\u001a\u000b\u0003aN\u0004\"AW9\n\u0005I\\&a\u0002\"p_2,\u0017M\u001c\u0005\u0006i\n\u0001\r!^\u0001\u0004kJd\u0007C\u0001<{\u001d\t9\b\u0010\u0005\u0002c7&\u0011\u0011pW\u0001\u0007!J,G-\u001a4\n\u0005md(AB*ue&twM\u0003\u0002z7\u0006)C-[:uS:\u001cG/\u00168tkB\u0004xN\u001d;fI\u0006;wM]3hCR,g)\u001e8di&|gn]\u000b\u0002\u007fB1\u0011\u0011AA\u0006\u0003\u001fi!!a\u0001\u000b\t\u0005\u0015\u0011qA\u0001\nS6lW\u000f^1cY\u0016T1!!\u0003\\\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u001b\t\u0019AA\u0002TKR\u0004B!!\u0005\u0002\u001c5\u0011\u00111\u0003\u0006\u0005\u0003+\t9\"\u0001\u0003mC:<'BAA\r\u0003\u0011Q\u0017M^1\n\u0007m\f\u0019\"\u0001\u0014eSN$\u0018N\\2u+:\u001cX\u000f\u001d9peR,G-Q4he\u0016<\u0017\r^3Gk:\u001cG/[8og\u0002\n1d];qa>\u0014H/\u001a3BO\u001e\u0014XmZ1uK\u001a+hn\u0019;j_:\u001c\u0018\u0001H:vaB|'\u000f^3e\u0003\u001e<'/Z4bi\u00164UO\\2uS>t7\u000fI\u0001\u0013gV\u0004\bo\u001c:uK\u00124UO\\2uS>t7/A\ntkB\u0004xN\u001d;fI\u001a+hn\u0019;j_:\u001c\b%A\njgN+\b\u000f]8si\u0016$g)\u001e8di&|g\u000eF\u0002q\u0003WAa!!\f\n\u0001\u0004)\u0018\u0001\u00034v]\u000et\u0015-\\3\u0003\u001f5K8+\u0015'T#2\u0013U/\u001b7eKJ\u001c2ACA\u001a!\u0011\t)$a\u000e\u000e\u0003\u0001I1!!\u000fO\u00059QEIQ\"T#2\u0013U/\u001b7eKJ$\"!!\u0010\u0011\u0007\u0005U\"\"\u0001\u0007wSNLG/\u0012=ue\u0006\u001cG\u000fF\u0003v\u0003\u0007\n9\u0005\u0003\u0004\u0002F1\u0001\r!^\u0001\u0006M&,G\u000e\u001a\u0005\u0007\u0003\u0013b\u0001\u0019A;\u0002\rM|WO]2f\u0003A1\u0018n]5u'Fce)\u001e8di&|g\u000eF\u0003v\u0003\u001f\n\t\u0006\u0003\u0004\u0002.5\u0001\r!\u001e\u0005\b\u0003'j\u0001\u0019AA+\u0003\u0019Ig\u000e];ugB!!,a\u0016v\u0013\r\tIf\u0017\u0002\u0006\u0003J\u0014\u0018-_\u0001\u000fm&\u001c\u0018\u000e^*peR|%\u000fZ3s)\u001d)\u0018qLA2\u0003oBa!!\u0019\u000f\u0001\u0004)\u0018aB:peR\\U-\u001f\u0005\b\u0003Kr\u0001\u0019AA4\u00035\u0019xN\u001d;ESJ,7\r^5p]B!\u0011\u0011NA:\u001b\t\tYG\u0003\u0003\u0002n\u0005=\u0014aC3yaJ,7o]5p]NT1!!\u001dC\u0003%\u0019wN\u001c8fGR|'/\u0003\u0003\u0002v\u0005-$!D*peR$\u0015N]3di&|g\u000eC\u0004\u0002z9\u0001\r!a\u001f\u0002\u00199,H\u000e\\(sI\u0016\u0014\u0018N\\4\u0011\t\u0005%\u0014QP\u0005\u0005\u0003\u007f\nYG\u0001\u0007Ok2dwJ\u001d3fe&tw-A\bwSNLGo\u0015;beR\u001cx+\u001b;i)\u0015)\u0018QQAE\u0011\u0019\t9i\u0004a\u0001k\u0006\tA\u000e\u0003\u0004\u0002\f>\u0001\r!^\u0001\u0002e\u0006ia/[:ji\u0016sGm],ji\"$R!^AI\u0003'Ca!a\"\u0011\u0001\u0004)\bBBAF!\u0001\u0007Q/A\u0007wSNLGoQ8oi\u0006Lgn\u001d\u000b\u0006k\u0006e\u00151\u0014\u0005\u0007\u0003\u000f\u000b\u0002\u0019A;\t\r\u0005-\u0015\u00031\u0001v\u0003Y1\u0018n]5u\u0003\u001e<'/Z4bi\u00164UO\\2uS>tGcB;\u0002\"\u0006\r\u0016q\u0015\u0005\u0007\u0003[\u0011\u0002\u0019A;\t\r\u0005\u0015&\u00031\u0001q\u0003)I7\u000fR5ti&t7\r\u001e\u0005\b\u0003'\u0012\u0002\u0019AA+\u0003E\u0019w.\u001c9jY\u0016,\u0005\u0010\u001d:fgNLwN\u001c\u000b\u0005\u0003[\u000b\u0019\f\u0005\u0003[\u0003_+\u0018bAAY7\n1q\n\u001d;j_:Dq!!.\u0014\u0001\u0004\t9,\u0001\u0003fqB\u0014\b\u0003BA5\u0003sKA!a/\u0002l\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u001f\u001d,GoQ1uC2L8\u000f\u001e+za\u0016$\"\"!1\u0002P\u0006e\u0017Q\\Aq!\u0015Q\u0016qVAb!\u0011\t)-a3\u000e\u0005\u0005\u001d'bAAe\u0005\u0006)A/\u001f9fg&!\u0011QZAd\u0005!!\u0015\r^1UsB,\u0007bBAi)\u0001\u0007\u00111[\u0001\bgFdG+\u001f9f!\rQ\u0016Q[\u0005\u0004\u0003/\\&aA%oi\"1\u00111\u001c\u000bA\u0002U\f\u0001\u0002^=qK:\u000bW.\u001a\u0005\b\u0003?$\u0002\u0019AAj\u0003\u0011\u0019\u0018N_3\t\u000f\u0005\rH\u00031\u0001\u0002f\u0006\u0011Q\u000e\u001a\t\u0005\u0003\u000b\f9/\u0003\u0003\u0002j\u0006\u001d'aD'fi\u0006$\u0017\r^1Ck&dG-\u001a:\u0002\u001fE,x\u000e^3JI\u0016tG/\u001b4jKJ$2!^Ax\u0011\u0019\t\t0\u0006a\u0001k\u000691m\u001c7OC6,\u0017!D:dQ\u0016l\u0017m]#ySN$8\u000fF\u0004q\u0003o\u0014)Aa\u0007\t\u000f\u0005eh\u00031\u0001\u0002|\u0006!1m\u001c8o!\u0011\tiP!\u0001\u000e\u0005\u0005}(bA\"\u0002\u0018%!!1AA\u0000\u0005)\u0019uN\u001c8fGRLwN\u001c\u0005\b\u0005\u000f1\u0002\u0019\u0001B\u0005\u0003\u001dy\u0007\u000f^5p]N\u0004BAa\u0003\u0003\u00185\u0011!Q\u0002\u0006\u0004\u0003\n=!\u0002\u0002B\t\u0005'\t1\u0002Z1uCN|WO]2fg*\u0019!Q\u0003\"\u0002\u0013\u0015DXmY;uS>t\u0017\u0002\u0002B\r\u0005\u001b\u00111B\u0013#C\u0007>\u0003H/[8og\"1!Q\u0004\fA\u0002U\faa]2iK6\f\u0017a\u00037jgR\u001c6\r[3nCN$bAa\t\u0003&\t\u001d\u0002#\u0002.\u0002X\u0005U\u0003bBA}/\u0001\u0007\u00111 \u0005\b\u0005\u000f9\u0002\u0019\u0001B\u0005\u0003aI7oQ1tG\u0006$\u0017N\\4UeVt7-\u0019;f)\u0006\u0014G.\u001a\u000b\u0003\u0005[\u0001BAWAXa\u0006Ar-\u001a;Va\u0012\fG/Z\"pYVlg\u000eV=qKF+XM]=\u0015\u000fU\u0014\u0019Da\u000e\u0003<!1!QG\rA\u0002U\f\u0011\u0002^1cY\u0016t\u0015-\\3\t\r\te\u0012\u00041\u0001v\u0003)\u0019w\u000e\\;n]:\u000bW.\u001a\u0005\u0007\u0005{I\u0002\u0019A;\u0002\u00179,w\u000fR1uCRK\b/Z\u0001\u0015O\u0016$(+\u001a8b[\u0016\u001cu\u000e\\;n]F+XM]=\u0015\u0013U\u0014\u0019E!\u0012\u0003H\t-\u0003B\u0002B\u001b5\u0001\u0007Q\u000f\u0003\u0004\u0003:i\u0001\r!\u001e\u0005\u0007\u0005\u0013R\u0002\u0019A;\u0002\u000f9,wOT1nK\"9!Q\n\u000eA\u0002\u0005M\u0017A\u00043c\u001b\u0006TwN\u001d,feNLwN\\\u0001 O\u0016$X\u000b\u001d3bi\u0016\u001cu\u000e\\;n]:+H\u000e\\1cS2LG/_)vKJLHcB;\u0003T\tU#q\u000b\u0005\u0007\u0005kY\u0002\u0019A;\t\r\te2\u00041\u0001v\u0011\u0019\u0011If\u0007a\u0001a\u0006Q\u0011n\u001d(vY2\f'\r\\3\u0002)\u001d,G\u000fV1cY\u0016\u001cu.\\7f]R\fV/\u001a:z)\u0015)(q\fB2\u0011\u0019\u0011\t\u0007\ba\u0001k\u0006)A/\u00192mK\"1!Q\r\u000fA\u0002U\fqaY8n[\u0016tG/A\u0006hKRTEIQ\"UsB,G\u0003\u0002B6\u0005g\u0002RAWAX\u0005[\u00022!\u0014B8\u0013\r\u0011\t\b\u0011\u0002\t\u0015\u0012\u00147\rV=qK\"9!QO\u000fA\u0002\u0005\r\u0017A\u00013u\u0003U9W\r^*dQ\u0016l\u0017mQ8n[\u0016tG/U;fef$R!\u001eB>\u0005{BaA!\b\u001f\u0001\u0004)\bB\u0002B3=\u0001\u0007Q/\u0001\rsK6|g/Z*dQ\u0016l\u0017mQ8n[\u0016tG/U;fef$2!\u001eBB\u0011\u0019\u0011ib\ba\u0001k\u0006Y1M]3bi\u0016Le\u000eZ3y)-)(\u0011\u0012BG\u0005;\u0013IKa/\t\r\t-\u0005\u00051\u0001v\u0003%Ig\u000eZ3y\u001d\u0006lW\rC\u0004\u0003\u0010\u0002\u0002\rA!%\u0002\u0015Q\f'\r\\3JI\u0016tG\u000f\u0005\u0003\u0003\u0014\neUB\u0001BK\u0015\u0011\u00119*a\u001c\u0002\u000f\r\fG/\u00197pO&!!1\u0014BK\u0005)IE-\u001a8uS\u001aLWM\u001d\u0005\b\u0005?\u0003\u0003\u0019\u0001BQ\u0003\u001d\u0019w\u000e\\;n]N\u0004RAWA,\u0005G\u0003B!!\u001b\u0003&&!!qUA6\u00059q\u0015-\\3e%\u00164WM]3oG\u0016DqAa+!\u0001\u0004\u0011i+A\td_2,XN\\:Qe>\u0004XM\u001d;jKN\u0004\u0002Ba,\u00036\n\r&\u0011X\u0007\u0003\u0005cSAAa-\u0002\u0018\u0005!Q\u000f^5m\u0013\u0011\u00119L!-\u0003\u00075\u000b\u0007\u000f\u0005\u0004\u00030\nUV/\u001e\u0005\b\u0005{\u0003\u0003\u0019\u0001B]\u0003)\u0001(o\u001c9feRLWm]\u0001\fS:$W\r_#ySN$8\u000fF\u0005q\u0005\u0007\u0014)Ma2\u0003J\"9\u0011\u0011`\u0011A\u0002\u0005m\bB\u0002BFC\u0001\u0007Q\u000fC\u0004\u0003\u0010\u0006\u0002\rA!%\t\u000f\t\u001d\u0011\u00051\u0001\u0003\n\u0005IAM]8q\u0013:$W\r\u001f\u000b\u0006k\n='\u0011\u001b\u0005\u0007\u0005\u0017\u0013\u0003\u0019A;\t\u000f\t=%\u00051\u0001\u0003\u0012\u0006YA.[:u\u0013:$W\r_3t)!\u00119N!:\u0003h\n%\b#\u0002.\u0002X\te\u0007\u0003\u0002Bn\u0005Cl!A!8\u000b\t\t}'QS\u0001\u0006S:$W\r_\u0005\u0005\u0005G\u0014iN\u0001\u0006UC\ndW-\u00138eKbDq!!?$\u0001\u0004\tY\u0010C\u0004\u0003\u0010\u000e\u0002\rA!%\t\u000f\t\u001d1\u00051\u0001\u0003\n\u0005\t2\r\\1tg&4\u00170\u0012=dKB$\u0018n\u001c8\u0015\u0015\t=(q_B\u0001\u0007\u000b\u0019i\u0001\u0005\u0003\u0003r\nMX\"\u0001\"\n\u0007\tU(IA\tB]\u0006d\u0017p]5t\u000bb\u001cW\r\u001d;j_:DqA!?%\u0001\u0004\u0011Y0A\u0001f!\r\u0001'Q`\u0005\u0004\u0005\u007fT'!\u0003+ie><\u0018M\u00197f\u0011\u0019\u0019\u0019\u0001\na\u0001k\u0006QQM\u001d:pe\u000ec\u0017m]:\t\u000f\r\u001dA\u00051\u0001\u0004\n\u0005\tR.Z:tC\u001e,\u0007+\u0019:b[\u0016$XM]:\u0011\u000bY\u001cY!^;\n\u0007\t]F\u0010\u0003\u0004\u0004\u0010\u0011\u0002\r!^\u0001\fI\u0016\u001c8M]5qi&|g.\u0001\u0006ee>\u00048k\u00195f[\u0006$R!^B\u000b\u0007/AaA!\b&\u0001\u0004)\bBBB\rK\u0001\u0007\u0001/A\u0004dCN\u001c\u0017\rZ3\u0003)5K8+\u0015'T#2\u000bV/\u001a:z\u0005VLG\u000eZ3s'\r13q\u0004\t\u0004\u001b\u000e\u0005\u0012bAB\u0012\u0001\n\u0019\"\n\u001a2d'Fc\u0015+^3ss\n+\u0018\u000e\u001c3fe\u00069A-[1mK\u000e$HCBB\u0015\u0007W\u0019i\u0003E\u0002\u00026\u0019Baa!\n*\u0001\u0004a\u0005b\u0002B\u0004S\u0001\u0007!\u0011B\u0001\u0006EVLG\u000e\u001a\u000b\u0002k\u00061r-\u001a;KI\n\u001c7+\u0015'Rk\u0016\u0014\u0018PQ;jY\u0012,'\u000f\u0006\u0003\u0004 \r]\u0002b\u0002B\u0004W\u0001\u0007!\u0011B\u0001\u000egV\u0004\bo\u001c:ug2KW.\u001b;\u0016\u0003A\fab];qa>\u0014Ho](gMN,G/\u0001\u0003d_BL\u0018!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\u0010\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u00111[\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0019iea\u0015\u0011\u0007i\u001by%C\u0002\u0004Rm\u00131!\u00118z\u0011%\u0019)&MA\u0001\u0002\u0004\t\u0019.A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u00077\u0002ba!\u0018\u0004`\r5SBAA\u0004\u0013\u0011\u0019\t'a\u0002\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004a\u000e\u001d\u0004\"CB+g\u0005\u0005\t\u0019AB'\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005=1Q\u000e\u0005\n\u0007+\"\u0014\u0011!a\u0001\u0003'\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003'\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u001f\ta!Z9vC2\u001cHc\u00019\u0004|!I1QK\u001c\u0002\u0002\u0003\u00071QJ\u0001\r\u001bf\u001c\u0016\u000b\u0014#jC2,7\r\u001e\t\u0003\u001bf\u001aR!OBB\u0007\u001f\u0003Ra!\"\u0004\f6l!aa\"\u000b\u0007\r%5,A\u0004sk:$\u0018.\\3\n\t\r55q\u0011\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0004\u0004\u0003BBI\u0007/k!aa%\u000b\t\rU\u0015qC\u0001\u0003S>L1![BJ)\t\u0019y(A\u0003baBd\u00170A\u0004v]\u0006\u0004\b\u000f\\=\u0015\u0007A\u001c\t\u000b\u0003\u0005\u0004$v\n\t\u00111\u0001n\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0007S\u0003B!!\u0005\u0004,&!1QVA\n\u0005\u0019y%M[3di\u0002")
public class MySQLDialect
extends JdbcDialect
implements SQLConfHelper,
NoLegacyJDBCError,
Product {
    private final Set<String> org$apache$spark$sql$jdbc$MySQLDialect$$distinctUnsupportedAggregateFunctions;
    private final Set<String> supportedAggregateFunctions;
    private final Set<String> supportedFunctions;

    public static boolean unapply(MySQLDialect x$0) {
        return MySQLDialect$.MODULE$.unapply(x$0);
    }

    public static MySQLDialect apply() {
        return MySQLDialect$.MODULE$.apply();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:mysql");
    }

    public Set<String> org$apache$spark$sql$jdbc$MySQLDialect$$distinctUnsupportedAggregateFunctions() {
        return this.org$apache$spark$sql$jdbc$MySQLDialect$$distinctUnsupportedAggregateFunctions;
    }

    private Set<String> supportedAggregateFunctions() {
        return this.supportedAggregateFunctions;
    }

    private Set<String> supportedFunctions() {
        return this.supportedFunctions;
    }

    @Override
    public boolean isSupportedFunction(String funcName) {
        return this.supportedFunctions().contains((Object)funcName);
    }

    @Override
    public Option<String> compileExpression(Expression expr) {
        Some some;
        MySQLSQLBuilder mysqlSQLBuilder = new MySQLSQLBuilder(this);
        try {
            some = new Some((Object)mysqlSQLBuilder.build(expr));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(throwable2)) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Error occurs while compiling V2 expression", throwable2);
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        boolean bl = false;
        int n = 0;
        int n2 = sqlType;
        if (-3 == n2 && "BIT".equalsIgnoreCase(typeName) && size != 1) {
            return this.getCatalystTypeForBitArray$1(md);
        }
        if (-7 == n2 && size > 1) {
            return this.getCatalystTypeForBitArray$1(md);
        }
        if (12 == n2 && "TINYTEXT".equalsIgnoreCase(typeName)) {
            return new Some((Object)StringType$.MODULE$);
        }
        if ((12 == n2 ? true : 1 == n2) && "JSON".equalsIgnoreCase(typeName)) {
            return new Some((Object)StringType$.MODULE$);
        }
        if (-6 == n2) {
            if (md.build().getBoolean("isSigned")) {
                return new Some((Object)ByteType$.MODULE$);
            }
            return new Some((Object)ShortType$.MODULE$);
        }
        if (5 == n2) {
            if (md.build().getBoolean("isSigned")) {
                return new Some((Object)ShortType$.MODULE$);
            }
            return new Some((Object)IntegerType$.MODULE$);
        }
        if (4 == n2 && "MEDIUMINT UNSIGNED".equalsIgnoreCase(typeName)) {
            return new Some((Object)IntegerType$.MODULE$);
        }
        if (7 == n2 ? true : 6 == n2) {
            if (md.build().getBoolean("isSigned")) {
                return new Some((Object)FloatType$.MODULE$);
            }
            return new Some((Object)DoubleType$.MODULE$);
        }
        if (93 == n2) {
            bl = true;
            n = n2;
            if ("DATETIME".equalsIgnoreCase(typeName)) {
                return new Some((Object)this.getTimestampType(md.build()));
            }
        }
        if (bl && !this.conf().legacyMySqlTimestampNTZMappingEnabled()) {
            return new Some((Object)TimestampType$.MODULE$);
        }
        return None$.MODULE$;
    }

    @Override
    public String quoteIdentifier(String colName) {
        return "`" + colName + "`";
    }

    @Override
    public boolean schemasExists(Connection conn, JDBCOptions options, String schema) {
        return ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])this.listSchemas(conn, options)), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MySQLDialect.$anonfun$schemasExists$1(schema, x$1)));
    }

    @Override
    public String[][] listSchemas(Connection conn, JDBCOptions options) {
        ArrayBuilder schemaBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        try {
            JdbcUtils$.MODULE$.executeQuery(conn, options, "SHOW SCHEMAS", (Function1<ResultSet, BoxedUnit>)(Function1 & Serializable)rs -> {
                MySQLDialect.$anonfun$listSchemas$1(schemaBuilder, rs);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception exception) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Cannot show schemas.");
        }
        return (String[][])schemaBuilder.result();
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public String getUpdateColumnTypeQuery(String tableName, String columnName, String newDataType) {
        return "ALTER TABLE " + tableName + " MODIFY COLUMN " + this.quoteIdentifier(columnName) + " " + newDataType;
    }

    @Override
    public String getRenameColumnQuery(String tableName, String columnName, String newName, int dbMajorVersion) {
        if (dbMajorVersion >= 8) {
            return "ALTER TABLE " + tableName + " RENAME COLUMN " + this.quoteIdentifier(columnName) + " TO " + this.quoteIdentifier(newName);
        }
        throw QueryExecutionErrors$.MODULE$.renameColumnUnsupportedForOlderMySQLError();
    }

    @Override
    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        throw QueryExecutionErrors$.MODULE$.unsupportedUpdateColumnNullabilityError();
    }

    @Override
    public String getTableCommentQuery(String table, String comment) {
        return "ALTER TABLE " + table + " COMMENT = '" + comment + "'";
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        DataType dataType = dt;
        if (FloatType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("FLOAT", 6));
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("LONGTEXT", -1));
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("TINYINT", -6));
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("SMALLINT", 5));
        }
        if (TimestampNTZType$.MODULE$.equals(dataType) && !this.conf().legacyMySqlTimestampNTZMappingEnabled()) {
            return Option$.MODULE$.apply((Object)new JdbcType("DATETIME", 93));
        }
        return JdbcUtils$.MODULE$.getCommonJDBCType(dt);
    }

    @Override
    public String getSchemaCommentQuery(String schema, String comment) {
        throw QueryExecutionErrors$.MODULE$.unsupportedCommentNamespaceError(schema);
    }

    @Override
    public String removeSchemaCommentQuery(String schema) {
        throw QueryExecutionErrors$.MODULE$.unsupportedRemoveNamespaceCommentError(schema);
    }

    @Override
    public String createIndex(String indexName, Identifier tableIdent, NamedReference[] columns, Map<NamedReference, Map<String, String>> columnsProperties, Map<String, String> properties) {
        String[] columnList = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])columns), (Function1 & Serializable)col -> this.quoteIdentifier((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])col.fieldNames()))), ClassTag$.MODULE$.apply(String.class));
        Tuple2<String, String[]> tuple2 = JdbcUtils$.MODULE$.processIndexProperties(properties, "mysql");
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String indexType = (String)tuple2._1();
        String[] indexPropertyList = (String[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)indexType, (Object)indexPropertyList);
        String indexType2 = (String)tuple22._1();
        String[] indexPropertyList2 = (String[])tuple22._2();
        return "CREATE INDEX " + this.quoteIdentifier(indexName) + " " + indexType2 + " ON " + this.quoteIdentifier(tableIdent.name()) + " (" + Predef$.MODULE$.wrapRefArray((Object[])columnList).mkString(", ") + ") " + Predef$.MODULE$.wrapRefArray((Object[])indexPropertyList2).mkString(" ");
    }

    @Override
    public boolean indexExists(Connection conn, String indexName, Identifier tableIdent, JDBCOptions options) {
        String sql = "SHOW INDEXES FROM " + this.quoteIdentifier(tableIdent.name()) + " WHERE key_name = '" + indexName + "'";
        return JdbcUtils$.MODULE$.checkIfIndexExists(conn, sql, options);
    }

    @Override
    public String dropIndex(String indexName, Identifier tableIdent) {
        return "DROP INDEX " + this.quoteIdentifier(indexName) + " ON " + tableIdent.name();
    }

    @Override
    public TableIndex[] listIndexes(Connection conn, Identifier tableIdent, JDBCOptions options) {
        String sql = "SHOW INDEXES FROM " + tableIdent.name();
        ObjectRef indexMap = ObjectRef.create((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        try {
            JdbcUtils$.MODULE$.executeQuery(conn, options, sql, (Function1<ResultSet, BoxedUnit>)(Function1 & Serializable)rs -> {
                MySQLDialect.$anonfun$listIndexes$1(indexMap, rs);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception exception) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Cannot retrieved index info.");
        }
        return (TableIndex[])((scala.collection.immutable.Map)indexMap.elem).values().toArray(ClassTag$.MODULE$.apply(TableIndex.class));
    }

    @Override
    public AnalysisException classifyException(Throwable e, String errorClass, scala.collection.immutable.Map<String, String> messageParameters, String description) {
        Throwable throwable = e;
        if (throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            int n = sQLException.getErrorCode();
            switch (n) {
                case 1050: {
                    String string = errorClass;
                    String string2 = "FAILED_JDBC.RENAME_TABLE";
                    if (string != null ? !string.equals(string2) : string2 != null) break;
                    String newTable = (String)messageParameters.apply((Object)"newName");
                    throw QueryCompilationErrors$.MODULE$.tableAlreadyExistsError(newTable);
                }
                case 1061: {
                    String string = errorClass;
                    String string3 = "FAILED_JDBC.CREATE_INDEX";
                    if (string != null ? !string.equals(string3) : string3 != null) break;
                    String indexName = (String)messageParameters.apply((Object)"indexName");
                    String tableName = (String)messageParameters.apply((Object)"tableName");
                    throw new IndexAlreadyExistsException(indexName, tableName, (Option)new Some((Object)e));
                }
                case 1091: {
                    String string = errorClass;
                    String string4 = "FAILED_JDBC.DROP_INDEX";
                    if (string != null ? !string.equals(string4) : string4 != null) break;
                    String indexName = (String)messageParameters.apply((Object)"indexName");
                    String tableName = (String)messageParameters.apply((Object)"tableName");
                    throw new NoSuchIndexException(indexName, tableName, (Option)new Some((Object)e));
                }
            }
            return NoLegacyJDBCError.classifyException$(this, e, errorClass, messageParameters, description);
        }
        if (throwable instanceof UnsupportedOperationException) {
            UnsupportedOperationException unsupportedOperationException = (UnsupportedOperationException)throwable;
            throw unsupportedOperationException;
        }
        return NoLegacyJDBCError.classifyException$(this, e, errorClass, messageParameters, description);
    }

    @Override
    public String dropSchema(String schema, boolean cascade) {
        if (cascade) {
            return "DROP SCHEMA " + this.quoteIdentifier(schema);
        }
        throw QueryExecutionErrors$.MODULE$.unsupportedDropNamespaceError(schema);
    }

    @Override
    public JdbcSQLQueryBuilder getJdbcSQLQueryBuilder(JDBCOptions options) {
        return new MySQLSQLQueryBuilder(this, this, options);
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsOffset() {
        return true;
    }

    public MySQLDialect copy() {
        return new MySQLDialect();
    }

    public String productPrefix() {
        return "MySQLDialect";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MySQLDialect;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean equals(Object x$1) {
        Object object = x$1;
        return object instanceof MySQLDialect && ((MySQLDialect)x$1).canEqual(this);
    }

    private final Option getCatalystTypeForBitArray$1(MetadataBuilder md$1) {
        md$1.putLong("binarylong", 1L);
        if (this.conf().legacyMySqlBitArrayMappingEnabled()) {
            return new Some((Object)LongType$.MODULE$);
        }
        return new Some((Object)BinaryType$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$schemasExists$1(String schema$1, String[] x$1) {
        Object object = ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])x$1));
        String string = schema$1;
        return !(object != null ? !object.equals(string) : string != null);
    }

    public static final /* synthetic */ void $anonfun$listSchemas$1(ArrayBuilder schemaBuilder$1, ResultSet rs) {
        while (rs.next()) {
            schemaBuilder$1.$plus$eq((Object)new String[]{rs.getString("Database")});
        }
    }

    public static final /* synthetic */ void $anonfun$listIndexes$1(ObjectRef indexMap$1, ResultSet rs) {
        while (rs.next()) {
            String indexName = rs.getString("key_name");
            String colName = rs.getString("column_name");
            String indexType = rs.getString("index_type");
            String indexComment = rs.getString("index_comment");
            if (((scala.collection.immutable.Map)indexMap$1.elem).contains((Object)indexName)) {
                TableIndex index = (TableIndex)((scala.collection.immutable.Map)indexMap$1.elem).get((Object)indexName).get();
                TableIndex newIndex = new TableIndex(indexName, indexType, (NamedReference[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])index.columns()), (Object)FieldReference$.MODULE$.apply(colName), ClassTag$.MODULE$.apply(NamedReference.class)), index.columnProperties(), index.properties());
                indexMap$1.elem = (scala.collection.immutable.Map)((scala.collection.immutable.Map)indexMap$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)indexName), (Object)newIndex));
                continue;
            }
            Properties properties = new Properties();
            Object object = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(indexComment)) ? properties.put("COMMENT", indexComment) : BoxedUnit.UNIT;
            TableIndex index = new TableIndex(indexName, indexType, (NamedReference[])((Object[])new NamedReference[]{FieldReference$.MODULE$.apply(colName)}), new HashMap(), properties);
            indexMap$1.elem = (scala.collection.immutable.Map)((scala.collection.immutable.Map)indexMap$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)indexName), (Object)index));
        }
    }

    public MySQLDialect() {
        SQLConfHelper.$init$((SQLConfHelper)this);
        NoLegacyJDBCError.$init$(this);
        Product.$init$((Product)this);
        this.org$apache$spark$sql$jdbc$MySQLDialect$$distinctUnsupportedAggregateFunctions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"VAR_POP", "VAR_SAMP", "STDDEV_POP", "STDDEV_SAMP"}));
        this.supportedAggregateFunctions = (Set)((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"MAX", "MIN", "SUM", "COUNT", "AVG"}))).$plus$plus(this.org$apache$spark$sql$jdbc$MySQLDialect$$distinctUnsupportedAggregateFunctions());
        this.supportedFunctions = (Set)this.supportedAggregateFunctions().$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"DATE_ADD", "DATE_DIFF"})));
    }

    public class MySQLSQLBuilder
    extends JdbcDialect.JDBCSQLBuilder {
        public String visitExtract(String field, String source) {
            String string = field;
            switch (string == null ? 0 : string.hashCode()) {
                case -1351979174: {
                    if (!"YEAR_OF_WEEK".equals(string)) break;
                    return "EXTRACT(YEAR FROM " + source + ")";
                }
                case 2074232729: {
                    if (!"DAY_OF_WEEK".equals(string)) break;
                    return "(WEEKDAY(" + source + ") + 1)";
                }
                case 2074292194: {
                    if (!"DAY_OF_YEAR".equals(string)) break;
                    return "DAYOFYEAR(" + source + ")";
                }
            }
            return super.visitExtract(field, source);
        }

        @Override
        public String visitSQLFunction(String funcName, String[] inputs) {
            String string = funcName;
            switch (string == null ? 0 : string.hashCode()) {
                case -1728155146: {
                    if (!"DATE_DIFF".equals(string)) break;
                    return "DATEDIFF(" + inputs[0] + ", " + inputs[1] + ")";
                }
                case -1718317968: {
                    if (!"DATE_ADD".equals(string)) break;
                    return "DATE_ADD(" + inputs[0] + ", INTERVAL " + inputs[1] + " DAY)";
                }
            }
            return super.visitSQLFunction(funcName, inputs);
        }

        public String visitSortOrder(String sortKey, SortDirection sortDirection, NullOrdering nullOrdering) {
            Tuple2 tuple2 = new Tuple2((Object)sortDirection, (Object)nullOrdering);
            if (tuple2 != null) {
                SortDirection sortDirection2 = (SortDirection)tuple2._1();
                NullOrdering nullOrdering2 = (NullOrdering)tuple2._2();
                if (SortDirection.ASCENDING.equals(sortDirection2) && NullOrdering.NULLS_FIRST.equals(nullOrdering2)) {
                    return sortKey + " " + sortDirection;
                }
            }
            if (tuple2 != null) {
                SortDirection sortDirection3 = (SortDirection)tuple2._1();
                NullOrdering nullOrdering3 = (NullOrdering)tuple2._2();
                if (SortDirection.ASCENDING.equals(sortDirection3) && NullOrdering.NULLS_LAST.equals(nullOrdering3)) {
                    return "CASE WHEN " + sortKey + " IS NULL THEN 1 ELSE 0 END, " + sortKey + " " + sortDirection;
                }
            }
            if (tuple2 != null) {
                SortDirection sortDirection4 = (SortDirection)tuple2._1();
                NullOrdering nullOrdering4 = (NullOrdering)tuple2._2();
                if (SortDirection.DESCENDING.equals(sortDirection4) && NullOrdering.NULLS_FIRST.equals(nullOrdering4)) {
                    return "CASE WHEN " + sortKey + " IS NULL THEN 0 ELSE 1 END, " + sortKey + " " + sortDirection;
                }
            }
            if (tuple2 != null) {
                SortDirection sortDirection5 = (SortDirection)tuple2._1();
                NullOrdering nullOrdering5 = (NullOrdering)tuple2._2();
                if (SortDirection.DESCENDING.equals(sortDirection5) && NullOrdering.NULLS_LAST.equals(nullOrdering5)) {
                    return sortKey + " " + sortDirection;
                }
            }
            throw new MatchError((Object)tuple2);
        }

        public String visitStartsWith(String l, String r) {
            String value = r.substring(1, r.length() - 1);
            return l + " LIKE '" + this.escapeSpecialCharsForLikePattern(value) + "%' ESCAPE '\\\\'";
        }

        public String visitEndsWith(String l, String r) {
            String value = r.substring(1, r.length() - 1);
            return l + " LIKE '%" + this.escapeSpecialCharsForLikePattern(value) + "' ESCAPE '\\\\'";
        }

        public String visitContains(String l, String r) {
            String value = r.substring(1, r.length() - 1);
            return l + " LIKE '%" + this.escapeSpecialCharsForLikePattern(value) + "%' ESCAPE '\\\\'";
        }

        @Override
        public String visitAggregateFunction(String funcName, boolean isDistinct, String[] inputs) {
            if (isDistinct && this.org$apache$spark$sql$jdbc$MySQLDialect$MySQLSQLBuilder$$$outer().org$apache$spark$sql$jdbc$MySQLDialect$$distinctUnsupportedAggregateFunctions().contains((Object)funcName)) {
                throw new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_3184", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"class"), (Object)this.getClass().getSimpleName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"funcName"), (Object)funcName)})));
            }
            return super.visitAggregateFunction(funcName, isDistinct, inputs);
        }

        public /* synthetic */ MySQLDialect org$apache$spark$sql$jdbc$MySQLDialect$MySQLSQLBuilder$$$outer() {
            return (MySQLDialect)this.$outer;
        }

        public MySQLSQLBuilder(MySQLDialect $outer) {
        }
    }

    public class MySQLSQLQueryBuilder
    extends JdbcSQLQueryBuilder {
        private final JdbcDialect dialect;
        private final JDBCOptions options;
        public final /* synthetic */ MySQLDialect $outer;

        @Override
        public String build() {
            String limitOrOffsetStmt = this.limit() > 0 ? (this.offset() > 0 ? "LIMIT " + this.offset() + ", " + this.limit() : this.dialect.getLimitClause(Predef$.MODULE$.int2Integer(this.limit()))) : (this.offset() > 0 ? "LIMIT " + this.offset() + ", 18446744073709551615" : "");
            return this.options.prepareQuery() + "SELECT " + this.columnList() + " FROM " + this.options.tableOrQuery() + " " + this.tableSampleClause() + " " + this.whereClause() + " " + this.groupByClause() + " " + this.orderByClause() + " " + limitOrOffsetStmt;
        }

        public /* synthetic */ MySQLDialect org$apache$spark$sql$jdbc$MySQLDialect$MySQLSQLQueryBuilder$$$outer() {
            return this.$outer;
        }

        public MySQLSQLQueryBuilder(MySQLDialect $outer, JdbcDialect dialect, JDBCOptions options) {
            this.dialect = dialect;
            this.options = options;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(dialect, options);
        }
    }
}

