/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Locale;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcSQLQueryBuilder;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.jdbc.NoLegacyJDBCError;
import org.apache.spark.sql.jdbc.OracleDialect$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.VarcharType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.SetOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\r\rb\u0001\u0002 @\t*CQA\u001b\u0001\u0005\u0002-DQ!\u001c\u0001\u0005B9Dq\u0001 \u0001C\u0002\u0013%Q\u0010C\u0004\u0002\u001c\u0001\u0001\u000b\u0011\u0002@\t\u0011\u0005u\u0001A1A\u0005\nuDq!a\b\u0001A\u0003%a\u0010\u0003\u0005\u0002\"\u0001\u0011\r\u0011\"\u0003~\u0011\u001d\t\u0019\u0003\u0001Q\u0001\nyDq!!\n\u0001\t\u0003\n9C\u0002\u0004\u0002.\u0001\u0001\u0011q\u0006\u0005\u0007U*!\t!!\u000f\t\u000f\u0005u\"\u0002\"\u0011\u0002@!9\u0011\u0011\u000b\u0001\u0005B\u0005M\u0003bBA8\u0001\u0011\u0005\u0013\u0011\u000f\u0005\b\u0003;\u0003A\u0011IAP\u0011\u001d\ti\u000b\u0001C!\u0003_Cq!a/\u0001\t\u0003\ni\fC\u0004\u0002B\u0002!\t%a1\t\u0013\u00055\u0007!%A\u0005\u0002\u0005=\u0007bBAs\u0001\u0011\u0005\u0013q\u001d\u0005\b\u0003k\u0004A\u0011IA|\u0011\u001d\u0011\t\u0001\u0001C!\u0005\u0007AqA!\u0004\u0001\t\u0003\u0012y\u0001C\u0004\u0003\u001c\u0001!\tE!\b\u0007\r\t\r\u0002\u0001\u0001B\u0013\u0011%\u0011i#\u0007B\u0001B\u0003%1\n\u0003\u0006\u00030e\u0011\t\u0011)A\u0005\u0005cAaA[\r\u0005\u0002\t\r\u0003b\u0002B&3\u0011\u0005#Q\n\u0005\b\u0005\u001f\u0002A\u0011\tB)\u0011\u001d\u0011)\u0006\u0001C!\u0005/BqA!\u0017\u0001\t\u0003\u00129\u0006C\u0004\u0003\\\u0001!\tE!\u0018\t\u0011\t\r\u0005!!A\u0005\u0002-D\u0011B!\"\u0001\u0003\u0003%\tEa\"\t\u0013\t%\u0005!!A\u0005\u0002\t-\u0005\"\u0003BG\u0001\u0005\u0005I\u0011\u0001BH\u0011%\u0011)\nAA\u0001\n\u0003\u00129\nC\u0005\u0003\"\u0002\t\t\u0011\"\u0001\u0003$\"I!q\u0015\u0001\u0002\u0002\u0013\u0005#\u0011\u0016\u0005\n\u0005[\u0003\u0011\u0011!C!\u0005_C\u0011B!-\u0001\u0003\u0003%\tEa-\t\u0013\tU\u0006!!A\u0005B\t]v\u0001\u0003B^\u007f!\u0005qH!0\u0007\u000fyz\u0004\u0012A \u0003@\"1!.\fC\u0001\u0005#D\u0011Ba5.\u0005\u0004%)A!6\t\u0011\tmW\u0006)A\u0007\u0005/D\u0011B!8.\u0005\u0004%)Aa8\t\u0011\t\u0015X\u0006)A\u0007\u0005CD\u0011Ba:.\u0005\u0004%)A!;\t\u0011\t=X\u0006)A\u0007\u0005WD\u0011B!=.\u0005\u0004%)Aa=\t\u0011\teX\u0006)A\u0007\u0005kD\u0011Ba?.\u0005\u0004%)A!@\t\u0011\r\rQ\u0006)A\u0007\u0005\u007fD\u0011b!\u0002.\u0005\u0004%)aa\u0002\t\u0011\r5Q\u0006)A\u0007\u0007\u0013A\u0001ba\u0004.\u0003\u0003%\ti\u001b\u0005\n\u0007#i\u0013\u0011!CA\u0007'A\u0011b!\u0007.\u0003\u0003%Iaa\u0007\u0003\u001b=\u0013\u0018m\u00197f\t&\fG.Z2u\u0015\t\u0001\u0015)\u0001\u0003kI\n\u001c'B\u0001\"D\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\t\u0016\u000bQa\u001d9be.T!AR$\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0015aA8sO\u000e\u00011C\u0002\u0001L\u001fVCf\f\u0005\u0002M\u001b6\tq(\u0003\u0002O\u007f\tY!\n\u001a2d\t&\fG.Z2u!\t\u00016+D\u0001R\u0015\t\u0011\u0016)\u0001\u0005dCR\fG._:u\u0013\t!\u0016KA\u0007T#2\u001buN\u001c4IK2\u0004XM\u001d\t\u0003\u0019ZK!aV \u0003#9{G*Z4bGfTEIQ\"FeJ|'\u000f\u0005\u0002Z96\t!LC\u0001\\\u0003\u0015\u00198-\u00197b\u0013\ti&LA\u0004Qe>$Wo\u0019;\u0011\u0005};gB\u00011f\u001d\t\tG-D\u0001c\u0015\t\u0019\u0017*\u0001\u0004=e>|GOP\u0005\u00027&\u0011aMW\u0001\ba\u0006\u001c7.Y4f\u0013\tA\u0017N\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002g5\u00061A(\u001b8jiz\"\u0012\u0001\u001c\t\u0003\u0019\u0002\t\u0011bY1o\u0011\u0006tG\r\\3\u0015\u0005=\u0014\bCA-q\u0013\t\t(LA\u0004C_>dW-\u00198\t\u000bM\u0014\u0001\u0019\u0001;\u0002\u0007U\u0014H\u000e\u0005\u0002vs:\u0011ao\u001e\t\u0003CjK!\u0001\u001f.\u0002\rA\u0013X\rZ3g\u0013\tQ8P\u0001\u0004TiJLgn\u001a\u0006\u0003qj\u000bQ\u0005Z5ti&t7\r^+ogV\u0004\bo\u001c:uK\u0012\fum\u001a:fO\u0006$XMR;oGRLwN\\:\u0016\u0003y\u0004Ra`A\u0005\u0003\u001bi!!!\u0001\u000b\t\u0005\r\u0011QA\u0001\nS6lW\u000f^1cY\u0016T1!a\u0002[\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u0017\t\tAA\u0002TKR\u0004B!a\u0004\u0002\u001a5\u0011\u0011\u0011\u0003\u0006\u0005\u0003'\t)\"\u0001\u0003mC:<'BAA\f\u0003\u0011Q\u0017M^1\n\u0007i\f\t\"\u0001\u0014eSN$\u0018N\\2u+:\u001cX\u000f\u001d9peR,G-Q4he\u0016<\u0017\r^3Gk:\u001cG/[8og\u0002\n1d];qa>\u0014H/\u001a3BO\u001e\u0014XmZ1uK\u001a+hn\u0019;j_:\u001c\u0018\u0001H:vaB|'\u000f^3e\u0003\u001e<'/Z4bi\u00164UO\\2uS>t7\u000fI\u0001\u0013gV\u0004\bo\u001c:uK\u00124UO\\2uS>t7/A\ntkB\u0004xN\u001d;fI\u001a+hn\u0019;j_:\u001c\b%A\njgN+\b\u000f]8si\u0016$g)\u001e8di&|g\u000eF\u0002p\u0003SAa!a\u000b\n\u0001\u0004!\u0018\u0001\u00034v]\u000et\u0015-\\3\u0003!=\u0013\u0018m\u00197f'Fc%)^5mI\u0016\u00148c\u0001\u0006\u00022A!\u00111GA\u001b\u001b\u0005\u0001\u0011bAA\u001c\u001b\nq!\n\u0012\"D'Fc%)^5mI\u0016\u0014HCAA\u001e!\r\t\u0019DC\u0001\u0017m&\u001c\u0018\u000e^!hOJ,w-\u0019;f\rVt7\r^5p]R9A/!\u0011\u0002D\u0005\u001d\u0003BBA\u0016\u0019\u0001\u0007A\u000f\u0003\u0004\u0002F1\u0001\ra\\\u0001\u000bSN$\u0015n\u001d;j]\u000e$\bbBA%\u0019\u0001\u0007\u00111J\u0001\u0007S:\u0004X\u000f^:\u0011\te\u000bi\u0005^\u0005\u0004\u0003\u001fR&!B!se\u0006L\u0018!E2p[BLG.Z#yaJ,7o]5p]R!\u0011QKA.!\u0011I\u0016q\u000b;\n\u0007\u0005e#L\u0001\u0004PaRLwN\u001c\u0005\b\u0003;j\u0001\u0019AA0\u0003\u0011)\u0007\u0010\u001d:\u0011\t\u0005\u0005\u00141N\u0007\u0003\u0003GRA!!\u001a\u0002h\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\r\tI'Q\u0001\nG>tg.Z2u_JLA!!\u001c\u0002d\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u001f\u001d,GoQ1uC2L8\u000f\u001e+za\u0016$\"\"a\u001d\u0002\u0002\u0006-\u0015qRAJ!\u0015I\u0016qKA;!\u0011\t9(! \u000e\u0005\u0005e$bAA>\u0003\u0006)A/\u001f9fg&!\u0011qPA=\u0005!!\u0015\r^1UsB,\u0007bBAB\u001d\u0001\u0007\u0011QQ\u0001\bgFdG+\u001f9f!\rI\u0016qQ\u0005\u0004\u0003\u0013S&aA%oi\"1\u0011Q\u0012\bA\u0002Q\f\u0001\u0002^=qK:\u000bW.\u001a\u0005\b\u0003#s\u0001\u0019AAC\u0003\u0011\u0019\u0018N_3\t\u000f\u0005Ue\u00021\u0001\u0002\u0018\u0006\u0011Q\u000e\u001a\t\u0005\u0003o\nI*\u0003\u0003\u0002\u001c\u0006e$aD'fi\u0006$\u0017\r^1Ck&dG-\u001a:\u0002\u0017\u001d,GO\u0013#C\u0007RK\b/\u001a\u000b\u0005\u0003C\u000bI\u000bE\u0003Z\u0003/\n\u0019\u000bE\u0002M\u0003KK1!a*@\u0005!QEMY2UsB,\u0007bBAV\u001f\u0001\u0007\u0011QO\u0001\u0003IR\fAbY8na&dWMV1mk\u0016$B!!-\u00028B\u0019\u0011,a-\n\u0007\u0005U&LA\u0002B]fDq!!/\u0011\u0001\u0004\t\t,A\u0003wC2,X-\u0001\rjg\u000e\u000b7oY1eS:<GK];oG\u0006$X\rV1cY\u0016$\"!a0\u0011\te\u000b9f\\\u0001\u0011O\u0016$HK];oG\u0006$X-U;fef$R\u0001^Ac\u0003\u0013Da!a2\u0013\u0001\u0004!\u0018!\u0002;bE2,\u0007\"CAf%A\u0005\t\u0019AA`\u0003\u001d\u0019\u0017m]2bI\u0016\f!dZ3u)J,hnY1uKF+XM]=%I\u00164\u0017-\u001e7uII*\"!!5+\t\u0005}\u00161[\u0016\u0003\u0003+\u0004B!a6\u0002b6\u0011\u0011\u0011\u001c\u0006\u0005\u00037\fi.A\u0005v]\u000eDWmY6fI*\u0019\u0011q\u001c.\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002d\u0006e'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\tr-\u001a;BI\u0012\u001cu\u000e\\;n]F+XM]=\u0015\u000fQ\fI/!<\u0002r\"1\u00111\u001e\u000bA\u0002Q\f\u0011\u0002^1cY\u0016t\u0015-\\3\t\r\u0005=H\u00031\u0001u\u0003)\u0019w\u000e\\;n]:\u000bW.\u001a\u0005\u0007\u0003g$\u0002\u0019\u0001;\u0002\u0011\u0011\fG/\u0019+za\u0016\f\u0001dZ3u+B$\u0017\r^3D_2,XN\u001c+za\u0016\fV/\u001a:z)\u001d!\u0018\u0011`A~\u0003{Da!a;\u0016\u0001\u0004!\bBBAx+\u0001\u0007A\u000f\u0003\u0004\u0002\u0000V\u0001\r\u0001^\u0001\f]\u0016<H)\u0019;b)f\u0004X-A\u0010hKR,\u0006\u000fZ1uK\u000e{G.^7o\u001dVdG.\u00192jY&$\u00180U;fef$r\u0001\u001eB\u0003\u0005\u000f\u0011I\u0001\u0003\u0004\u0002lZ\u0001\r\u0001\u001e\u0005\u0007\u0003_4\u0002\u0019\u0001;\t\r\t-a\u00031\u0001p\u0003)I7OT;mY\u0006\u0014G.Z\u0001\u000fO\u0016$H*[7ji\u000ec\u0017-^:f)\r!(\u0011\u0003\u0005\b\u0005'9\u0002\u0019\u0001B\u000b\u0003\u0015a\u0017.\\5u!\u0011\tyAa\u0006\n\t\te\u0011\u0011\u0003\u0002\b\u0013:$XmZ3s\u0003=9W\r^(gMN,Go\u00117bkN,Gc\u0001;\u0003 !9!\u0011\u0005\rA\u0002\tU\u0011AB8gMN,GOA\u000bPe\u0006\u001cG.Z*R\u0019F+XM]=Ck&dG-\u001a:\u0014\u0007e\u00119\u0003E\u0002M\u0005SI1Aa\u000b@\u0005MQEMY2T#2\u000bV/\u001a:z\u0005VLG\u000eZ3s\u0003\u001d!\u0017.\u00197fGR\fqa\u001c9uS>t7\u000f\u0005\u0003\u00034\t}RB\u0001B\u001b\u0015\r\u0001%q\u0007\u0006\u0005\u0005s\u0011Y$A\u0006eCR\f7o\\;sG\u0016\u001c(b\u0001B\u001f\u0003\u0006IQ\r_3dkRLwN\\\u0005\u0005\u0005\u0003\u0012)DA\u0006K\t\n\u001bu\n\u001d;j_:\u001cHC\u0002B#\u0005\u000f\u0012I\u0005E\u0002\u00024eAaA!\f\u001d\u0001\u0004Y\u0005b\u0002B\u00189\u0001\u0007!\u0011G\u0001\u0006EVLG\u000e\u001a\u000b\u0002i\u00061r-\u001a;KI\n\u001c7+\u0015'Rk\u0016\u0014\u0018PQ;jY\u0012,'\u000f\u0006\u0003\u0003(\tM\u0003b\u0002B\u0018=\u0001\u0007!\u0011G\u0001\u000egV\u0004\bo\u001c:ug2KW.\u001b;\u0016\u0003=\fab];qa>\u0014Ho](gMN,G/A\tdY\u0006\u001c8/\u001b4z\u000bb\u001cW\r\u001d;j_:$\"Ba\u0018\u0003h\tE$Q\u000fB@!\u0011\u0011\tGa\u0019\u000e\u0003\u0005K1A!\u001aB\u0005E\te.\u00197zg&\u001cX\t_2faRLwN\u001c\u0005\b\u0005S\n\u0003\u0019\u0001B6\u0003\u0005)\u0007cA0\u0003n%\u0019!qN5\u0003\u0013QC'o\\<bE2,\u0007B\u0002B:C\u0001\u0007A/\u0001\u0006feJ|'o\u00117bgNDqAa\u001e\"\u0001\u0004\u0011I(A\tnKN\u001c\u0018mZ3QCJ\fW.\u001a;feN\u0004R!\u001eB>iRL1A! |\u0005\ri\u0015\r\u001d\u0005\u0007\u0005\u0003\u000b\u0003\u0019\u0001;\u0002\u0017\u0011,7o\u0019:jaRLwN\\\u0001\u0005G>\u0004\u00180A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u001b\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\"\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011\u0011\u0017BI\u0011%\u0011\u0019*JA\u0001\u0002\u0004\t))A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u00053\u0003bAa'\u0003\u001e\u0006EVBAA\u0003\u0013\u0011\u0011y*!\u0002\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004_\n\u0015\u0006\"\u0003BJO\u0005\u0005\t\u0019AAY\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u00055!1\u0016\u0005\n\u0005'C\u0013\u0011!a\u0001\u0003\u000b\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003\u000b\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u001b\ta!Z9vC2\u001cHcA8\u0003:\"I!1S\u0016\u0002\u0002\u0003\u0007\u0011\u0011W\u0001\u000e\u001fJ\f7\r\\3ES\u0006dWm\u0019;\u0011\u00051k3#B\u0017\u0003B\n\u001d\u0007cA-\u0003D&\u0019!Q\u0019.\u0003\r\u0005s\u0017PU3g!\u0011\u0011IMa4\u000e\u0005\t-'\u0002\u0002Bg\u0003+\t!![8\n\u0007!\u0014Y\r\u0006\u0002\u0003>\u0006a!)\u0013(B%f{f\tT(B)V\u0011!q[\b\u0003\u00053l\u0012\u0001Z\u0001\u000e\u0005&s\u0015IU-`\r2{\u0015\t\u0016\u0011\u0002\u001b\tKe*\u0011*Z?\u0012{UK\u0011'F+\t\u0011\to\u0004\u0002\u0003dv\tQ-\u0001\bC\u0013:\u000b%+W0E\u001fV\u0013E*\u0012\u0011\u0002\u0019QKU*R*U\u00036\u0003v\f\u0016.\u0016\u0005\t-xB\u0001Bw;\u0005Y\u001a!\u0004+J\u001b\u0016\u001bF+Q'Q?RS\u0006%A\u0007U\u00136+5\u000bV!N!~cEKW\u000b\u0003\u0005k|!Aa>\u001e\u0003i\ra\u0002V%N\u000bN#\u0016)\u0014)`\u0019RS\u0006%A\u0006J\u001dR+%KV!M?fkUC\u0001B\u0000\u001f\t\u0019\t!H\u0001\u001a\u00041Ie\nV#S-\u0006cu,W'!\u0003-Ie\nV#S-\u0006cu\fR*\u0016\u0005\r%qBAB\u0006;\u0005A\u001a\u0001D%O)\u0016\u0013f+\u0011'`\tN\u0003\u0013!B1qa2L\u0018aB;oCB\u0004H.\u001f\u000b\u0004_\u000eU\u0001\u0002CB\fy\u0005\u0005\t\u0019\u00017\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0004\u001eA!\u0011qBB\u0010\u0013\u0011\u0019\t#!\u0005\u0003\r=\u0013'.Z2u\u0001")
public class OracleDialect
extends JdbcDialect
implements SQLConfHelper,
NoLegacyJDBCError,
Product {
    private final Set<String> org$apache$spark$sql$jdbc$OracleDialect$$distinctUnsupportedAggregateFunctions;
    private final Set<String> supportedAggregateFunctions;
    private final Set<String> supportedFunctions;

    public static boolean unapply(OracleDialect x$0) {
        return OracleDialect$.MODULE$.unapply(x$0);
    }

    public static OracleDialect apply() {
        return OracleDialect$.MODULE$.apply();
    }

    public static int INTERVAL_DS() {
        return OracleDialect$.MODULE$.INTERVAL_DS();
    }

    public static int INTERVAL_YM() {
        return OracleDialect$.MODULE$.INTERVAL_YM();
    }

    public static int TIMESTAMP_LTZ() {
        return OracleDialect$.MODULE$.TIMESTAMP_LTZ();
    }

    public static int TIMESTAMP_TZ() {
        return OracleDialect$.MODULE$.TIMESTAMP_TZ();
    }

    public static int BINARY_DOUBLE() {
        return OracleDialect$.MODULE$.BINARY_DOUBLE();
    }

    public static int BINARY_FLOAT() {
        return OracleDialect$.MODULE$.BINARY_FLOAT();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:oracle");
    }

    public Set<String> org$apache$spark$sql$jdbc$OracleDialect$$distinctUnsupportedAggregateFunctions() {
        return this.org$apache$spark$sql$jdbc$OracleDialect$$distinctUnsupportedAggregateFunctions;
    }

    private Set<String> supportedAggregateFunctions() {
        return this.supportedAggregateFunctions;
    }

    private Set<String> supportedFunctions() {
        return this.supportedFunctions;
    }

    @Override
    public boolean isSupportedFunction(String funcName) {
        return this.supportedFunctions().contains((Object)funcName);
    }

    @Override
    public Option<String> compileExpression(Expression expr) {
        Some some;
        OracleSQLBuilder oracleSQLBuilder = new OracleSQLBuilder(this);
        try {
            some = new Some((Object)oracleSQLBuilder.build(expr));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(throwable2)) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Error occurs while compiling V2 expression", throwable2);
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        int n = sqlType;
        switch (n) {
            case 2: {
                long scale = md != null ? md.build().getLong("scale") : 0L;
                int n2 = size;
                switch (n2) {
                    case 0: {
                        return Option$.MODULE$.apply((Object)new DecimalType(DecimalType$.MODULE$.MAX_PRECISION(), 10));
                    }
                }
                if (scale == -127L) {
                    return Option$.MODULE$.apply((Object)new DecimalType(DecimalType$.MODULE$.MAX_PRECISION(), 10));
                }
                return None$.MODULE$;
            }
            case -102: 
            case -101: {
                return new Some((Object)TimestampType$.MODULE$);
            }
            case 100: {
                return new Some((Object)FloatType$.MODULE$);
            }
            case 101: {
                return new Some((Object)DoubleType$.MODULE$);
            }
            case -103: {
                return new Some((Object)YearMonthIntervalType$.MODULE$.apply());
            }
            case -104: {
                return new Some((Object)DayTimeIntervalType$.MODULE$.apply());
            }
        }
        return None$.MODULE$;
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        DataType dataType = dt;
        if (BooleanType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NUMBER(1)", 16));
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NUMBER(10)", 4));
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NUMBER(19)", -5));
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NUMBER(19, 4)", 6));
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NUMBER(19, 4)", 8));
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NUMBER(3)", 5));
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NUMBER(5)", 5));
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("VARCHAR2(255)", 12));
        }
        if (dataType instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)dataType;
            int n = varcharType.length();
            return new Some((Object)new JdbcType("VARCHAR2(" + n + ")", 12));
        }
        if (TimestampType$.MODULE$.equals(dataType) && !this.conf().legacyOracleTimestampMappingEnabled()) {
            return new Some((Object)new JdbcType("TIMESTAMP WITH LOCAL TIME ZONE", -102));
        }
        return None$.MODULE$;
    }

    @Override
    public Object compileValue(Object value2) {
        Object object = value2;
        if (object instanceof String) {
            String string = (String)object;
            return "'" + this.escapeSql(string) + "'";
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            return "{ts '" + timestamp + "'}";
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return "{d '" + date + "'}";
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            return Predef$.MODULE$.genericWrapArray(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps((Object)objectArray), (Function1 & Serializable)value -> this.compileValue(value), ClassTag$.MODULE$.Any())).mkString(", ");
        }
        return value2;
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public String getTruncateQuery(String table, Option<Object> cascade) {
        Some some;
        boolean bl;
        Option<Object> option = cascade;
        if (option instanceof Some && (bl = BoxesRunTime.unboxToBoolean((Object)(some = (Some)option).value()))) {
            return "TRUNCATE TABLE " + table + " CASCADE";
        }
        return "TRUNCATE TABLE " + table;
    }

    @Override
    public Option<Object> getTruncateQuery$default$2() {
        return this.isCascadingTruncateTable();
    }

    @Override
    public String getAddColumnQuery(String tableName, String columnName, String dataType) {
        return "ALTER TABLE " + tableName + " ADD " + this.quoteIdentifier(columnName) + " " + dataType;
    }

    @Override
    public String getUpdateColumnTypeQuery(String tableName, String columnName, String newDataType) {
        return "ALTER TABLE " + tableName + " MODIFY " + this.quoteIdentifier(columnName) + " " + newDataType;
    }

    @Override
    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        String nullable = isNullable ? "NULL" : "NOT NULL";
        return "ALTER TABLE " + tableName + " MODIFY " + this.quoteIdentifier(columnName) + " " + nullable;
    }

    @Override
    public String getLimitClause(Integer limit) {
        if (Predef$.MODULE$.Integer2int(limit) > 0) {
            return "WHERE rownum <= " + limit;
        }
        return "";
    }

    @Override
    public String getOffsetClause(Integer offset) {
        if (Predef$.MODULE$.Integer2int(offset) > 0) {
            return "WHERE rn > " + offset;
        }
        return "";
    }

    @Override
    public JdbcSQLQueryBuilder getJdbcSQLQueryBuilder(JDBCOptions options) {
        return new OracleSQLQueryBuilder(this, this, options);
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsOffset() {
        return true;
    }

    @Override
    public AnalysisException classifyException(Throwable e, String errorClass, Map<String, String> messageParameters, String description) {
        Throwable throwable = e;
        if (throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            int n = sQLException.getErrorCode();
            switch (n) {
                case 955: {
                    String string = errorClass;
                    String string2 = "FAILED_JDBC.RENAME_TABLE";
                    if (string != null ? !string.equals(string2) : string2 != null) break;
                    String newTable = (String)messageParameters.apply((Object)"newName");
                    throw QueryCompilationErrors$.MODULE$.tableAlreadyExistsError(newTable);
                }
            }
            return NoLegacyJDBCError.classifyException$(this, e, errorClass, messageParameters, description);
        }
        return NoLegacyJDBCError.classifyException$(this, e, errorClass, messageParameters, description);
    }

    public OracleDialect copy() {
        return new OracleDialect();
    }

    public String productPrefix() {
        return "OracleDialect";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof OracleDialect;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean equals(Object x$1) {
        Object object = x$1;
        return object instanceof OracleDialect && ((OracleDialect)x$1).canEqual(this);
    }

    public OracleDialect() {
        SQLConfHelper.$init$((SQLConfHelper)this);
        NoLegacyJDBCError.$init$(this);
        Product.$init$((Product)this);
        this.org$apache$spark$sql$jdbc$OracleDialect$$distinctUnsupportedAggregateFunctions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"VAR_POP", "VAR_SAMP", "STDDEV_POP", "STDDEV_SAMP", "COVAR_POP", "COVAR_SAMP", "CORR", "REGR_INTERCEPT", "REGR_R2", "REGR_SLOPE", "REGR_SXY"}));
        this.supportedAggregateFunctions = (Set)((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"MAX", "MIN", "SUM", "COUNT", "AVG"}))).$plus$plus(this.org$apache$spark$sql$jdbc$OracleDialect$$distinctUnsupportedAggregateFunctions());
        this.supportedFunctions = this.supportedAggregateFunctions();
    }

    public class OracleSQLBuilder
    extends JdbcDialect.JDBCSQLBuilder {
        @Override
        public String visitAggregateFunction(String funcName, boolean isDistinct, String[] inputs) {
            if (isDistinct && this.org$apache$spark$sql$jdbc$OracleDialect$OracleSQLBuilder$$$outer().org$apache$spark$sql$jdbc$OracleDialect$$distinctUnsupportedAggregateFunctions().contains((Object)funcName)) {
                throw new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_3184", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"class"), (Object)this.getClass().getSimpleName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"funcName"), (Object)funcName)})));
            }
            return super.visitAggregateFunction(funcName, isDistinct, inputs);
        }

        public /* synthetic */ OracleDialect org$apache$spark$sql$jdbc$OracleDialect$OracleSQLBuilder$$$outer() {
            return (OracleDialect)this.$outer;
        }

        public OracleSQLBuilder(OracleDialect $outer) {
        }
    }

    public class OracleSQLQueryBuilder
    extends JdbcSQLQueryBuilder {
        private final JdbcDialect dialect;
        private final JDBCOptions options;
        public final /* synthetic */ OracleDialect $outer;

        @Override
        public String build() {
            String string;
            String selectStmt = "SELECT " + this.columnList() + " FROM " + this.options.tableOrQuery() + " " + this.tableSampleClause() + " " + this.whereClause() + " " + this.groupByClause() + " " + this.orderByClause();
            if (this.limit() > 0) {
                if (this.offset() > 0) {
                    string = "SELECT " + this.columnList() + " FROM (SELECT tab.*, rownum rn FROM (" + selectStmt + ") tab) WHERE rn > " + this.offset() + " AND rn <= " + (this.limit() + this.offset());
                } else {
                    String limitClause = this.dialect.getLimitClause(Predef$.MODULE$.int2Integer(this.limit()));
                    string = "SELECT tab.* FROM (" + selectStmt + ") tab " + limitClause;
                }
            } else if (this.offset() > 0) {
                String offsetClause = this.dialect.getOffsetClause(Predef$.MODULE$.int2Integer(this.offset()));
                string = "SELECT " + this.columnList() + " FROM (SELECT tab.*, rownum rn FROM (" + selectStmt + ") tab) " + offsetClause;
            } else {
                string = selectStmt;
            }
            String finalSelectStmt = string;
            return this.options.prepareQuery() + finalSelectStmt;
        }

        public /* synthetic */ OracleDialect org$apache$spark$sql$jdbc$OracleDialect$OracleSQLQueryBuilder$$$outer() {
            return this.$outer;
        }

        public OracleSQLQueryBuilder(OracleDialect $outer, JdbcDialect dialect, JDBCOptions options) {
            this.dialect = dialect;
            this.options = options;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(dialect, options);
        }
    }
}

