/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Locale;
import java.util.Map;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.IndexAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchIndexException;
import org.apache.spark.sql.catalyst.analysis.NonEmptyNamespaceException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions$;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.execution.datasources.v2.TableSampleInfo;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.jdbc.NoLegacyJDBCError;
import org.apache.spark.sql.jdbc.PostgresDialect$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.VarcharType;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Using;
import scala.util.Using$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005\rEc\u0001\u0002\u001a4\tzBQA\u0018\u0001\u0005\u0002}CQ!\u0019\u0001\u0005B\tDq\u0001\u001d\u0001C\u0002\u0013%\u0011\u000fC\u0004\u0002\u0004\u0001\u0001\u000b\u0011\u0002:\t\u0011\u0005\u0015\u0001A1A\u0005\nEDq!a\u0002\u0001A\u0003%!\u000fC\u0004\u0002\n\u0001!\t%a\u0003\t\u000f\u0005E\u0001\u0001\"\u0011\u0002\u0014!9\u00111\t\u0001\u0005\n\u0005\u0015\u0003bBA(\u0001\u0011\u0005\u0013\u0011\u000b\u0005\b\u0003[\u0002A\u0011IA8\u0011\u001d\t)\b\u0001C!\u0003oBq!!\"\u0001\t\u0003\n9\tC\u0004\u0002\f\u0002!\t%!$\t\u0013\u0005]\u0005!%A\u0005\u0002\u0005e\u0005bBAX\u0001\u0011\u0005\u0013\u0011\u0017\u0005\b\u0003\u001b\u0004A\u0011IAh\u0011\u001d\ti\u000e\u0001C!\u0003?Dq!!;\u0001\t\u0003\nY\u000fC\u0004\u0003.\u0001!\tEa\f\t\u000f\t=\u0003\u0001\"\u0011\u0003R!I!q\u000b\u0001C\u0002\u00135!\u0011\f\u0005\t\u0005S\u0002\u0001\u0015!\u0004\u0003\\!9!1\u000e\u0001\u0005B\t5\u0004b\u0002BG\u0001\u0011\u0005#q\u0012\u0005\b\u0005#\u0003A\u0011\tBH\u0011\u001d\u0011\u0019\n\u0001C!\u0005\u001fCqA!&\u0001\t\u0003\u00129\nC\u0004\u0003*\u0002!\tEa+\t\u000f\tU\u0006\u0001\"\u0011\u00038\"9!1\u0018\u0001\u0005B\tu\u0006b\u0002Be\u0001\u0011\u0005#1\u001a\u0005\t\u0005C\u0004\u0011\u0011!C\u0001?\"I!1\u001d\u0001\u0002\u0002\u0013\u0005#Q\u001d\u0005\n\u0005O\u0004\u0011\u0011!C\u0001\u0005SD\u0011Ba;\u0001\u0003\u0003%\tA!<\t\u0013\te\b!!A\u0005B\tm\b\"CB\u0003\u0001\u0005\u0005I\u0011AB\u0004\u0011%\u0019Y\u0001AA\u0001\n\u0003\u001ai\u0001C\u0005\u0004\u0012\u0001\t\t\u0011\"\u0011\u0004\u0014!I1Q\u0003\u0001\u0002\u0002\u0013\u00053q\u0003\u0005\n\u00073\u0001\u0011\u0011!C!\u000779\u0011ba\b4\u0003\u0003EIa!\t\u0007\u0011I\u001a\u0014\u0011!E\u0005\u0007GAaA\u0018\u0017\u0005\u0002\rm\u0002\"CB\u000bY\u0005\u0005IQIB\f\u0011!\u0019i\u0004LA\u0001\n\u0003{\u0006\"CB Y\u0005\u0005I\u0011QB!\u0011%\u00199\u0005LA\u0001\n\u0013\u0019IEA\bQ_N$xM]3t\t&\fG.Z2u\u0015\t!T'\u0001\u0003kI\n\u001c'B\u0001\u001c8\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003qe\nQa\u001d9be.T!AO\u001e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0014aA8sO\u000e\u00011C\u0002\u0001@\u0007&c%\u000b\u0005\u0002A\u00036\t1'\u0003\u0002Cg\tY!\n\u001a2d\t&\fG.Z2u!\t!u)D\u0001F\u0015\t1U'\u0001\u0005dCR\fG._:u\u0013\tAUIA\u0007T#2\u001buN\u001c4IK2\u0004XM\u001d\t\u0003\u0001*K!aS\u001a\u0003#9{G*Z4bGfTEIQ\"FeJ|'\u000f\u0005\u0002N!6\taJC\u0001P\u0003\u0015\u00198-\u00197b\u0013\t\tfJA\u0004Qe>$Wo\u0019;\u0011\u0005M[fB\u0001+Z\u001d\t)\u0006,D\u0001W\u0015\t9V(\u0001\u0004=e>|GOP\u0005\u0002\u001f&\u0011!LT\u0001\ba\u0006\u001c7.Y4f\u0013\taVL\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002[\u001d\u00061A(\u001b8jiz\"\u0012\u0001\u0019\t\u0003\u0001\u0002\t\u0011bY1o\u0011\u0006tG\r\\3\u0015\u0005\r4\u0007CA'e\u0013\t)gJA\u0004C_>dW-\u00198\t\u000b\u001d\u0014\u0001\u0019\u00015\u0002\u0007U\u0014H\u000e\u0005\u0002j[:\u0011!n\u001b\t\u0003+:K!\u0001\u001c(\u0002\rA\u0013X\rZ3g\u0013\tqwN\u0001\u0004TiJLgn\u001a\u0006\u0003Y:\u000b1d];qa>\u0014H/\u001a3BO\u001e\u0014XmZ1uK\u001a+hn\u0019;j_:\u001cX#\u0001:\u0011\u0007MD(0D\u0001u\u0015\t)h/A\u0005j[6,H/\u00192mK*\u0011qOT\u0001\u000bG>dG.Z2uS>t\u0017BA=u\u0005\r\u0019V\r\u001e\t\u0004w\u0006\u0005Q\"\u0001?\u000b\u0005ut\u0018\u0001\u00027b]\u001eT\u0011a`\u0001\u0005U\u00064\u0018-\u0003\u0002oy\u0006a2/\u001e9q_J$X\rZ!hOJ,w-\u0019;f\rVt7\r^5p]N\u0004\u0013AE:vaB|'\u000f^3e\rVt7\r^5p]N\f1c];qa>\u0014H/\u001a3Gk:\u001cG/[8og\u0002\n1#[:TkB\u0004xN\u001d;fI\u001a+hn\u0019;j_:$2aYA\u0007\u0011\u0019\tya\u0002a\u0001Q\u0006Aa-\u001e8d\u001d\u0006lW-A\bhKR\u001c\u0015\r^1msN$H+\u001f9f))\t)\"a\n\u00022\u0005U\u0012\u0011\b\t\u0006\u001b\u0006]\u00111D\u0005\u0004\u00033q%AB(qi&|g\u000e\u0005\u0003\u0002\u001e\u0005\rRBAA\u0010\u0015\r\t\t#N\u0001\u0006if\u0004Xm]\u0005\u0005\u0003K\tyB\u0001\u0005ECR\fG+\u001f9f\u0011\u001d\tI\u0003\u0003a\u0001\u0003W\tqa]9m)f\u0004X\rE\u0002N\u0003[I1!a\fO\u0005\rIe\u000e\u001e\u0005\u0007\u0003gA\u0001\u0019\u00015\u0002\u0011QL\b/\u001a(b[\u0016Dq!a\u000e\t\u0001\u0004\tY#\u0001\u0003tSj,\u0007bBA\u001e\u0011\u0001\u0007\u0011QH\u0001\u0003[\u0012\u0004B!!\b\u0002@%!\u0011\u0011IA\u0010\u0005=iU\r^1eCR\f')^5mI\u0016\u0014\u0018A\u0004;p\u0007\u0006$\u0018\r\\=tiRK\b/\u001a\u000b\t\u0003+\t9%!\u0013\u0002N!1\u00111G\u0005A\u0002!Dq!a\u0013\n\u0001\u0004\tY#A\u0005qe\u0016\u001c\u0017n]5p]\"9\u00111H\u0005A\u0002\u0005u\u0012AI2p]Z,'\u000f\u001e&bm\u0006$\u0016.\\3ti\u0006l\u0007\u000fV8US6,7\u000f^1na:#&\f\u0006\u0003\u0002T\u0005}\u0003\u0003BA+\u00037j!!a\u0016\u000b\u0007\u0005ec0\u0001\u0003uS6,\u0017\u0002BA/\u0003/\u0012Q\u0002T8dC2$\u0015\r^3US6,\u0007bBA1\u0015\u0001\u0007\u00111M\u0001\u0002iB!\u0011QMA5\u001b\t\t9G\u0003\u00027}&!\u00111NA4\u0005%!\u0016.\\3ti\u0006l\u0007/\u0001\u0012d_:4XM\u001d;US6,7\u000f^1na:#&\fV8KCZ\fG+[7fgR\fW\u000e\u001d\u000b\u0005\u0003G\n\t\bC\u0004\u0002t-\u0001\r!a\u0015\u0002\u00071$G/A\u0006hKRTEIQ\"UsB,G\u0003BA=\u0003\u0003\u0003R!TA\f\u0003w\u00022\u0001QA?\u0013\r\tyh\r\u0002\t\u0015\u0012\u00147\rV=qK\"9\u00111\u0011\u0007A\u0002\u0005m\u0011A\u00013u\u0003aI7oQ1tG\u0006$\u0017N\\4UeVt7-\u0019;f)\u0006\u0014G.\u001a\u000b\u0003\u0003\u0013\u0003B!TA\fG\u0006\u0001r-\u001a;UeVt7-\u0019;f#V,'/\u001f\u000b\u0006Q\u0006=\u00151\u0013\u0005\u0007\u0003#s\u0001\u0019\u00015\u0002\u000bQ\f'\r\\3\t\u0013\u0005Ue\u0002%AA\u0002\u0005%\u0015aB2bg\u000e\fG-Z\u0001\u001bO\u0016$HK];oG\u0006$X-U;fef$C-\u001a4bk2$HEM\u000b\u0003\u00037SC!!#\u0002\u001e.\u0012\u0011q\u0014\t\u0005\u0003C\u000bY+\u0004\u0002\u0002$*!\u0011QUAT\u0003%)hn\u00195fG.,GMC\u0002\u0002*:\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\ti+a)\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0006cK\u001a|'/\u001a$fi\u000eDGCBAZ\u0003s\u000b\u0019\rE\u0002N\u0003kK1!a.O\u0005\u0011)f.\u001b;\t\u000f\u0005m\u0006\u00031\u0001\u0002>\u0006Q1m\u001c8oK\u000e$\u0018n\u001c8\u0011\t\u0005\u0015\u0014qX\u0005\u0005\u0003\u0003\f9G\u0001\u0006D_:tWm\u0019;j_:Dq!!2\u0011\u0001\u0004\t9-\u0001\u0006qe>\u0004XM\u001d;jKN\u0004R![AeQ\"L1!a3p\u0005\ri\u0015\r]\u0001\u0019O\u0016$X\u000b\u001d3bi\u0016\u001cu\u000e\\;n]RK\b/Z)vKJLHc\u00025\u0002R\u0006U\u0017\u0011\u001c\u0005\u0007\u0003'\f\u0002\u0019\u00015\u0002\u0013Q\f'\r\\3OC6,\u0007BBAl#\u0001\u0007\u0001.\u0001\u0006d_2,XN\u001c(b[\u0016Da!a7\u0012\u0001\u0004A\u0017a\u00038fo\u0012\u000bG/\u0019+za\u0016\fqdZ3u+B$\u0017\r^3D_2,XN\u001c(vY2\f'-\u001b7jif\fV/\u001a:z)\u001dA\u0017\u0011]Ar\u0003KDa!a5\u0013\u0001\u0004A\u0007BBAl%\u0001\u0007\u0001\u000e\u0003\u0004\u0002hJ\u0001\raY\u0001\u000bSNtU\u000f\u001c7bE2,\u0017aC2sK\u0006$X-\u00138eKb$2\u0002[Aw\u0003c\u0014)Aa\u0007\u0003,!1\u0011q^\nA\u0002!\f\u0011\"\u001b8eKbt\u0015-\\3\t\u000f\u0005M8\u00031\u0001\u0002v\u0006QA/\u00192mK&#WM\u001c;\u0011\t\u0005](\u0011A\u0007\u0003\u0003sTA!a?\u0002~\u000691-\u0019;bY><'bAA\u0000k\u0005I1m\u001c8oK\u000e$xN]\u0005\u0005\u0005\u0007\tIP\u0001\u0006JI\u0016tG/\u001b4jKJDqAa\u0002\u0014\u0001\u0004\u0011I!A\u0004d_2,XN\\:\u0011\u000b5\u0013YAa\u0004\n\u0007\t5aJA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0003\u0012\t]QB\u0001B\n\u0015\u0011\u0011)\"!@\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0005\u00053\u0011\u0019B\u0001\bOC6,GMU3gKJ,gnY3\t\u000f\tu1\u00031\u0001\u0003 \u0005\t2m\u001c7v[:\u001c\bK]8qKJ$\u0018.Z:\u0011\u0011\t\u0005\"q\u0005B\b\u0005Si!Aa\t\u000b\u0007\t\u0015b0\u0001\u0003vi&d\u0017\u0002BAf\u0005G\u0001bA!\t\u0003(!D\u0007bBAc'\u0001\u0007!\u0011F\u0001\fS:$W\r_#ySN$8\u000fF\u0005d\u0005c\u0011)Da\u000e\u0003:!9!1\u0007\u000bA\u0002\u0005u\u0016\u0001B2p]:Da!a<\u0015\u0001\u0004A\u0007bBAz)\u0001\u0007\u0011Q\u001f\u0005\b\u0005w!\u0002\u0019\u0001B\u001f\u0003\u001dy\u0007\u000f^5p]N\u0004BAa\u0010\u0003L5\u0011!\u0011\t\u0006\u0004i\t\r#\u0002\u0002B#\u0005\u000f\n1\u0002Z1uCN|WO]2fg*\u0019!\u0011J\u001b\u0002\u0013\u0015DXmY;uS>t\u0017\u0002\u0002B'\u0005\u0003\u00121B\u0013#C\u0007>\u0003H/[8og\u0006IAM]8q\u0013:$W\r\u001f\u000b\u0006Q\nM#Q\u000b\u0005\u0007\u0003_,\u0002\u0019\u00015\t\u000f\u0005MX\u00031\u0001\u0002v\u0006!\u0002oZ!me\u0016\fG-_#ySN$8OU3hKb,\"Aa\u0017\u0011\t\tu#QM\u0007\u0003\u0005?RAA!\u0019\u0003d\u0005AQ.\u0019;dQ&twMC\u0002\u0003&9KAAa\u001a\u0003`\t)!+Z4fq\u0006)\u0002oZ!me\u0016\fG-_#ySN$8OU3hKb\u0004\u0013!E2mCN\u001c\u0018NZ=Fq\u000e,\u0007\u000f^5p]RQ!q\u000eB<\u0005\u0003\u0013)I!#\u0011\t\tE$1O\u0007\u0002k%\u0019!QO\u001b\u0003#\u0005s\u0017\r\\=tSN,\u0005pY3qi&|g\u000eC\u0004\u0003za\u0001\rAa\u001f\u0002\u0003\u0015\u00042a\u0015B?\u0013\r\u0011y(\u0018\u0002\n)\"\u0014xn^1cY\u0016DaAa!\u0019\u0001\u0004A\u0017AC3se>\u00148\t\\1tg\"9!q\u0011\rA\u0002\u0005\u001d\u0017!E7fgN\fw-\u001a)be\u0006lW\r^3sg\"1!1\u0012\rA\u0002!\f1\u0002Z3tGJL\u0007\u000f^5p]\u0006i1/\u001e9q_J$8\u000fT5nSR,\u0012aY\u0001\u000fgV\u0004\bo\u001c:ug>3gm]3u\u0003M\u0019X\u000f\u001d9peR\u001cH+\u00192mKN\u000bW\u000e\u001d7f\u000399W\r\u001e+bE2,7+Y7qY\u0016$2\u0001\u001bBM\u0011\u001d\u0011Y\n\ba\u0001\u0005;\u000baa]1na2,\u0007\u0003\u0002BP\u0005Kk!A!)\u000b\t\t\r&1I\u0001\u0003mJJAAa*\u0003\"\nyA+\u00192mKN\u000bW\u000e\u001d7f\u0013:4w.A\u0006sK:\fW.\u001a+bE2,G#\u00025\u0003.\nE\u0006b\u0002BX;\u0001\u0007\u0011Q_\u0001\t_2$G+\u00192mK\"9!1W\u000fA\u0002\u0005U\u0018\u0001\u00038foR\u000b'\r\\3\u0002?\r|gN^3si*\u000bg/\u0019+j[\u0016\u001cH/Y7q)>$\u0016.\\3ti\u0006l\u0007\u000f\u0006\u0003\u0002d\te\u0006bBA1=\u0001\u0007\u00111M\u0001\u0016G>tg/\u001a:u\u0015\u00064\u0018\rR1uKR{G)\u0019;f)\u0011\u0011yL!2\u0011\t\u0005\u0015$\u0011Y\u0005\u0005\u0005\u0007\f9G\u0001\u0003ECR,\u0007b\u0002Bd?\u0001\u0007!qX\u0001\u0002I\u0006)R\u000f\u001d3bi\u0016,\u0005\u0010\u001e:b\u0007>dW/\u001c8NKR\fGCCAZ\u0005\u001b\u0014yM!7\u0003^\"9!1\u0007\u0011A\u0002\u0005u\u0006b\u0002BiA\u0001\u0007!1[\u0001\u0005eNlG\r\u0005\u0003\u0002f\tU\u0017\u0002\u0002Bl\u0003O\u0012\u0011CU3tk2$8+\u001a;NKR\fG)\u0019;b\u0011\u001d\u0011Y\u000e\ta\u0001\u0003W\t\u0011bY8mk6t\u0017\n\u001a=\t\u000f\t}\u0007\u00051\u0001\u0002>\u0005AQ.\u001a;bI\u0006$\u0018-\u0001\u0003d_BL\u0018!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070F\u0001{\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tY#\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\t=(Q\u001f\t\u0004\u001b\nE\u0018b\u0001Bz\u001d\n\u0019\u0011I\\=\t\u0013\t]H%!AA\u0002\u0005-\u0012a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003~B1!q`B\u0001\u0005_l\u0011A^\u0005\u0004\u0007\u00071(\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2aYB\u0005\u0011%\u00119PJA\u0001\u0002\u0004\u0011y/\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,Gc\u0001>\u0004\u0010!I!q_\u0014\u0002\u0002\u0003\u0007\u00111F\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u00111F\u0001\ti>\u001cFO]5oOR\t!0\u0001\u0004fcV\fGn\u001d\u000b\u0004G\u000eu\u0001\"\u0003B|U\u0005\u0005\t\u0019\u0001Bx\u0003=\u0001vn\u001d;he\u0016\u001cH)[1mK\u000e$\bC\u0001!-'\u0015a3QEB\u0019!\u0015\u00199c!\fa\u001b\t\u0019ICC\u0002\u0004,9\u000bqA];oi&lW-\u0003\u0003\u00040\r%\"!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oaA!11GB\u001d\u001b\t\u0019)DC\u0002\u00048y\f!![8\n\u0007q\u001b)\u0004\u0006\u0002\u0004\"\u0005)\u0011\r\u001d9ms\u00069QO\\1qa2LHcA2\u0004D!A1Q\t\u0019\u0002\u0002\u0003\u0007\u0001-A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"aa\u0013\u0011\u0007m\u001ci%C\u0002\u0004Pq\u0014aa\u00142kK\u000e$\b")
public class PostgresDialect
extends JdbcDialect
implements SQLConfHelper,
NoLegacyJDBCError,
Product {
    private final Set<String> supportedAggregateFunctions;
    private final Set<String> supportedFunctions;
    private final Regex pgAlreadyExistsRegex;

    public static boolean unapply(PostgresDialect x$0) {
        return PostgresDialect$.MODULE$.unapply(x$0);
    }

    public static PostgresDialect apply() {
        return PostgresDialect$.MODULE$.apply();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:postgresql");
    }

    private Set<String> supportedAggregateFunctions() {
        return this.supportedAggregateFunctions;
    }

    private Set<String> supportedFunctions() {
        return this.supportedFunctions;
    }

    @Override
    public boolean isSupportedFunction(String funcName) {
        return this.supportedFunctions().contains((Object)funcName);
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        boolean bl = false;
        int n = 0;
        int n2 = sqlType;
        if (7 == n2) {
            return new Some((Object)FloatType$.MODULE$);
        }
        if (5 == n2) {
            return new Some((Object)ShortType$.MODULE$);
        }
        if (-7 == n2) {
            String string = typeName;
            String string2 = "bit";
            if (!(string != null ? !string.equals(string2) : string2 != null) && size != 1) {
                return new Some((Object)BinaryType$.MODULE$);
            }
        }
        if (8 == n2) {
            String string = typeName;
            String string3 = "money";
            if (!(string != null ? !string.equals(string3) : string3 != null)) {
                return new Some((Object)StringType$.MODULE$);
            }
        }
        if (93 == n2 && "timestamptz".equalsIgnoreCase(typeName) && !this.conf().legacyPostgresDatetimeMappingEnabled()) {
            return new Some((Object)TimestampType$.MODULE$);
        }
        if (92 == n2 && "timetz".equalsIgnoreCase(typeName)) {
            return new Some((Object)TimestampType$.MODULE$);
        }
        if (1 == n2 && "bpchar".equalsIgnoreCase(typeName) && size == Integer.MAX_VALUE) {
            return new Some((Object)StringType$.MODULE$);
        }
        if (1111 == n2) {
            bl = true;
            n = n2;
            if ("void".equalsIgnoreCase(typeName)) {
                return new Some((Object)NullType$.MODULE$);
            }
        }
        if (bl) {
            return new Some((Object)StringType$.MODULE$);
        }
        if ("text".equalsIgnoreCase(typeName)) {
            return new Some((Object)StringType$.MODULE$);
        }
        if (2003 == n2) {
            Option<DataType> elementType = this.toCatalystType(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(typeName), 1), size, md);
            return elementType.map((Function1 & Serializable)et -> {
                Metadata metadata = md.build();
                int dim = metadata.contains("arrayDimension") ? (int)metadata.getLong("arrayDimension") : 1;
                return (DataType)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), dim).foldLeft(et, (Function2 & Serializable)(acc, x$1) -> ArrayType$.MODULE$.apply(acc));
            });
        }
        return None$.MODULE$;
    }

    private Option<DataType> toCatalystType(String typeName, int precision, MetadataBuilder md) {
        boolean bl = false;
        String string = null;
        String string2 = typeName;
        if ("bool".equals(string2)) {
            return new Some((Object)BooleanType$.MODULE$);
        }
        if ("bit".equals(string2)) {
            bl = true;
            string = string2;
            if (precision == 1) {
                return new Some((Object)BooleanType$.MODULE$);
            }
        }
        if (bl) {
            md.putBoolean("pg_bit_array_type", true);
            return new Some((Object)BinaryType$.MODULE$);
        }
        if ("int2".equals(string2)) {
            return new Some((Object)ShortType$.MODULE$);
        }
        if ("int4".equals(string2)) {
            return new Some((Object)IntegerType$.MODULE$);
        }
        if ("int8".equals(string2) ? true : "oid".equals(string2)) {
            return new Some((Object)LongType$.MODULE$);
        }
        if ("float4".equals(string2)) {
            return new Some((Object)FloatType$.MODULE$);
        }
        if ("float8".equals(string2)) {
            return new Some((Object)DoubleType$.MODULE$);
        }
        if ("varchar".equals(string2)) {
            return new Some((Object)new VarcharType(precision));
        }
        if ("bpchar".equals(string2) && precision == Integer.MAX_VALUE) {
            return new Some((Object)StringType$.MODULE$);
        }
        if ("char".equals(string2) ? true : "bpchar".equals(string2)) {
            return new Some((Object)new CharType(precision));
        }
        if ("text".equals(string2) ? true : ("cidr".equals(string2) ? true : ("inet".equals(string2) ? true : ("json".equals(string2) ? true : ("jsonb".equals(string2) ? true : ("uuid".equals(string2) ? true : ("xml".equals(string2) ? true : ("tsvector".equals(string2) ? true : ("tsquery".equals(string2) ? true : ("macaddr".equals(string2) ? true : ("macaddr8".equals(string2) ? true : ("txid_snapshot".equals(string2) ? true : ("point".equals(string2) ? true : ("line".equals(string2) ? true : ("lseg".equals(string2) ? true : ("box".equals(string2) ? true : ("path".equals(string2) ? true : ("polygon".equals(string2) ? true : ("circle".equals(string2) ? true : ("pg_lsn".equals(string2) ? true : ("varbit".equals(string2) ? true : ("interval".equals(string2) ? true : "pg_snapshot".equals(string2))))))))))))))))))))))) {
            return new Some((Object)StringType$.MODULE$);
        }
        if ("bytea".equals(string2)) {
            return new Some((Object)BinaryType$.MODULE$);
        }
        if ("timestamptz".equals(string2) ? true : "timetz".equals(string2)) {
            return new Some((Object)TimestampType$.MODULE$);
        }
        if ("timestamp".equals(string2) ? true : "time".equals(string2)) {
            return new Some((Object)this.getTimestampType(md.build()));
        }
        if ("date".equals(string2)) {
            return new Some((Object)DateType$.MODULE$);
        }
        if (("numeric".equals(string2) ? true : "decimal".equals(string2)) && precision > 0) {
            int scale = (int)md.build().getLong("scale");
            return new Some((Object)DecimalType$.MODULE$.bounded(precision, scale));
        }
        if ("numeric".equals(string2) ? true : "decimal".equals(string2)) {
            return new Some((Object)DecimalType$.MODULE$.SYSTEM_DEFAULT());
        }
        if ("money".equals(string2)) {
            return None$.MODULE$;
        }
        return new Some((Object)StringType$.MODULE$);
    }

    @Override
    public LocalDateTime convertJavaTimestampToTimestampNTZ(Timestamp t) {
        return t.toLocalDateTime();
    }

    @Override
    public Timestamp convertTimestampNTZToJavaTimestamp(LocalDateTime ldt) {
        return Timestamp.valueOf(ldt);
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        ArrayType arrayType;
        DataType et;
        DataType dataType = dt;
        if (StringType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("TEXT", 12));
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("BYTEA", -2));
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("BOOLEAN", 16));
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("FLOAT4", 6));
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("FLOAT8", 8));
        }
        if (ShortType$.MODULE$.equals(dataType) ? true : ByteType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("SMALLINT", 5));
        }
        if (TimestampType$.MODULE$.equals(dataType) && !this.conf().legacyPostgresDatetimeMappingEnabled()) {
            return new Some((Object)new JdbcType("TIMESTAMP WITH TIME ZONE", 93));
        }
        if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            return new Some((Object)new JdbcType("NUMERIC(" + decimalType.precision() + "," + decimalType.scale() + ")", 2));
        }
        if (dataType instanceof ArrayType && ((et = (arrayType = (ArrayType)dataType).elementType()) instanceof AtomicType || et instanceof ArrayType)) {
            return this.getJDBCType(et).map((Function1 & Serializable)x$2 -> x$2.databaseTypeDefinition()).orElse((Function0 & Serializable)() -> JdbcUtils$.MODULE$.getCommonJDBCType(et).map((Function1 & Serializable)x$3 -> x$3.databaseTypeDefinition())).map((Function1 & Serializable)typeName -> new JdbcType(typeName + "[]", 2003));
        }
        return None$.MODULE$;
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public String getTruncateQuery(String table, Option<Object> cascade) {
        Some some;
        boolean bl;
        Option<Object> option = cascade;
        if (option instanceof Some && (bl = BoxesRunTime.unboxToBoolean((Object)(some = (Some)option).value()))) {
            return "TRUNCATE TABLE ONLY " + table + " CASCADE";
        }
        return "TRUNCATE TABLE ONLY " + table;
    }

    @Override
    public Option<Object> getTruncateQuery$default$2() {
        return this.isCascadingTruncateTable();
    }

    @Override
    public void beforeFetch(Connection connection, scala.collection.immutable.Map<String, String> properties) {
        super.beforeFetch(connection, properties);
        if (StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)properties.getOrElse((Object)JDBCOptions$.MODULE$.JDBC_BATCH_FETCH_SIZE(), (Function0 & Serializable)() -> "0"))) > 0) {
            connection.setAutoCommit(false);
            return;
        }
    }

    @Override
    public String getUpdateColumnTypeQuery(String tableName, String columnName, String newDataType) {
        return "ALTER TABLE " + tableName + " ALTER COLUMN " + this.quoteIdentifier(columnName) + " TYPE " + newDataType;
    }

    @Override
    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        String nullable = isNullable ? "DROP NOT NULL" : "SET NOT NULL";
        return "ALTER TABLE " + tableName + " ALTER COLUMN " + this.quoteIdentifier(columnName) + " " + nullable;
    }

    @Override
    public String createIndex(String indexName, Identifier tableIdent, NamedReference[] columns, Map<NamedReference, Map<String, String>> columnsProperties, Map<String, String> properties) {
        String indexType;
        Object indexProperties;
        String[] columnList;
        block1: {
            columnList = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])columns), (Function1 & Serializable)col -> this.quoteIdentifier((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])col.fieldNames()))), ClassTag$.MODULE$.apply(String.class));
            indexProperties = "";
            Tuple2<String, String[]> tuple2 = JdbcUtils$.MODULE$.processIndexProperties(properties, "postgresql");
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String indexType2 = (String)tuple2._1();
            String[] indexPropertyList = (String[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)indexType2, (Object)indexPropertyList);
            indexType = (String)tuple22._1();
            String[] indexPropertyList2 = (String[])tuple22._2();
            if (!ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])indexPropertyList2))) break block1;
            indexProperties = "WITH (" + Predef$.MODULE$.wrapRefArray((Object[])indexPropertyList2).mkString(", ") + ")";
        }
        return "CREATE INDEX " + this.quoteIdentifier(indexName) + " ON " + this.quoteIdentifier(tableIdent.name()) + " " + indexType + " (" + Predef$.MODULE$.wrapRefArray((Object[])columnList).mkString(", ") + ") " + (String)indexProperties;
    }

    @Override
    public boolean indexExists(Connection conn, String indexName, Identifier tableIdent, JDBCOptions options) {
        String sql = "SELECT * FROM pg_indexes WHERE tablename = '" + tableIdent.name() + "' AND indexname = '" + indexName + "'";
        return JdbcUtils$.MODULE$.checkIfIndexExists(conn, sql, options);
    }

    @Override
    public String dropIndex(String indexName, Identifier tableIdent) {
        return "DROP INDEX " + this.quoteIdentifier(indexName);
    }

    private final Regex pgAlreadyExistsRegex() {
        return this.pgAlreadyExistsRegex;
    }

    @Override
    public AnalysisException classifyException(Throwable e, String errorClass, scala.collection.immutable.Map<String, String> messageParameters, String description) {
        Throwable throwable = e;
        if (throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            String string = sQLException.getSQLState();
            switch (string == null ? 0 : string.hashCode()) {
                case 48220673: {
                    if (!"2BP01".equals(string)) break;
                    throw new NonEmptyNamespaceException((String[])Option$.MODULE$.option2Iterable(messageParameters.get((Object)"namespace")).toArray(ClassTag$.MODULE$.apply(String.class)), sQLException.getMessage(), (Option)new Some((Object)e));
                }
                case 49567037: {
                    if (!"42704".equals(string)) break;
                    String string2 = errorClass;
                    String string3 = "FAILED_JDBC.DROP_INDEX";
                    if (string2 != null ? !string2.equals(string3) : string3 != null) break;
                    String indexName = (String)messageParameters.apply((Object)"indexName");
                    String tableName = (String)messageParameters.apply((Object)"tableName");
                    throw new NoSuchIndexException(indexName, tableName, (Option)new Some((Object)e));
                }
                case 49591065: {
                    if (!"42P07".equals(string)) break;
                    String string4 = errorClass;
                    String string5 = "FAILED_JDBC.CREATE_INDEX";
                    if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                        throw new IndexAlreadyExistsException((String)messageParameters.apply((Object)"indexName"), (String)messageParameters.apply((Object)"tableName"), (Option)new Some((Object)e));
                    }
                    String string6 = errorClass;
                    String string7 = "FAILED_JDBC.RENAME_TABLE";
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        String newTable = (String)messageParameters.apply((Object)"newName");
                        throw QueryCompilationErrors$.MODULE$.tableAlreadyExistsError(newTable);
                    }
                    Option tblRegexp = this.pgAlreadyExistsRegex().findFirstMatchIn((CharSequence)sQLException.getMessage());
                    if (tblRegexp.nonEmpty()) {
                        throw QueryCompilationErrors$.MODULE$.tableAlreadyExistsError(((Regex.MatchData)tblRegexp.get()).group(1));
                    }
                    return NoLegacyJDBCError.classifyException$(this, e, errorClass, messageParameters, description);
                }
            }
            return NoLegacyJDBCError.classifyException$(this, e, errorClass, messageParameters, description);
        }
        if (throwable instanceof UnsupportedOperationException) {
            UnsupportedOperationException unsupportedOperationException = (UnsupportedOperationException)throwable;
            throw unsupportedOperationException;
        }
        return NoLegacyJDBCError.classifyException$(this, e, errorClass, messageParameters, description);
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsOffset() {
        return true;
    }

    @Override
    public boolean supportsTableSample() {
        return true;
    }

    @Override
    public String getTableSample(TableSampleInfo sample) {
        return "TABLESAMPLE BERNOULLI (" + (sample.upperBound() - sample.lowerBound()) * (double)100 + ") REPEATABLE (" + sample.seed() + ")";
    }

    @Override
    public String renameTable(Identifier oldTable, Identifier newTable) {
        if (!Predef$.MODULE$.wrapRefArray((Object[])oldTable.namespace()).sameElements((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])newTable.namespace()))) {
            throw QueryCompilationErrors$.MODULE$.cannotRenameTableAcrossSchemaError();
        }
        return "ALTER TABLE " + this.getFullyQualifiedQuotedTableName(oldTable) + " RENAME TO " + newTable.name();
    }

    @Override
    public Timestamp convertJavaTimestampToTimestamp(Timestamp t) {
        long l = t.getTime();
        if (9223372036825200000L == l) {
            return new Timestamp(LocalDateTime.of(9999, 12, 31, 23, 59, 59, 999999999).toInstant(ZoneOffset.UTC).toEpochMilli());
        }
        if (-9223372036832400000L == l) {
            return new Timestamp(LocalDateTime.of(1, 1, 1, 0, 0, 0).toInstant(ZoneOffset.UTC).toEpochMilli());
        }
        return t;
    }

    @Override
    public Date convertJavaDateToDate(Date d) {
        long l = d.getTime();
        if (9223372036825200000L == l) {
            return new Date(LocalDateTime.of(9999, 12, 31, 0, 0, 0).toInstant(ZoneOffset.UTC).toEpochMilli());
        }
        if (-9223372036832400000L == l) {
            return new Date(LocalDateTime.of(1, 1, 1, 0, 0, 0).toInstant(ZoneOffset.UTC).toEpochMilli());
        }
        return d;
    }

    @Override
    public void updateExtraColumnMeta(Connection conn, ResultSetMetaData rsmd, int columnIdx, MetadataBuilder metadata) {
        int n = rsmd.getColumnType(columnIdx);
        switch (n) {
            case 2003: {
                String tableName = rsmd.getTableName(columnIdx);
                String columnName = rsmd.getColumnName(columnIdx);
                String query = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |SELECT pg_attribute.attndims\n             |FROM pg_attribute\n             |  JOIN pg_class ON pg_attribute.attrelid = pg_class.oid\n             |  JOIN pg_namespace ON pg_class.relnamespace = pg_namespace.oid\n             |WHERE pg_class.relname = '" + tableName + "' and pg_attribute.attname = '" + columnName + "'\n             |"));
                try {
                    Using$.MODULE$.resource((Object)conn.createStatement(), (Function1 & Serializable)stmt -> Using$.MODULE$.resource((Object)stmt.executeQuery(query), (Function1 & Serializable)rs -> {
                        if (rs.next()) {
                            return metadata.putLong("arrayDimension", rs.getLong(1));
                        }
                        return BoxedUnit.UNIT;
                    }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                }
                catch (SQLException e) {
                    this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to get array dimension for column ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.COLUMN_NAME$.MODULE$, (Object)columnName)}))), (Throwable)e);
                }
                return;
            }
        }
    }

    public PostgresDialect copy() {
        return new PostgresDialect();
    }

    public String productPrefix() {
        return "PostgresDialect";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof PostgresDialect;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean equals(Object x$1) {
        Object object = x$1;
        return object instanceof PostgresDialect && ((PostgresDialect)x$1).canEqual(this);
    }

    public PostgresDialect() {
        SQLConfHelper.$init$((SQLConfHelper)this);
        NoLegacyJDBCError.$init$(this);
        Product.$init$((Product)this);
        this.supportedAggregateFunctions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"MAX", "MIN", "SUM", "COUNT", "AVG", "VAR_POP", "VAR_SAMP", "STDDEV_POP", "STDDEV_SAMP", "COVAR_POP", "COVAR_SAMP", "CORR", "REGR_INTERCEPT", "REGR_R2", "REGR_SLOPE", "REGR_SXY"}));
        this.supportedFunctions = this.supportedAggregateFunctions();
        this.pgAlreadyExistsRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(?:.*)relation \"(.*)\" already exists"));
    }
}

