/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import java.io.Serializable;
import java.util.Locale;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.fs.Path;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.api.java.function.VoidFunction2;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.ForeachWriter;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.UnresolvedIdentifier;
import org.apache.spark.sql.catalyst.analysis.UnresolvedIdentifier$;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.parser.ParserInterface;
import org.apache.spark.sql.catalyst.plans.logical.ColumnDefinition$;
import org.apache.spark.sql.catalyst.plans.logical.CreateTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.OptionList;
import org.apache.spark.sql.catalyst.plans.logical.TableSpecBase;
import org.apache.spark.sql.catalyst.plans.logical.UnresolvedTableSpec;
import org.apache.spark.sql.catalyst.streaming.InternalOutputModes$;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.connector.catalog.V1Table;
import org.apache.spark.sql.connector.catalog.V2TableWithV1Fallback;
import org.apache.spark.sql.connector.expressions.ClusterByTransform;
import org.apache.spark.sql.connector.expressions.FieldReference$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Implicits$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Utils$;
import org.apache.spark.sql.execution.datasources.v2.FileDataSourceV2;
import org.apache.spark.sql.execution.datasources.v2.python.PythonDataSourceV2;
import org.apache.spark.sql.execution.streaming.ContinuousTrigger;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.sql.execution.streaming.sources.ForeachBatchSink;
import org.apache.spark.sql.execution.streaming.sources.ForeachWriterTable;
import org.apache.spark.sql.execution.streaming.sources.ForeachWriterTable$;
import org.apache.spark.sql.execution.streaming.sources.MemoryPlan;
import org.apache.spark.sql.execution.streaming.sources.MemorySink;
import org.apache.spark.sql.streaming.DataStreamWriter$;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.util.ArrayImplicits$;
import org.apache.spark.util.Clock;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Evolving
@ScalaSignature(bytes="\u0006\u0005\u0011\u001da\u0001B+W\u0005\u0005D\u0001\"\u001b\u0001\u0003\u0002\u0003\u0006IA\u001b\u0005\u0007s\u0002!\t\u0001\u0017>\t\u000fy\u0004!\u0019!C\u0005\u007f\"A\u0011q\u0002\u0001!\u0002\u0013\t\t\u0001C\u0004\u0002\u0012\u0001!\t!a\u0005\t\u000f\u0005E\u0001\u0001\"\u0001\u0002\u001e!9\u0011q\u0007\u0001\u0005\u0002\u0005e\u0002bBA\"\u0001\u0011\u0005\u0011Q\t\u0005\b\u0003\u0013\u0002A\u0011AA&\u0011\u001d\t\t\u0006\u0001C\u0001\u0003'Bq!!\u001c\u0001\t\u0003\ty\u0007C\u0004\u0002v\u0001!\t!a\u001e\t\u000f\u0005U\u0004\u0001\"\u0001\u0002\u0002\"9\u0011Q\u000f\u0001\u0005\u0002\u00055\u0005bBA;\u0001\u0011\u0005\u0011\u0011\u0014\u0005\b\u0003K\u0003A\u0011AAT\u0011\u001d\t)\u000b\u0001C\u0001\u0003oCq!!3\u0001\t\u0003\tY\rC\u0004\u0002J\u0002!\t!a6\t\u000f\te\u0001\u0001\"\u0001\u0003\u001c!9!\u0011\b\u0001\u0005\n\tm\u0002\"\u0003B.\u0001E\u0005I\u0011\u0002B/\u0011\u001d\u0011y\u0007\u0001C\u0005\u0005cB\u0011B!-\u0001#\u0003%IAa-\t\u0013\t]\u0006!%A\u0005\n\te\u0006\"\u0003B_\u0001E\u0005I\u0011\u0002B/\u0011\u001d\u0011y\f\u0001C\u0005\u0005\u0003DqA!6\u0001\t\u0003\u00119\u000e\u0003\u0005\u0003d\u0002!\t\u0001\u0017Bs\u0011)\u0011i\u0010AI\u0001\n\u0003A&q \u0005\b\u0007\u0007\u0001A\u0011AB\u0003\u0011\u001d\u0019\u0019\u0001\u0001C\u0001\u00073Aqa!\u000f\u0001\t\u0013\u0019Y\u0004C\u0004\u0004L\u0001!Iaa\u000f\t\u000f\r5\u0003\u0001\"\u0003\u0004P!91\u0011\f\u0001\u0005\n\rm\u0003bBB1\u0001\u0011%11\r\u0005\n\u0003\u001f\u0002\u0001\u0019!C\u0005\u0003gD\u0011b!\u001a\u0001\u0001\u0004%Iaa\u001a\t\u0011\r5\u0004\u0001)Q\u0005\u0003CA\u0011Ba\b\u0001\u0001\u0004%I!a=\t\u0013\r=\u0004\u00011A\u0005\n\rE\u0004\u0002CB;\u0001\u0001\u0006K!!\t\t\u0013\u0005E\u0001\u00011A\u0005\n\r]\u0004\"CB=\u0001\u0001\u0007I\u0011BB>\u0011!\u0019y\b\u0001Q!\n\u0005]\u0001\"CA\u001c\u0001\u0001\u0007I\u0011BBA\u0011%\u0019\u0019\t\u0001a\u0001\n\u0013\u0019)\t\u0003\u0005\u0004\n\u0002\u0001\u000b\u0015BA\u001f\u0011%\u0019Y\t\u0001a\u0001\n\u0013\u0019i\tC\u0005\u0004\u0010\u0002\u0001\r\u0011\"\u0003\u0004\u0012\"A1Q\u0013\u0001!B\u0013\u0011I\tC\u0005\u0004\u0018\u0002\u0001\r\u0011\"\u0003\u0004\u001a\"I11\u0014\u0001A\u0002\u0013%1Q\u0014\u0005\t\u0007C\u0003\u0001\u0015)\u0003\u0003j\"I11\u0015\u0001A\u0002\u0013%1Q\u0015\u0005\n\u0007O\u0003\u0001\u0019!C\u0005\u0007SC\u0001b!,\u0001A\u0003&!\u0011\u001f\u0005\n\u0007_\u0003\u0001\u0019!C\u0005\u0007cC\u0011ba-\u0001\u0001\u0004%Ia!.\t\u0011\re\u0006\u0001)Q\u0005\u0007\u0017A\u0011ba/\u0001\u0001\u0004%Iaa\u000f\t\u0013\ru\u0006\u00011A\u0005\n\r}\u0006\u0002CBb\u0001\u0001\u0006Ka!\u0010\t\u0013\r\u0015\u0007\u00011A\u0005\n\rm\u0002\"CBd\u0001\u0001\u0007I\u0011BBe\u0011!\u0019i\r\u0001Q!\n\ruraBBi-\"\u000511\u001b\u0004\u0007+ZC\ta!6\t\re,E\u0011ABl\u0011%\u0019I.\u0012b\u0001\n\u0003\u0019Y\u000e\u0003\u0005\u0004b\u0016\u0003\u000b\u0011BBo\u0011%\u0019\u0019/\u0012b\u0001\n\u0003\u0019Y\u000e\u0003\u0005\u0004f\u0016\u0003\u000b\u0011BBo\u0011%\u00199/\u0012b\u0001\n\u0003\u0019Y\u000e\u0003\u0005\u0004j\u0016\u0003\u000b\u0011BBo\u0011%\u0019Y/\u0012b\u0001\n\u0003\u0019Y\u000e\u0003\u0005\u0004n\u0016\u0003\u000b\u0011BBo\u0011%\u0019y/\u0012b\u0001\n\u0003\u0019Y\u000e\u0003\u0005\u0004r\u0016\u0003\u000b\u0011BBo\u0011%\u0019\u00190\u0012b\u0001\n\u0003\u0019Y\u000e\u0003\u0005\u0004v\u0016\u0003\u000b\u0011BBo\u0011%\u001990\u0012b\u0001\n\u0003\u0019I\u0010\u0003\u0005\u0005\u0006\u0015\u0003\u000b\u0011BB~\u0005A!\u0015\r^1TiJ,\u0017-\\,sSR,'O\u0003\u0002X1\u0006I1\u000f\u001e:fC6Lgn\u001a\u0006\u00033j\u000b1a]9m\u0015\tYF,A\u0003ta\u0006\u00148N\u0003\u0002^=\u00061\u0011\r]1dQ\u0016T\u0011aX\u0001\u0004_J<7\u0001A\u000b\u0003EB\u001c\"\u0001A2\u0011\u0005\u0011<W\"A3\u000b\u0003\u0019\fQa]2bY\u0006L!\u0001[3\u0003\r\u0005s\u0017PU3g\u0003\t!7\u000fE\u0002lY:l\u0011\u0001W\u0005\u0003[b\u0013q\u0001R1uCN,G\u000f\u0005\u0002pa2\u0001A!B9\u0001\u0005\u0004\u0011(!\u0001+\u0012\u0005M4\bC\u00013u\u0013\t)XMA\u0004O_RD\u0017N\\4\u0011\u0005\u0011<\u0018B\u0001=f\u0005\r\te._\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005ml\bc\u0001?\u0001]6\ta\u000bC\u0003j\u0005\u0001\u0007!.\u0001\u0002eMV\u0011\u0011\u0011\u0001\t\u0005\u0003\u0007\tIAD\u0002l\u0003\u000bI1!a\u0002Y\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0003\u0002\u000e\tIA)\u0019;b\rJ\fW.\u001a\u0006\u0004\u0003\u000fA\u0016a\u00013gA\u0005Qq.\u001e;qkRlu\u000eZ3\u0015\u0007m\f)\u0002C\u0004\u0002\u0012\u0015\u0001\r!a\u0006\u0011\u0007q\fI\"C\u0002\u0002\u001cY\u0013!bT;uaV$Xj\u001c3f)\rY\u0018q\u0004\u0005\b\u0003#1\u0001\u0019AA\u0011!\u0011\t\u0019#!\r\u000f\t\u0005\u0015\u0012Q\u0006\t\u0004\u0003O)WBAA\u0015\u0015\r\tY\u0003Y\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005=R-\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003g\t)D\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003_)\u0017a\u0002;sS\u001e<WM\u001d\u000b\u0004w\u0006m\u0002bBA\u001c\u000f\u0001\u0007\u0011Q\b\t\u0004y\u0006}\u0012bAA!-\n9AK]5hO\u0016\u0014\u0018!C9vKJLh*Y7f)\rY\u0018q\t\u0005\b\u0003\u0007B\u0001\u0019AA\u0011\u0003\u00191wN]7biR\u001910!\u0014\t\u000f\u0005=\u0013\u00021\u0001\u0002\"\u000511o\\;sG\u0016\f1\u0002]1si&$\u0018n\u001c8CsR\u001910!\u0016\t\u000f\u0005]#\u00021\u0001\u0002Z\u0005A1m\u001c7OC6,7\u000fE\u0003e\u00037\n\t#C\u0002\u0002^\u0015\u0014!\u0002\u0010:fa\u0016\fG/\u001a3?Q\rQ\u0011\u0011\r\t\u0005\u0003G\nI'\u0004\u0002\u0002f)\u0019\u0011qM3\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002l\u0005\u0015$a\u0002<be\u0006\u0014xm]\u0001\nG2,8\u000f^3s\u0005f$2a_A9\u0011\u001d\t9f\u0003a\u0001\u00033B3aCA1\u0003\u0019y\u0007\u000f^5p]R)10!\u001f\u0002~!9\u00111\u0010\u0007A\u0002\u0005\u0005\u0012aA6fs\"9\u0011q\u0010\u0007A\u0002\u0005\u0005\u0012!\u0002<bYV,G#B>\u0002\u0004\u0006\u0015\u0005bBA>\u001b\u0001\u0007\u0011\u0011\u0005\u0005\b\u0003\u007fj\u0001\u0019AAD!\r!\u0017\u0011R\u0005\u0004\u0003\u0017+'a\u0002\"p_2,\u0017M\u001c\u000b\u0006w\u0006=\u0015\u0011\u0013\u0005\b\u0003wr\u0001\u0019AA\u0011\u0011\u001d\tyH\u0004a\u0001\u0003'\u00032\u0001ZAK\u0013\r\t9*\u001a\u0002\u0005\u0019>tw\rF\u0003|\u00037\u000bi\nC\u0004\u0002|=\u0001\r!!\t\t\u000f\u0005}t\u00021\u0001\u0002 B\u0019A-!)\n\u0007\u0005\rVM\u0001\u0004E_V\u0014G.Z\u0001\b_B$\u0018n\u001c8t)\rY\u0018\u0011\u0016\u0005\b\u0003K\u0003\u0002\u0019AAV!!\ti+a-\u0002\"\u0005\u0005RBAAX\u0015\r\t\t,Z\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA[\u0003_\u00131!T1q)\rY\u0018\u0011\u0018\u0005\b\u0003K\u000b\u0002\u0019AA^!!\ti,a2\u0002\"\u0005\u0005RBAA`\u0015\u0011\t\t-a1\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003\u000b\fAA[1wC&!\u0011QWA`\u0003\u0015\u0019H/\u0019:u)\u0011\ti-a5\u0011\u0007q\fy-C\u0002\u0002RZ\u0013ab\u0015;sK\u0006l\u0017N\\4Rk\u0016\u0014\u0018\u0010C\u0004\u0002VJ\u0001\r!!\t\u0002\tA\fG\u000f\u001b\u000b\u0003\u0003\u001bDSaEAn\u0003[\u0004R\u0001ZAo\u0003CL1!a8f\u0005\u0019!\bN]8xgB!\u00111]Au\u001b\t\t)O\u0003\u0003\u0002h\u0006}\u0016AC2p]\u000e,(O]3oi&!\u00111^As\u0005A!\u0016.\\3pkR,\u0005pY3qi&|g.M\u0004\u001f\u0003C\tyOa\u00062\u0013\r\n\t0a>\u0003\u000e\u0005eX\u0003BAz\u0003k,\"!!\t\u0005\rE\u0004'\u0019AA\u0000\u0013\u0011\tI0a?\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0015\r\ti0Z\u0001\u0007i\"\u0014xn^:\u0012\u0007M\u0014\t\u0001\u0005\u0003\u0003\u0004\t\u001dab\u00013\u0003\u0006%\u0019\u0011qA3\n\t\t%!1\u0002\u0002\n)\"\u0014xn^1cY\u0016T1!a\u0002fc%\u0019#q\u0002B\t\u0005'\tiPD\u0002e\u0005#I1!!@fc\u0015\u0011C-\u001aB\u000b\u0005\u0015\u00198-\u00197bc\r1\u0013\u0011]\u0001\bi>$\u0016M\u00197f)\u0011\tiM!\b\t\u000f\t}A\u00031\u0001\u0002\"\u0005IA/\u00192mK:\u000bW.\u001a\u0015\u0004)\t\r\u0002\u0003\u0002B\u0013\u0005Si!Aa\n\u000b\u0007\u0005\u001d$,\u0003\u0003\u0003,\t\u001d\"\u0001C#w_24\u0018N\\4)\u000bQ\tYNa\f2\u000fy\t\tC!\r\u00038EJ1%!=\u0002x\nM\u0012\u0011`\u0019\nG\t=!\u0011\u0003B\u001b\u0003{\fTA\t3f\u0005+\t4AJAq\u00035\u0019H/\u0019:u\u0013:$XM\u001d8bYR1\u0011Q\u001aB\u001f\u0005\u000bBq!!6\u0016\u0001\u0004\u0011y\u0004E\u0003e\u0005\u0003\n\t#C\u0002\u0003D\u0015\u0014aa\u00149uS>t\u0007\"\u0003B$+A\u0005\t\u0019\u0001B%\u00031\u0019\u0017\r^1m_\u001e$\u0016M\u00197f!\u0015!'\u0011\tB&!\u0011\u0011iEa\u0016\u000e\u0005\t=#\u0002\u0002B)\u0005'\nqaY1uC2|wMC\u0002\u0003Va\u000b\u0001bY1uC2L8\u000f^\u0005\u0005\u00053\u0012yE\u0001\u0007DCR\fGn\\4UC\ndW-A\fti\u0006\u0014H/\u00138uKJt\u0017\r\u001c\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!q\f\u0016\u0005\u0005\u0013\u0012\tg\u000b\u0002\u0003dA!!Q\rB6\u001b\t\u00119G\u0003\u0003\u0003j\u0005\u0015\u0014!C;oG\",7m[3e\u0013\u0011\u0011iGa\u001a\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0006ti\u0006\u0014H/U;fef$B\"!4\u0003t\t\u0015%1\u0013BL\u0005_CqA!\u001e\u0018\u0001\u0004\u00119(\u0001\u0003tS:\\\u0007\u0003\u0002B=\u0005\u0003k!Aa\u001f\u000b\t\tE#Q\u0010\u0006\u0004\u0005\u007fB\u0016!C2p]:,7\r^8s\u0013\u0011\u0011\u0019Ia\u001f\u0003\u000bQ\u000b'\r\\3\t\u000f\t\u001du\u00031\u0001\u0003\n\u0006Qa.Z<PaRLwN\\:\u0011\r\t-%qRA\u0011\u001b\t\u0011iI\u0003\u0003\u0002B\nM\u0013\u0002\u0002BI\u0005\u001b\u0013!cQ1tK&s7/\u001a8tSRLg/Z'ba\"I!QS\f\u0011\u0002\u0003\u0007\u0011qQ\u0001\u0016e\u0016\u001cwN^3s\rJ|Wn\u00115fG.\u0004x.\u001b8u\u0011%\u0011Ij\u0006I\u0001\u0002\u0004\u0011Y*A\bdCR\fGn\\4B]\u0012LE-\u001a8u!\u0015!'\u0011\tBO!\u001d!'q\u0014BR\u0005SK1A!)f\u0005\u0019!V\u000f\u001d7feA!!\u0011\u0010BS\u0013\u0011\u00119Ka\u001f\u0003\u0019Q\u000b'\r\\3DCR\fGn\\4\u0011\t\te$1V\u0005\u0005\u0005[\u0013YH\u0001\u0006JI\u0016tG/\u001b4jKJD\u0011Ba\u0012\u0018!\u0003\u0005\rA!\u0013\u0002)M$\u0018M\u001d;Rk\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011)L\u000b\u0003\u0002\b\n\u0005\u0014\u0001F:uCJ$\u0018+^3ss\u0012\"WMZ1vYR$C'\u0006\u0002\u0003<*\"!1\u0014B1\u0003Q\u0019H/\u0019:u#V,'/\u001f\u0013eK\u001a\fW\u000f\u001c;%k\u0005a1M]3bi\u00164\u0016gU5oWR!!1\u0019Bi!\u0011\u0011)M!4\u000e\u0005\t\u001d'bA,\u0003J*\u0019!1\u001a-\u0002\u0013\u0015DXmY;uS>t\u0017\u0002\u0002Bh\u0005\u000f\u0014AaU5oW\"9!1[\u000eA\u0002\t%\u0015aD8qi&|gn],ji\"\u0004\u0016\r\u001e5\u0002\u000f\u0019|'/Z1dQR\u00191P!7\t\u000f\tmG\u00041\u0001\u0003^\u00061qO]5uKJ\u0004Ba\u001bBp]&\u0019!\u0011\u001d-\u0003\u001b\u0019{'/Z1dQ^\u0013\u0018\u000e^3s\u0003U1wN]3bG\"LU\u000e\u001d7f[\u0016tG/\u0019;j_:$Ra\u001fBt\u0005WDqAa7\u001e\u0001\u0004\u0011I\u000f\u0005\u0003l\u0005?4\b\"\u0003Bw;A\u0005\t\u0019\u0001Bx\u0003\u001d)gnY8eKJ\u0004R\u0001\u001aB!\u0005c\u0004RAa=\u0003zZl!A!>\u000b\t\t](1K\u0001\tK:\u001cw\u000eZ3sg&!!1 B{\u0005E)\u0005\u0010\u001d:fgNLwN\\#oG>$WM]\u0001 M>\u0014X-Y2i\u00136\u0004H.Z7f]R\fG/[8oI\u0011,g-Y;mi\u0012\u0012TCAB\u0001U\u0011\u0011yO!\u0019\u0002\u0019\u0019|'/Z1dQ\n\u000bGo\u00195\u0015\u0007m\u001c9\u0001C\u0004\u0004\n}\u0001\raa\u0003\u0002\u0011\u0019,hn\u0019;j_:\u0004\u0002\u0002ZB\u0007U\u0006M5\u0011C\u0005\u0004\u0007\u001f)'!\u0003$v]\u000e$\u0018n\u001c83!\r!71C\u0005\u0004\u0007+)'\u0001B+oSRD3a\bB\u0012)\rY81\u0004\u0005\b\u0007\u0013\u0001\u0003\u0019AB\u000f!\u001d\u0019yb!\u000bk\u0007[i!a!\t\u000b\t\r%11\u0005\u0006\u0005\u0003\u000b\u001c)CC\u0002\u0004(i\u000b1!\u00199j\u0013\u0011\u0019Yc!\t\u0003\u001bY{\u0017\u000e\u001a$v]\u000e$\u0018n\u001c83!\u0011\u0019yc!\u000e\u000e\u0005\rE\"\u0002BB\u001a\u0003\u0007\fA\u0001\\1oO&!\u0011qSB\u0019Q\r\u0001#1E\u0001\u0012]>\u0014X.\u00197ju\u0016$\u0007+\u0019:D_2\u001cXCAB\u001f!\u0015!'\u0011IB !\u0019\u0019\tea\u0012\u0002\"9!11\tB\u0003\u001d\u0011\t9c!\u0012\n\u0003\u0019LAa!\u0013\u0003\f\t\u00191+Z9\u000219|'/\\1mSj,Gm\u00117vgR,'/\u001b8h\u0007>d7/A\u0005o_Jl\u0017\r\\5{KR1\u0011\u0011EB)\u0007+Bqaa\u0015$\u0001\u0004\t\t#\u0001\u0006d_2,XN\u001c(b[\u0016Dqaa\u0016$\u0001\u0004\t\t#\u0001\u0006d_2,XN\u001c+za\u0016\fA#Y:tKJ$hj\u001c;QCJ$\u0018\u000e^5p]\u0016$G\u0003BB\t\u0007;Bqaa\u0018%\u0001\u0004\t\t#A\u0005pa\u0016\u0014\u0018\r^5p]\u0006\tc/\u00197jI\u0006$X\rU1si&$\u0018n\u001c8j]\u001e\fe\u000eZ\"mkN$XM]5oOR\u00111\u0011C\u0001\u000bg>,(oY3`I\u0015\fH\u0003BB\t\u0007SB\u0011ba\u001b(\u0003\u0003\u0005\r!!\t\u0002\u0007a$\u0013'A\u0004t_V\u00148-\u001a\u0011\u0002\u001bQ\f'\r\\3OC6,w\fJ3r)\u0011\u0019\tba\u001d\t\u0013\r-$&!AA\u0002\u0005\u0005\u0012A\u0003;bE2,g*Y7fAU\u0011\u0011qC\u0001\u000f_V$\b/\u001e;N_\u0012,w\fJ3r)\u0011\u0019\tb! \t\u0013\r-T&!AA\u0002\u0005]\u0011aC8viB,H/T8eK\u0002*\"!!\u0010\u0002\u0017Q\u0014\u0018nZ4fe~#S-\u001d\u000b\u0005\u0007#\u00199\tC\u0005\u0004lA\n\t\u00111\u0001\u0002>\u0005AAO]5hO\u0016\u0014\b%\u0001\u0007fqR\u0014\u0018m\u00149uS>t7/\u0006\u0002\u0003\n\u0006\u0001R\r\u001f;sC>\u0003H/[8og~#S-\u001d\u000b\u0005\u0007#\u0019\u0019\nC\u0005\u0004lM\n\t\u00111\u0001\u0003\n\u0006iQ\r\u001f;sC>\u0003H/[8og\u0002\nQBZ8sK\u0006\u001c\u0007n\u0016:ji\u0016\u0014XC\u0001Bu\u0003E1wN]3bG\"<&/\u001b;fe~#S-\u001d\u000b\u0005\u0007#\u0019y\nC\u0005\u0004lY\n\t\u00111\u0001\u0003j\u0006qam\u001c:fC\u000eDwK]5uKJ\u0004\u0013\u0001\u00064pe\u0016\f7\r[,sSR,'/\u00128d_\u0012,'/\u0006\u0002\u0003r\u0006Abm\u001c:fC\u000eDwK]5uKJ,enY8eKJ|F%Z9\u0015\t\rE11\u0016\u0005\n\u0007WJ\u0014\u0011!a\u0001\u0005c\fQCZ8sK\u0006\u001c\u0007n\u0016:ji\u0016\u0014XI\\2pI\u0016\u0014\b%\u0001\ng_J,\u0017m\u00195CCR\u001c\u0007n\u0016:ji\u0016\u0014XCAB\u0006\u0003Y1wN]3bG\"\u0014\u0015\r^2i/JLG/\u001a:`I\u0015\fH\u0003BB\t\u0007oC\u0011ba\u001b=\u0003\u0003\u0005\raa\u0003\u0002'\u0019|'/Z1dQ\n\u000bGo\u00195Xe&$XM\u001d\u0011\u0002'A\f'\u000f^5uS>t\u0017N\\4D_2,XN\\:\u0002/A\f'\u000f^5uS>t\u0017N\\4D_2,XN\\:`I\u0015\fH\u0003BB\t\u0007\u0003D\u0011ba\u001b@\u0003\u0003\u0005\ra!\u0010\u0002)A\f'\u000f^5uS>t\u0017N\\4D_2,XN\\:!\u0003E\u0019G.^:uKJLgnZ\"pYVlgn]\u0001\u0016G2,8\u000f^3sS:<7i\u001c7v[:\u001cx\fJ3r)\u0011\u0019\tba3\t\u0013\r-$)!AA\u0002\ru\u0012AE2mkN$XM]5oO\u000e{G.^7og\u0002B3\u0001\u0001B\u0012\u0003A!\u0015\r^1TiJ,\u0017-\\,sSR,'\u000f\u0005\u0002}\u000bN\u0011Qi\u0019\u000b\u0003\u0007'\f!cU(V%\u000e+uLT!N\u000b~kU)T(S3V\u00111Q\u001c\t\u0005\u0007_\u0019y.\u0003\u0003\u00024\rE\u0012aE*P+J\u001bUi\u0018(B\u001b\u0016{V*R'P%f\u0003\u0013aE*P+J\u001bUi\u0018(B\u001b\u0016{fi\u0014*F\u0003\u000eC\u0015\u0001F*P+J\u001bUi\u0018(B\u001b\u0016{fi\u0014*F\u0003\u000eC\u0005%A\rT\u001fV\u00136)R0O\u00036+uLR(S\u000b\u0006\u001b\u0005j\u0018\"B)\u000eC\u0015AG*P+J\u001bUi\u0018(B\u001b\u0016{fi\u0014*F\u0003\u000eCuLQ!U\u0007\"\u0003\u0013aE*P+J\u001bUi\u0018(B\u001b\u0016{6i\u0014(T\u001f2+\u0015\u0001F*P+J\u001bUi\u0018(B\u001b\u0016{6i\u0014(T\u001f2+\u0005%A\tT\u001fV\u00136)R0O\u00036+u\fV!C\u0019\u0016\u000b!cU(V%\u000e+uLT!N\u000b~#\u0016I\u0011'FA\u0005\u00012kT+S\u0007\u0016{f*Q'F?:{u\nU\u0001\u0012'>+&kQ#`\u001d\u0006kUi\u0018(P\u001fB\u0003\u0013\u0001H*P+J\u001bUiU0B\u00192{ukX(O\u000b~#\u0016*T#`#V+%+W\u000b\u0003\u0007w\u0004ba!@\u0005\u0004\ruWBAB\u0000\u0015\u0011!\t!a,\u0002\u0013%lW.\u001e;bE2,\u0017\u0002BB%\u0007\u007f\fQdU(V%\u000e+5kX!M\u0019>;vl\u0014(F?RKU*R0R+\u0016\u0013\u0016\f\t")
public final class DataStreamWriter<T> {
    private final Dataset<T> ds;
    private final Dataset<Row> df;
    private String source;
    private String tableName;
    private OutputMode outputMode;
    private Trigger trigger;
    private CaseInsensitiveMap<String> extraOptions;
    private ForeachWriter<Object> foreachWriter;
    private ExpressionEncoder<Object> foreachWriterEncoder;
    private Function2<Dataset<T>, Object, BoxedUnit> foreachBatchWriter;
    private Option<Seq<String>> partitioningColumns;
    private Option<Seq<String>> clusteringColumns;

    public static Seq<String> SOURCES_ALLOW_ONE_TIME_QUERY() {
        return DataStreamWriter$.MODULE$.SOURCES_ALLOW_ONE_TIME_QUERY();
    }

    public static String SOURCE_NAME_NOOP() {
        return DataStreamWriter$.MODULE$.SOURCE_NAME_NOOP();
    }

    public static String SOURCE_NAME_TABLE() {
        return DataStreamWriter$.MODULE$.SOURCE_NAME_TABLE();
    }

    public static String SOURCE_NAME_CONSOLE() {
        return DataStreamWriter$.MODULE$.SOURCE_NAME_CONSOLE();
    }

    public static String SOURCE_NAME_FOREACH_BATCH() {
        return DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH_BATCH();
    }

    public static String SOURCE_NAME_FOREACH() {
        return DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH();
    }

    public static String SOURCE_NAME_MEMORY() {
        return DataStreamWriter$.MODULE$.SOURCE_NAME_MEMORY();
    }

    public DataStreamWriter<T> partitionBy(String ... colNames) {
        return this.partitionBy((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public DataStreamWriter<T> clusterBy(String ... colNames) {
        return this.clusterBy((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])colNames));
    }

    private Dataset<Row> df() {
        return this.df;
    }

    public DataStreamWriter<T> outputMode(OutputMode outputMode) {
        this.outputMode_$eq(outputMode);
        return this;
    }

    public DataStreamWriter<T> outputMode(String outputMode) {
        this.outputMode_$eq(InternalOutputModes$.MODULE$.apply(outputMode));
        return this;
    }

    public DataStreamWriter<T> trigger(Trigger trigger) {
        this.trigger_$eq(trigger);
        return this;
    }

    public DataStreamWriter<T> queryName(String queryName) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"queryName"), (Object)queryName)));
        return this;
    }

    public DataStreamWriter<T> format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataStreamWriter<T> partitionBy(Seq<String> colNames) {
        this.partitioningColumns_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames));
        this.validatePartitioningAndClustering();
        return this;
    }

    public DataStreamWriter<T> clusterBy(Seq<String> colNames) {
        this.clusteringColumns_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames));
        this.validatePartitioningAndClustering();
        return this;
    }

    public DataStreamWriter<T> option(String key, String value) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value)));
        return this;
    }

    public DataStreamWriter<T> option(String key, boolean value) {
        return this.option(key, Boolean.toString(value));
    }

    public DataStreamWriter<T> option(String key, long value) {
        return this.option(key, Long.toString(value));
    }

    public DataStreamWriter<T> option(String key, double value) {
        return this.option(key, Double.toString(value));
    }

    public DataStreamWriter<T> options(Map<String, String> options) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus(options));
        return this;
    }

    public DataStreamWriter<T> options(java.util.Map<String, String> options) {
        this.options((Map<String, String>)CollectionConverters$.MODULE$.MapHasAsScala(options).asScala());
        return this;
    }

    public StreamingQuery start(String path) {
        if (!this.df().sparkSession().sessionState().conf().legacyPathOptionBehavior() && this.extraOptions().contains("path")) {
            throw QueryCompilationErrors$.MODULE$.setPathOptionAndCallWithPathParameterError("start");
        }
        return this.startInternal((Option<String>)new Some((Object)path), this.startInternal$default$2());
    }

    public StreamingQuery start() throws TimeoutException {
        return this.startInternal((Option<String>)None$.MODULE$, this.startInternal$default$2());
    }

    @Evolving
    public StreamingQuery toTable(String tableName) throws TimeoutException {
        SupportsWrite supportsWrite;
        Table tableInstance;
        Option option;
        Seq originalMultipartIdentifier;
        this.tableName_$eq(tableName);
        ParserInterface parser = this.df().sparkSession().sessionState().sqlParser();
        Seq seq = originalMultipartIdentifier = parser.parseMultipartIdentifier(tableName);
        if (seq == null || (option = this.df().sparkSession().sessionState().analyzer().CatalogAndIdentifier().unapply(seq)).isEmpty()) {
            throw new MatchError((Object)seq);
        }
        CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option.get())._1();
        Identifier identifier = (Identifier)((Tuple2)option.get())._2();
        Tuple2 tuple2 = new Tuple2((Object)catalog, (Object)identifier);
        CatalogPlugin catalog2 = (CatalogPlugin)tuple2._1();
        Identifier identifier2 = (Identifier)tuple2._2();
        if (this.df().sparkSession().sessionState().catalog().isTempView(originalMultipartIdentifier)) {
            throw QueryCompilationErrors$.MODULE$.tempViewNotSupportStreamingWriteError(tableName);
        }
        if (!CatalogV2Implicits$.MODULE$.CatalogHelper(catalog2).asTableCatalog().tableExists(identifier2)) {
            scala.collection.immutable.Map properties = (scala.collection.immutable.Map)this.normalizedClusteringCols().map((Function1 & Serializable)cols -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceUtils$.MODULE$.CLUSTERING_COLUMNS_KEY()), (Object)DataSourceUtils$.MODULE$.encodePartitioningColumns((Seq<String>)cols))}))).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty());
            ArraySeq partitioningOrClusteringTransform = (ArraySeq)this.normalizedClusteringCols().map((Function1 & Serializable)colNames -> ArrayImplicits$.MODULE$.SparkArrayOps((Object)new ClusterByTransform[]{new ClusterByTransform((Seq)colNames.map((Function1 & Serializable)col -> FieldReference$.MODULE$.apply(col)))}).toImmutableArraySeq()).getOrElse((Function0 & Serializable)() -> ArrayImplicits$.MODULE$.SparkArrayOps((Object)CatalogV2Implicits$.MODULE$.PartitionTypeHelper((Seq)this.partitioningColumns().getOrElse((Function0 & Serializable)() -> Nil$.MODULE$)).asTransforms()).toImmutableArraySeq());
            UnresolvedTableSpec tableSpec = new UnresolvedTableSpec(properties, (Option)new Some((Object)this.source()), new OptionList((Seq)package$.MODULE$.Seq().empty()), this.extraOptions().get("path"), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
            CreateTable cmd = new CreateTable((LogicalPlan)new UnresolvedIdentifier(originalMultipartIdentifier, UnresolvedIdentifier$.MODULE$.apply$default$2()), (Seq)this.df().schema().asNullable().map((Function1 & Serializable)x$2 -> ColumnDefinition$.MODULE$.fromV1Column(x$2, parser)), (Seq)partitioningOrClusteringTransform, (TableSpecBase)tableSpec, false);
            v0 = Dataset$.MODULE$.ofRows(this.df().sparkSession(), (LogicalPlan)cmd);
        } else {
            v0 = BoxedUnit.UNIT;
        }
        Table table = tableInstance = CatalogV2Implicits$.MODULE$.CatalogHelper(catalog2).asTableCatalog().loadTable(identifier2);
        if (table instanceof SupportsWrite && DataSourceV2Implicits$.MODULE$.TableHelper((Table)(supportsWrite = (SupportsWrite)table)).supports(TableCapability.STREAMING_WRITE)) {
            SupportsWrite x$1 = supportsWrite;
            CaseInsensitiveMap<String> x$22 = this.extraOptions();
            Some x$3 = new Some((Object)new Tuple2((Object)CatalogV2Implicits$.MODULE$.CatalogHelper(catalog2).asTableCatalog(), (Object)identifier2));
            boolean x$4 = this.startQuery$default$3();
            Option<CatalogTable> x$5 = this.startQuery$default$5();
            return this.startQuery((Table)x$1, x$22, x$4, (Option<Tuple2<TableCatalog, Identifier>>)x$3, x$5);
        }
        if (table instanceof V2TableWithV1Fallback) {
            V2TableWithV1Fallback v2TableWithV1Fallback = (V2TableWithV1Fallback)table;
            return this.writeToV1Table$1(v2TableWithV1Fallback.v1Table(), tableName);
        }
        if (table instanceof V1Table) {
            V1Table v1Table = (V1Table)table;
            return this.writeToV1Table$1(v1Table.v1Table(), tableName);
        }
        throw QueryCompilationErrors$.MODULE$.tableNotSupportStreamingWriteError(tableName, table);
    }

    private StreamingQuery startInternal(Option<String> path, Option<CatalogTable> catalogTable) {
        Sink sink;
        Sink sink2;
        CaseInsensitiveMap optionsWithPath;
        String string = this.source().toLowerCase(Locale.ROOT);
        String string2 = DDLUtils$.MODULE$.HIVE_PROVIDER();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw QueryCompilationErrors$.MODULE$.cannotOperateOnHiveDataSourceFilesError("write");
        }
        String string3 = this.source();
        String string4 = DataStreamWriter$.MODULE$.SOURCE_NAME_MEMORY();
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            this.assertNotPartitioned(DataStreamWriter$.MODULE$.SOURCE_NAME_MEMORY());
            if (this.extraOptions().get("queryName").isEmpty()) {
                throw QueryCompilationErrors$.MODULE$.queryNameNotSpecifiedForMemorySinkError();
            }
            MemorySink sink3 = new MemorySink();
            Dataset<Row> resultDf = Dataset$.MODULE$.ofRows(this.df().sparkSession(), new MemoryPlan(sink3, (Seq<Attribute>)DataTypeUtils$.MODULE$.toAttributes(this.df().schema())));
            OutputMode outputMode = this.outputMode();
            OutputMode outputMode2 = OutputMode.Complete();
            boolean recoverFromCheckpoint = !(outputMode != null ? !outputMode.equals(outputMode2) : outputMode2 != null);
            MemorySink x$1 = sink3;
            CaseInsensitiveMap<String> x$2 = this.extraOptions();
            boolean x$3 = recoverFromCheckpoint;
            Option<CatalogTable> x$4 = catalogTable;
            Option<Tuple2<TableCatalog, Identifier>> x$5 = this.startQuery$default$4();
            StreamingQuery query = this.startQuery(x$1, x$2, x$3, x$5, x$4);
            resultDf.createOrReplaceTempView(query.name());
            return query;
        }
        String string5 = this.source();
        String string6 = DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH();
        if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
            ForeachWriterTable<?> sink4;
            this.assertNotPartitioned(DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH());
            ForeachWriterTable<?> x$6 = sink4 = ForeachWriterTable$.MODULE$.apply(this.foreachWriter(), this.foreachWriterEncoder());
            CaseInsensitiveMap<String> x$7 = this.extraOptions();
            Option<CatalogTable> x$8 = catalogTable;
            boolean x$9 = this.startQuery$default$3();
            Option<Tuple2<TableCatalog, Identifier>> x$10 = this.startQuery$default$4();
            return this.startQuery(x$6, x$7, x$9, x$10, x$8);
        }
        String string7 = this.source();
        String string8 = DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH_BATCH();
        if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
            ForeachBatchSink<T> sink5;
            this.assertNotPartitioned(DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH_BATCH());
            if (this.trigger() instanceof ContinuousTrigger) {
                throw QueryCompilationErrors$.MODULE$.sourceNotSupportedWithContinuousTriggerError(this.source());
            }
            ForeachBatchSink<T> x$11 = sink5 = new ForeachBatchSink<T>(this.foreachBatchWriter(), this.ds.exprEnc());
            CaseInsensitiveMap<String> x$12 = this.extraOptions();
            Option<CatalogTable> x$13 = catalogTable;
            boolean x$14 = this.startQuery$default$3();
            Option<Tuple2<TableCatalog, Identifier>> x$15 = this.startQuery$default$4();
            return this.startQuery(x$11, x$12, x$14, x$15, x$13);
        }
        Class<?> cls = DataSource$.MODULE$.lookupDataSource(this.source(), this.df().sparkSession().sessionState().conf());
        Seq disabledSources = Utils$.MODULE$.stringToSeq(this.df().sparkSession().sessionState().conf().disabledV2StreamingWriters());
        boolean useV1Source = disabledSources.contains((Object)cls.getCanonicalName()) || FileDataSourceV2.class.isAssignableFrom(cls);
        CaseInsensitiveMap caseInsensitiveMap = optionsWithPath = path.isEmpty() ? this.extraOptions() : this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), path.get()));
        if (TableProvider.class.isAssignableFrom(cls) && !useV1Source) {
            SupportsWrite supportsWrite;
            Table table;
            TableProvider provider = (TableProvider)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
            scala.collection.immutable.Map<String, String> sessionOptions = DataSourceV2Utils$.MODULE$.extractSessionConfigs(provider, this.df().sparkSession().sessionState().conf());
            scala.collection.immutable.Map finalOptions = (scala.collection.immutable.Map)((MapOps)sessionOptions.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DataStreamWriter.$anonfun$startInternal$1(optionsWithPath, x0$1)))).$plus$plus((IterableOnce)optionsWithPath.originalMap());
            CaseInsensitiveStringMap dsOptions = new CaseInsensitiveStringMap(CollectionConverters$.MODULE$.MapHasAsJava((Map)finalOptions).asJava());
            None$ outputSchema = provider.supportsExternalMetadata() ? new Some((Object)this.df().schema()) : None$.MODULE$;
            TableProvider tableProvider = provider;
            if (tableProvider instanceof PythonDataSourceV2) {
                PythonDataSourceV2 pythonDataSourceV2 = (PythonDataSourceV2)tableProvider;
                pythonDataSourceV2.setShortName(this.source());
            }
            Table table2 = table = DataSourceV2Utils$.MODULE$.getTableFromProvider(provider, dsOptions, (Option<StructType>)outputSchema);
            sink2 = table2 instanceof SupportsWrite && DataSourceV2Implicits$.MODULE$.TableHelper((Table)(supportsWrite = (SupportsWrite)table2)).supports(TableCapability.STREAMING_WRITE) ? supportsWrite : this.createV1Sink((CaseInsensitiveMap<String>)optionsWithPath);
        } else {
            sink2 = this.createV1Sink((CaseInsensitiveMap<String>)optionsWithPath);
        }
        Sink x$16 = sink = sink2;
        CaseInsensitiveMap x$17 = optionsWithPath;
        Option<CatalogTable> x$18 = catalogTable;
        boolean x$19 = this.startQuery$default$3();
        Option<Tuple2<TableCatalog, Identifier>> x$20 = this.startQuery$default$4();
        return this.startQuery(x$16, (CaseInsensitiveMap<String>)x$17, x$19, x$20, x$18);
    }

    private Option<CatalogTable> startInternal$default$2() {
        return None$.MODULE$;
    }

    private StreamingQuery startQuery(Table sink, CaseInsensitiveMap<String> newOptions, boolean recoverFromCheckpoint, Option<Tuple2<TableCatalog, Identifier>> catalogAndIdent, Option<CatalogTable> catalogTable) {
        boolean useTempCheckpointLocation = DataStreamWriter$.MODULE$.SOURCES_ALLOW_ONE_TIME_QUERY().contains((Object)this.source());
        Option x$1 = newOptions.get("queryName");
        Option x$2 = newOptions.get("checkpointLocation");
        Dataset<Row> x$3 = this.df();
        scala.collection.immutable.Map x$4 = newOptions.originalMap();
        Table x$5 = sink;
        OutputMode x$6 = this.outputMode();
        boolean x$7 = useTempCheckpointLocation;
        boolean x$8 = recoverFromCheckpoint;
        Trigger x$9 = this.trigger();
        Option<Tuple2<TableCatalog, Identifier>> x$10 = catalogAndIdent;
        Option<CatalogTable> x$11 = catalogTable;
        Clock x$12 = this.df().sparkSession().sessionState().streamingQueryManager().startQuery$default$10();
        return this.df().sparkSession().sessionState().streamingQueryManager().startQuery((Option<String>)x$1, (Option<String>)x$2, x$3, (scala.collection.immutable.Map<String, String>)x$4, x$5, x$6, x$7, x$8, x$9, x$12, x$10, x$11);
    }

    private boolean startQuery$default$3() {
        return true;
    }

    private Option<Tuple2<TableCatalog, Identifier>> startQuery$default$4() {
        return None$.MODULE$;
    }

    private Option<CatalogTable> startQuery$default$5() {
        return None$.MODULE$;
    }

    private Sink createV1Sink(CaseInsensitiveMap<String> optionsWithPath) {
        scala.collection.immutable.Map map;
        scala.collection.immutable.Map optionsWithoutClusteringKey = (scala.collection.immutable.Map)optionsWithPath.originalMap().$minus((Object)DataSourceUtils$.MODULE$.CLUSTERING_COLUMNS_KEY());
        Option<Seq<String>> option = this.normalizedClusteringCols();
        if (option instanceof Some) {
            Some some = (Some)option;
            Seq cols = (Seq)some.value();
            map = (scala.collection.immutable.Map)optionsWithoutClusteringKey.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceUtils$.MODULE$.CLUSTERING_COLUMNS_KEY()), (Object)DataSourceUtils$.MODULE$.encodePartitioningColumns((Seq<String>)cols)));
        } else if (None$.MODULE$.equals(option)) {
            map = optionsWithoutClusteringKey;
        } else {
            throw new MatchError(option);
        }
        scala.collection.immutable.Map optionsWithClusteringColumns = map;
        SparkSession x$1 = this.df().sparkSession();
        String x$2 = this.source();
        scala.collection.immutable.Map x$3 = optionsWithClusteringColumns;
        Seq x$4 = (Seq)this.normalizedParCols().getOrElse((Function0 & Serializable)() -> Nil$.MODULE$);
        Seq<String> x$5 = DataSource$.MODULE$.apply$default$3();
        Option<StructType> x$6 = DataSource$.MODULE$.apply$default$4();
        Option<BucketSpec> x$7 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$8 = DataSource$.MODULE$.apply$default$8();
        DataSource ds = new DataSource(x$1, x$2, x$5, x$6, (Seq<String>)x$4, x$7, (scala.collection.immutable.Map<String, String>)x$3, x$8);
        return ds.createSink(this.outputMode());
    }

    public DataStreamWriter<T> foreach(ForeachWriter<T> writer) {
        return this.foreachImplementation(writer, this.foreachImplementation$default$2());
    }

    public DataStreamWriter<T> foreachImplementation(ForeachWriter<Object> writer, Option<ExpressionEncoder<Object>> encoder) {
        this.source_$eq(DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH());
        if (writer == null) {
            throw new IllegalArgumentException("foreach writer cannot be null");
        }
        this.foreachWriter_$eq((ForeachWriter<Object>)((ForeachWriter)this.ds.sparkSession().sparkContext().clean(writer, this.ds.sparkSession().sparkContext().clean$default$2())));
        encoder.foreach((Function1 & Serializable)e -> {
            this.foreachWriterEncoder_$eq((ExpressionEncoder<Object>)e);
            return BoxedUnit.UNIT;
        });
        return this;
    }

    public Option<ExpressionEncoder<Object>> foreachImplementation$default$2() {
        return None$.MODULE$;
    }

    @Evolving
    public DataStreamWriter<T> foreachBatch(Function2<Dataset<T>, Object, BoxedUnit> function) {
        this.source_$eq(DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH_BATCH());
        if (function == null) {
            throw new IllegalArgumentException("foreachBatch function cannot be null");
        }
        this.foreachBatchWriter_$eq(function);
        return this;
    }

    @Evolving
    public DataStreamWriter<T> foreachBatch(VoidFunction2<Dataset<T>, Long> function) {
        return this.foreachBatch((Function2 & Serializable)(batchDs, batchId) -> {
            function.call((Object)batchDs, (Object)Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)batchId)));
            return BoxedUnit.UNIT;
        });
    }

    private Option<Seq<String>> normalizedParCols() {
        return this.partitioningColumns().map((Function1 & Serializable)cols -> (Seq)cols.map((Function1 & Serializable)x$3 -> this.normalize((String)x$3, "Partition")));
    }

    private Option<Seq<String>> normalizedClusteringCols() {
        return this.clusteringColumns().map((Function1 & Serializable)cols -> (Seq)cols.map((Function1 & Serializable)x$4 -> this.normalize((String)x$4, "Clustering")));
    }

    private String normalize(String columnName, String columnType) {
        Seq validColumnNames = (Seq)this.df().logicalPlan().output().map((Function1 & Serializable)x$5 -> x$5.name());
        return (String)validColumnNames.find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DataStreamWriter.$anonfun$normalize$2(this, columnName, x$6))).getOrElse((Function0 & Serializable)() -> {
            throw QueryCompilationErrors$.MODULE$.columnNotFoundInExistingColumnsError(columnType, columnName, validColumnNames);
        });
    }

    private void assertNotPartitioned(String operation) {
        if (this.partitioningColumns().isDefined()) {
            throw QueryCompilationErrors$.MODULE$.operationNotSupportPartitioningError(operation);
        }
    }

    private void validatePartitioningAndClustering() {
        if (this.clusteringColumns().nonEmpty() && this.partitioningColumns().nonEmpty()) {
            throw QueryCompilationErrors$.MODULE$.clusterByWithPartitionedBy();
        }
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private String tableName() {
        return this.tableName;
    }

    private void tableName_$eq(String x$1) {
        this.tableName = x$1;
    }

    private OutputMode outputMode() {
        return this.outputMode;
    }

    private void outputMode_$eq(OutputMode x$1) {
        this.outputMode = x$1;
    }

    private Trigger trigger() {
        return this.trigger;
    }

    private void trigger_$eq(Trigger x$1) {
        this.trigger = x$1;
    }

    private CaseInsensitiveMap<String> extraOptions() {
        return this.extraOptions;
    }

    private void extraOptions_$eq(CaseInsensitiveMap<String> x$1) {
        this.extraOptions = x$1;
    }

    private ForeachWriter<Object> foreachWriter() {
        return this.foreachWriter;
    }

    private void foreachWriter_$eq(ForeachWriter<Object> x$1) {
        this.foreachWriter = x$1;
    }

    private ExpressionEncoder<Object> foreachWriterEncoder() {
        return this.foreachWriterEncoder;
    }

    private void foreachWriterEncoder_$eq(ExpressionEncoder<Object> x$1) {
        this.foreachWriterEncoder = x$1;
    }

    private Function2<Dataset<T>, Object, BoxedUnit> foreachBatchWriter() {
        return this.foreachBatchWriter;
    }

    private void foreachBatchWriter_$eq(Function2<Dataset<T>, Object, BoxedUnit> x$1) {
        this.foreachBatchWriter = x$1;
    }

    private Option<Seq<String>> partitioningColumns() {
        return this.partitioningColumns;
    }

    private void partitioningColumns_$eq(Option<Seq<String>> x$1) {
        this.partitioningColumns = x$1;
    }

    private Option<Seq<String>> clusteringColumns() {
        return this.clusteringColumns;
    }

    private void clusteringColumns_$eq(Option<Seq<String>> x$1) {
        this.clusteringColumns = x$1;
    }

    private final StreamingQuery writeToV1Table$1(CatalogTable table, String tableName$1) {
        CatalogTableType catalogTableType = table.tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
            throw QueryCompilationErrors$.MODULE$.streamingIntoViewNotSupportedError(tableName$1);
        }
        Predef$.MODULE$.require(table.provider().isDefined());
        String string = this.source();
        Object object = table.provider().get();
        if (string == null ? object != null : !string.equals(object)) {
            throw QueryCompilationErrors$.MODULE$.inputSourceDiffersFromDataSourceProviderError(this.source(), tableName$1, table);
        }
        return super.startInternal((Option<String>)new Some((Object)new Path(table.location()).toString()), (Option<CatalogTable>)new Some((Object)table));
    }

    public static final /* synthetic */ boolean $anonfun$startInternal$1(CaseInsensitiveMap optionsWithPath$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            return !optionsWithPath$1.contains(k);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$normalize$2(DataStreamWriter $this, String columnName$1, String x$6) {
        return BoxesRunTime.unboxToBoolean((Object)$this.df().sparkSession().sessionState().analyzer().resolver().apply((Object)x$6, (Object)columnName$1));
    }

    public DataStreamWriter(Dataset<T> ds) {
        this.ds = ds;
        this.df = ds.toDF();
        this.source = this.df().sparkSession().sessionState().conf().defaultDataSourceName();
        this.tableName = null;
        this.outputMode = OutputMode.Append();
        this.trigger = Trigger.ProcessingTime((long)0L);
        this.extraOptions = CaseInsensitiveMap$.MODULE$.apply(Predef$.MODULE$.Map().empty());
        this.foreachWriter = null;
        this.foreachWriterEncoder = ds.exprEnc();
        this.foreachBatchWriter = null;
        this.partitioningColumns = None$.MODULE$;
        this.clusteringColumns = None$.MODULE$;
    }
}

