/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.hadoop.ParquetOutputCommitter;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.codec.CodecConfig;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.ContextUtil;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.apache.spark.SparkException;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.util.RebaseDateTime;
import org.apache.spark.sql.connector.expressions.aggregate.AggregateFunc;
import org.apache.spark.sql.connector.expressions.aggregate.Aggregation;
import org.apache.spark.sql.connector.expressions.aggregate.Count;
import org.apache.spark.sql.connector.expressions.aggregate.CountStar;
import org.apache.spark.sql.connector.expressions.aggregate.Max;
import org.apache.spark.sql.connector.expressions.aggregate.Min;
import org.apache.spark.sql.execution.datasources.AggregatePushDownUtils$;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.parquet.NoopUpdater$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOptions;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOutputWriter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetRowConverter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetUtils;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.execution.datasources.parquet.SparkShreddingUtils$;
import org.apache.spark.sql.execution.datasources.v2.V2ColumnUtils$;
import org.apache.spark.sql.internal.LegacyBehaviorPolicy$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.VariantType$;
import org.apache.spark.util.ArrayImplicits$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public final class ParquetUtils$
implements Logging {
    public static final ParquetUtils$ MODULE$ = new ParquetUtils$();
    private static final String FIELD_ID_METADATA_KEY;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        FIELD_ID_METADATA_KEY = "parquet.field.id";
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Option<StructType> inferSchema(SparkSession sparkSession, scala.collection.immutable.Map<String, String> parameters, Seq<FileStatus> files) {
        Seq seq;
        ParquetOptions parquetOptions = new ParquetOptions(parameters, sparkSession.sessionState().conf());
        boolean shouldMergeSchemas = parquetOptions.mergeSchema();
        boolean mergeRespectSummaries = sparkSession.sessionState().conf().isParquetSchemaRespectSummaries();
        ParquetUtils.FileTypes filesByType = this.splitFiles(files);
        if (shouldMergeSchemas) {
            Seq needMerged = mergeRespectSummaries ? (Seq)package$.MODULE$.Seq().empty() : filesByType.data();
            seq = (Seq)((IterableOps)needMerged.$plus$plus(filesByType.metadata())).$plus$plus(filesByType.commonMetadata());
        } else {
            seq = Option$.MODULE$.option2Iterable(filesByType.commonMetadata().headOption().orElse((Function0 & Serializable)() -> filesByType.metadata().headOption()).orElse((Function0 & Serializable)() -> filesByType.data().headOption())).toSeq();
        }
        Seq filesToTouch = seq;
        return ParquetFileFormat$.MODULE$.mergeSchemasInParallel(parameters, (Seq<FileStatus>)filesToTouch, sparkSession);
    }

    private ParquetUtils.FileTypes splitFiles(Seq<FileStatus> allFiles) {
        FileStatus[] leaves = (FileStatus[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])allFiles.toArray(ClassTag$.MODULE$.apply(FileStatus.class))), (Function1 & Serializable)x$1 -> x$1.getPath().toString(), (Ordering)Ordering.String$.MODULE$);
        return new ParquetUtils.FileTypes((Seq<FileStatus>)ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.refArrayOps((Object[])leaves), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)ParquetUtils$.MODULE$.isSummaryFile(f.getPath())))).toImmutableArraySeq(), (Seq<FileStatus>)ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])leaves), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ParquetUtils$.$anonfun$splitFiles$3(x$2)))).toImmutableArraySeq(), (Seq<FileStatus>)ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])leaves), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ParquetUtils$.$anonfun$splitFiles$4(x$3)))).toImmutableArraySeq());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isSummaryFile(Path file) {
        String string = file.getName();
        String string2 = "_common_metadata";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = file.getName();
        String string4 = "_metadata";
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public String FIELD_ID_METADATA_KEY() {
        return FIELD_ID_METADATA_KEY;
    }

    public boolean hasFieldIds(StructType schema) {
        if (schema.isEmpty()) {
            return false;
        }
        return this.recursiveCheck$1((DataType)schema);
    }

    public boolean hasFieldId(StructField field) {
        return field.metadata().contains(this.FIELD_ID_METADATA_KEY());
    }

    public int getFieldId(StructField field) {
        int n;
        Predef$.MODULE$.require(this.hasFieldId(field), (Function0 & Serializable)() -> "The key `" + MODULE$.FIELD_ID_METADATA_KEY() + "` doesn't exist in the metadata of " + field);
        try {
            n = Math.toIntExact(field.metadata().getLong(this.FIELD_ID_METADATA_KEY()));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ArithmeticException ? true : throwable2 instanceof ClassCastException) {
                throw new IllegalArgumentException("The key `" + this.FIELD_ID_METADATA_KEY() + "` must be a 32-bit integer");
            }
            throw throwable;
        }
        return n;
    }

    public boolean isBatchReadSupportedForSchema(SQLConf sqlConf, StructType schema) {
        return sqlConf.parquetVectorizedReaderEnabled() && schema.forall((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)ParquetUtils$.MODULE$.isBatchReadSupported(sqlConf, f.dataType())));
    }

    public boolean isBatchReadSupported(SQLConf sqlConf, DataType dt) {
        while (true) {
            DataType dataType;
            if ((dataType = dt) instanceof AtomicType) {
                return true;
            }
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                if (sqlConf.parquetVectorizedReaderNestedColumnEnabled()) {
                    dt = arrayType.elementType();
                    continue;
                }
                return false;
            }
            if (dataType instanceof MapType) {
                MapType mapType = (MapType)dataType;
                if (sqlConf.parquetVectorizedReaderNestedColumnEnabled() && this.isBatchReadSupported(sqlConf, mapType.keyType())) {
                    dt = mapType.valueType();
                    continue;
                }
                return false;
            }
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                return sqlConf.parquetVectorizedReaderNestedColumnEnabled() && ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])structType.fields()), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)ParquetUtils$.MODULE$.isBatchReadSupported(sqlConf, f.dataType())));
            }
            if (!(dataType instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)dataType;
            dt = userDefinedType.sqlType();
        }
        return false;
    }

    public InternalRow createAggInternalRowFromFooter(ParquetMetadata footer, String filePath, StructType dataSchema, StructType partitionSchema, Aggregation aggregation, StructType aggSchema, InternalRow partitionValues, RebaseDateTime.RebaseSpec datetimeRebaseSpec) {
        Tuple2<PrimitiveType[], Object[]> tuple2 = this.getPushedDownAggResult(footer, filePath, dataSchema, partitionSchema, aggregation);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        PrimitiveType[] primitiveTypes = (PrimitiveType[])tuple2._1();
        Object[] values = (Object[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)primitiveTypes, (Object)values);
        PrimitiveType[] primitiveTypes2 = (PrimitiveType[])tuple22._1();
        Object[] values2 = (Object[])tuple22._2();
        Types.MessageTypeBuilder builder = Types.buildMessage();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])primitiveTypes2), (Function1 & Serializable)t -> (Types.GroupBuilder)builder.addField((Type)t));
        MessageType parquetSchema = builder.named("root");
        StructType schemaWithoutGroupBy = AggregatePushDownUtils$.MODULE$.getSchemaWithoutGroupingExpression(aggSchema, aggregation);
        ParquetToSparkSchemaConverter schemaConverter = new ParquetToSparkSchemaConverter(ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$1(), ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$2(), ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$3(), ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$4(), ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$5());
        ParquetRowConverter converter = new ParquetRowConverter(schemaConverter, (GroupType)parquetSchema, schemaWithoutGroupBy, (Option<ZoneId>)None$.MODULE$, datetimeRebaseSpec, new RebaseDateTime.RebaseSpec(LegacyBehaviorPolicy$.MODULE$.CORRECTED(), RebaseDateTime.RebaseSpec$.MODULE$.apply$default$2()), NoopUpdater$.MODULE$);
        PrimitiveType.PrimitiveTypeName[] primitiveTypeNames = (PrimitiveType.PrimitiveTypeName[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])primitiveTypes2), (Function1 & Serializable)x$5 -> x$5.getPrimitiveTypeName(), ClassTag$.MODULE$.apply(PrimitiveType.PrimitiveTypeName.class));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])primitiveTypeNames))), (Function1 & Serializable)x0$1 -> {
            ParquetUtils$.$anonfun$createAggInternalRowFromFooter$3(values2, converter, primitiveTypeNames, x0$1);
            return BoxedUnit.UNIT;
        });
        if (ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])aggregation.groupByExpressions()))) {
            InternalRow reorderedPartitionValues = AggregatePushDownUtils$.MODULE$.reOrderPartitionCol(partitionSchema, aggregation, partitionValues);
            return new JoinedRow(reorderedPartitionValues, converter.currentRecord());
        }
        return converter.currentRecord();
    }

    public Tuple2<PrimitiveType[], Object[]> getPushedDownAggResult(ParquetMetadata footer, String filePath, StructType dataSchema, StructType partitionSchema, Aggregation aggregation) {
        FileMetaData footerFileMetaData = footer.getFileMetaData();
        List fields = footerFileMetaData.getSchema().getFields();
        List blocks = footer.getBlocks();
        ArrayBuilder primitiveTypeBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(PrimitiveType.class));
        ArrayBuilder valuesBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Any());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])aggregation.aggregateExpressions()), (Function1 & Serializable)agg -> {
            ObjectRef value = ObjectRef.create((Object)None$.MODULE$);
            LongRef rowCount = LongRef.create((long)0L);
            BooleanRef isCount = BooleanRef.create((boolean)false);
            IntRef index = IntRef.create((int)0);
            ObjectRef schemaName = ObjectRef.create((Object)"");
            blocks.forEach(block -> {
                Count count;
                Min min;
                Max max;
                List blockMetaData = block.getColumns();
                AggregateFunc aggregateFunc = agg;
                if (aggregateFunc instanceof Max && V2ColumnUtils$.MODULE$.extractV2Column((max = (Max)aggregateFunc).column()).isDefined()) {
                    String colName = (String)V2ColumnUtils$.MODULE$.extractV2Column(max.column()).get();
                    index$1.elem = Predef$.MODULE$.wrapRefArray((Object[])dataSchema.fieldNames()).toList().indexOf((Object)colName);
                    schemaName$1.elem = "max(" + colName + ")";
                    Object currentMax = MODULE$.getCurrentBlockMaxOrMin(filePath, blockMetaData, index$1.elem, true);
                    Object object = value$1.elem;
                    None$ none$ = None$.MODULE$;
                    if (!(object == null ? none$ != null : !object.equals(none$)) || ((Comparable)currentMax).compareTo(value$1.elem) > 0) {
                        value$1.elem = currentMax;
                        return;
                    }
                    return;
                }
                if (aggregateFunc instanceof Min && V2ColumnUtils$.MODULE$.extractV2Column((min = (Min)aggregateFunc).column()).isDefined()) {
                    String colName = (String)V2ColumnUtils$.MODULE$.extractV2Column(min.column()).get();
                    index$1.elem = Predef$.MODULE$.wrapRefArray((Object[])dataSchema.fieldNames()).toList().indexOf((Object)colName);
                    schemaName$1.elem = "min(" + colName + ")";
                    Object currentMin = MODULE$.getCurrentBlockMaxOrMin(filePath, blockMetaData, index$1.elem, false);
                    Object object = value$1.elem;
                    None$ none$ = None$.MODULE$;
                    if (!(object == null ? none$ != null : !object.equals(none$)) || ((Comparable)currentMin).compareTo(value$1.elem) < 0) {
                        value$1.elem = currentMin;
                        return;
                    }
                    return;
                }
                if (aggregateFunc instanceof Count && V2ColumnUtils$.MODULE$.extractV2Column((count = (Count)aggregateFunc).column()).isDefined()) {
                    String colName = (String)V2ColumnUtils$.MODULE$.extractV2Column(count.column()).get();
                    schemaName$1.elem = "count(" + colName + ")";
                    rowCount$1.elem += block.getRowCount();
                    boolean isPartitionCol = false;
                    if (Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields()), (Function1 & Serializable)x$6 -> x$6.name(), ClassTag$.MODULE$.apply(String.class))).toSet().contains((Object)colName)) {
                        isPartitionCol = true;
                    }
                    isCount$1.elem = true;
                    if (!isPartitionCol) {
                        index$1.elem = Predef$.MODULE$.wrapRefArray((Object[])dataSchema.fieldNames()).toList().indexOf((Object)colName);
                        rowCount$1.elem -= MODULE$.getNumNulls(filePath, blockMetaData, index$1.elem);
                        return;
                    }
                    return;
                }
                if (aggregateFunc instanceof CountStar) {
                    schemaName$1.elem = "count(*)";
                    rowCount$1.elem += block.getRowCount();
                    isCount$1.elem = true;
                    return;
                }
            });
            if (isCount.elem) {
                valuesBuilder.$plus$eq((Object)BoxesRunTime.boxToLong((long)rowCount.elem));
                return (ArrayBuilder)primitiveTypeBuilder.$plus$eq(Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).named((String)schemaName.elem));
            }
            valuesBuilder.$plus$eq(value.elem);
            Type field = (Type)fields.get(index.elem);
            return (ArrayBuilder)primitiveTypeBuilder.$plus$eq(((Types.BasePrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)field.asPrimitiveType().getPrimitiveTypeName()).as(field.getLogicalTypeAnnotation())).length(field.asPrimitiveType().getTypeLength()).named((String)schemaName.elem));
        });
        return new Tuple2(primitiveTypeBuilder.result(), valuesBuilder.result());
    }

    private Object getCurrentBlockMaxOrMin(String filePath, List<ColumnChunkMetaData> columnChunkMetaData, int i, boolean isMax) {
        Statistics statistics = columnChunkMetaData.get(i).getStatistics();
        if (!statistics.hasNonNullValue()) {
            throw new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_3172", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"filePath"), (Object)filePath), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), (Object)SQLConf$.MODULE$.PARQUET_AGGREGATE_PUSHDOWN_ENABLED().key())})));
        }
        if (isMax) {
            return statistics.genericGetMax();
        }
        return statistics.genericGetMin();
    }

    private long getNumNulls(String filePath, List<ColumnChunkMetaData> columnChunkMetaData, int i) {
        Statistics statistics = columnChunkMetaData.get(i).getStatistics();
        if (!statistics.isNumNullsSet()) {
            throw new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_3171", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"filePath"), (Object)filePath), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), (Object)SQLConf$.MODULE$.PARQUET_AGGREGATE_PUSHDOWN_ENABLED().key())})));
        }
        return statistics.getNumNulls();
    }

    private StructType replaceVariantTypes(StructType schema, StructType shreddingSchema) {
        StructField[] newFields = (StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])shreddingSchema.fields()))), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                StructField field = (StructField)tuple2._1();
                DataType dataType = field.dataType();
                if (dataType instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    StructType x$1 = MODULE$.replaceVariantTypes(structType, shreddingSchema);
                    String x$2 = field.copy$default$1();
                    boolean x$3 = field.copy$default$3();
                    Metadata x$4 = field.copy$default$4();
                    return field.copy(x$2, (DataType)x$1, x$3, x$4);
                }
                if (VariantType$.MODULE$.equals(dataType)) {
                    StructType x$5 = shreddingSchema;
                    String x$6 = field.copy$default$1();
                    boolean x$7 = field.copy$default$3();
                    Metadata x$8 = field.copy$default$4();
                    return field.copy(x$6, (DataType)x$5, x$7, x$8);
                }
                return field;
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(StructField.class));
        return new StructType(newFields);
    }

    public OutputWriterFactory prepareWrite(SQLConf sqlConf, Job job, StructType dataSchema, ParquetOptions parquetOptions) {
        None$ none$;
        Configuration conf = ContextUtil.getConfiguration((JobContext)job);
        Class committerClass = conf.getClass(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key(), ParquetOutputCommitter.class, OutputCommitter.class);
        if (conf.get(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key()) == null) {
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Using default output committer for Parquet: "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.CLASS_NAME$.MODULE$, (Object)ParquetOutputCommitter.class.getCanonicalName())})))));
        } else {
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Using user defined output committer for Parquet: "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.CLASS_NAME$.MODULE$, (Object)committerClass.getCanonicalName())})))));
        }
        conf.setClass(SQLConf$.MODULE$.OUTPUT_COMMITTER_CLASS().key(), committerClass, OutputCommitter.class);
        job.setOutputFormatClass(ParquetOutputFormat.class);
        ParquetOutputFormat.setWriteSupportClass((Job)job, ParquetWriteSupport.class);
        if (BoxesRunTime.unboxToBoolean((Object)sqlConf.getConf(SQLConf$.MODULE$.VARIANT_WRITE_SHREDDING_ENABLED())) && !((String)sqlConf.getConf(SQLConf$.MODULE$.VARIANT_FORCE_SHREDDING_SCHEMA_FOR_TEST())).isEmpty()) {
            DataType simpleShreddingSchema = DataType$.MODULE$.fromDDL((String)sqlConf.getConf(SQLConf$.MODULE$.VARIANT_FORCE_SHREDDING_SCHEMA_FOR_TEST()));
            StructType oneShreddingSchema = SparkShreddingUtils$.MODULE$.variantShreddingSchema(simpleShreddingSchema, SparkShreddingUtils$.MODULE$.variantShreddingSchema$default$2());
            StructType schemaWithMetadata = SparkShreddingUtils$.MODULE$.addWriteShreddingMetadata(oneShreddingSchema);
            none$ = new Some((Object)this.replaceVariantTypes(dataSchema, schemaWithMetadata));
        } else {
            none$ = None$.MODULE$;
        }
        None$ shreddingSchema = none$;
        ParquetWriteSupport$.MODULE$.setSchema(dataSchema, conf);
        shreddingSchema.foreach((Function1 & Serializable)x$7 -> {
            ParquetWriteSupport$.MODULE$.setShreddingSchema(x$7, conf);
            return BoxedUnit.UNIT;
        });
        conf.set(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key(), Boolean.toString(sqlConf.writeLegacyParquetFormat()));
        conf.set(SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key(), sqlConf.parquetOutputTimestampType().toString());
        conf.set(SQLConf$.MODULE$.PARQUET_FIELD_ID_WRITE_ENABLED().key(), Boolean.toString(sqlConf.parquetFieldIdWriteEnabled()));
        conf.set(SQLConf$.MODULE$.LEGACY_PARQUET_NANOS_AS_LONG().key(), Boolean.toString(sqlConf.legacyParquetNanosAsLong()));
        conf.set("parquet.compression", parquetOptions.compressionCodecClassName());
        if (conf.get("parquet.summary.metadata.level") == null && conf.get("parquet.enable.summary-metadata") == null) {
            conf.setEnum("parquet.summary.metadata.level", (Enum)ParquetOutputFormat.JobSummaryLevel.NONE);
        }
        ParquetOutputFormat.JobSummaryLevel jobSummaryLevel = ParquetOutputFormat.getJobSummaryLevel((Configuration)conf);
        ParquetOutputFormat.JobSummaryLevel jobSummaryLevel2 = ParquetOutputFormat.JobSummaryLevel.NONE;
        if ((jobSummaryLevel == null ? jobSummaryLevel2 != null : !jobSummaryLevel.equals(jobSummaryLevel2)) && !ParquetOutputCommitter.class.isAssignableFrom(committerClass)) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Committer ", " is not a "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.CLASS_NAME$.MODULE$, (Object)committerClass)})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ParquetOutputCommitter and cannot create job summaries. Set Parquet option "}))).log((Seq)Nil$.MODULE$)).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " to NONE."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.CONFIG$.MODULE$, (Object)"parquet.summary.metadata.level")})))));
        }
        return new OutputWriterFactory(){

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new ParquetOutputWriter(path, context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return CodecConfig.from((TaskAttemptContext)context).getCodec().getExtension() + ".parquet";
            }
        };
    }

    public static final /* synthetic */ boolean $anonfun$splitFiles$3(FileStatus x$2) {
        String string = x$2.getPath().getName();
        String string2 = "_metadata";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$splitFiles$4(FileStatus x$3) {
        String string = x$3.getPath().getName();
        String string2 = "_common_metadata";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$hasFieldIds$1(ParquetUtils$ $this, StructField field) {
        return MODULE$.hasFieldId(field) || $this.recursiveCheck$1(field.dataType());
    }

    private final boolean recursiveCheck$1(DataType schema) {
        block3: {
            while (true) {
                DataType dataType;
                if ((dataType = schema) instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    return structType.exists((Function1 & Serializable)field -> BoxesRunTime.boxToBoolean((boolean)ParquetUtils$.$anonfun$hasFieldIds$1(this, field)));
                }
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    schema = arrayType.elementType();
                    continue;
                }
                if (!(dataType instanceof MapType)) break block3;
                MapType mapType = (MapType)dataType;
                if (this.recursiveCheck$1(mapType.keyType())) break;
                schema = mapType.valueType();
            }
            return true;
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$createAggInternalRowFromFooter$3(Object[] values$1, ParquetRowConverter converter$1, PrimitiveType.PrimitiveTypeName[] primitiveTypeNames$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            PrimitiveType.PrimitiveTypeName primitiveTypeName = (PrimitiveType.PrimitiveTypeName)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if (PrimitiveType.PrimitiveTypeName.BOOLEAN.equals(primitiveTypeName)) {
                boolean v = BoxesRunTime.unboxToBoolean((Object)values$1[i]);
                converter$1.getConverter(i).asPrimitiveConverter().addBoolean(v);
                return;
            }
        }
        if (tuple2 != null) {
            PrimitiveType.PrimitiveTypeName primitiveTypeName = (PrimitiveType.PrimitiveTypeName)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if (PrimitiveType.PrimitiveTypeName.INT32.equals(primitiveTypeName)) {
                Integer v = (Integer)values$1[i];
                converter$1.getConverter(i).asPrimitiveConverter().addInt(Predef$.MODULE$.Integer2int(v));
                return;
            }
        }
        if (tuple2 != null) {
            PrimitiveType.PrimitiveTypeName primitiveTypeName = (PrimitiveType.PrimitiveTypeName)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if (PrimitiveType.PrimitiveTypeName.INT64.equals(primitiveTypeName)) {
                long v = BoxesRunTime.unboxToLong((Object)values$1[i]);
                converter$1.getConverter(i).asPrimitiveConverter().addLong(v);
                return;
            }
        }
        if (tuple2 != null) {
            PrimitiveType.PrimitiveTypeName primitiveTypeName = (PrimitiveType.PrimitiveTypeName)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if (PrimitiveType.PrimitiveTypeName.FLOAT.equals(primitiveTypeName)) {
                float v = BoxesRunTime.unboxToFloat((Object)values$1[i]);
                converter$1.getConverter(i).asPrimitiveConverter().addFloat(v);
                return;
            }
        }
        if (tuple2 != null) {
            PrimitiveType.PrimitiveTypeName primitiveTypeName = (PrimitiveType.PrimitiveTypeName)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if (PrimitiveType.PrimitiveTypeName.DOUBLE.equals(primitiveTypeName)) {
                double v = BoxesRunTime.unboxToDouble((Object)values$1[i]);
                converter$1.getConverter(i).asPrimitiveConverter().addDouble(v);
                return;
            }
        }
        if (tuple2 != null) {
            PrimitiveType.PrimitiveTypeName primitiveTypeName = (PrimitiveType.PrimitiveTypeName)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if (PrimitiveType.PrimitiveTypeName.BINARY.equals(primitiveTypeName)) {
                Binary v = (Binary)values$1[i];
                converter$1.getConverter(i).asPrimitiveConverter().addBinary(v);
                return;
            }
        }
        if (tuple2 != null) {
            PrimitiveType.PrimitiveTypeName primitiveTypeName = (PrimitiveType.PrimitiveTypeName)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if (PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY.equals(primitiveTypeName)) {
                Binary v = (Binary)values$1[i];
                converter$1.getConverter(i).asPrimitiveConverter().addBinary(v);
                return;
            }
        }
        if (tuple2 != null) {
            int i = tuple2._2$mcI$sp();
            throw new SparkException("Unexpected parquet type name: " + primitiveTypeNames$1[i]);
        }
        throw new MatchError((Object)tuple2);
    }

    private ParquetUtils$() {
    }
}

