/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2.state;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.execution.datasources.v2.state.StateDataSourceErrors$;
import org.apache.spark.sql.execution.datasources.v2.state.StateSourceOptions;
import org.apache.spark.sql.execution.datasources.v2.state.StateSourceOptions$;
import org.apache.spark.sql.execution.datasources.v2.state.StateSourceOptions$JoinSideValues$;
import org.apache.spark.sql.execution.datasources.v2.state.StateStoreReaderInfo;
import org.apache.spark.sql.execution.datasources.v2.state.StateTable;
import org.apache.spark.sql.execution.datasources.v2.state.StreamStreamJoinStateHelper$;
import org.apache.spark.sql.execution.datasources.v2.state.metadata.StateMetadataPartitionReader;
import org.apache.spark.sql.execution.datasources.v2.state.metadata.StateMetadataTableEntry;
import org.apache.spark.sql.execution.datasources.v2.state.utils.SchemaUtil$;
import org.apache.spark.sql.execution.streaming.OffsetSeq;
import org.apache.spark.sql.execution.streaming.OffsetSeqLog;
import org.apache.spark.sql.execution.streaming.OffsetSeqMetadata;
import org.apache.spark.sql.execution.streaming.OffsetSeqMetadata$;
import org.apache.spark.sql.execution.streaming.StreamingCheckpointConstants$;
import org.apache.spark.sql.execution.streaming.StreamingSymmetricHashJoinHelper$LeftSide$;
import org.apache.spark.sql.execution.streaming.StreamingSymmetricHashJoinHelper$RightSide$;
import org.apache.spark.sql.execution.streaming.TimerStateUtils$;
import org.apache.spark.sql.execution.streaming.TransformWithStateOperatorProperties;
import org.apache.spark.sql.execution.streaming.TransformWithStateOperatorProperties$;
import org.apache.spark.sql.execution.streaming.TransformWithStateVariableInfo;
import org.apache.spark.sql.execution.streaming.state.InMemoryStateSchemaProvider;
import org.apache.spark.sql.execution.streaming.state.KeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.NoPrefixKeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.PrefixKeyScanStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.StateSchemaCompatibilityChecker;
import org.apache.spark.sql.execution.streaming.state.StateSchemaCompatibilityChecker$;
import org.apache.spark.sql.execution.streaming.state.StateSchemaMetadata$;
import org.apache.spark.sql.execution.streaming.state.StateSchemaProvider;
import org.apache.spark.sql.execution.streaming.state.StateStore$;
import org.apache.spark.sql.execution.streaming.state.StateStoreColFamilySchema;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf$;
import org.apache.spark.sql.execution.streaming.state.StateStoreId;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderId;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.streaming.TimeMode;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005uf\u0001\u0002\t\u0012\u0001\tBQa\u0010\u0001\u0005\u0002\u0001C\u0001b\u0011\u0001\t\u0006\u0004%I\u0001\u0012\u0005\t\u0013\u0002A)\u0019!C\u0005\u0015\"A1\u000b\u0001EC\u0002\u0013%A\u000bC\u0004\\\u0001\t\u0007I\u0011\u0002/\t\r)\u0004\u0001\u0015!\u0003^\u0011\u0015Y\u0007\u0001\"\u0011m\u0011\u00159\b\u0001\"\u0011y\u0011\u001d\ty\u0003\u0001C!\u0003cAq!!\u0011\u0001\t\u0003\n\u0019\u0005C\u0004\u0002L\u0001!I!!\u0014\t\u000f\u0005-\u0004\u0001\"\u0003\u0002n!9\u0011\u0011\u0013\u0001\u0005\n\u0005M\u0005bBAM\u0001\u0011%\u00111\u0014\u0005\b\u0003K\u0003A\u0011BAT\u0005=\u0019F/\u0019;f\t\u0006$\u0018mU8ve\u000e,'B\u0001\n\u0014\u0003\u0015\u0019H/\u0019;f\u0015\t!R#\u0001\u0002we)\u0011acF\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002\u00193\u0005IQ\r_3dkRLwN\u001c\u0006\u00035m\t1a]9m\u0015\taR$A\u0003ta\u0006\u00148N\u0003\u0002\u001f?\u00051\u0011\r]1dQ\u0016T\u0011\u0001I\u0001\u0004_J<7\u0001A\n\u0006\u0001\rZ3'\u000f\t\u0003I%j\u0011!\n\u0006\u0003M\u001d\nA\u0001\\1oO*\t\u0001&\u0001\u0003kCZ\f\u0017B\u0001\u0016&\u0005\u0019y%M[3diB\u0011A&M\u0007\u0002[)\u0011afL\u0001\bG\u0006$\u0018\r\\8h\u0015\t\u0001\u0014$A\u0005d_:tWm\u0019;pe&\u0011!'\f\u0002\u000e)\u0006\u0014G.\u001a)s_ZLG-\u001a:\u0011\u0005Q:T\"A\u001b\u000b\u0005YJ\u0012aB:pkJ\u001cWm]\u0005\u0003qU\u0012!\u0003R1uCN{WO]2f%\u0016<\u0017n\u001d;feB\u0011!(P\u0007\u0002w)\u0011AhG\u0001\tS:$XM\u001d8bY&\u0011ah\u000f\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t\u0011\t\u0005\u0002C\u00015\t\u0011#A\u0004tKN\u001c\u0018n\u001c8\u0016\u0003\u0015\u0003\"AR$\u000e\u0003eI!\u0001S\r\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002\u0015!\fGm\\8q\u0007>tg-F\u0001L!\ta\u0015+D\u0001N\u0015\tqu*\u0001\u0003d_:4'B\u0001)\u001e\u0003\u0019A\u0017\rZ8pa&\u0011!+\u0014\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002)M,'/[1mSj,G\rS1e_>\u00048i\u001c8g+\u0005)\u0006C\u0001,Z\u001b\u00059&B\u0001-\u001c\u0003\u0011)H/\u001b7\n\u0005i;&!G*fe&\fG.\u001b>bE2,7i\u001c8gS\u001e,(/\u0019;j_:\fq\u0002^<t'\"|'\u000f\u001e(b[\u0016\u001cV-]\u000b\u0002;B\u0019a,Z4\u000e\u0003}S!\u0001Y1\u0002\u0013%lW.\u001e;bE2,'B\u00012d\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002I\u0006)1oY1mC&\u0011am\u0018\u0002\u0004'\u0016\f\bC\u0001\u0013i\u0013\tIWE\u0001\u0004TiJLgnZ\u0001\u0011i^\u001c8\u000b[8si:\u000bW.Z*fc\u0002\n\u0011b\u001d5peRt\u0015-\\3\u0015\u00035\u0004\"A\\;\u000f\u0005=\u001c\bC\u00019d\u001b\u0005\t(B\u0001:\"\u0003\u0019a$o\\8u}%\u0011AoY\u0001\u0007!J,G-\u001a4\n\u0005%4(B\u0001;d\u0003!9W\r\u001e+bE2,GCB=}\u0003\u0013\t\t\u0003\u0005\u0002-u&\u001110\f\u0002\u0006)\u0006\u0014G.\u001a\u0005\u0006{\"\u0001\rA`\u0001\u0007g\u000eDW-\\1\u0011\u0007}\f)!\u0004\u0002\u0002\u0002)\u0019\u00111A\r\u0002\u000bQL\b/Z:\n\t\u0005\u001d\u0011\u0011\u0001\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007bBA\u0006\u0011\u0001\u0007\u0011QB\u0001\ra\u0006\u0014H/\u001b;j_:Lgn\u001a\t\u0007\u0003\u001f\t\t\"!\u0006\u000e\u0003\rL1!a\u0005d\u0005\u0015\t%O]1z!\u0011\t9\"!\b\u000e\u0005\u0005e!bAA\u000e_\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\u0011\ty\"!\u0007\u0003\u0013Q\u0013\u0018M\\:g_Jl\u0007bBA\u0012\u0011\u0001\u0007\u0011QE\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001c\bCBA\u0014\u0003WiW.\u0004\u0002\u0002*)\u0011\u0001lJ\u0005\u0005\u0003[\tICA\u0002NCB\f1\"\u001b8gKJ\u001c6\r[3nCR\u0019a0a\r\t\u000f\u0005U\u0012\u00021\u0001\u00028\u00059q\u000e\u001d;j_:\u001c\b\u0003BA\u001d\u0003{i!!a\u000f\u000b\u0005aK\u0012\u0002BA \u0003w\u0011\u0001dQ1tK&s7/\u001a8tSRLg/Z*ue&tw-T1q\u0003a\u0019X\u000f\u001d9peR\u001cX\t\u001f;fe:\fG.T3uC\u0012\fG/\u0019\u000b\u0003\u0003\u000b\u0002B!a\u0004\u0002H%\u0019\u0011\u0011J2\u0003\u000f\t{w\u000e\\3b]\u0006\u0019\"-^5mIN#\u0018\r^3Ti>\u0014XmQ8oMR1\u0011qJA/\u0003C\u0002B!!\u0015\u0002Z5\u0011\u00111\u000b\u0006\u0004%\u0005U#bAA,/\u0005I1\u000f\u001e:fC6LgnZ\u0005\u0005\u00037\n\u0019F\u0001\bTi\u0006$Xm\u0015;pe\u0016\u001cuN\u001c4\t\r\u0005}3\u00021\u0001n\u0003I\u0019\u0007.Z2la>Lg\u000e\u001e'pG\u0006$\u0018n\u001c8\t\u000f\u0005\r4\u00021\u0001\u0002f\u00059!-\u0019;dQ&#\u0007\u0003BA\b\u0003OJ1!!\u001bd\u0005\u0011auN\\4\u0002#I,hn\u0015;bi\u00164\u0016M]\"iK\u000e\\7\u000f\u0006\u0004\u0002p\u0005U\u0014q\u0010\t\u0005\u0003\u001f\t\t(C\u0002\u0002t\r\u0014A!\u00168ji\"9\u0011q\u000f\u0007A\u0002\u0005e\u0014!D:pkJ\u001cWm\u00149uS>t7\u000fE\u0002C\u0003wJ1!! \u0012\u0005I\u0019F/\u0019;f'>,(oY3PaRLwN\\:\t\u000f\u0005\u0005E\u00021\u0001\u0002\u0004\u0006\u00112\u000f^1uKN#xN]3NKR\fG-\u0019;b!\u0019\ty!!\u0005\u0002\u0006B!\u0011qQAG\u001b\t\tIIC\u0002\u0002\fF\t\u0001\"\\3uC\u0012\fG/Y\u0005\u0005\u0003\u001f\u000bIIA\fTi\u0006$X-T3uC\u0012\fG/\u0019+bE2,WI\u001c;ss\u0006)r-\u001a;Ti\u0006$Xm\u0015;pe\u0016lU\r^1eCR\fG\u0003BAB\u0003+Cq!a&\u000e\u0001\u0004\tI(\u0001\nti\u0006$XmU8ve\u000e,w\n\u001d;j_:\u001c\u0018\u0001H4fiN#xN]3NKR\fG-\u0019;b\u0003:$'+\u001e8DQ\u0016\u001c7n\u001d\u000b\u0005\u0003;\u000b\u0019\u000bE\u0002C\u0003?K1!!)\u0012\u0005Q\u0019F/\u0019;f'R|'/\u001a*fC\u0012,'/\u00138g_\"9\u0011q\u000f\bA\u0002\u0005e\u0014AF4fi.+\u0017p\u0015;bi\u0016,enY8eKJ\u001c\u0006/Z2\u0015\r\u0005%\u0016qVA]!\u0011\t\t&a+\n\t\u00055\u00161\u000b\u0002\u0014\u0017\u0016L8\u000b^1uK\u0016s7m\u001c3feN\u0003Xm\u0019\u0005\b\u0003c{\u0001\u0019AAZ\u0003=\u0019w\u000e\u001c$b[&d\u0017pU2iK6\f\u0007\u0003BA)\u0003kKA!a.\u0002T\tI2\u000b^1uKN#xN]3D_24\u0015-\\5msN\u001b\u0007.Z7b\u0011\u001d\tYl\u0004a\u0001\u0003\u0007\u000bQb\u001d;pe\u0016lU\r^1eCR\f\u0007")
public class StateDataSource
implements TableProvider,
DataSourceRegister,
Logging {
    private SparkSession session;
    private Configuration hadoopConf;
    private SerializableConfiguration serializedHadoopConf;
    private final Seq<String> twsShortNameSeq;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Transform[] inferPartitioning(CaseInsensitiveStringMap x$1) {
        return super.inferPartitioning(x$1);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SparkSession session$lzycompute() {
        StateDataSource stateDataSource = this;
        synchronized (stateDataSource) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.session = SparkSession$.MODULE$.active();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.session;
    }

    private SparkSession session() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.session$lzycompute();
        }
        return this.session;
    }

    private Configuration hadoopConf$lzycompute() {
        StateDataSource stateDataSource = this;
        synchronized (stateDataSource) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.hadoopConf = this.session().sessionState().newHadoopConf();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.hadoopConf;
    }

    private Configuration hadoopConf() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.hadoopConf$lzycompute();
        }
        return this.hadoopConf;
    }

    private SerializableConfiguration serializedHadoopConf$lzycompute() {
        StateDataSource stateDataSource = this;
        synchronized (stateDataSource) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.serializedHadoopConf = new SerializableConfiguration(this.hadoopConf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.serializedHadoopConf;
    }

    private SerializableConfiguration serializedHadoopConf() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.serializedHadoopConf$lzycompute();
        }
        return this.serializedHadoopConf;
    }

    private Seq<String> twsShortNameSeq() {
        return this.twsShortNameSeq;
    }

    @Override
    public String shortName() {
        return "statestore";
    }

    public Table getTable(StructType schema, Transform[] partitioning2, Map<String, String> properties) {
        KeyStateEncoderSpec keyStateEncoderSpec;
        StateSourceOptions sourceOptions = StateSourceOptions$.MODULE$.apply(this.session(), this.hadoopConf(), properties);
        StateStoreConf stateConf = this.buildStateStoreConf(sourceOptions.resolvedCpLocation(), sourceOptions.batchId());
        StateStoreReaderInfo stateStoreReaderInfo = this.getStoreMetadataAndRunChecks(sourceOptions);
        if (stateStoreReaderInfo.keyStateEncoderSpecOpt().isDefined()) {
            keyStateEncoderSpec = (KeyStateEncoderSpec)stateStoreReaderInfo.keyStateEncoderSpecOpt().get();
        } else {
            StructType keySchema = (StructType)SchemaUtil$.MODULE$.getSchemaAsDataType(schema, "key");
            keyStateEncoderSpec = new NoPrefixKeyStateEncoderSpec(keySchema);
        }
        KeyStateEncoderSpec keyStateEncoderSpec2 = keyStateEncoderSpec;
        return new StateTable(this.session(), schema, sourceOptions, stateConf, keyStateEncoderSpec2, stateStoreReaderInfo.transformWithStateVariableInfoOpt(), stateStoreReaderInfo.stateStoreColFamilySchemaOpt(), stateStoreReaderInfo.stateSchemaProviderOpt());
    }

    public StructType inferSchema(CaseInsensitiveStringMap options) {
        StructType structType;
        StateSourceOptions sourceOptions = StateSourceOptions$.MODULE$.apply(this.session(), this.hadoopConf(), options);
        StateStoreReaderInfo stateStoreReaderInfo = this.getStoreMetadataAndRunChecks(sourceOptions);
        Path stateCheckpointLocation = sourceOptions.stateCheckpointLocation();
        try {
            Tuple2 tuple2;
            Enumeration.Value value = sourceOptions.joinSide();
            Enumeration.Value value2 = StateSourceOptions$JoinSideValues$.MODULE$.left();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                tuple2 = StreamStreamJoinStateHelper$.MODULE$.readKeyValueSchema(this.session(), stateCheckpointLocation.toString(), sourceOptions.operatorId(), StreamingSymmetricHashJoinHelper$LeftSide$.MODULE$, StreamStreamJoinStateHelper$.MODULE$.readKeyValueSchema$default$5());
            } else {
                Enumeration.Value value4 = StateSourceOptions$JoinSideValues$.MODULE$.right();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    tuple2 = StreamStreamJoinStateHelper$.MODULE$.readKeyValueSchema(this.session(), stateCheckpointLocation.toString(), sourceOptions.operatorId(), StreamingSymmetricHashJoinHelper$RightSide$.MODULE$, StreamStreamJoinStateHelper$.MODULE$.readKeyValueSchema$default$5());
                } else {
                    Enumeration.Value value6 = StateSourceOptions$JoinSideValues$.MODULE$.none();
                    Enumeration.Value value7 = value;
                    if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                        Predef$.MODULE$.require(stateStoreReaderInfo.stateStoreColFamilySchemaOpt().isDefined());
                        StateStoreColFamilySchema resultSchema = (StateStoreColFamilySchema)stateStoreReaderInfo.stateStoreColFamilySchemaOpt().get();
                        tuple2 = new Tuple2((Object)resultSchema.keySchema(), (Object)resultSchema.valueSchema());
                    } else {
                        throw new MatchError((Object)value);
                    }
                }
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError(tuple22);
            }
            StructType keySchema = (StructType)tuple22._1();
            StructType valueSchema = (StructType)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)keySchema, (Object)valueSchema);
            StructType keySchema2 = (StructType)tuple23._1();
            StructType valueSchema2 = (StructType)tuple23._2();
            structType = SchemaUtil$.MODULE$.getSourceSchema(sourceOptions, keySchema2, valueSchema2, stateStoreReaderInfo.transformWithStateVariableInfoOpt(), stateStoreReaderInfo.stateStoreColFamilySchemaOpt());
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                throw StateDataSourceErrors$.MODULE$.failedToReadStateSchema(sourceOptions, throwable2);
            }
            throw throwable;
        }
        return structType;
    }

    public boolean supportsExternalMetadata() {
        return false;
    }

    private StateStoreConf buildStateStoreConf(String checkpointLocation, long batchId) {
        OffsetSeqLog offsetLog = new OffsetSeqLog(this.session(), new Path(checkpointLocation, StreamingCheckpointConstants$.MODULE$.DIR_NAME_OFFSETS()).toString());
        Option option = offsetLog.get(batchId);
        if (option instanceof Some) {
            Some some = (Some)option;
            OffsetSeq value = (OffsetSeq)some.value();
            OffsetSeqMetadata metadata = (OffsetSeqMetadata)value.metadata().getOrElse((Function0 & Serializable)() -> {
                throw StateDataSourceErrors$.MODULE$.offsetMetadataLogUnavailable(batchId, checkpointLocation);
            });
            SQLConf clonedSqlConf = this.session().sessionState().conf().clone();
            OffsetSeqMetadata$.MODULE$.setSessionConf(metadata, clonedSqlConf);
            return StateStoreConf$.MODULE$.apply(clonedSqlConf);
        }
        throw StateDataSourceErrors$.MODULE$.offsetLogUnavailable(batchId, checkpointLocation);
    }

    private void runStateVarChecks(StateSourceOptions sourceOptions, StateMetadataTableEntry[] stateStoreMetadata) {
        if (sourceOptions.stateVarName().isDefined() || sourceOptions.readRegisteredTimers()) {
            Predef$.MODULE$.require(ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])stateStoreMetadata)) == 1);
            StateMetadataTableEntry opMetadata = (StateMetadataTableEntry)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])stateStoreMetadata));
            if (!this.twsShortNameSeq().contains((Object)opMetadata.operatorName())) {
                String errorMsg = "Providing state variable names is only supported with the transformWithState operator. Found operator=" + opMetadata.operatorName() + ". Please remove this option and re-run the query.";
                throw StateDataSourceErrors$.MODULE$.invalidOptionValue(StateSourceOptions$.MODULE$.STATE_VAR_NAME(), errorMsg);
            }
            String operatorProperties = opMetadata.operatorPropertiesJson();
            if (operatorProperties.isEmpty()) {
                throw StateDataSourceErrors$.MODULE$.invalidOptionValue(StateSourceOptions$.MODULE$.STATE_VAR_NAME(), "No state variable names are defined for the transformWithState operator");
            }
            TransformWithStateOperatorProperties twsOperatorProperties = TransformWithStateOperatorProperties$.MODULE$.fromJson(operatorProperties);
            String timeMode = twsOperatorProperties.timeMode();
            if (sourceOptions.readRegisteredTimers()) {
                String string = timeMode;
                String string2 = TimeMode.None().toString();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    throw StateDataSourceErrors$.MODULE$.invalidOptionValue(StateSourceOptions$.MODULE$.READ_REGISTERED_TIMERS(), "Registered timers are not available in TimeMode=None.");
                }
            }
            String stateVarName = sourceOptions.readRegisteredTimers() ? (String)TimerStateUtils$.MODULE$.getTimerStateVarNames(timeMode)._1() : (String)sourceOptions.stateVarName().get();
            List<TransformWithStateVariableInfo> stateVars = twsOperatorProperties.stateVariables();
            List stateVarInfo = stateVars.filter((Function1 & Serializable)stateVar -> BoxesRunTime.boxToBoolean((boolean)StateDataSource.$anonfun$runStateVarChecks$1(stateVarName, stateVar)));
            if (stateVarInfo.size() != 1) {
                throw StateDataSourceErrors$.MODULE$.invalidOptionValue(StateSourceOptions$.MODULE$.STATE_VAR_NAME(), "State variable " + stateVarName + " is not defined for the transformWithState operator.");
            }
            return;
        }
        if (ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])stateStoreMetadata)) == 1 && this.twsShortNameSeq().contains((Object)((StateMetadataTableEntry)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])stateStoreMetadata))).operatorName())) {
            throw StateDataSourceErrors$.MODULE$.requiredOptionUnspecified("stateVarName");
        }
    }

    private StateMetadataTableEntry[] getStateStoreMetadata(StateSourceOptions stateSourceOptions) {
        StateMetadataTableEntry[] allStateStoreMetadata = (StateMetadataTableEntry[])new StateMetadataPartitionReader(stateSourceOptions.stateCheckpointLocation().getParent().toString(), this.serializedHadoopConf(), stateSourceOptions.batchId()).stateMetadata().toArray(ClassTag$.MODULE$.apply(StateMetadataTableEntry.class));
        StateMetadataTableEntry[] stateStoreMetadata = (StateMetadataTableEntry[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])allStateStoreMetadata), (Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)StateDataSource.$anonfun$getStateStoreMetadata$1(stateSourceOptions, entry)));
        return stateStoreMetadata;
    }

    /*
     * Unable to fully structure code
     */
    private StateStoreReaderInfo getStoreMetadataAndRunChecks(StateSourceOptions sourceOptions) {
        block6: {
            storeMetadata = this.getStateStoreMetadata(sourceOptions);
            this.runStateVarChecks(sourceOptions, storeMetadata);
            keyStateEncoderSpecOpt = None$.MODULE$;
            stateStoreColFamilySchemaOpt = None$.MODULE$;
            transformWithStateVariableInfoOpt = None$.MODULE$;
            stateSchemaProvider = None$.MODULE$;
            timeMode = TimeMode.None().toString();
            v0 = sourceOptions.joinSide();
            var9_8 = StateSourceOptions$JoinSideValues$.MODULE$.none();
            if (v0 != null ? v0.equals(var9_8) == false : var9_8 != null) break block6;
            stateVarName = ObjectRef.create((Object)((String)sourceOptions.stateVarName().getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$getStoreMetadataAndRunChecks$1(), ()Ljava/lang/String;)())));
            if (storeMetadata.length <= 0 || ((StateMetadataTableEntry)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])storeMetadata))).version() != 2) ** GOTO lbl-1000
            var12_10 = ((StateMetadataTableEntry)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])storeMetadata))).operatorName();
            if (this.twsShortNameSeq().exists((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$getStoreMetadataAndRunChecks$2$adapted(java.lang.String java.lang.CharSequence ), (Ljava/lang/CharSequence;)Ljava/lang/Object;)((String)var12_10))) {
                storeMetadataEntry = (StateMetadataTableEntry)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])storeMetadata));
                operatorProperties = TransformWithStateOperatorProperties$.MODULE$.fromJson(storeMetadataEntry.operatorPropertiesJson());
                timeMode = operatorProperties.timeMode();
                if (sourceOptions.readRegisteredTimers()) {
                    stateVarName.elem = (String)TimerStateUtils$.MODULE$.getTimerStateVarNames(timeMode)._1();
                }
                Predef$.MODULE$.require((stateVarInfoList = operatorProperties.stateVariables().filter((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$getStoreMetadataAndRunChecks$3$adapted(scala.runtime.ObjectRef org.apache.spark.sql.execution.streaming.TransformWithStateVariableInfo ), (Lorg/apache/spark/sql/execution/streaming/TransformWithStateVariableInfo;)Ljava/lang/Object;)((ObjectRef)stateVarName))).size() == 1, (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$getStoreMetadataAndRunChecks$4(scala.runtime.ObjectRef org.apache.spark.sql.execution.datasources.v2.state.StateSourceOptions ), ()Ljava/lang/String;)((ObjectRef)stateVarName, (StateSourceOptions)sourceOptions));
                stateVarInfo = (TransformWithStateVariableInfo)stateVarInfoList.head();
                transformWithStateVariableInfoOpt = new Some((Object)stateVarInfo);
                schemaFilePaths = storeMetadataEntry.stateSchemaFilePaths();
                stateSchemaMetadata = StateSchemaMetadata$.MODULE$.createStateSchemaMetadata(sourceOptions.stateCheckpointLocation().toString(), this.hadoopConf(), schemaFilePaths);
                stateSchemaProvider = new Some((Object)new InMemoryStateSchemaProvider(stateSchemaMetadata));
                v1 = schemaFilePaths.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$getStoreMetadataAndRunChecks$5(java.lang.String ), (Ljava/lang/String;)Lorg/apache/hadoop/fs/Path;)());
            } else lbl-1000:
            // 2 sources

            {
                v1 = None$.MODULE$.toList();
            }
            oldSchemaFilePaths = v1;
            try {
                partitionId = StateStore$.MODULE$.PARTITION_ID_TO_CHECK_SCHEMA();
                stateCheckpointLocation = sourceOptions.stateCheckpointLocation();
                storeId = new StateStoreId(stateCheckpointLocation.toString(), sourceOptions.operatorId(), partitionId, sourceOptions.storeName());
                providerId = new StateStoreProviderId(storeId, UUID.randomUUID());
                manager = new StateSchemaCompatibilityChecker(providerId, this.hadoopConf(), (List<Path>)oldSchemaFilePaths, StateSchemaCompatibilityChecker$.MODULE$.$lessinit$greater$default$4());
                stateSchema = manager.readSchemaFile();
                resultSchema = (StateStoreColFamilySchema)stateSchema.filter((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$getStoreMetadataAndRunChecks$6$adapted(scala.runtime.ObjectRef org.apache.spark.sql.execution.streaming.state.StateStoreColFamilySchema ), (Lorg/apache/spark/sql/execution/streaming/state/StateStoreColFamilySchema;)Ljava/lang/Object;)((ObjectRef)stateVarName)).head();
                keyStateEncoderSpecOpt = new Some((Object)this.getKeyStateEncoderSpec(resultSchema, storeMetadata));
                stateStoreColFamilySchemaOpt = new Some((Object)resultSchema);
            }
            catch (Throwable var26_25) {
                var27_26 = var26_25;
                if (var27_26 != null && NonFatal$.MODULE$.apply(var28_27 = var27_26)) {
                    throw StateDataSourceErrors$.MODULE$.failedToReadStateSchema(sourceOptions, var28_27);
                }
                throw var26_25;
            }
        }
        return new StateStoreReaderInfo((Option<KeyStateEncoderSpec>)keyStateEncoderSpecOpt, (Option<StateStoreColFamilySchema>)stateStoreColFamilySchemaOpt, (Option<TransformWithStateVariableInfo>)transformWithStateVariableInfoOpt, (Option<StateSchemaProvider>)stateSchemaProvider);
    }

    private KeyStateEncoderSpec getKeyStateEncoderSpec(StateStoreColFamilySchema colFamilySchema, StateMetadataTableEntry[] storeMetadata) {
        KeyStateEncoderSpec keyStateEncoderSpec;
        if (storeMetadata.length == 0) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Metadata for state store not found, possible cause is this checkpoint is created by older version of spark. If the query has session window aggregation, the state can't be read correctly and runtime exception will be thrown. Run the streaming query in newer spark version to generate state metadata can fix the issue.");
            keyStateEncoderSpec = new NoPrefixKeyStateEncoderSpec(colFamilySchema.keySchema());
        } else {
            Predef$.MODULE$.require(storeMetadata.length == 1);
            StateMetadataTableEntry storeMetadataEntry = (StateMetadataTableEntry)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])storeMetadata));
            if (storeMetadataEntry.version() == 1 && storeMetadataEntry.numColsPrefixKey() == 0) {
                keyStateEncoderSpec = new NoPrefixKeyStateEncoderSpec(colFamilySchema.keySchema());
            } else if (storeMetadataEntry.version() == 1 && storeMetadataEntry.numColsPrefixKey() > 0) {
                keyStateEncoderSpec = new PrefixKeyScanStateEncoderSpec(colFamilySchema.keySchema(), storeMetadataEntry.numColsPrefixKey());
            } else if (storeMetadataEntry.version() == 2) {
                Predef$.MODULE$.require(colFamilySchema.keyStateEncoderSpec().isDefined());
                keyStateEncoderSpec = (KeyStateEncoderSpec)colFamilySchema.keyStateEncoderSpec().get();
            } else {
                throw StateDataSourceErrors$.MODULE$.internalError("Failed to read key state encoder spec for operator=" + storeMetadataEntry.operatorId());
            }
        }
        NoPrefixKeyStateEncoderSpec keyStateEncoderSpec2 = keyStateEncoderSpec;
        return keyStateEncoderSpec2;
    }

    public static final /* synthetic */ boolean $anonfun$runStateVarChecks$1(String stateVarName$1, TransformWithStateVariableInfo stateVar) {
        String string = stateVar.stateName();
        String string2 = stateVarName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$getStateStoreMetadata$1(StateSourceOptions stateSourceOptions$1, StateMetadataTableEntry entry) {
        if (entry.operatorId() != (long)stateSourceOptions$1.operatorId()) return false;
        String string = entry.stateStoreName();
        String string2 = stateSourceOptions$1.storeName();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public static final /* synthetic */ String $anonfun$getStoreMetadataAndRunChecks$1() {
        return StateStore$.MODULE$.DEFAULT_COL_FAMILY_NAME();
    }

    public static final /* synthetic */ boolean $anonfun$getStoreMetadataAndRunChecks$3(ObjectRef stateVarName$2, TransformWithStateVariableInfo stateVar) {
        String string = stateVar.stateName();
        String string2 = (String)stateVarName$2.elem;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ String $anonfun$getStoreMetadataAndRunChecks$4(ObjectRef stateVarName$2, StateSourceOptions sourceOptions$1) {
        return "Failed to find unique state variable info for state variable " + (String)stateVarName$2.elem + " in operator " + sourceOptions$1.operatorId();
    }

    public static final /* synthetic */ Path $anonfun$getStoreMetadataAndRunChecks$5(String x$2) {
        return new Path(x$2);
    }

    public static final /* synthetic */ boolean $anonfun$getStoreMetadataAndRunChecks$6(ObjectRef stateVarName$2, StateStoreColFamilySchema x$3) {
        String string = x$3.colFamilyName();
        String string2 = (String)stateVarName$2.elem;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public StateDataSource() {
        Logging.$init$((Logging)this);
        this.twsShortNameSeq = new .colon.colon((Object)"transformWithStateExec", (List)new .colon.colon((Object)"transformWithStateInPandasExec", (List)Nil$.MODULE$));
    }

    public static final /* synthetic */ Object $anonfun$getStoreMetadataAndRunChecks$2$adapted(String eta$0$1$1, CharSequence x$1) {
        return BoxesRunTime.boxToBoolean((boolean)eta$0$1$1.contains(x$1));
    }

    public static final /* synthetic */ Object $anonfun$getStoreMetadataAndRunChecks$3$adapted(ObjectRef stateVarName$2, TransformWithStateVariableInfo stateVar) {
        return BoxesRunTime.boxToBoolean((boolean)StateDataSource.$anonfun$getStoreMetadataAndRunChecks$3(stateVarName$2, stateVar));
    }

    public static final /* synthetic */ Object $anonfun$getStoreMetadataAndRunChecks$6$adapted(ObjectRef stateVarName$2, StateStoreColFamilySchema x$3) {
        return BoxesRunTime.boxToBoolean((boolean)StateDataSource.$anonfun$getStoreMetadataAndRunChecks$6(stateVarName$2, x$3));
    }
}

