/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.runtime;

import java.io.Serializable;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.connector.read.streaming.MicroBatchStream;
import org.apache.spark.sql.connector.read.streaming.ReadLimit;
import org.apache.spark.sql.connector.read.streaming.SupportsTriggerAvailableNow;
import org.apache.spark.sql.execution.streaming.Offset;
import org.apache.spark.sql.execution.streaming.runtime.LongOffset;
import org.apache.spark.sql.execution.streaming.runtime.MemoryStream$;
import org.apache.spark.sql.execution.streaming.runtime.MemoryStreamBase;
import org.apache.spark.sql.execution.streaming.runtime.MemoryStreamInputPartition;
import org.apache.spark.sql.execution.streaming.runtime.MemoryStreamReaderFactory$;
import org.apache.spark.sql.internal.SQLConf$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\r-v!B\"E\u0011\u0003\u0019f!B+E\u0011\u00031\u0006\"B3\u0002\t\u00031\u0007bB4\u0002\u0005\u0004%\t\u0002\u001b\u0005\u0007g\u0006\u0001\u000b\u0011B5\t\u000fQ\f!\u0019!C\tQ\"1Q/\u0001Q\u0001\n%DQA^\u0001\u0005\u0002]DaA^\u0001\u0005\u0002\rE\u0003\u0002\u0003<\u0002\u0003\u0003%\tia\u001a\t\u0013\ru\u0014!%A\u0005\u0002\r}\u0004\"CBB\u0003\u0005\u0005I\u0011QBC\u0011%\u0019Y*AI\u0001\n\u0003\u0019i\nC\u0005\u0004\"\u0006\t\t\u0011\"\u0003\u0004$\u001a!Q\u000b\u0012!{\u0011)\t)F\u0004BK\u0002\u0013\u0005\u0011q\u000b\u0005\u000b\u0003?r!\u0011#Q\u0001\n\u0005e\u0003BCA1\u001d\tU\r\u0011\"\u0001\u0002d!Q\u0011Q\u000e\b\u0003\u0012\u0003\u0006I!!\u001a\t\u0015\u0005=dB!f\u0001\n\u0003\t\t\b\u0003\u0006\u0002z9\u0011\t\u0012)A\u0005\u0003gB!\"a\u001f\u000f\u0005\u0007\u0005\u000b1BA?\u0011\u0019)g\u0002\"\u0001\u0002\u0004\"I\u0011\u0011\u0013\bC\u0002\u0013E\u00111\u0013\u0005\t\u0003Ws\u0001\u0015!\u0003\u0002\u0016\"I\u0011Q\u0016\bC\u0002\u0013E\u0011q\u0016\u0005\t\u0003\u001bt\u0001\u0015!\u0003\u00022\"I\u0011\u0011\u001e\bA\u0002\u0013E\u00111\u001e\u0005\n\u0003gt\u0001\u0019!C\t\u0003kD\u0001B!\u0001\u000fA\u0003&\u0011Q\u001e\u0005\n\u0005\u000bq\u0001\u0019!C\t\u0003WD\u0011Ba\u0002\u000f\u0001\u0004%\tB!\u0003\t\u0011\t5a\u0002)Q\u0005\u0003[D\u0011B!\u0005\u000f\u0001\u0004%I!a;\t\u0013\tMa\u00021A\u0005\n\tU\u0001\u0002\u0003B\r\u001d\u0001\u0006K!!<\t\u0017\tua\u00021AA\u0002\u0013%!q\u0004\u0005\f\u0005Oq\u0001\u0019!a\u0001\n\u0013\u0011I\u0003C\u0006\u0003.9\u0001\r\u0011!Q!\n\t\u0005\u0002\"\u0003B\u0019\u001d\u0001\u0007I\u0011CAv\u0011%\u0011\u0019D\u0004a\u0001\n#\u0011)\u0004\u0003\u0005\u0003:9\u0001\u000b\u0015BAw\u0011\u001d\u0011iD\u0004C\u0001\u0005\u007fAqA!\u0015\u000f\t\u0003\u0012\u0019\u0006C\u0004\u0003f9!\tEa\u001a\t\u000f\t5d\u0002\"\u0011\u0003p!9!\u0011\u000f\b\u0005B\tM\u0004b\u0002B;\u001d\u0011\u0005#q\u000e\u0005\b\u0005krA\u0011\tB<\u0011\u001d\u0011)I\u0004C!\u0005\u000fCqAa'\u000f\t\u0003\u0012i\nC\u0004\u0003&:!IAa*\t\u000f\t]f\u0002\"\u0011\u0003:\"9!Q\u0018\b\u0005B\tM\u0004b\u0002B`\u001d\u0011\u0005!1\u000f\u0005\n\u0005\u0003t\u0011\u0011!C\u0001\u0005\u0007D\u0011B!7\u000f#\u0003%\tAa7\t\u0013\tMh\"%A\u0005\u0002\tU\b\"\u0003B\u007f\u001dE\u0005I\u0011\u0001B\u0000\u0011%\u00199ADA\u0001\n\u0003\u001aI\u0001C\u0005\u0004\u00169\t\t\u0011\"\u0001\u0002X!I1q\u0003\b\u0002\u0002\u0013\u00051\u0011\u0004\u0005\n\u0007;q\u0011\u0011!C!\u0007?A\u0011b!\u000b\u000f\u0003\u0003%\taa\u000b\t\u0013\rUb\"!A\u0005B\r]\u0002\"CB\u001e\u001d\u0005\u0005I\u0011IB\u001f\u0011%\u0019yDDA\u0001\n\u0003\u001a\t%\u0001\u0007NK6|'/_*ue\u0016\fWN\u0003\u0002F\r\u00069!/\u001e8uS6,'BA$I\u0003%\u0019HO]3b[&twM\u0003\u0002J\u0015\u0006IQ\r_3dkRLwN\u001c\u0006\u0003\u00172\u000b1a]9m\u0015\tie*A\u0003ta\u0006\u00148N\u0003\u0002P!\u00061\u0011\r]1dQ\u0016T\u0011!U\u0001\u0004_J<7\u0001\u0001\t\u0003)\u0006i\u0011\u0001\u0012\u0002\r\u001b\u0016lwN]=TiJ,\u0017-\\\n\u0004\u0003]k\u0006C\u0001-\\\u001b\u0005I&\"\u0001.\u0002\u000bM\u001c\u0017\r\\1\n\u0005qK&AB!osJ+g\r\u0005\u0002_G6\tqL\u0003\u0002aC\u0006\u0011\u0011n\u001c\u0006\u0002E\u0006!!.\u0019<b\u0013\t!wL\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0004=S:LGO\u0010\u000b\u0002'\u0006q1-\u001e:sK:$(\t\\8dW&#W#A5\u0011\u0005)\fX\"A6\u000b\u00051l\u0017AB1u_6L7M\u0003\u0002o_\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005A\f\u0017\u0001B;uS2L!A]6\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u0003=\u0019WO\u001d:f]R\u0014En\\2l\u0013\u0012\u0004\u0013AD7f[>\u0014\u0018p\u0015;sK\u0006l\u0017\nZ\u0001\u0010[\u0016lwN]=TiJ,\u0017-\\%eA\u0005)\u0011\r\u001d9msV\u0019\u0001pa\u0012\u0015\u000be\u001cIea\u0014\u0011\tQs1QI\u000b\u0004w\u0006\r1\u0003\u0004\b}\u0003+\t9#!\f\u0002:\u0005}\u0002c\u0001+~\u007f&\u0011a\u0010\u0012\u0002\u0011\u001b\u0016lwN]=TiJ,\u0017-\u001c\"bg\u0016\u0004B!!\u0001\u0002\u00041\u0001AaBA\u0003\u001d\t\u0007\u0011q\u0001\u0002\u0002\u0003F!\u0011\u0011BA\b!\rA\u00161B\u0005\u0004\u0003\u001bI&a\u0002(pi\"Lgn\u001a\t\u00041\u0006E\u0011bAA\n3\n\u0019\u0011I\\=\u0011\t\u0005]\u00111E\u0007\u0003\u00033Q1aRA\u000e\u0015\u0011\ti\"a\b\u0002\tI,\u0017\r\u001a\u0006\u0004\u0003CQ\u0015!C2p]:,7\r^8s\u0013\u0011\t)#!\u0007\u0003!5K7M]8CCR\u001c\u0007n\u0015;sK\u0006l\u0007\u0003BA\f\u0003SIA!a\u000b\u0002\u001a\tY2+\u001e9q_J$8\u000f\u0016:jO\u001e,'/\u0011<bS2\f'\r\\3O_^\u0004B!a\f\u000265\u0011\u0011\u0011\u0007\u0006\u0004\u0003ga\u0015\u0001C5oi\u0016\u0014h.\u00197\n\t\u0005]\u0012\u0011\u0007\u0002\b\u0019><w-\u001b8h!\rA\u00161H\u0005\u0004\u0003{I&a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003\u0003\n\tF\u0004\u0003\u0002D\u00055c\u0002BA#\u0003\u0017j!!a\u0012\u000b\u0007\u0005%#+\u0001\u0004=e>|GOP\u0005\u00025&\u0019\u0011qJ-\u0002\u000fA\f7m[1hK&\u0019A-a\u0015\u000b\u0007\u0005=\u0013,\u0001\u0002jIV\u0011\u0011\u0011\f\t\u00041\u0006m\u0013bAA/3\n\u0019\u0011J\u001c;\u0002\u0007%$\u0007%\u0001\u0006tc2\u001cuN\u001c;fqR,\"!!\u001a\u0011\t\u0005\u001d\u0014\u0011N\u0007\u0002\u0015&\u0019\u00111\u000e&\u0003\u0015M\u000bFjQ8oi\u0016DH/A\u0006tc2\u001cuN\u001c;fqR\u0004\u0013!\u00048v[B\u000b'\u000f^5uS>t7/\u0006\u0002\u0002tA)\u0001,!\u001e\u0002Z%\u0019\u0011qO-\u0003\r=\u0003H/[8o\u00039qW/\u001c)beRLG/[8og\u0002\n!\"\u001a<jI\u0016t7-\u001a\u00135!\u0015\t9'a \u0000\u0013\r\t\tI\u0013\u0002\b\u000b:\u001cw\u000eZ3s)!\t))a#\u0002\u000e\u0006=E\u0003BAD\u0003\u0013\u00032\u0001\u0016\b\u0000\u0011\u001d\tYH\u0006a\u0002\u0003{Bq!!\u0016\u0017\u0001\u0004\tI\u0006C\u0004\u0002bY\u0001\r!!\u001a\t\u0013\u0005=d\u0003%AA\u0002\u0005M\u0014AB8viB,H/\u0006\u0002\u0002\u0016B1\u0011\u0011IAL\u00037KA!!'\u0002T\t\u00191+Z9\u0011\t\u0005u\u0015qU\u0007\u0003\u0003?SA!!)\u0002$\u0006YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\r\t)KS\u0001\tG\u0006$\u0018\r\\=ti&!\u0011\u0011VAP\u0005%\tE\u000f\u001e:jEV$X-A\u0004pkR\u0004X\u000f\u001e\u0011\u0002\u000f\t\fGo\u00195fgV\u0011\u0011\u0011\u0017\t\u0007\u0003g\u000bi,!1\u000e\u0005\u0005U&\u0002BA\\\u0003s\u000bq!\\;uC\ndWMC\u0002\u0002<f\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty,!.\u0003\u00151K7\u000f\u001e\"vM\u001a,'\u000fE\u0003Y\u0003\u0007\f9-C\u0002\u0002Ff\u0013Q!\u0011:sCf\u0004B!!(\u0002J&!\u00111ZAP\u0005%)fn]1gKJ{w/\u0001\u0005cCR\u001c\u0007.Z:!Q\u001dQ\u0012\u0011[Ar\u0003K\u0004B!a5\u0002`6\u0011\u0011Q\u001b\u0006\u0004]\u0006]'\u0002BAm\u00037\f!\"\u00198o_R\fG/[8o\u0015\t\ti.A\u0003kCZ\f\u00070\u0003\u0003\u0002b\u0006U'!C$vCJ$W\r\u001a\"z\u0003\u00151\u0018\r\\;fC\t\t9/\u0001\u0003uQ&\u001c\u0018!D2veJ,g\u000e^(gMN,G/\u0006\u0002\u0002nB\u0019A+a<\n\u0007\u0005EHI\u0001\u0006M_:<wJ\u001a4tKR\f\u0011cY;se\u0016tGo\u00144gg\u0016$x\fJ3r)\u0011\t90!@\u0011\u0007a\u000bI0C\u0002\u0002|f\u0013A!\u00168ji\"I\u0011q \u000f\u0002\u0002\u0003\u0007\u0011Q^\u0001\u0004q\u0012\n\u0014AD2veJ,g\u000e^(gMN,G\u000f\t\u0015\b;\u0005E\u00171]As\u0003-\u0019H/\u0019:u\u001f\u001a47/\u001a;\u0002\u001fM$\u0018M\u001d;PM\u001a\u001cX\r^0%KF$B!a>\u0003\f!I\u0011q`\u0010\u0002\u0002\u0003\u0007\u0011Q^\u0001\rgR\f'\u000f^(gMN,G\u000f\t\u0015\bA\u0005E\u00171]As\u0003%)g\u000eZ(gMN,G/A\u0007f]\u0012|eMZ:fi~#S-\u001d\u000b\u0005\u0003o\u00149\u0002C\u0005\u0002\u0000\n\n\t\u00111\u0001\u0002n\u0006QQM\u001c3PM\u001a\u001cX\r\u001e\u0011)\u000f\r\n\t.a9\u0002f\u0006)\u0012M^1jY\u0006\u0014G.\u001a(po\u0016sGm\u00144gg\u0016$XC\u0001B\u0011!\u0011\t9Ba\t\n\t\t\u0015\u0012\u0011\u0004\u0002\u0007\u001f\u001a47/\u001a;\u00023\u00054\u0018-\u001b7bE2,gj\\<F]\u0012|eMZ:fi~#S-\u001d\u000b\u0005\u0003o\u0014Y\u0003C\u0005\u0002\u0000\u0016\n\t\u00111\u0001\u0003\"\u00051\u0012M^1jY\u0006\u0014G.\u001a(po\u0016sGm\u00144gg\u0016$\b\u0005K\u0004'\u0003#\f\u0019/!:\u0002'1\f7\u000f^(gMN,GoQ8n[&$H/\u001a3\u0002/1\f7\u000f^(gMN,GoQ8n[&$H/\u001a3`I\u0015\fH\u0003BA|\u0005oA\u0011\"a@)\u0003\u0003\u0005\r!!<\u0002)1\f7\u000f^(gMN,GoQ8n[&$H/\u001a3!Q\u001dI\u0013\u0011[Ar\u0003K\fq!\u00193e\t\u0006$\u0018\r\u0006\u0003\u0003B\t\u001d\u0003\u0003\u0002B\"\u0005\u000bj\u0011AR\u0005\u0004\u0005K1\u0005b\u0002B%U\u0001\u0007!1J\u0001\u0005I\u0006$\u0018\rE\u0003\u0002B\t5s0\u0003\u0003\u0003P\u0005M#\u0001D%uKJ\f'\r\\3P]\u000e,\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\tU\u0003\u0003\u0002B,\u0005?rAA!\u0017\u0003\\A\u0019\u0011QI-\n\u0007\tu\u0013,\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005C\u0012\u0019G\u0001\u0004TiJLgn\u001a\u0006\u0004\u0005;J\u0016!\u00053fg\u0016\u0014\u0018.\u00197ju\u0016|eMZ:fiR!!\u0011\u0005B5\u0011\u001d\u0011Y\u0007\fa\u0001\u0005+\nAA[:p]\u0006i\u0011N\\5uS\u0006dwJ\u001a4tKR$\"A!\t\u0002;A\u0014X\r]1sK\u001a{'\u000f\u0016:jO\u001e,'/\u0011<bS2\f'\r\\3O_^$\"!a>\u0002\u00191\fG/Z:u\u001f\u001a47/\u001a;\u0015\r\t\u0005\"\u0011\u0010B>\u0011\u001d\u0011)\u0001\ra\u0001\u0005CAqA! 1\u0001\u0004\u0011y(A\u0003mS6LG\u000f\u0005\u0003\u0002\u0018\t\u0005\u0015\u0002\u0002BB\u00033\u0011\u0011BU3bI2KW.\u001b;\u0002'Ad\u0017M\\%oaV$\b+\u0019:uSRLwN\\:\u0015\r\t%%1\u0013BL!\u0015A\u00161\u0019BF!\u0011\u0011iIa$\u000e\u0005\u0005m\u0011\u0002\u0002BI\u00037\u0011a\"\u00138qkR\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0003\u0016F\u0002\rA!\t\u0002\u000bM$\u0018M\u001d;\t\u000f\te\u0015\u00071\u0001\u0003\"\u0005\u0019QM\u001c3\u0002'\r\u0014X-\u0019;f%\u0016\fG-\u001a:GC\u000e$xN]=\u0015\u0005\t}\u0005\u0003\u0002BG\u0005CKAAa)\u0002\u001c\t1\u0002+\u0019:uSRLwN\u001c*fC\u0012,'OR1di>\u0014\u00180A\nhK:,'/\u0019;f\t\u0016\u0014WoZ*ue&tw\r\u0006\u0005\u0003V\t%&q\u0016BZ\u0011\u001d\u0011Yk\ra\u0001\u0005[\u000bAA]8xgB1\u0011\u0011IAL\u0003\u000fDqA!-4\u0001\u0004\tI&\u0001\u0007ti\u0006\u0014Ho\u0014:eS:\fG\u000eC\u0004\u00036N\u0002\r!!\u0017\u0002\u0015\u0015tGm\u0014:eS:\fG.\u0001\u0004d_6l\u0017\u000e\u001e\u000b\u0005\u0003o\u0014Y\fC\u0004\u0003\u001aR\u0002\rA!\t\u0002\tM$x\u000e]\u0001\u0006e\u0016\u001cX\r^\u0001\u0005G>\u0004\u00180\u0006\u0003\u0003F\n5G\u0003\u0003Bd\u0005'\u0014)Na6\u0015\t\t%'q\u001a\t\u0005):\u0011Y\r\u0005\u0003\u0002\u0002\t5GaBA\u0003o\t\u0007\u0011q\u0001\u0005\b\u0003w:\u00049\u0001Bi!\u0019\t9'a \u0003L\"I\u0011QK\u001c\u0011\u0002\u0003\u0007\u0011\u0011\f\u0005\n\u0003C:\u0004\u0013!a\u0001\u0003KB\u0011\"a\u001c8!\u0003\u0005\r!a\u001d\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU!!Q\u001cBy+\t\u0011yN\u000b\u0003\u0002Z\t\u00058F\u0001Br!\u0011\u0011)O!<\u000e\u0005\t\u001d(\u0002\u0002Bu\u0005W\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005e\u0017,\u0003\u0003\u0003p\n\u001d(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00129\u0011Q\u0001\u001dC\u0002\u0005\u001d\u0011AD2paf$C-\u001a4bk2$HEM\u000b\u0005\u0005o\u0014Y0\u0006\u0002\u0003z*\"\u0011Q\rBq\t\u001d\t)!\u000fb\u0001\u0003\u000f\tabY8qs\u0012\"WMZ1vYR$3'\u0006\u0003\u0004\u0002\r\u0015QCAB\u0002U\u0011\t\u0019H!9\u0005\u000f\u0005\u0015!H1\u0001\u0002\b\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"aa\u0003\u0011\t\r511C\u0007\u0003\u0007\u001fQ1a!\u0005b\u0003\u0011a\u0017M\\4\n\t\t\u00054qB\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tyaa\u0007\t\u0013\u0005}X(!AA\u0002\u0005e\u0013a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\r\u0005\u0002CBB\u0012\u0007K\ty!\u0004\u0002\u0002:&!1qEA]\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\r521\u0007\t\u00041\u000e=\u0012bAB\u00193\n9!i\\8mK\u0006t\u0007\"CA\u0000\u007f\u0005\u0005\t\u0019AA\b\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\r-1\u0011\b\u0005\n\u0003\u007f\u0004\u0015\u0011!a\u0001\u00033\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u00033\na!Z9vC2\u001cH\u0003BB\u0017\u0007\u0007B\u0011\"a@C\u0003\u0003\u0005\r!a\u0004\u0011\t\u0005\u00051q\t\u0003\b\u0003\u000b9!\u0019AA\u0004\u0011%\u0019YeBA\u0001\u0002\b\u0019i%\u0001\u0006fm&$WM\\2fIE\u0002b!a\u001a\u0002\u0000\r\u0015\u0003bBA1\u000f\u0001\u000f\u0011QM\u000b\u0005\u0007'\u001aY\u0006\u0006\u0003\u0004V\r\u0015DCBB,\u0007;\u001a\u0019\u0007\u0005\u0003U\u001d\re\u0003\u0003BA\u0001\u00077\"q!!\u0002\t\u0005\u0004\t9\u0001C\u0005\u0004`!\t\t\u0011q\u0001\u0004b\u0005QQM^5eK:\u001cW\r\n\u001a\u0011\r\u0005\u001d\u0014qPB-\u0011\u001d\t\t\u0007\u0003a\u0002\u0003KBq!a\u001c\t\u0001\u0004\tI&\u0006\u0003\u0004j\rED\u0003CB6\u0007o\u001aIha\u001f\u0015\t\r541\u000f\t\u0005):\u0019y\u0007\u0005\u0003\u0002\u0002\rEDaBA\u0003\u0013\t\u0007\u0011q\u0001\u0005\b\u0003wJ\u00019AB;!\u0019\t9'a \u0004p!9\u0011QK\u0005A\u0002\u0005e\u0003bBA1\u0013\u0001\u0007\u0011Q\r\u0005\n\u0003_J\u0001\u0013!a\u0001\u0003g\nq\"\u00199qYf$C-\u001a4bk2$HeM\u000b\u0005\u0007\u0003\u0019\t\tB\u0004\u0002\u0006)\u0011\r!a\u0002\u0002\u000fUt\u0017\r\u001d9msV!1qQBM)\u0011\u0019Ii!%\u0011\u000ba\u000b)ha#\u0011\u0013a\u001bi)!\u0017\u0002f\u0005M\u0014bABH3\n1A+\u001e9mKNB\u0011ba%\f\u0003\u0003\u0005\ra!&\u0002\u0007a$\u0003\u0007\u0005\u0003U\u001d\r]\u0005\u0003BA\u0001\u00073#q!!\u0002\f\u0005\u0004\t9!A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u000b\u0005\u0007\u0003\u0019y\nB\u0004\u0002\u00061\u0011\r!a\u0002\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\r\u0015\u0006\u0003BB\u0007\u0007OKAa!+\u0004\u0010\t1qJ\u00196fGR\u0004")
public class MemoryStream<A>
extends MemoryStreamBase<A>
implements MicroBatchStream,
SupportsTriggerAvailableNow,
Logging,
Product,
Serializable {
    private final int id;
    private final SQLContext sqlContext;
    private final Option<Object> numPartitions;
    private final Seq<Attribute> output;
    @GuardedBy(value="this")
    private final ListBuffer<UnsafeRow[]> batches;
    @GuardedBy(value="this")
    private LongOffset currentOffset;
    @GuardedBy(value="this")
    private LongOffset startOffset;
    @GuardedBy(value="this")
    private LongOffset endOffset;
    @GuardedBy(value="this")
    private org.apache.spark.sql.connector.read.streaming.Offset availableNowEndOffset;
    @GuardedBy(value="this")
    private LongOffset lastOffsetCommitted;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static <A> Option<Object> $lessinit$greater$default$3() {
        return MemoryStream$.MODULE$.$lessinit$greater$default$3();
    }

    public static <A> Option<Tuple3<Object, SQLContext, Option<Object>>> unapply(MemoryStream<A> x$0) {
        return MemoryStream$.MODULE$.unapply(x$0);
    }

    public static <A> Option<Object> apply$default$3() {
        return MemoryStream$.MODULE$.apply$default$3();
    }

    public static <A> MemoryStream<A> apply(int id, SQLContext sqlContext, Option<Object> numPartitions, Encoder<A> evidence$4) {
        return MemoryStream$.MODULE$.apply(id, sqlContext, numPartitions, evidence$4);
    }

    public static <A> MemoryStream<A> apply(int numPartitions, Encoder<A> evidence$2, SQLContext sqlContext) {
        return MemoryStream$.MODULE$.apply(numPartitions, evidence$2, sqlContext);
    }

    public static <A> MemoryStream<A> apply(Encoder<A> evidence$1, SQLContext sqlContext) {
        return MemoryStream$.MODULE$.apply(evidence$1, sqlContext);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int id() {
        return this.id;
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public Option<Object> numPartitions() {
        return this.numPartitions;
    }

    public Seq<Attribute> output() {
        return this.output;
    }

    public ListBuffer<UnsafeRow[]> batches() {
        return this.batches;
    }

    public LongOffset currentOffset() {
        return this.currentOffset;
    }

    public void currentOffset_$eq(LongOffset x$1) {
        this.currentOffset = x$1;
    }

    public LongOffset startOffset() {
        return this.startOffset;
    }

    public void startOffset_$eq(LongOffset x$1) {
        this.startOffset = x$1;
    }

    private LongOffset endOffset() {
        return this.endOffset;
    }

    private void endOffset_$eq(LongOffset x$1) {
        this.endOffset = x$1;
    }

    private org.apache.spark.sql.connector.read.streaming.Offset availableNowEndOffset() {
        return this.availableNowEndOffset;
    }

    private void availableNowEndOffset_$eq(org.apache.spark.sql.connector.read.streaming.Offset x$1) {
        this.availableNowEndOffset = x$1;
    }

    public LongOffset lastOffsetCommitted() {
        return this.lastOffsetCommitted;
    }

    public void lastOffsetCommitted_$eq(LongOffset x$1) {
        this.lastOffsetCommitted = x$1;
    }

    @Override
    public Offset addData(IterableOnce<A> data) {
        LongOffset longOffset;
        Seq objects = (Seq)data.iterator().to(IterableFactory$.MODULE$.toFactory((IterableFactory)package$.MODULE$.Seq()));
        UnsafeRow[] rows = (UnsafeRow[])objects.iterator().map((Function1 & Serializable)d -> (UnsafeRow)this.toRow().apply(d).copy()).toArray(ClassTag$.MODULE$.apply(UnsafeRow.class));
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Adding: " + objects);
        MemoryStream memoryStream = this;
        synchronized (memoryStream) {
            this.currentOffset_$eq(this.currentOffset().$plus(1L));
            this.batches().$plus$eq((Object)rows);
            longOffset = this.currentOffset();
        }
        return longOffset;
    }

    public String toString() {
        return "MemoryStream[" + org.apache.spark.sql.catalyst.util.package$.MODULE$.truncatedString(this.output(), ",", SQLConf$.MODULE$.get().maxToStringFields()) + "]";
    }

    @Override
    public org.apache.spark.sql.connector.read.streaming.Offset deserializeOffset(String json) {
        return new LongOffset(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(json)));
    }

    @Override
    public org.apache.spark.sql.connector.read.streaming.Offset initialOffset() {
        return new LongOffset(-1L);
    }

    public synchronized void prepareForTriggerAvailableNow() {
        this.availableNowEndOffset_$eq(this.latestOffset(this.initialOffset(), ReadLimit.allAvailable()));
    }

    public org.apache.spark.sql.connector.read.streaming.Offset latestOffset() {
        throw new IllegalStateException("Should not reach here!");
    }

    public org.apache.spark.sql.connector.read.streaming.Offset latestOffset(org.apache.spark.sql.connector.read.streaming.Offset startOffset, ReadLimit limit) {
        if (this.currentOffset().offset() == -1L) {
            return null;
        }
        return this.currentOffset();
    }

    public InputPartition[] planInputPartitions(org.apache.spark.sql.connector.read.streaming.Offset start, org.apache.spark.sql.connector.read.streaming.Offset end) {
        InputPartition[] inputPartitionArray;
        LongOffset startOffset = (LongOffset)start;
        LongOffset endOffset = (LongOffset)end;
        MemoryStream memoryStream = this;
        synchronized (memoryStream) {
            InputPartition[] inputPartitionArray2;
            ListBuffer listBuffer;
            int startOrdinal = (int)startOffset.offset() + 1;
            int endOrdinal = (int)endOffset.offset() + 1;
            MemoryStream memoryStream2 = this;
            synchronized (memoryStream2) {
                int sliceStart = startOrdinal - (int)this.lastOffsetCommitted().offset() - 1;
                int sliceEnd = endOrdinal - (int)this.lastOffsetCommitted().offset() - 1;
                Predef$.MODULE$.assert(sliceStart <= sliceEnd, (Function0 & Serializable)() -> "sliceStart: " + sliceStart + " sliceEnd: " + sliceEnd);
                listBuffer = (ListBuffer)this.batches().slice(sliceStart, sliceEnd);
            }
            ListBuffer newBlocks = listBuffer;
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> this.generateDebugString((Seq<UnsafeRow>)((IterableOnceOps)newBlocks.flatten((Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs))).toSeq(), startOrdinal, endOrdinal));
            Option<Object> option = this.numPartitions();
            if (option instanceof Some) {
                Some some = (Some)option;
                int numParts = BoxesRunTime.unboxToInt((Object)some.value());
                UnsafeRow[] inputRows = (UnsafeRow[])((IterableOnceOps)newBlocks.flatten((Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs))).toArray(ClassTag$.MODULE$.apply(UnsafeRow.class));
                inputPartitionArray2 = (InputPartition[])RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numParts).map((Function1 & Serializable)newPartIdx -> MemoryStream.$anonfun$planInputPartitions$5(inputRows, numParts, BoxesRunTime.unboxToInt((Object)newPartIdx))).toArray(ClassTag$.MODULE$.apply(InputPartition.class));
            } else {
                inputPartitionArray2 = (InputPartition[])((IterableOnceOps)newBlocks.map((Function1 & Serializable)block -> new MemoryStreamInputPartition((UnsafeRow[])block))).toArray(ClassTag$.MODULE$.apply(InputPartition.class));
            }
            inputPartitionArray = inputPartitionArray2;
        }
        return inputPartitionArray;
    }

    public PartitionReaderFactory createReaderFactory() {
        return MemoryStreamReaderFactory$.MODULE$;
    }

    private String generateDebugString(Seq<UnsafeRow> rows, int startOrdinal, int endOrdinal) {
        ExpressionEncoder.Deserializer fromRow = this.encoder().resolveAndBind(this.encoder().resolveAndBind$default$1(), this.encoder().resolveAndBind$default$2()).createDeserializer();
        return "MemoryBatch [" + startOrdinal + ", " + endOrdinal + "]: " + ((IterableOnceOps)rows.map((Function1 & Serializable)row -> fromRow.apply((InternalRow)row))).mkString(", ");
    }

    @Override
    public synchronized void commit(org.apache.spark.sql.connector.read.streaming.Offset end) {
        LongOffset newOffset = (LongOffset)end;
        int offsetDiff = (int)(newOffset.offset() - this.lastOffsetCommitted().offset());
        if (offsetDiff < 0) {
            throw new IllegalStateException("Offsets committed out of order: " + this.lastOffsetCommitted() + " followed by " + end);
        }
        this.batches().dropInPlace(offsetDiff);
        this.lastOffsetCommitted_$eq(newOffset);
    }

    public void stop() {
    }

    public synchronized void reset() {
        this.batches().clear();
        this.startOffset_$eq(new LongOffset(-1L));
        this.endOffset_$eq(new LongOffset(-1L));
        this.currentOffset_$eq(new LongOffset(-1L));
        this.lastOffsetCommitted_$eq(new LongOffset(-1L));
        this.availableNowEndOffset_$eq(null);
    }

    public <A> MemoryStream<A> copy(int id, SQLContext sqlContext, Option<Object> numPartitions, Encoder<A> evidence$4) {
        return new MemoryStream<A>(id, sqlContext, numPartitions, evidence$4);
    }

    public <A> int copy$default$1() {
        return this.id();
    }

    public <A> SQLContext copy$default$2() {
        return this.sqlContext();
    }

    public <A> Option<Object> copy$default$3() {
        return this.numPartitions();
    }

    public String productPrefix() {
        return "MemoryStream";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return BoxesRunTime.boxToInteger((int)this.id());
            }
            case 1: {
                return this.sqlContext();
            }
            case 2: {
                return this.numPartitions();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MemoryStream;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "id";
            }
            case 1: {
                return "sqlContext";
            }
            case 2: {
                return "numPartitions";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)this.id());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.sqlContext()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.numPartitions()));
        return Statics.finalizeHash((int)n, (int)3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MemoryStream)) return false;
        boolean bl = true;
        if (!bl) return false;
        MemoryStream memoryStream = (MemoryStream)x$1;
        if (this.id() != memoryStream.id()) return false;
        SQLContext sQLContext = this.sqlContext();
        SQLContext sQLContext2 = memoryStream.sqlContext();
        if (sQLContext == null) {
            if (sQLContext2 != null) {
                return false;
            }
        } else if (!sQLContext.equals(sQLContext2)) return false;
        Option<Object> option = this.numPartitions();
        Option<Object> option2 = memoryStream.numPartitions();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!memoryStream.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$planInputPartitions$6(int numParts$1, int newPartIdx$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int idx = tuple2._2$mcI$sp();
            return idx % numParts$1 == newPartIdx$1;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ MemoryStreamInputPartition $anonfun$planInputPartitions$5(UnsafeRow[] inputRows$1, int numParts$1, int newPartIdx) {
        UnsafeRow[] records = (UnsafeRow[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])inputRows$1))), (Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MemoryStream.$anonfun$planInputPartitions$6(numParts$1, newPartIdx, x0$1)))), (Function1 & Serializable)x$2 -> (UnsafeRow)x$2._1(), ClassTag$.MODULE$.apply(UnsafeRow.class));
        return new MemoryStreamInputPartition(records);
    }

    public MemoryStream(int id, SQLContext sqlContext, Option<Object> numPartitions, Encoder<A> evidence$4) {
        this.id = id;
        this.sqlContext = sqlContext;
        this.numPartitions = numPartitions;
        super(sqlContext, evidence$4);
        Logging.$init$((Logging)this);
        Product.$init$((Product)this);
        this.output = this.logicalPlan().output();
        this.batches = new ListBuffer();
        this.currentOffset = new LongOffset(-1L);
        this.startOffset = new LongOffset(-1L);
        this.endOffset = new LongOffset(-1L);
        this.lastOffsetCommitted = new LongOffset(-1L);
    }
}

