/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.runtime;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.execution.streaming.ProcessingTimeTrigger;
import org.apache.spark.sql.execution.streaming.runtime.MicroBatchExecutionContext;
import org.apache.spark.sql.execution.streaming.runtime.ProcessingTimeExecutor$;
import org.apache.spark.sql.execution.streaming.runtime.TriggerExecutor;
import org.apache.spark.util.Clock;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005%g\u0001\u0002\u0011\"\u0001BB\u0001\u0002\u0015\u0001\u0003\u0016\u0004%\t!\u0015\u0005\t-\u0002\u0011\t\u0012)A\u0005%\"Aq\u000b\u0001BK\u0002\u0013\u0005\u0001\f\u0003\u0005`\u0001\tE\t\u0015!\u0003Z\u0011\u0015\u0001\u0007\u0001\"\u0001b\u0011\u001d)\u0007A1A\u0005\n\u0019DaA\u001b\u0001!\u0002\u00139\u0007\"B6\u0001\t\u0003b\u0007\"B>\u0001\t\u0003a\bBB@\u0001\t\u0003\t\t\u0001C\u0005\u0002\b\u0001\t\t\u0011\"\u0001\u0002\n!I\u0011q\u0002\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0003\u0005\n\u0003O\u0001\u0011\u0013!C\u0001\u0003SA\u0011\"!\f\u0001\u0003\u0003%\t%a\f\t\u0013\u0005\u0005\u0003!!A\u0005\u0002\u0005\r\u0003\"CA&\u0001\u0005\u0005I\u0011AA'\u0011%\tI\u0006AA\u0001\n\u0003\nY\u0006C\u0005\u0002j\u0001\t\t\u0011\"\u0001\u0002l!I\u0011q\u000e\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u000f\u0005\n\u0003k\u0002\u0011\u0011!C!\u0003oB\u0011\"!\u001f\u0001\u0003\u0003%\t%a\u001f\t\u0013\u0005u\u0004!!A\u0005B\u0005}t!CABC\u0005\u0005\t\u0012AAC\r!\u0001\u0013%!A\t\u0002\u0005\u001d\u0005B\u00021\u0019\t\u0003\ti\nC\u0005\u0002za\t\t\u0011\"\u0012\u0002|!I\u0011q\u0014\r\u0002\u0002\u0013\u0005\u0015\u0011\u0015\u0005\n\u0003OC\u0012\u0013!C\u0001\u0003SA\u0011\"!+\u0019\u0003\u0003%\t)a+\t\u0013\u0005u\u0006$%A\u0005\u0002\u0005%\u0002\"CA`1\u0005\u0005I\u0011BAa\u0005Y\u0001&o\\2fgNLgn\u001a+j[\u0016,\u00050Z2vi>\u0014(B\u0001\u0012$\u0003\u001d\u0011XO\u001c;j[\u0016T!\u0001J\u0013\u0002\u0013M$(/Z1nS:<'B\u0001\u0014(\u0003%)\u00070Z2vi&|gN\u0003\u0002)S\u0005\u00191/\u001d7\u000b\u0005)Z\u0013!B:qCJ\\'B\u0001\u0017.\u0003\u0019\t\u0007/Y2iK*\ta&A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001c]Z\u0014\t\u0012\t\u0003eUj\u0011a\r\u0006\u0002i\u0005)1oY1mC&\u0011ag\r\u0002\u0007\u0003:L(+\u001a4\u0011\u0005aJT\"A\u0011\n\u0005i\n#a\u0004+sS\u001e<WM]#yK\u000e,Ho\u001c:\u0011\u0005qzT\"A\u001f\u000b\u0005yJ\u0013\u0001C5oi\u0016\u0014h.\u00197\n\u0005\u0001k$a\u0002'pO\u001eLgn\u001a\t\u0003e\tK!aQ\u001a\u0003\u000fA\u0013x\u000eZ;diB\u0011Q)\u0014\b\u0003\r.s!a\u0012&\u000e\u0003!S!!S\u0018\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0014B\u0001'4\u0003\u001d\u0001\u0018mY6bO\u0016L!AT(\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u00051\u001b\u0014!\u00069s_\u000e,7o]5oORKW.\u001a+sS\u001e<WM]\u000b\u0002%B\u00111\u000bV\u0007\u0002G%\u0011Qk\t\u0002\u0016!J|7-Z:tS:<G+[7f)JLwmZ3s\u0003Y\u0001(o\\2fgNLgn\u001a+j[\u0016$&/[4hKJ\u0004\u0013!B2m_\u000e\\W#A-\u0011\u0005ikV\"A.\u000b\u0005qK\u0013\u0001B;uS2L!AX.\u0003\u000b\rcwnY6\u0002\r\rdwnY6!\u0003\u0019a\u0014N\\5u}Q\u0019!m\u00193\u0011\u0005a\u0002\u0001\"\u0002)\u0006\u0001\u0004\u0011\u0006bB,\u0006!\u0003\u0005\r!W\u0001\u000bS:$XM\u001d<bY6\u001bX#A4\u0011\u0005IB\u0017BA54\u0005\u0011auN\\4\u0002\u0017%tG/\u001a:wC2l5\u000fI\u0001\bKb,7-\u001e;f)\ti\u0007\u000f\u0005\u00023]&\u0011qn\r\u0002\u0005+:LG\u000fC\u0003r\u0011\u0001\u0007!/\u0001\bue&<w-\u001a:IC:$G.\u001a:\u0011\tI\u001aX\u000f_\u0005\u0003iN\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0005a2\u0018BA<\"\u0005ii\u0015n\u0019:p\u0005\u0006$8\r[#yK\u000e,H/[8o\u0007>tG/\u001a=u!\t\u0011\u00140\u0003\u0002{g\t9!i\\8mK\u0006t\u0017\u0001\u00078pi&4\u0017PQ1uG\"4\u0015\r\u001c7j]\u001e\u0014U\r[5oIR\u0011Q. \u0005\u0006}&\u0001\raZ\u0001\u0012e\u0016\fG.\u00127baN,G\rV5nK6\u001b\u0018!\u00048fqR\u0014\u0015\r^2i)&lW\rF\u0002h\u0003\u0007Aa!!\u0002\u000b\u0001\u00049\u0017a\u00018po\u0006!1m\u001c9z)\u0015\u0011\u00171BA\u0007\u0011\u001d\u00016\u0002%AA\u0002ICqaV\u0006\u0011\u0002\u0003\u0007\u0011,\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005M!f\u0001*\u0002\u0016-\u0012\u0011q\u0003\t\u0005\u00033\t\u0019#\u0004\u0002\u0002\u001c)!\u0011QDA\u0010\u0003%)hn\u00195fG.,GMC\u0002\u0002\"M\n!\"\u00198o_R\fG/[8o\u0013\u0011\t)#a\u0007\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005-\"fA-\u0002\u0016\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!\r\u0011\t\u0005M\u0012QH\u0007\u0003\u0003kQA!a\u000e\u0002:\u0005!A.\u00198h\u0015\t\tY$\u0001\u0003kCZ\f\u0017\u0002BA \u0003k\u0011aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAA#!\r\u0011\u0014qI\u0005\u0004\u0003\u0013\u001a$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA(\u0003+\u00022AMA)\u0013\r\t\u0019f\r\u0002\u0004\u0003:L\b\"CA,!\u0005\u0005\t\u0019AA#\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\f\t\u0007\u0003?\n)'a\u0014\u000e\u0005\u0005\u0005$bAA2g\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u001d\u0014\u0011\r\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002y\u0003[B\u0011\"a\u0016\u0013\u0003\u0003\u0005\r!a\u0014\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003c\t\u0019\bC\u0005\u0002XM\t\t\u00111\u0001\u0002F\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002F\u0005AAo\\*ue&tw\r\u0006\u0002\u00022\u00051Q-];bYN$2\u0001_AA\u0011%\t9FFA\u0001\u0002\u0004\ty%\u0001\fQe>\u001cWm]:j]\u001e$\u0016.\\3Fq\u0016\u001cW\u000f^8s!\tA\u0004dE\u0003\u0019\u0003\u0013\u000b\u0019\nE\u0004\u0002\f\u0006=%+\u00172\u000e\u0005\u00055%B\u0001\u00124\u0013\u0011\t\t*!$\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0005\u0003\u0002\u0016\u0006mUBAAL\u0015\u0011\tI*!\u000f\u0002\u0005%|\u0017b\u0001(\u0002\u0018R\u0011\u0011QQ\u0001\u0006CB\u0004H.\u001f\u000b\u0006E\u0006\r\u0016Q\u0015\u0005\u0006!n\u0001\rA\u0015\u0005\b/n\u0001\n\u00111\u0001Z\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u0012\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0003[\u000bI\fE\u00033\u0003_\u000b\u0019,C\u0002\u00022N\u0012aa\u00149uS>t\u0007#\u0002\u001a\u00026JK\u0016bAA\\g\t1A+\u001e9mKJB\u0001\"a/\u001e\u0003\u0003\u0005\rAY\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002DB!\u00111GAc\u0013\u0011\t9-!\u000e\u0003\r=\u0013'.Z2u\u0001")
public class ProcessingTimeExecutor
implements TriggerExecutor,
Logging,
Product,
Serializable {
    private final ProcessingTimeTrigger processingTimeTrigger;
    private final Clock clock;
    private final long intervalMs;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private MicroBatchExecutionContext org$apache$spark$sql$execution$streaming$runtime$TriggerExecutor$$execCtx;

    public static Clock $lessinit$greater$default$2() {
        return ProcessingTimeExecutor$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<ProcessingTimeTrigger, Clock>> unapply(ProcessingTimeExecutor x$0) {
        return ProcessingTimeExecutor$.MODULE$.unapply(x$0);
    }

    public static Clock apply$default$2() {
        return ProcessingTimeExecutor$.MODULE$.apply$default$2();
    }

    public static ProcessingTimeExecutor apply(ProcessingTimeTrigger processingTimeTrigger, Clock clock) {
        return ProcessingTimeExecutor$.MODULE$.apply(processingTimeTrigger, clock);
    }

    public static Function1<Tuple2<ProcessingTimeTrigger, Clock>, ProcessingTimeExecutor> tupled() {
        return ProcessingTimeExecutor$.MODULE$.tupled();
    }

    public static Function1<ProcessingTimeTrigger, Function1<Clock, ProcessingTimeExecutor>> curried() {
        return ProcessingTimeExecutor$.MODULE$.curried();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public void setNextBatch(MicroBatchExecutionContext execContext) {
        TriggerExecutor.setNextBatch$(this, execContext);
    }

    @Override
    public boolean runOneBatch(Function1<MicroBatchExecutionContext, Object> batchRunner) {
        return TriggerExecutor.runOneBatch$(this, batchRunner);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public MicroBatchExecutionContext org$apache$spark$sql$execution$streaming$runtime$TriggerExecutor$$execCtx() {
        return this.org$apache$spark$sql$execution$streaming$runtime$TriggerExecutor$$execCtx;
    }

    @Override
    public void org$apache$spark$sql$execution$streaming$runtime$TriggerExecutor$$execCtx_$eq(MicroBatchExecutionContext x$1) {
        this.org$apache$spark$sql$execution$streaming$runtime$TriggerExecutor$$execCtx = x$1;
    }

    public ProcessingTimeTrigger processingTimeTrigger() {
        return this.processingTimeTrigger;
    }

    public Clock clock() {
        return this.clock;
    }

    private long intervalMs() {
        return this.intervalMs;
    }

    @Override
    public void execute(Function1<MicroBatchExecutionContext, Object> triggerHandler) {
        while (true) {
            Object object;
            boolean terminated;
            long triggerTimeMs = this.clock().getTimeMillis();
            long nextTriggerTimeMs = this.nextBatchTime(triggerTimeMs);
            boolean bl = terminated = !this.runOneBatch(triggerHandler);
            if (this.intervalMs() > 0L) {
                long batchElapsedTimeMs = this.clock().getTimeMillis() - triggerTimeMs;
                if (batchElapsedTimeMs > this.intervalMs()) {
                    this.notifyBatchFallingBehind(batchElapsedTimeMs);
                }
                if (terminated) {
                    return;
                }
                object = BoxesRunTime.boxToLong((long)this.clock().waitTillTime(nextTriggerTimeMs));
                continue;
            }
            if (terminated) {
                return;
            }
            object = BoxedUnit.UNIT;
        }
    }

    public void notifyBatchFallingBehind(long realElapsedTimeMs) {
        this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Current batch is falling behind. The trigger interval is "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " milliseconds, but spent "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.TRIGGER_INTERVAL, BoxesRunTime.boxToLong((long)this.intervalMs()))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " milliseconds"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.ELAPSED_TIME, BoxesRunTime.boxToLong((long)realElapsedTimeMs))})))));
    }

    public long nextBatchTime(long now) {
        if (this.intervalMs() == 0L) {
            return now;
        }
        return now / this.intervalMs() * this.intervalMs() + this.intervalMs();
    }

    public ProcessingTimeExecutor copy(ProcessingTimeTrigger processingTimeTrigger, Clock clock) {
        return new ProcessingTimeExecutor(processingTimeTrigger, clock);
    }

    public ProcessingTimeTrigger copy$default$1() {
        return this.processingTimeTrigger();
    }

    public Clock copy$default$2() {
        return this.clock();
    }

    public String productPrefix() {
        return "ProcessingTimeExecutor";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.processingTimeTrigger();
            }
            case 1: {
                return this.clock();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ProcessingTimeExecutor;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "processingTimeTrigger";
            }
            case 1: {
                return "clock";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ProcessingTimeExecutor)) return false;
        boolean bl = true;
        if (!bl) return false;
        ProcessingTimeExecutor processingTimeExecutor = (ProcessingTimeExecutor)x$1;
        ProcessingTimeTrigger processingTimeTrigger = this.processingTimeTrigger();
        ProcessingTimeTrigger processingTimeTrigger2 = processingTimeExecutor.processingTimeTrigger();
        if (processingTimeTrigger == null) {
            if (processingTimeTrigger2 != null) {
                return false;
            }
        } else if (!processingTimeTrigger.equals(processingTimeTrigger2)) return false;
        Clock clock = this.clock();
        Clock clock2 = processingTimeExecutor.clock();
        if (clock == null) {
            if (clock2 != null) {
                return false;
            }
        } else if (!clock.equals(clock2)) return false;
        if (!processingTimeExecutor.canEqual(this)) return false;
        return true;
    }

    public ProcessingTimeExecutor(ProcessingTimeTrigger processingTimeTrigger, Clock clock) {
        this.processingTimeTrigger = processingTimeTrigger;
        this.clock = clock;
        TriggerExecutor.$init$(this);
        Logging.$init$((Logging)this);
        Product.$init$((Product)this);
        this.intervalMs = processingTimeTrigger.intervalMs();
        Predef$.MODULE$.require(this.intervalMs() >= 0L);
    }
}

