/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.NonEmptyNamespaceException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.jdbc.DB2Dialect$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcSQLQueryBuilder;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.jdbc.NoLegacyJDBCError;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.SetOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\r\u0015b\u0001\u0002\u001d:\t\u0012CQ\u0001\u001a\u0001\u0005\u0002\u0015DQa\u001a\u0001\u0005B!DqA\u001e\u0001C\u0002\u0013%q\u000fC\u0004\u0002\u0010\u0001\u0001\u000b\u0011\u0002=\t\u0011\u0005E\u0001A1A\u0005\n]Dq!a\u0005\u0001A\u0003%\u0001\u0010\u0003\u0005\u0002\u0016\u0001\u0011\r\u0011\"\u0003x\u0011\u001d\t9\u0002\u0001Q\u0001\naDq!!\u0007\u0001\t\u0003\nY\u0002C\u0004\u0002\"\u0001!\t%a\t\u0007\r\u0005M\u0002\u0001AA\u001b\u0011\u0019!7\u0002\"\u0001\u0002@!9\u00111I\u0006\u0005B\u0005\u0015\u0003bBA,\u0017\u0011\u0005\u0013\u0011\f\u0005\b\u0003;\u0002A\u0011IA0\u0011\u001d\tY\b\u0001C!\u0003{Bq!!#\u0001\t\u0003\nY\tC\u0004\u00028\u0002!\t%!/\t\u000f\u0005\u001d\u0007\u0001\"\u0011\u0002J\"9\u0011Q\u001a\u0001\u0005B\u0005=\u0007bBAk\u0001\u0011\u0005\u0013q\u001b\u0005\n\u0003C\u0004\u0011\u0013!C\u0001\u0003GDq!!?\u0001\t\u0003\nY\u0010C\u0004\u0003\u0012\u0001!\tEa\u0005\t\u000f\t\u0005\u0002\u0001\"\u0011\u0003$!9!Q\u0006\u0001\u0005B\t=\u0002b\u0002B\u001b\u0001\u0011\u0005#q\u0007\u0005\b\u0005K\u0002A\u0011\tB4\u0011\u001d\u0011i\u0007\u0001C!\u0005_BqAa\u001f\u0001\t\u0003\u0012iH\u0002\u0004\u0003\u0004\u0002\u0001!Q\u0011\u0005\n\u0005\u001b{\"\u0011!Q\u0001\n\u0015C!Ba$ \u0005\u0003\u0005\u000b\u0011\u0002BI\u0011\u0019!w\u0004\"\u0001\u0003$\"9!1V\u0010\u0005B\t5\u0006b\u0002BX\u0001\u0011\u0005#\u0011\u0017\u0005\b\u0005k\u0003A\u0011\tB\\\u0011\u001d\u0011I\f\u0001C!\u0005oC\u0001Ba/\u0001\u0003\u0003%\t!\u001a\u0005\n\u0005{\u0003\u0011\u0011!C!\u0005\u007fC\u0011B!1\u0001\u0003\u0003%\tAa1\t\u0013\t\u0015\u0007!!A\u0005\u0002\t\u001d\u0007\"\u0003Bg\u0001\u0005\u0005I\u0011\tBh\u0011%\u0011I\u000eAA\u0001\n\u0003\u0011Y\u000eC\u0005\u0003`\u0002\t\t\u0011\"\u0011\u0003b\"I!Q\u001d\u0001\u0002\u0002\u0013\u0005#q\u001d\u0005\n\u0005S\u0004\u0011\u0011!C!\u0005WD\u0011B!<\u0001\u0003\u0003%\tEa<\b\u0013\tM\u0018(!A\t\n\tUh\u0001\u0003\u001d:\u0003\u0003EIAa>\t\r\u0011\u0014D\u0011AB\b\u0011%\u0011IOMA\u0001\n\u000b\u0012Y\u000f\u0003\u0005\u0004\u0012I\n\t\u0011\"!f\u0011%\u0019\u0019BMA\u0001\n\u0003\u001b)\u0002C\u0005\u0004\u001cI\n\t\u0011\"\u0003\u0004\u001e\tQAI\u0011\u001aES\u0006dWm\u0019;\u000b\u0005iZ\u0014\u0001\u00026eE\u000eT!\u0001P\u001f\u0002\u0007M\fHN\u0003\u0002?\u007f\u0005)1\u000f]1sW*\u0011\u0001)Q\u0001\u0007CB\f7\r[3\u000b\u0003\t\u000b1a\u001c:h\u0007\u0001\u0019b\u0001A#J\u001fJC\u0006C\u0001$H\u001b\u0005I\u0014B\u0001%:\u0005-QEMY2ES\u0006dWm\u0019;\u0011\u0005)kU\"A&\u000b\u00051[\u0014\u0001C2bi\u0006d\u0017p\u001d;\n\u00059[%!D*R\u0019\u000e{gN\u001a%fYB,'\u000f\u0005\u0002G!&\u0011\u0011+\u000f\u0002\u0012\u001d>dUmZ1ds*#%iQ#se>\u0014\bCA*W\u001b\u0005!&\"A+\u0002\u000bM\u001c\u0017\r\\1\n\u0005]#&a\u0002)s_\u0012,8\r\u001e\t\u00033\u0006t!AW0\u000f\u0005msV\"\u0001/\u000b\u0005u\u001b\u0015A\u0002\u001fs_>$h(C\u0001V\u0013\t\u0001G+A\u0004qC\u000e\\\u0017mZ3\n\u0005\t\u001c'\u0001D*fe&\fG.\u001b>bE2,'B\u00011U\u0003\u0019a\u0014N\\5u}Q\ta\r\u0005\u0002G\u0001\u0005I1-\u00198IC:$G.\u001a\u000b\u0003S2\u0004\"a\u00156\n\u0005-$&a\u0002\"p_2,\u0017M\u001c\u0005\u0006[\n\u0001\rA\\\u0001\u0004kJd\u0007CA8t\u001d\t\u0001\u0018\u000f\u0005\u0002\\)&\u0011!\u000fV\u0001\u0007!J,G-\u001a4\n\u0005Q,(AB*ue&twM\u0003\u0002s)\u0006)C-[:uS:\u001cG/\u00168tkB\u0004xN\u001d;fI\u0006;wM]3hCR,g)\u001e8di&|gn]\u000b\u0002qB!\u0011P`A\u0001\u001b\u0005Q(BA>}\u0003%IW.\\;uC\ndWM\u0003\u0002~)\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005}T(aA*fiB!\u00111AA\u0007\u001b\t\t)A\u0003\u0003\u0002\b\u0005%\u0011\u0001\u00027b]\u001eT!!a\u0003\u0002\t)\fg/Y\u0005\u0004i\u0006\u0015\u0011A\n3jgRLgn\u0019;V]N,\b\u000f]8si\u0016$\u0017iZ4sK\u001e\fG/\u001a$v]\u000e$\u0018n\u001c8tA\u0005Y2/\u001e9q_J$X\rZ!hOJ,w-\u0019;f\rVt7\r^5p]N\fAd];qa>\u0014H/\u001a3BO\u001e\u0014XmZ1uK\u001a+hn\u0019;j_:\u001c\b%\u0001\ntkB\u0004xN\u001d;fI\u001a+hn\u0019;j_:\u001c\u0018aE:vaB|'\u000f^3e\rVt7\r^5p]N\u0004\u0013aE5t'V\u0004\bo\u001c:uK\u00124UO\\2uS>tGcA5\u0002\u001e!1\u0011qD\u0005A\u00029\f\u0001BZ;oG:\u000bW.Z\u0001\u001aSN|%M[3di:{GOR8v]\u0012,\u0005pY3qi&|g\u000eF\u0002j\u0003KAq!a\n\u000b\u0001\u0004\tI#A\u0001f!\u0011\tY#a\f\u000e\u0005\u00055\"b\u0001\u001f\u0002\n%!\u0011\u0011GA\u0017\u00051\u0019\u0016\u000bT#yG\u0016\u0004H/[8o\u00055!%IM*R\u0019\n+\u0018\u000e\u001c3feN\u00191\"a\u000e\u0011\t\u0005e\u00121H\u0007\u0002\u0001%\u0019\u0011QH$\u0003\u001d)#%iQ*R\u0019\n+\u0018\u000e\u001c3feR\u0011\u0011\u0011\t\t\u0004\u0003sY\u0011A\u0006<jg&$\u0018iZ4sK\u001e\fG/\u001a$v]\u000e$\u0018n\u001c8\u0015\u000f9\f9%!\u0013\u0002N!1\u0011qD\u0007A\u00029Da!a\u0013\u000e\u0001\u0004I\u0017AC5t\t&\u001cH/\u001b8di\"9\u0011qJ\u0007A\u0002\u0005E\u0013AB5oaV$8\u000f\u0005\u0003T\u0003'r\u0017bAA+)\n)\u0011I\u001d:bs\u0006\u0019B-[1mK\u000e$h)\u001e8di&|gNT1nKR\u0019a.a\u0017\t\r\u0005}a\u00021\u0001o\u0003E\u0019w.\u001c9jY\u0016,\u0005\u0010\u001d:fgNLwN\u001c\u000b\u0005\u0003C\n9\u0007\u0005\u0003T\u0003Gr\u0017bAA3)\n1q\n\u001d;j_:Dq!!\u001b\u0010\u0001\u0004\tY'\u0001\u0003fqB\u0014\b\u0003BA7\u0003oj!!a\u001c\u000b\t\u0005E\u00141O\u0001\fKb\u0004(/Z:tS>t7OC\u0002\u0002vm\n\u0011bY8o]\u0016\u001cGo\u001c:\n\t\u0005e\u0014q\u000e\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017\u0001D2p[BLG.\u001a,bYV,G\u0003BA@\u0003\u000b\u00032aUAA\u0013\r\t\u0019\t\u0016\u0002\u0004\u0003:L\bbBAD!\u0001\u0007\u0011qP\u0001\u0006m\u0006dW/Z\u0001\u0010O\u0016$8)\u0019;bYf\u001cH\u000fV=qKRQ\u0011QRAN\u0003K\u000bI+!,\u0011\u000bM\u000b\u0019'a$\u0011\t\u0005E\u0015qS\u0007\u0003\u0003'S1!!&<\u0003\u0015!\u0018\u0010]3t\u0013\u0011\tI*a%\u0003\u0011\u0011\u000bG/\u0019+za\u0016Dq!!(\u0012\u0001\u0004\ty*A\u0004tc2$\u0016\u0010]3\u0011\u0007M\u000b\t+C\u0002\u0002$R\u00131!\u00138u\u0011\u0019\t9+\u0005a\u0001]\u0006AA/\u001f9f\u001d\u0006lW\rC\u0004\u0002,F\u0001\r!a(\u0002\tML'0\u001a\u0005\b\u0003_\u000b\u0002\u0019AAY\u0003\tiG\r\u0005\u0003\u0002\u0012\u0006M\u0016\u0002BA[\u0003'\u0013q\"T3uC\u0012\fG/\u0019\"vS2$WM]\u0001\fO\u0016$(\n\u0012\"D)f\u0004X\r\u0006\u0003\u0002<\u0006\r\u0007#B*\u0002d\u0005u\u0006c\u0001$\u0002@&\u0019\u0011\u0011Y\u001d\u0003\u0011)#'m\u0019+za\u0016Dq!!2\u0013\u0001\u0004\ty)\u0001\u0002ei\u0006A\u0012n]\"bg\u000e\fG-\u001b8h)J,hnY1uKR\u000b'\r\\3\u0015\u0005\u0005-\u0007\u0003B*\u0002d%\fq#[:Ts:$\u0018\r_#se>\u0014()Z:u\u000b\u001a4wN\u001d;\u0015\u0007%\f\t\u000eC\u0004\u0002TR\u0001\r!!\u000b\u0002\u0013\u0015D8-\u001a9uS>t\u0017\u0001E4fiR\u0013XO\\2bi\u0016\fV/\u001a:z)\u0015q\u0017\u0011\\Ao\u0011\u0019\tY.\u0006a\u0001]\u0006)A/\u00192mK\"I\u0011q\\\u000b\u0011\u0002\u0003\u0007\u00111Z\u0001\bG\u0006\u001c8-\u00193f\u0003i9W\r\u001e+sk:\u001c\u0017\r^3Rk\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t)O\u000b\u0003\u0002L\u0006\u001d8FAAu!\u0011\tY/!>\u000e\u0005\u00055(\u0002BAx\u0003c\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005MH+\u0001\u0006b]:|G/\u0019;j_:LA!a>\u0002n\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u0017I,g.Y7f)\u0006\u0014G.\u001a\u000b\u0006]\u0006u(Q\u0002\u0005\b\u0003\u007f<\u0002\u0019\u0001B\u0001\u0003!yG\u000e\u001a+bE2,\u0007\u0003\u0002B\u0002\u0005\u0013i!A!\u0002\u000b\t\t\u001d\u00111O\u0001\bG\u0006$\u0018\r\\8h\u0013\u0011\u0011YA!\u0002\u0003\u0015%#WM\u001c;jM&,'\u000fC\u0004\u0003\u0010]\u0001\rA!\u0001\u0002\u00119,w\u000fV1cY\u0016\f\u0001dZ3u+B$\u0017\r^3D_2,XN\u001c+za\u0016\fV/\u001a:z)\u001dq'Q\u0003B\r\u0005;AaAa\u0006\u0019\u0001\u0004q\u0017!\u0003;bE2,g*Y7f\u0011\u0019\u0011Y\u0002\u0007a\u0001]\u0006Q1m\u001c7v[:t\u0015-\\3\t\r\t}\u0001\u00041\u0001o\u0003-qWm\u001e#bi\u0006$\u0016\u0010]3\u0002?\u001d,G/\u00169eCR,7i\u001c7v[:tU\u000f\u001c7bE&d\u0017\u000e^=Rk\u0016\u0014\u0018\u0010F\u0004o\u0005K\u00119C!\u000b\t\r\t]\u0011\u00041\u0001o\u0011\u0019\u0011Y\"\u0007a\u0001]\"1!1F\rA\u0002%\f!\"[:Ok2d\u0017M\u00197f\u0003a\u0011X-\\8wKN\u001b\u0007.Z7b\u0007>lW.\u001a8u#V,'/\u001f\u000b\u0004]\nE\u0002B\u0002B\u001a5\u0001\u0007a.\u0001\u0004tG\",W.Y\u0001\u0012G2\f7o]5gs\u0016C8-\u001a9uS>tG\u0003\u0004B\u001d\u0005\u001b\u0012yEa\u0015\u0003^\t\u0005$C\u0002B\u001e\u0005\u007f\u0011)E\u0002\u0004\u0003>\u0001\u0001!\u0011\b\u0002\ryI,g-\u001b8f[\u0016tGO\u0010\t\u00043\n\u0005\u0013b\u0001B\"G\nIA\u000b\u001b:po\u0006\u0014G.\u001a\t\u0005\u0005\u000f\u0012I%D\u0001>\u0013\r\u0011Y%\u0010\u0002\u000f'B\f'o\u001b+ie><\u0018M\u00197f\u0011\u001d\t9c\u0007a\u0001\u0005\u007fAaA!\u0015\u001c\u0001\u0004q\u0017!C2p]\u0012LG/[8o\u0011\u001d\u0011)f\u0007a\u0001\u0005/\n\u0011#\\3tg\u0006<W\rU1sC6,G/\u001a:t!\u0015y'\u0011\f8o\u0013\r\u0011Y&\u001e\u0002\u0004\u001b\u0006\u0004\bB\u0002B07\u0001\u0007a.A\u0006eKN\u001c'/\u001b9uS>t\u0007B\u0002B27\u0001\u0007\u0011.A\u0005jgJ+h\u000e^5nK\u0006QAM]8q'\u000eDW-\\1\u0015\u000b9\u0014IGa\u001b\t\r\tMB\u00041\u0001o\u0011\u0019\ty\u000e\ba\u0001S\u0006qq-\u001a;MS6LGo\u00117bkN,Gc\u00018\u0003r!9!1O\u000fA\u0002\tU\u0014!\u00027j[&$\b\u0003BA\u0002\u0005oJAA!\u001f\u0002\u0006\t9\u0011J\u001c;fO\u0016\u0014\u0018aD4fi>3gm]3u\u00072\fWo]3\u0015\u00079\u0014y\bC\u0004\u0003\u0002z\u0001\rA!\u001e\u0002\r=4gm]3u\u0005I!%IM*R\u0019F+XM]=Ck&dG-\u001a:\u0014\u0007}\u00119\tE\u0002G\u0005\u0013K1Aa#:\u0005MQEMY2T#2\u000bV/\u001a:z\u0005VLG\u000eZ3s\u0003\u001d!\u0017.\u00197fGR\fqa\u001c9uS>t7\u000f\u0005\u0003\u0003\u0014\n}UB\u0001BK\u0015\rQ$q\u0013\u0006\u0005\u00053\u0013Y*A\u0006eCR\f7o\\;sG\u0016\u001c(b\u0001BOw\u0005IQ\r_3dkRLwN\\\u0005\u0005\u0005C\u0013)JA\u0006K\t\n\u001bu\n\u001d;j_:\u001cHC\u0002BS\u0005O\u0013I\u000bE\u0002\u0002:}AaA!$#\u0001\u0004)\u0005b\u0002BHE\u0001\u0007!\u0011S\u0001\u0006EVLG\u000e\u001a\u000b\u0002]\u00061r-\u001a;KI\n\u001c7+\u0015'Rk\u0016\u0014\u0018PQ;jY\u0012,'\u000f\u0006\u0003\u0003\b\nM\u0006b\u0002BHI\u0001\u0007!\u0011S\u0001\u000egV\u0004\bo\u001c:ug2KW.\u001b;\u0016\u0003%\fab];qa>\u0014Ho](gMN,G/\u0001\u0003d_BL\u0018!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\u0002\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011qT\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tyH!3\t\u0013\t-'&!AA\u0002\u0005}\u0015a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003RB1!1\u001bBk\u0003\u007fj\u0011\u0001`\u0005\u0004\u0005/d(\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2!\u001bBo\u0011%\u0011Y\rLA\u0001\u0002\u0004\ty(\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA\u0001\u0005GD\u0011Ba3.\u0003\u0003\u0005\r!a(\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a(\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u0001\u0002\r\u0015\fX/\u00197t)\rI'\u0011\u001f\u0005\n\u0005\u0017\u0004\u0014\u0011!a\u0001\u0003\u007f\n!\u0002\u0012\"3\t&\fG.Z2u!\t1%gE\u00033\u0005s\u001c)\u0001E\u0003\u0003|\u000e\u0005a-\u0004\u0002\u0003~*\u0019!q +\u0002\u000fI,h\u000e^5nK&!11\u0001B\u007f\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g\u000e\r\t\u0005\u0007\u000f\u0019i!\u0004\u0002\u0004\n)!11BA\u0005\u0003\tIw.C\u0002c\u0007\u0013!\"A!>\u0002\u000b\u0005\u0004\b\u000f\\=\u0002\u000fUt\u0017\r\u001d9msR\u0019\u0011na\u0006\t\u0011\rea'!AA\u0002\u0019\f1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0019y\u0002\u0005\u0003\u0002\u0004\r\u0005\u0012\u0002BB\u0012\u0003\u000b\u0011aa\u00142kK\u000e$\b")
public class DB2Dialect
extends JdbcDialect
implements SQLConfHelper,
NoLegacyJDBCError,
Product {
    private final Set<String> org$apache$spark$sql$jdbc$DB2Dialect$$distinctUnsupportedAggregateFunctions;
    private final Set<String> supportedAggregateFunctions;
    private final Set<String> supportedFunctions;

    public static boolean unapply(DB2Dialect x$0) {
        return DB2Dialect$.MODULE$.unapply(x$0);
    }

    public static DB2Dialect apply() {
        return DB2Dialect$.MODULE$.apply();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:db2");
    }

    public Set<String> org$apache$spark$sql$jdbc$DB2Dialect$$distinctUnsupportedAggregateFunctions() {
        return this.org$apache$spark$sql$jdbc$DB2Dialect$$distinctUnsupportedAggregateFunctions;
    }

    private Set<String> supportedAggregateFunctions() {
        return this.supportedAggregateFunctions;
    }

    private Set<String> supportedFunctions() {
        return this.supportedFunctions;
    }

    @Override
    public boolean isSupportedFunction(String funcName) {
        return this.supportedFunctions().contains((Object)funcName);
    }

    @Override
    public boolean isObjectNotFoundException(SQLException e) {
        return e.getErrorCode() == -204;
    }

    @Override
    public Option<String> compileExpression(Expression expr) {
        Some some;
        DB2SQLBuilder db2SQLBuilder = new DB2SQLBuilder(this);
        try {
            some = new Some((Object)db2SQLBuilder.build(expr));
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Error occurs while compiling V2 expression", throwable2);
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    @Override
    public Object compileValue(Object value) {
        Object object = value;
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.byteArrayOps(byArray), (Function1 & Serializable)x$1 -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%02X"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)x$1))})), ClassTag$.MODULE$.apply(String.class))).mkString("BLOB(X'", "", "')");
        }
        return super.compileValue(object);
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        int n = sqlType;
        switch (n) {
            case 5: {
                if (this.conf().legacyDB2numericMappingEnabled()) break;
                return Option$.MODULE$.apply((Object)ShortType$.MODULE$);
            }
            case 7: {
                return Option$.MODULE$.apply((Object)FloatType$.MODULE$);
            }
            case 1111: {
                String string = typeName;
                switch (string == null ? 0 : string.hashCode()) {
                    case 87031: {
                        if (!"XML".equals(string)) break;
                        return Option$.MODULE$.apply((Object)StringType$.MODULE$);
                    }
                    case 1345372058: {
                        if (!"DECFLOAT".equals(string)) break;
                        return Option$.MODULE$.apply((Object)new DecimalType(38, 18));
                    }
                }
                if (string.startsWith("TIMESTAMP")) {
                    return Option$.MODULE$.apply((Object)TimestampType$.MODULE$);
                }
                return None$.MODULE$;
            }
        }
        return None$.MODULE$;
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        boolean bl = false;
        DataType dataType = null;
        DataType dataType2 = dt;
        if (StringType$.MODULE$.equals(dataType2)) {
            return Option$.MODULE$.apply((Object)new JdbcType("CLOB", 2005));
        }
        if (BooleanType$.MODULE$.equals(dataType2)) {
            bl = true;
            dataType = dataType2;
            if (this.conf().legacyDB2BooleanMappingEnabled()) {
                return Option$.MODULE$.apply((Object)new JdbcType("CHAR(1)", 1));
            }
        }
        if (bl) {
            return Option$.MODULE$.apply((Object)new JdbcType("BOOLEAN", 16));
        }
        if (ShortType$.MODULE$.equals(dataType2) ? true : ByteType$.MODULE$.equals(dataType2)) {
            return new Some((Object)new JdbcType("SMALLINT", 5));
        }
        return None$.MODULE$;
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public boolean isSyntaxErrorBestEffort(SQLException exception) {
        return Option$.MODULE$.apply((Object)exception.getSQLState()).exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.startsWith("42")));
    }

    @Override
    public String getTruncateQuery(String table, Option<Object> cascade) {
        return "TRUNCATE TABLE " + table + " IMMEDIATE";
    }

    @Override
    public Option<Object> getTruncateQuery$default$2() {
        return this.isCascadingTruncateTable();
    }

    @Override
    public String renameTable(Identifier oldTable, Identifier newTable) {
        return "RENAME TABLE " + this.getFullyQualifiedQuotedTableName(oldTable) + " TO " + this.getFullyQualifiedQuotedTableName(newTable);
    }

    @Override
    public String getUpdateColumnTypeQuery(String tableName, String columnName, String newDataType) {
        return "ALTER TABLE " + tableName + " ALTER COLUMN " + this.quoteIdentifier(columnName) + " SET DATA TYPE " + newDataType;
    }

    @Override
    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        String nullable = isNullable ? "DROP NOT NULL" : "SET NOT NULL";
        return "ALTER TABLE " + tableName + " ALTER COLUMN " + this.quoteIdentifier(columnName) + " " + nullable;
    }

    @Override
    public String removeSchemaCommentQuery(String schema) {
        return "COMMENT ON SCHEMA " + this.quoteIdentifier(schema) + " IS ''";
    }

    @Override
    public Throwable classifyException(Throwable e, String condition, Map<String, String> messageParameters, String description, boolean isRuntime) {
        Throwable throwable = e;
        if (throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            String string = sQLException.getSQLState();
            switch (string == null ? 0 : string.hashCode()) {
                case 49567064: {
                    if (!"42710".equals(string)) break;
                    String string2 = condition;
                    String string3 = "FAILED_JDBC.RENAME_TABLE";
                    if (string2 != null ? !string2.equals(string3) : string3 != null) break;
                    String newTable = (String)messageParameters.apply((Object)"newName");
                    throw QueryCompilationErrors$.MODULE$.tableAlreadyExistsError(newTable);
                }
                case 49568276: {
                    if (!"42893".equals(string)) break;
                    throw new NonEmptyNamespaceException((String[])Option$.MODULE$.option2Iterable(messageParameters.get((Object)"namespace")).toArray(ClassTag$.MODULE$.apply(String.class)), sQLException.getMessage(), (Option)new Some((Object)e));
                }
            }
            return NoLegacyJDBCError.classifyException$(this, e, condition, messageParameters, description, isRuntime);
        }
        return NoLegacyJDBCError.classifyException$(this, e, condition, messageParameters, description, isRuntime);
    }

    @Override
    public String dropSchema(String schema, boolean cascade) {
        if (cascade) {
            return "DROP SCHEMA " + this.quoteIdentifier(schema) + " CASCADE";
        }
        return "DROP SCHEMA " + this.quoteIdentifier(schema) + " RESTRICT";
    }

    @Override
    public String getLimitClause(Integer limit) {
        if (Predef$.MODULE$.Integer2int(limit) > 0) {
            return "FETCH FIRST " + limit + " ROWS ONLY";
        }
        return "";
    }

    @Override
    public String getOffsetClause(Integer offset) {
        if (Predef$.MODULE$.Integer2int(offset) > 0) {
            return "OFFSET " + offset + " ROWS";
        }
        return "";
    }

    @Override
    public JdbcSQLQueryBuilder getJdbcSQLQueryBuilder(JDBCOptions options) {
        return new DB2SQLQueryBuilder(this, this, options);
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsOffset() {
        return true;
    }

    public DB2Dialect copy() {
        return new DB2Dialect();
    }

    public String productPrefix() {
        return "DB2Dialect";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DB2Dialect;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean equals(Object x$1) {
        Object object = x$1;
        return object instanceof DB2Dialect && ((DB2Dialect)x$1).canEqual(this);
    }

    public DB2Dialect() {
        SQLConfHelper.$init$((SQLConfHelper)this);
        NoLegacyJDBCError.$init$(this);
        Product.$init$((Product)this);
        this.org$apache$spark$sql$jdbc$DB2Dialect$$distinctUnsupportedAggregateFunctions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"COVAR_POP", "COVAR_SAMP", "REGR_INTERCEPT", "REGR_R2", "REGR_SLOPE", "REGR_SXY"}));
        this.supportedAggregateFunctions = (Set)((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"MAX", "MIN", "SUM", "COUNT", "AVG", "VAR_POP", "VAR_SAMP", "STDDEV_POP", "STDDEV_SAMP"}))).$plus$plus(this.org$apache$spark$sql$jdbc$DB2Dialect$$distinctUnsupportedAggregateFunctions());
        this.supportedFunctions = this.supportedAggregateFunctions();
    }

    public class DB2SQLBuilder
    extends JdbcDialect.JDBCSQLBuilder {
        @Override
        public String visitAggregateFunction(String funcName, boolean isDistinct, String[] inputs) {
            if (isDistinct && this.org$apache$spark$sql$jdbc$DB2Dialect$DB2SQLBuilder$$$outer().org$apache$spark$sql$jdbc$DB2Dialect$$distinctUnsupportedAggregateFunctions().contains((Object)funcName)) {
                throw new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_3184", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"class"), (Object)this.getClass().getSimpleName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"funcName"), (Object)funcName)})));
            }
            return super.visitAggregateFunction(funcName, isDistinct, inputs);
        }

        @Override
        public String dialectFunctionName(String funcName) {
            String string = funcName;
            switch (string == null ? 0 : string.hashCode()) {
                case -1782591723: {
                    if (!"COVAR_SAMP".equals(string)) break;
                    return "COVARIANCE_SAMP";
                }
                case -446106967: {
                    if (!"VAR_SAMP".equals(string)) break;
                    return "VARIANCE_SAMP";
                }
                case -102600828: {
                    if (!"STDDEV_POP".equals(string)) break;
                    return "STDDEV";
                }
                case 358136589: {
                    if (!"COVAR_POP".equals(string)) break;
                    return "COVARIANCE";
                }
                case 955438329: {
                    if (!"VAR_POP".equals(string)) break;
                    return "VARIANCE";
                }
                case 1114417534: {
                    if (!"STDDEV_SAMP".equals(string)) break;
                    return "STDDEV_SAMP";
                }
            }
            return super.dialectFunctionName(funcName);
        }

        public /* synthetic */ DB2Dialect org$apache$spark$sql$jdbc$DB2Dialect$DB2SQLBuilder$$$outer() {
            return (DB2Dialect)this.$outer;
        }

        public DB2SQLBuilder(DB2Dialect $outer) {
            super($outer);
        }
    }

    public class DB2SQLQueryBuilder
    extends JdbcSQLQueryBuilder {
        private final JdbcDialect dialect;
        private final JDBCOptions options;
        public final /* synthetic */ DB2Dialect $outer;

        @Override
        public String build() {
            String limitClause = this.dialect.getLimitClause(Predef$.MODULE$.int2Integer(this.limit()));
            String offsetClause = this.dialect.getOffsetClause(Predef$.MODULE$.int2Integer(this.offset()));
            return this.options.prepareQuery() + "SELECT " + this.columnList() + " FROM " + this.options.tableOrQuery() + " " + this.whereClause() + " " + this.groupByClause() + " " + this.orderByClause() + " " + offsetClause + " " + limitClause;
        }

        public /* synthetic */ DB2Dialect org$apache$spark$sql$jdbc$DB2Dialect$DB2SQLQueryBuilder$$$outer() {
            return this.$outer;
        }

        public DB2SQLQueryBuilder(DB2Dialect $outer, JdbcDialect dialect, JDBCOptions options) {
            this.dialect = dialect;
            this.options = options;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(dialect, options);
        }
    }
}

