/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.serialization;

import java.util.Locale;
import org.apache.flume.Context;
import org.apache.flume.FlumeException;
import org.apache.flume.annotations.InterfaceAudience;
import org.apache.flume.annotations.InterfaceStability;
import org.apache.flume.serialization.EventDeserializer;
import org.apache.flume.serialization.EventDeserializerType;
import org.apache.flume.serialization.ResettableInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spark-project.guava.base.Preconditions;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class EventDeserializerFactory {
    private static final Logger logger = LoggerFactory.getLogger(EventDeserializerFactory.class);

    public static EventDeserializer getInstance(String deserializerType, Context context, ResettableInputStream in) {
        EventDeserializer.Builder builder;
        EventDeserializerType type;
        Preconditions.checkNotNull((Object)deserializerType, (Object)"serializer type must not be null");
        try {
            type = EventDeserializerType.valueOf(deserializerType.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            logger.debug("Not in enum, loading builder class: {}", (Object)deserializerType);
            type = EventDeserializerType.OTHER;
        }
        Class<EventDeserializer.Builder> builderClass = type.getBuilderClass();
        if (builderClass == null) {
            try {
                Class<?> c = Class.forName(deserializerType);
                if (c == null || !EventDeserializer.Builder.class.isAssignableFrom(c)) {
                    String errMessage = "Unable to instantiate Builder from " + deserializerType + ": does not appear to implement " + EventDeserializer.Builder.class.getName();
                    throw new FlumeException(errMessage);
                }
                builderClass = c;
            }
            catch (ClassNotFoundException ex) {
                logger.error("Class not found: " + deserializerType, (Throwable)ex);
                throw new FlumeException(ex);
            }
        }
        try {
            builder = builderClass.newInstance();
        }
        catch (InstantiationException ex) {
            String errMessage = "Cannot instantiate builder: " + deserializerType;
            logger.error(errMessage, (Throwable)ex);
            throw new FlumeException(errMessage, ex);
        }
        catch (IllegalAccessException ex) {
            String errMessage = "Cannot instantiate builder: " + deserializerType;
            logger.error(errMessage, (Throwable)ex);
            throw new FlumeException(errMessage, ex);
        }
        return builder.build(context, in);
    }
}

