/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.client.avro;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedList;
import java.util.List;
import org.apache.flume.Event;
import org.apache.flume.annotations.InterfaceAudience;
import org.apache.flume.annotations.InterfaceStability;
import org.apache.flume.client.avro.EventReader;
import org.apache.flume.event.EventBuilder;
import org.spark-project.guava.base.Charsets;
import org.spark-project.guava.collect.Lists;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class SimpleTextLineEventReader
implements EventReader {
    private final BufferedReader reader;

    public SimpleTextLineEventReader(Reader in) {
        this.reader = new BufferedReader(in);
    }

    @Override
    public Event readEvent() throws IOException {
        String line = this.reader.readLine();
        if (line != null) {
            return EventBuilder.withBody(line, Charsets.UTF_8);
        }
        return null;
    }

    @Override
    public List<Event> readEvents(int n) throws IOException {
        Event event;
        LinkedList events = Lists.newLinkedList();
        while (events.size() < n && (event = this.readEvent()) != null) {
            events.add(event);
        }
        return events;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

