/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.instrumentation.util;

import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spark-project.guava.base.Throwables;
import org.spark-project.guava.collect.Maps;

public class JMXPollUtil {
    private static Logger LOG = LoggerFactory.getLogger(JMXPollUtil.class);
    private static MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();

    public static Map<String, Map<String, String>> getAllMBeans() {
        HashMap mbeanMap = Maps.newHashMap();
        Set<ObjectInstance> queryMBeans = null;
        try {
            queryMBeans = mbeanServer.queryMBeans(null, null);
        }
        catch (Exception ex) {
            LOG.error("Could not get Mbeans for monitoring", (Throwable)ex);
            Throwables.propagate((Throwable)ex);
        }
        for (ObjectInstance obj : queryMBeans) {
            try {
                if (!obj.getObjectName().toString().startsWith("org.apache.flume")) continue;
                MBeanAttributeInfo[] attrs = mbeanServer.getMBeanInfo(obj.getObjectName()).getAttributes();
                String[] strAtts = new String[attrs.length];
                for (int i = 0; i < strAtts.length; ++i) {
                    strAtts[i] = attrs[i].getName();
                }
                AttributeList attrList = mbeanServer.getAttributes(obj.getObjectName(), strAtts);
                String component = obj.getObjectName().toString().substring(obj.getObjectName().toString().indexOf(61) + 1);
                HashMap attrMap = Maps.newHashMap();
                for (Object attr : attrList) {
                    Attribute localAttr = (Attribute)attr;
                    if (localAttr.getName().equalsIgnoreCase("type")) {
                        component = localAttr.getValue() + "." + component;
                    }
                    attrMap.put(localAttr.getName(), localAttr.getValue().toString());
                }
                mbeanMap.put(component, attrMap);
            }
            catch (Exception e) {
                LOG.error("Unable to poll JMX for metrics.", (Throwable)e);
            }
        }
        return mbeanMap;
    }
}

