/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.source;

import org.apache.flume.Context;
import org.apache.flume.FlumeException;
import org.apache.flume.Source;
import org.apache.flume.annotations.InterfaceAudience;
import org.apache.flume.annotations.InterfaceStability;
import org.apache.flume.channel.ChannelProcessor;
import org.apache.flume.conf.Configurable;
import org.apache.flume.lifecycle.LifecycleState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spark-project.guava.base.Preconditions;
import org.spark-project.guava.base.Throwables;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class BasicSourceSemantics
implements Source,
Configurable {
    private static final Logger logger = LoggerFactory.getLogger(BasicSourceSemantics.class);
    private Exception exception;
    private ChannelProcessor channelProcessor;
    private String name;
    private LifecycleState lifecycleState = LifecycleState.IDLE;

    @Override
    public synchronized void configure(Context context) {
        if (this.isStarted()) {
            throw new IllegalStateException("Configure called when started");
        }
        try {
            this.exception = null;
            this.setLifecycleState(LifecycleState.IDLE);
            this.doConfigure(context);
        }
        catch (Exception e) {
            this.exception = e;
            this.setLifecycleState(LifecycleState.ERROR);
            Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public synchronized void start() {
        if (this.exception != null) {
            logger.error(String.format("Cannot start due to error: name = %s", this.getName()), (Throwable)this.exception);
        } else {
            try {
                Preconditions.checkState((this.channelProcessor != null ? 1 : 0) != 0, (Object)"No channel processor configured");
                this.doStart();
                this.setLifecycleState(LifecycleState.START);
            }
            catch (Exception e) {
                logger.error(String.format("Unexpected error performing start: name = %s", this.getName()), (Throwable)e);
                this.exception = e;
                this.setLifecycleState(LifecycleState.ERROR);
            }
        }
    }

    @Override
    public synchronized void stop() {
        try {
            this.doStop();
            this.setLifecycleState(LifecycleState.STOP);
        }
        catch (Exception e) {
            logger.error(String.format("Unexpected error performing stop: name = %s", this.getName()), (Throwable)e);
            this.setLifecycleState(LifecycleState.ERROR);
        }
    }

    @Override
    public synchronized void setChannelProcessor(ChannelProcessor cp) {
        this.channelProcessor = cp;
    }

    @Override
    public synchronized ChannelProcessor getChannelProcessor() {
        return this.channelProcessor;
    }

    @Override
    public synchronized void setName(String name) {
        this.name = name;
    }

    @Override
    public synchronized String getName() {
        return this.name;
    }

    @Override
    public synchronized LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String toString() {
        return this.getClass().getName() + "{name:" + this.name + ",state:" + (Object)((Object)this.lifecycleState) + "}";
    }

    protected boolean isStarted() {
        return this.getLifecycleState() == LifecycleState.START;
    }

    protected Exception getStartException() {
        return this.exception;
    }

    protected synchronized void setLifecycleState(LifecycleState lifecycleState) {
        this.lifecycleState = lifecycleState;
    }

    protected abstract void doConfigure(Context var1) throws FlumeException;

    protected abstract void doStart() throws FlumeException;

    protected abstract void doStop() throws FlumeException;
}

