/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.flume.sink;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.flume.Channel;
import org.apache.spark.streaming.flume.sink.EventBatch;
import org.apache.spark.streaming.flume.sink.Logging;
import org.apache.spark.streaming.flume.sink.Logging$class;
import org.apache.spark.streaming.flume.sink.SparkFlumeProtocol;
import org.apache.spark.streaming.flume.sink.SparkSinkEvent;
import org.apache.spark.streaming.flume.sink.SparkSinkThreadFactory;
import org.apache.spark.streaming.flume.sink.SparkSinkUtils$;
import org.apache.spark.streaming.flume.sink.TransactionProcessor;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005-f!B\u0001\u0003\u0001\u0011q!\u0001G*qCJ\\\u0017I\u001e:p\u0007\u0006dGNY1dW\"\u000bg\u000e\u001a7fe*\u00111\u0001B\u0001\u0005g&t7N\u0003\u0002\u0006\r\u0005)a\r\\;nK*\u0011q\u0001C\u0001\ngR\u0014X-Y7j]\u001eT!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\n\u0005\u0001=92\u0004\u0005\u0002\u0011+5\t\u0011C\u0003\u0002\u0013'\u0005!A.\u00198h\u0015\u0005!\u0012\u0001\u00026bm\u0006L!AF\t\u0003\r=\u0013'.Z2u!\tA\u0012$D\u0001\u0003\u0013\tQ\"A\u0001\nTa\u0006\u00148N\u00127v[\u0016\u0004&o\u001c;pG>d\u0007C\u0001\r\u001d\u0013\ti\"AA\u0004M_\u001e<\u0017N\\4\t\u0011}\u0001!Q1A\u0005\u0002\u0005\nq\u0001\u001e5sK\u0006$7o\u0001\u0001\u0016\u0003\t\u0002\"a\t\u0014\u000e\u0003\u0011R\u0011!J\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0011\u00121!\u00138u\u0011!I\u0003A!A!\u0002\u0013\u0011\u0013\u0001\u0003;ie\u0016\fGm\u001d\u0011\t\u0011-\u0002!Q1A\u0005\u00021\nqa\u00195b]:,G.F\u0001.!\tq\u0003'D\u00010\u0015\t)!\"\u0003\u00022_\t91\t[1o]\u0016d\u0007\u0002C\u001a\u0001\u0005\u0003\u0005\u000b\u0011B\u0017\u0002\u0011\rD\u0017M\u001c8fY\u0002B\u0001\"\u000e\u0001\u0003\u0006\u0004%\t!I\u0001\u0013iJ\fgn]1di&|g\u000eV5nK>,H\u000f\u0003\u00058\u0001\t\u0005\t\u0015!\u0003#\u0003M!(/\u00198tC\u000e$\u0018n\u001c8US6,w.\u001e;!\u0011!I\u0004A!b\u0001\n\u0003\t\u0013a\u00042bG.|eMZ%oi\u0016\u0014h/\u00197\t\u0011m\u0002!\u0011!Q\u0001\n\t\n\u0001CY1dW>3g-\u00138uKJ4\u0018\r\u001c\u0011\t\u000bu\u0002A\u0011\u0001 \u0002\rqJg.\u001b;?)\u0015y\u0004)\u0011\"D!\tA\u0002\u0001C\u0003 y\u0001\u0007!\u0005C\u0003,y\u0001\u0007Q\u0006C\u00036y\u0001\u0007!\u0005C\u0003:y\u0001\u0007!\u0005C\u0004F\u0001\t\u0007I\u0011\u0001$\u0002-Q\u0014\u0018M\\:bGRLwN\\#yK\u000e,Ho\u001c:PaR,\u0012a\u0012\t\u0004G!S\u0015BA%%\u0005\u0019y\u0005\u000f^5p]B\u00111\nU\u0007\u0002\u0019*\u0011QJT\u0001\u000bG>t7-\u001e:sK:$(BA(\u0014\u0003\u0011)H/\u001b7\n\u0005Ec%aD#yK\u000e,Ho\u001c:TKJ4\u0018nY3\t\rM\u0003\u0001\u0015!\u0003H\u0003]!(/\u00198tC\u000e$\u0018n\u001c8Fq\u0016\u001cW\u000f^8s\u001fB$\b\u0005C\u0004V\u0001\t\u0007I\u0011\u0002,\u00023M,\u0017/^3oG\u0016tU/\u001c2feR{\u0007K]8dKN\u001cxN]\u000b\u0002/B!\u0001,X0c\u001b\u0005I&B\u0001.\\\u0003\u001diW\u000f^1cY\u0016T!\u0001\u0018\u0013\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002_3\n9\u0001*Y:i\u001b\u0006\u0004\bC\u0001\ta\u0013\t\t\u0017C\u0001\u0007DQ\u0006\u00148+Z9vK:\u001cW\r\u0005\u0002\u0019G&\u0011AM\u0001\u0002\u0015)J\fgn]1di&|g\u000e\u0015:pG\u0016\u001c8o\u001c:\t\r\u0019\u0004\u0001\u0015!\u0003X\u0003i\u0019X-];f]\u000e,g*^7cKJ$v\u000e\u0015:pG\u0016\u001c8o\u001c:!\u0011\u001dA\u0007A1A\u0005\n%\fqa]3r\u0005\u0006\u001cX-F\u0001k!\t\u00012.\u0003\u0002m#\t11\u000b\u001e:j]\u001eDaA\u001c\u0001!\u0002\u0013Q\u0017\u0001C:fc\n\u000b7/\u001a\u0011\t\u000fA\u0004!\u0019!C\u0005c\u0006Q1/Z9D_VtG/\u001a:\u0016\u0003I\u0004\"a\u001d<\u000e\u0003QT!!\u001e'\u0002\r\u0005$x.\\5d\u0013\t9HO\u0001\u0006Bi>l\u0017n\u0019'p]\u001eDa!\u001f\u0001!\u0002\u0013\u0011\u0018aC:fc\u000e{WO\u001c;fe\u0002Bqa\u001f\u0001A\u0002\u0013%A0A\u0004ti>\u0004\b/\u001a3\u0016\u0003u\u0004\"a\t@\n\u0005}$#a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003\u0007\u0001\u0001\u0019!C\u0005\u0003\u000b\t1b\u001d;paB,Gm\u0018\u0013fcR!\u0011qAA\u0007!\r\u0019\u0013\u0011B\u0005\u0004\u0003\u0017!#\u0001B+oSRD\u0011\"a\u0004\u0002\u0002\u0005\u0005\t\u0019A?\u0002\u0007a$\u0013\u0007C\u0004\u0002\u0014\u0001\u0001\u000b\u0015B?\u0002\u0011M$x\u000e\u001d9fI\u0002B\u0001\"a\u0006\u0001\u0001\u0004%I\u0001`\u0001\u0007SN$Vm\u001d;\t\u0013\u0005m\u0001\u00011A\u0005\n\u0005u\u0011AC5t)\u0016\u001cHo\u0018\u0013fcR!\u0011qAA\u0010\u0011%\ty!!\u0007\u0002\u0002\u0003\u0007Q\u0010C\u0004\u0002$\u0001\u0001\u000b\u0015B?\u0002\u000f%\u001cH+Z:uA!\"\u0011\u0011EA\u0014!\r\u0019\u0013\u0011F\u0005\u0004\u0003W!#\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u0013\u0005=\u0002\u00011A\u0005\n\u0005E\u0012!\u0003;fgRd\u0015\r^2i+\t\t\u0019\u0004E\u0002L\u0003kI1!a\u000eM\u00059\u0019u.\u001e8u\t><h\u000eT1uG\"D\u0011\"a\u000f\u0001\u0001\u0004%I!!\u0010\u0002\u001bQ,7\u000f\u001e'bi\u000eDw\fJ3r)\u0011\t9!a\u0010\t\u0015\u0005=\u0011\u0011HA\u0001\u0002\u0004\t\u0019\u0004\u0003\u0005\u0002D\u0001\u0001\u000b\u0015BA\u001a\u0003)!Xm\u001d;MCR\u001c\u0007\u000e\t\u0005\b\u0003\u000f\u0002A\u0011IA%\u000359W\r^#wK:$()\u0019;dQR!\u00111JA)!\rA\u0012QJ\u0005\u0004\u0003\u001f\u0012!AC#wK:$()\u0019;dQ\"9\u00111KA#\u0001\u0004\u0011\u0013!\u00018\t\u000f\u0005]\u0003\u0001\"\u0003\u0002Z\u0005y1M]3bi\u0016\u0004&o\\2fgN|'\u000f\u0006\u0004\u0002\\\u0005u\u0013Q\u000e\t\u0004G!\u0013\u0007\u0002CA0\u0003+\u0002\r!!\u0019\u0002\u0007M,\u0017\u000f\u0005\u0003\u0002d\u0005%dbA\u0012\u0002f%\u0019\u0011q\r\u0013\u0002\rA\u0013X\rZ3g\u0013\ra\u00171\u000e\u0006\u0004\u0003O\"\u0003bBA*\u0003+\u0002\rA\t\u0005\b\u0003c\u0002A\u0011IA:\u0003\r\t7m\u001b\u000b\u0005\u0003k\nY\bE\u0002\u0011\u0003oJ1!!\u001f\u0012\u0005\u00111v.\u001b3\t\u000f\u0005u\u0014q\u000ea\u0001?\u0006q1/Z9vK:\u001cWMT;nE\u0016\u0014\bbBAA\u0001\u0011\u0005\u00131Q\u0001\u0005]\u0006\u001c7\u000e\u0006\u0003\u0002v\u0005\u0015\u0005bBA?\u0003\u007f\u0002\ra\u0018\u0005\b\u0003\u0013\u0003A\u0011BAF\u0003M\u0019w.\u001c9mKR,GK]1og\u0006\u001cG/[8o)\u0019\t9!!$\u0002\u0010\"9\u0011QPAD\u0001\u0004y\u0006bBAI\u0003\u000f\u0003\r!`\u0001\bgV\u001c7-Z:t\u0011!\t)\n\u0001C\u0001\u0005\u0005]\u0015!\u0006:f[>4X-\u00118e\u000f\u0016$\bK]8dKN\u001cxN\u001d\u000b\u0005\u00037\nI\nC\u0004\u0002~\u0005M\u0005\u0019A0\t\u0011\u0005u\u0005\u0001\"\u0001\u0003\u0003?\u000bqcY8v]R$un\u001e8XQ\u0016t')\u0019;dQ\u0006\u001b7.\u001a3\u0015\t\u0005\u001d\u0011\u0011\u0015\u0005\t\u0003G\u000bY\n1\u0001\u00024\u0005)A.\u0019;dQ\"9\u0011q\u0015\u0001\u0005\u0002\u0005%\u0016\u0001C:ikR$wn\u001e8\u0015\u0005\u0005\u001d\u0001")
public class SparkAvroCallbackHandler
implements SparkFlumeProtocol,
Logging {
    private final int threads;
    private final Channel channel;
    private final int transactionTimeout;
    private final int backOffInterval;
    private final Option<ExecutorService> transactionExecutorOpt;
    private final HashMap<CharSequence, TransactionProcessor> sequenceNumberToProcessor;
    private final String seqBase;
    private final AtomicLong seqCounter;
    private boolean stopped;
    private volatile boolean isTest;
    private CountDownLatch testLatch;
    private transient Logger org$apache$spark$streaming$flume$sink$Logging$$log_;

    @Override
    public Logger org$apache$spark$streaming$flume$sink$Logging$$log_() {
        return this.org$apache$spark$streaming$flume$sink$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$streaming$flume$sink$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$streaming$flume$sink$Logging$$log_ = x$1;
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    public int threads() {
        return this.threads;
    }

    public Channel channel() {
        return this.channel;
    }

    public int transactionTimeout() {
        return this.transactionTimeout;
    }

    public int backOffInterval() {
        return this.backOffInterval;
    }

    public Option<ExecutorService> transactionExecutorOpt() {
        return this.transactionExecutorOpt;
    }

    private HashMap<CharSequence, TransactionProcessor> sequenceNumberToProcessor() {
        return this.sequenceNumberToProcessor;
    }

    private String seqBase() {
        return this.seqBase;
    }

    private AtomicLong seqCounter() {
        return this.seqCounter;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    private boolean isTest() {
        return this.isTest;
    }

    private void isTest_$eq(boolean x$1) {
        this.isTest = x$1;
    }

    private CountDownLatch testLatch() {
        return this.testLatch;
    }

    private void testLatch_$eq(CountDownLatch x$1) {
        this.testLatch = x$1;
    }

    @Override
    public EventBatch getEventBatch(int n) {
        Option<TransactionProcessor> option;
        block6: {
            EventBatch eventBatch;
            block5: {
                block4: {
                    this.logDebug((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Got getEventBatch call from Spark.";
                        }
                    });
                    String sequenceNumber = new StringBuilder().append((Object)this.seqBase()).append((Object)BoxesRunTime.boxToLong((long)this.seqCounter().incrementAndGet())).toString();
                    option = this.createProcessor(sequenceNumber, n);
                    if (!(option instanceof Some)) break block4;
                    Some some = (Some)option;
                    TransactionProcessor processor = (TransactionProcessor)some.x();
                    this.transactionExecutorOpt().foreach((Function1)new Serializable(this, processor){
                        public static final long serialVersionUID = 0L;
                        private final TransactionProcessor processor$1;

                        public final Future<Void> apply(ExecutorService x$1) {
                            return x$1.submit(this.processor$1);
                        }
                        {
                            this.processor$1 = processor$1;
                        }
                    });
                    EventBatch batch = processor.getEventBatch();
                    if (SparkSinkUtils$.MODULE$.isErrorBatch(batch)) {
                        this.removeAndGetProcessor(sequenceNumber);
                        this.logWarning((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Received an error batch - no events were received from channel! ";
                            }
                        });
                    }
                    eventBatch = batch;
                    break block5;
                }
                if (!None$.MODULE$.equals(option)) break block6;
                eventBatch = new EventBatch("Spark sink has been stopped!", "", Collections.<SparkSinkEvent>emptyList());
            }
            return eventBatch;
        }
        throw new MatchError(option);
    }

    private Option<TransactionProcessor> createProcessor(String seq, int n) {
        HashMap<CharSequence, TransactionProcessor> hashMap = this.sequenceNumberToProcessor();
        synchronized (hashMap) {
            None$ none$;
            if (this.stopped()) {
                none$ = None$.MODULE$;
            } else {
                TransactionProcessor processor = new TransactionProcessor(this.channel(), seq, n, this.transactionTimeout(), this.backOffInterval(), this);
                this.sequenceNumberToProcessor().put((Object)seq, (Object)processor);
                if (this.isTest()) {
                    processor.countDownWhenBatchAcked(this.testLatch());
                }
                none$ = new Some((Object)processor);
            }
            None$ none$2 = none$;
            return (Option)none$2;
        }
    }

    @Override
    public Void ack(CharSequence sequenceNumber) {
        this.logDebug((Function0<String>)new Serializable(this, sequenceNumber){
            public static final long serialVersionUID = 0L;
            private final CharSequence sequenceNumber$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Received Ack for batch with sequence number: ").append((Object)this.sequenceNumber$1).toString();
            }
            {
                this.sequenceNumber$1 = sequenceNumber$1;
            }
        });
        this.completeTransaction(sequenceNumber, true);
        return null;
    }

    @Override
    public Void nack(CharSequence sequenceNumber) {
        this.completeTransaction(sequenceNumber, false);
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Spark failed to commit transaction. Will reattempt events.";
            }
        });
        return null;
    }

    private void completeTransaction(CharSequence sequenceNumber, boolean success) {
        this.removeAndGetProcessor(sequenceNumber).foreach((Function1)new Serializable(this, success){
            public static final long serialVersionUID = 0L;
            private final boolean success$1;

            public final void apply(TransactionProcessor processor) {
                processor.batchProcessed(this.success$1);
            }
            {
                this.success$1 = success$1;
            }
        });
    }

    public Option<TransactionProcessor> removeAndGetProcessor(CharSequence sequenceNumber) {
        HashMap<CharSequence, TransactionProcessor> hashMap = this.sequenceNumberToProcessor();
        synchronized (hashMap) {
            Option option = this.sequenceNumberToProcessor().remove((Object)((Object)sequenceNumber).toString());
            return option;
        }
    }

    public void countDownWhenBatchAcked(CountDownLatch latch) {
        this.testLatch_$eq(latch);
        this.isTest_$eq(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown() {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Shutting down Spark Avro Callback Handler";
            }
        });
        HashMap<CharSequence, TransactionProcessor> hashMap = this.sequenceNumberToProcessor();
        synchronized (hashMap) {
            this.stopped_$eq(true);
            this.sequenceNumberToProcessor().values().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(TransactionProcessor x$2) {
                    x$2.shutdown();
                }
            });
        }
        this.transactionExecutorOpt().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final List<Runnable> apply(ExecutorService x$3) {
                return x$3.shutdownNow();
            }
        });
    }

    public SparkAvroCallbackHandler(int threads, Channel channel, int transactionTimeout, int backOffInterval) {
        this.threads = threads;
        this.channel = channel;
        this.transactionTimeout = transactionTimeout;
        this.backOffInterval = backOffInterval;
        Logging$class.$init$(this);
        this.transactionExecutorOpt = Option$.MODULE$.apply((Object)Executors.newFixedThreadPool(threads, new SparkSinkThreadFactory("Spark Sink Processor Thread - %d")));
        this.sequenceNumberToProcessor = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.seqBase = UUID.randomUUID().toString().substring(0, 8);
        this.seqCounter = new AtomicLong(0L);
        this.stopped = false;
        this.isTest = false;
        this.testLatch = null;
    }
}

