/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink;

import org.apache.flume.Channel;
import org.apache.flume.Context;
import org.apache.flume.CounterGroup;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.Sink;
import org.apache.flume.Transaction;
import org.apache.flume.conf.Configurable;
import org.apache.flume.sink.AbstractSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spark_project.guava.base.Preconditions;

public class NullSink
extends AbstractSink
implements Configurable {
    private static final Logger logger = LoggerFactory.getLogger(NullSink.class);
    private static final int DFLT_BATCH_SIZE = 100;
    private static final int DFLT_LOG_EVERY_N_EVENTS = 10000;
    private CounterGroup counterGroup = new CounterGroup();
    private int batchSize = 100;
    private int logEveryNEvents = 10000;

    @Override
    public void configure(Context context) {
        this.batchSize = context.getInteger("batchSize", 100);
        logger.debug(this.getName() + " " + "batch size set to " + String.valueOf(this.batchSize));
        Preconditions.checkArgument((this.batchSize > 0 ? 1 : 0) != 0, (Object)"Batch size must be > 0");
        this.logEveryNEvents = context.getInteger("logEveryNEvents", 10000);
        logger.debug(this.getName() + " " + "log event N events set to " + this.logEveryNEvents);
        Preconditions.checkArgument((this.logEveryNEvents > 0 ? 1 : 0) != 0, (Object)"logEveryNEvents must be > 0");
    }

    @Override
    public Sink.Status process() throws EventDeliveryException {
        Sink.Status status = Sink.Status.READY;
        Channel channel = this.getChannel();
        Transaction transaction = channel.getTransaction();
        Event event = null;
        long eventCounter = this.counterGroup.get("events.success");
        try {
            transaction.begin();
            int i = 0;
            for (i = 0; i < this.batchSize; ++i) {
                event = channel.take();
                if (++eventCounter % (long)this.logEveryNEvents == 0L) {
                    logger.info("Null sink {} successful processed {} events.", (Object)this.getName(), (Object)eventCounter);
                }
                if (event != null) continue;
                status = Sink.Status.BACKOFF;
                break;
            }
            transaction.commit();
            this.counterGroup.addAndGet("events.success", Long.valueOf(Math.min(this.batchSize, i)));
            this.counterGroup.incrementAndGet("transaction.success");
        }
        catch (Exception ex) {
            transaction.rollback();
            this.counterGroup.incrementAndGet("transaction.failed");
            logger.error("Failed to deliver event. Exception follows.", (Throwable)ex);
            throw new EventDeliveryException("Failed to deliver event: " + event, ex);
        }
        finally {
            transaction.close();
        }
        return status;
    }

    @Override
    public void start() {
        logger.info("Starting {}...", (Object)this);
        this.counterGroup.setName(this.getName());
        super.start();
        logger.info("Null sink {} started.", (Object)this.getName());
    }

    @Override
    public void stop() {
        logger.info("Null sink {} stopping...", (Object)this.getName());
        super.stop();
        logger.info("Null sink {} stopped. Event metrics: {}", (Object)this.getName(), (Object)this.counterGroup);
    }

    @Override
    public String toString() {
        return "NullSink " + this.getName() + " { batchSize: " + this.batchSize + " }";
    }
}

