/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.flume.sink;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.flume.Channel;
import org.apache.spark.streaming.flume.sink.EventBatch;
import org.apache.spark.streaming.flume.sink.Logging;
import org.apache.spark.streaming.flume.sink.Logging$class;
import org.apache.spark.streaming.flume.sink.SparkFlumeProtocol;
import org.apache.spark.streaming.flume.sink.SparkSinkEvent;
import org.apache.spark.streaming.flume.sink.SparkSinkUtils$;
import org.apache.spark.streaming.flume.sink.TransactionProcessor;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.Some;
import scala.collection.JavaConversions$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005=d!B\u0001\u0003\u0001\u0011q!\u0001G*qCJ\\\u0017I\u001e:p\u0007\u0006dGNY1dW\"\u000bg\u000e\u001a7fe*\u00111\u0001B\u0001\u0005g&t7N\u0003\u0002\u0006\r\u0005)a\r\\;nK*\u0011q\u0001C\u0001\ngR\u0014X-Y7j]\u001eT!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\n\u0005\u0001=92\u0004\u0005\u0002\u0011+5\t\u0011C\u0003\u0002\u0013'\u0005!A.\u00198h\u0015\u0005!\u0012\u0001\u00026bm\u0006L!AF\t\u0003\r=\u0013'.Z2u!\tA\u0012$D\u0001\u0003\u0013\tQ\"A\u0001\nTa\u0006\u00148N\u00127v[\u0016\u0004&o\u001c;pG>d\u0007C\u0001\r\u001d\u0013\ti\"AA\u0004M_\u001e<\u0017N\\4\t\u0011}\u0001!Q1A\u0005\u0002\u0005\nq\u0001\u001e5sK\u0006$7o\u0001\u0001\u0016\u0003\t\u0002\"a\t\u0014\u000e\u0003\u0011R\u0011!J\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0011\u00121!\u00138u\u0011!I\u0003A!A!\u0002\u0013\u0011\u0013\u0001\u0003;ie\u0016\fGm\u001d\u0011\t\u0011-\u0002!Q1A\u0005\u00021\nqa\u00195b]:,G.F\u0001.!\tq\u0003'D\u00010\u0015\t)!\"\u0003\u00022_\t91\t[1o]\u0016d\u0007\u0002C\u001a\u0001\u0005\u0003\u0005\u000b\u0011B\u0017\u0002\u0011\rD\u0017M\u001c8fY\u0002B\u0001\"\u000e\u0001\u0003\u0006\u0004%\t!I\u0001\u0013iJ\fgn]1di&|g\u000eV5nK>,H\u000f\u0003\u00058\u0001\t\u0005\t\u0015!\u0003#\u0003M!(/\u00198tC\u000e$\u0018n\u001c8US6,w.\u001e;!\u0011!I\u0004A!b\u0001\n\u0003\t\u0013a\u00042bG.|eMZ%oi\u0016\u0014h/\u00197\t\u0011m\u0002!\u0011!Q\u0001\n\t\n\u0001CY1dW>3g-\u00138uKJ4\u0018\r\u001c\u0011\t\u000bu\u0002A\u0011\u0001 \u0002\rqJg.\u001b;?)\u0015y\u0004)\u0011\"D!\tA\u0002\u0001C\u0003 y\u0001\u0007!\u0005C\u0003,y\u0001\u0007Q\u0006C\u00036y\u0001\u0007!\u0005C\u0003:y\u0001\u0007!\u0005C\u0004F\u0001\t\u0007I\u0011\u0001$\u0002-Q\u0014\u0018M\\:bGRLwN\\#yK\u000e,Ho\u001c:PaR,\u0012a\u0012\t\u0004G!S\u0015BA%%\u0005\u0019y\u0005\u000f^5p]B\u00111\nU\u0007\u0002\u0019*\u0011QJT\u0001\u000bG>t7-\u001e:sK:$(BA(\u0014\u0003\u0011)H/\u001b7\n\u0005Ec%aD#yK\u000e,Ho\u001c:TKJ4\u0018nY3\t\rM\u0003\u0001\u0015!\u0003H\u0003]!(/\u00198tC\u000e$\u0018n\u001c8Fq\u0016\u001cW\u000f^8s\u001fB$\b\u0005C\u0004V\u0001\t\u0007I\u0011\u0002,\u00023M,\u0017/^3oG\u0016tU/\u001c2feR{\u0007K]8dKN\u001cxN]\u000b\u0002/B!1\n\u0017.^\u0013\tIFJA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCB\u0004\"\u0001E.\n\u0005q\u000b\"\u0001D\"iCJ\u001cV-];f]\u000e,\u0007C\u0001\r_\u0013\ty&A\u0001\u000bUe\u0006t7/Y2uS>t\u0007K]8dKN\u001cxN\u001d\u0005\u0007C\u0002\u0001\u000b\u0011B,\u00025M,\u0017/^3oG\u0016tU/\u001c2feR{\u0007K]8dKN\u001cxN\u001d\u0011\t\u000f\r\u0004!\u0019!C\u0005I\u000691/Z9CCN,W#A3\u0011\u0005A1\u0017BA4\u0012\u0005\u0019\u0019FO]5oO\"1\u0011\u000e\u0001Q\u0001\n\u0015\f\u0001b]3r\u0005\u0006\u001cX\r\t\u0005\bW\u0002\u0011\r\u0011\"\u0003m\u0003)\u0019X-]\"pk:$XM]\u000b\u0002[B\u0011a.]\u0007\u0002_*\u0011\u0001\u000fT\u0001\u0007CR|W.[2\n\u0005I|'AC!u_6L7\rT8oO\"1A\u000f\u0001Q\u0001\n5\f1b]3r\u0007>,h\u000e^3sA!)a\u000f\u0001C!o\u0006iq-\u001a;Fm\u0016tGOQ1uG\"$\"\u0001_>\u0011\u0005aI\u0018B\u0001>\u0003\u0005))e/\u001a8u\u0005\u0006$8\r\u001b\u0005\u0006yV\u0004\rAI\u0001\u0002]\")a\u0010\u0001C\u0005\u007f\u0006y1M]3bi\u0016\u0004&o\\2fgN|'\u000f\u0006\u0004\u0002\u0002\u0005\r\u00111\u0003\t\u0004G!k\u0006bBA\u0003{\u0002\u0007\u0011qA\u0001\u0004g\u0016\f\b\u0003BA\u0005\u0003\u001fq1aIA\u0006\u0013\r\ti\u0001J\u0001\u0007!J,G-\u001a4\n\u0007\u001d\f\tBC\u0002\u0002\u000e\u0011BQ\u0001`?A\u0002\tBq!a\u0006\u0001\t\u0003\nI\"A\u0002bG.$B!a\u0007\u0002\"A\u0019\u0001#!\b\n\u0007\u0005}\u0011C\u0001\u0003W_&$\u0007bBA\u0012\u0003+\u0001\rAW\u0001\u000fg\u0016\fX/\u001a8dK:+XNY3s\u0011\u001d\t9\u0003\u0001C!\u0003S\tAA\\1dWR!\u00111DA\u0016\u0011\u001d\t\u0019#!\nA\u0002iCq!a\f\u0001\t\u0013\t\t$A\nd_6\u0004H.\u001a;f)J\fgn]1di&|g\u000e\u0006\u0004\u00024\u0005e\u00121\b\t\u0004G\u0005U\u0012bAA\u001cI\t!QK\\5u\u0011\u001d\t\u0019#!\fA\u0002iC\u0001\"!\u0010\u0002.\u0001\u0007\u0011qH\u0001\bgV\u001c7-Z:t!\r\u0019\u0013\u0011I\u0005\u0004\u0003\u0007\"#a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003\u000f\u0002A\u0011\u0001\u0002\u0002J\u0005)\"/Z7pm\u0016\fe\u000eZ$fiB\u0013xnY3tg>\u0014HcA/\u0002L!9\u00111EA#\u0001\u0004Q\u0006bBA(\u0001\u0011\u0005\u0011\u0011K\u0001\tg\",H\u000fZ8x]R\u0011\u00111\u0007\u0005\n\u0003+\u0002\u0001\u0019!C\u0005\u0003/\nqa\u001d;paB,G-\u0006\u0002\u0002@!I\u00111\f\u0001A\u0002\u0013%\u0011QL\u0001\fgR|\u0007\u000f]3e?\u0012*\u0017\u000f\u0006\u0003\u00024\u0005}\u0003BCA1\u00033\n\t\u00111\u0001\u0002@\u0005\u0019\u0001\u0010J\u0019\t\u0011\u0005\u0015\u0004\u0001)Q\u0005\u0003\u007f\t\u0001b\u001d;paB,G\r\t\u0015\u0005\u0003G\nI\u0007E\u0002$\u0003WJ1!!\u001c%\u0005!1x\u000e\\1uS2,\u0007")
public class SparkAvroCallbackHandler
implements SparkFlumeProtocol,
Logging {
    private final int threads;
    private final Channel channel;
    private final int transactionTimeout;
    private final int backOffInterval;
    private final Option<ExecutorService> transactionExecutorOpt;
    private final ConcurrentHashMap<CharSequence, TransactionProcessor> sequenceNumberToProcessor;
    private final String seqBase;
    private final AtomicLong seqCounter;
    private volatile boolean stopped;
    private transient Logger org$apache$spark$streaming$flume$sink$Logging$$log_;

    @Override
    public Logger org$apache$spark$streaming$flume$sink$Logging$$log_() {
        return this.org$apache$spark$streaming$flume$sink$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$streaming$flume$sink$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$streaming$flume$sink$Logging$$log_ = x$1;
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    public int threads() {
        return this.threads;
    }

    public Channel channel() {
        return this.channel;
    }

    public int transactionTimeout() {
        return this.transactionTimeout;
    }

    public int backOffInterval() {
        return this.backOffInterval;
    }

    public Option<ExecutorService> transactionExecutorOpt() {
        return this.transactionExecutorOpt;
    }

    private ConcurrentHashMap<CharSequence, TransactionProcessor> sequenceNumberToProcessor() {
        return this.sequenceNumberToProcessor;
    }

    private String seqBase() {
        return this.seqBase;
    }

    private AtomicLong seqCounter() {
        return this.seqCounter;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    @Override
    public EventBatch getEventBatch(int n) {
        Option<TransactionProcessor> option;
        block6: {
            EventBatch eventBatch;
            block5: {
                block4: {
                    this.logDebug((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Got getEventBatch call from Spark.";
                        }
                    });
                    String sequenceNumber = new StringBuilder().append((Object)this.seqBase()).append((Object)BoxesRunTime.boxToLong((long)this.seqCounter().incrementAndGet())).toString();
                    option = this.createProcessor(sequenceNumber, n);
                    if (!(option instanceof Some)) break block4;
                    Some some = (Some)option;
                    TransactionProcessor processor = (TransactionProcessor)some.x();
                    this.transactionExecutorOpt().foreach((Function1)new Serializable(this, processor){
                        public static final long serialVersionUID = 0L;
                        private final TransactionProcessor processor$1;

                        public final Future<Void> apply(ExecutorService x$1) {
                            return x$1.submit(this.processor$1);
                        }
                        {
                            this.processor$1 = processor$1;
                        }
                    });
                    EventBatch batch = processor.getEventBatch();
                    if (SparkSinkUtils$.MODULE$.isErrorBatch(batch)) {
                        this.removeAndGetProcessor(sequenceNumber);
                        this.logWarning((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Received an error batch - no events were received from channel! ";
                            }
                        });
                    }
                    eventBatch = batch;
                    break block5;
                }
                None$ none$ = None$.MODULE$;
                Option<TransactionProcessor> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block6;
                eventBatch = new EventBatch("Spark sink has been stopped!", "", Collections.<SparkSinkEvent>emptyList());
            }
            return eventBatch;
        }
        throw new MatchError(option);
    }

    private Option<TransactionProcessor> createProcessor(String seq, int n) {
        ConcurrentHashMap<CharSequence, TransactionProcessor> concurrentHashMap = this.sequenceNumberToProcessor();
        synchronized (concurrentHashMap) {
            None$ none$;
            if (this.stopped()) {
                none$ = None$.MODULE$;
            } else {
                TransactionProcessor processor = new TransactionProcessor(this.channel(), seq, n, this.transactionTimeout(), this.backOffInterval(), this);
                this.sequenceNumberToProcessor().put(seq, processor);
                none$ = new Some((Object)processor);
            }
            None$ none$2 = none$;
            return (Option)none$2;
        }
    }

    @Override
    public Void ack(CharSequence sequenceNumber) {
        this.logDebug((Function0<String>)new Serializable(this, sequenceNumber){
            public static final long serialVersionUID = 0L;
            private final CharSequence sequenceNumber$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Received Ack for batch with sequence number: ").append((Object)this.sequenceNumber$1).toString();
            }
            {
                this.sequenceNumber$1 = sequenceNumber$1;
            }
        });
        this.completeTransaction(sequenceNumber, true);
        return null;
    }

    @Override
    public Void nack(CharSequence sequenceNumber) {
        this.completeTransaction(sequenceNumber, false);
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Spark failed to commit transaction. Will reattempt events.";
            }
        });
        return null;
    }

    private void completeTransaction(CharSequence sequenceNumber, boolean success) {
        Option$.MODULE$.apply((Object)this.removeAndGetProcessor(sequenceNumber)).foreach((Function1)new Serializable(this, success){
            public static final long serialVersionUID = 0L;
            private final boolean success$1;

            public final void apply(TransactionProcessor processor) {
                processor.batchProcessed(this.success$1);
            }
            {
                this.success$1 = success$1;
            }
        });
    }

    public TransactionProcessor removeAndGetProcessor(CharSequence sequenceNumber) {
        ConcurrentHashMap<CharSequence, TransactionProcessor> concurrentHashMap = this.sequenceNumberToProcessor();
        synchronized (concurrentHashMap) {
            TransactionProcessor transactionProcessor = this.sequenceNumberToProcessor().remove(((Object)sequenceNumber).toString());
            return transactionProcessor;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown() {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Shutting down Spark Avro Callback Handler";
            }
        });
        ConcurrentHashMap<CharSequence, TransactionProcessor> concurrentHashMap = this.sequenceNumberToProcessor();
        synchronized (concurrentHashMap) {
            this.stopped_$eq(true);
            JavaConversions$.MODULE$.collectionAsScalaIterable(this.sequenceNumberToProcessor().values()).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(TransactionProcessor x$2) {
                    x$2.shutdown();
                }
            });
        }
        this.transactionExecutorOpt().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final List<Runnable> apply(ExecutorService x$3) {
                return x$3.shutdownNow();
            }
        });
    }

    public SparkAvroCallbackHandler(int threads, Channel channel, int transactionTimeout, int backOffInterval) {
        this.threads = threads;
        this.channel = channel;
        this.transactionTimeout = transactionTimeout;
        this.backOffInterval = backOffInterval;
        Logging$class.$init$(this);
        this.transactionExecutorOpt = Option$.MODULE$.apply((Object)Executors.newFixedThreadPool(threads, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Spark Sink Processor Thread - %d").build()));
        this.sequenceNumberToProcessor = new ConcurrentHashMap();
        this.seqBase = RandomStringUtils.randomAlphanumeric((int)8);
        this.seqCounter = new AtomicLong(0L);
        this.stopped = false;
    }
}

