/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.flume;

import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.avro.ipc.NettyTransceiver;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.ipc.specific.SpecificRequestor;
import org.apache.commons.lang3.RandomUtils;
import org.apache.flume.source.avro.AvroFlumeEvent;
import org.apache.flume.source.avro.AvroSourceProtocol;
import org.apache.flume.source.avro.Status;
import org.apache.spark.SparkConf;
import org.apache.spark.util.Utils$;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.socket.SocketChannel;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.handler.codec.compression.ZlibDecoder;
import org.jboss.netty.handler.codec.compression.ZlibEncoder;
import org.spark-project.guava.base.Charsets;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

@ScalaSignature(bytes="\u0006\u0001q4Q!\u0001\u0002\u0001\u00051\u0011aB\u00127v[\u0016$Vm\u001d;Vi&d7O\u0003\u0002\u0004\t\u0005)a\r\\;nK*\u0011QAB\u0001\ngR\u0014X-Y7j]\u001eT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\n\u0003\u00015\u0001\"AD\t\u000e\u0003=Q\u0011\u0001E\u0001\u0006g\u000e\fG.Y\u0005\u0003%=\u0011a!\u00118z%\u00164\u0007\"\u0002\u000b\u0001\t\u00031\u0012A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003]\u0001\"\u0001\u0007\u0001\u000e\u0003\tAqA\u0007\u0001A\u0002\u0013%1$A\u0006ue\u0006t7oY3jm\u0016\u0014X#\u0001\u000f\u0011\u0005u\u0011S\"\u0001\u0010\u000b\u0005}\u0001\u0013aA5qG*\u0011\u0011\u0005C\u0001\u0005CZ\u0014x.\u0003\u0002$=\t\u0001b*\u001a;usR\u0013\u0018M\\:dK&4XM\u001d\u0005\bK\u0001\u0001\r\u0011\"\u0003'\u0003=!(/\u00198tG\u0016Lg/\u001a:`I\u0015\fHCA\u0014+!\tq\u0001&\u0003\u0002*\u001f\t!QK\\5u\u0011\u001dYC%!AA\u0002q\t1\u0001\u001f\u00132\u0011\u0019i\u0003\u0001)Q\u00059\u0005aAO]1og\u000e,\u0017N^3sA!9q\u0006\u0001b\u0001\n\u0013\u0001\u0014\u0001\u0003;fgR\u0004vN\u001d;\u0016\u0003E\u0002\"A\u0004\u001a\n\u0005Mz!aA%oi\"1Q\u0007\u0001Q\u0001\nE\n\u0011\u0002^3tiB{'\u000f\u001e\u0011\t\u000b]\u0002A\u0011\u0001\u001d\u0002\u0017\u001d,G\u000fV3tiB{'\u000f\u001e\u000b\u0002c!)!\b\u0001C\u0005q\u0005aa-\u001b8e\rJ,W\rU8si\")A\b\u0001C\u0001{\u0005QqO]5uK&s\u0007/\u001e;\u0015\u0007\u001drt\nC\u0003@w\u0001\u0007\u0001)A\u0003j]B,H\u000fE\u0002B\r\"k\u0011A\u0011\u0006\u0003\u0007\u0012\u000bA!\u001e;jY*\tQ)\u0001\u0003kCZ\f\u0017BA$C\u0005\u0011a\u0015n\u001d;\u0011\u0005%ceB\u0001\bK\u0013\tYu\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001b:\u0013aa\u0015;sS:<'BA&\u0010\u0011\u0015\u00016\b1\u0001R\u0003E)g.\u00192mK\u000e{W\u000e\u001d:fgNLwN\u001c\t\u0003\u001dIK!aU\b\u0003\u000f\t{w\u000e\\3b]\")Q\u000b\u0001C\u0001-\u0006)1\r\\8tKR\tqE\u0002\u0003Y\u0001\u0011I&!G\"p[B\u0014Xm]:j_:\u001c\u0005.\u00198oK24\u0015m\u0019;pef\u001c\"a\u0016.\u0011\u0005m3W\"\u0001/\u000b\u0005us\u0016a\u00018j_*\u0011q\fY\u0001\u0007g>\u001c7.\u001a;\u000b\u0005\u0005\u0014\u0017aB2iC:tW\r\u001c\u0006\u0003G\u0012\fQA\\3uifT!!\u001a\u0006\u0002\u000b)\u0014wn]:\n\u0005\u001dd&!\b(j_\u000ec\u0017.\u001a8u'>\u001c7.\u001a;DQ\u0006tg.\u001a7GC\u000e$xN]=\t\u0011%<&\u0011!Q\u0001\nE\n\u0001cY8naJ,7o]5p]2+g/\u001a7\t\u000bQ9F\u0011A6\u0015\u00051t\u0007CA7X\u001b\u0005\u0001\u0001\"B5k\u0001\u0004\t\u0004\"\u00029X\t\u0003\n\u0018A\u00038fo\u000eC\u0017M\u001c8fYR\u0011!O\u001e\t\u0003gRl\u0011AX\u0005\u0003kz\u0013QbU8dW\u0016$8\t[1o]\u0016d\u0007\"B<p\u0001\u0004A\u0018\u0001\u00039ja\u0016d\u0017N\\3\u0011\u0005eTX\"\u00011\n\u0005m\u0004'aD\"iC:tW\r\u001c)ja\u0016d\u0017N\\3")
public class FlumeTestUtils {
    private NettyTransceiver transceiver = null;
    private final int testPort = this.findFreePort();

    private NettyTransceiver transceiver() {
        return this.transceiver;
    }

    private void transceiver_$eq(NettyTransceiver x$1) {
        this.transceiver = x$1;
    }

    private int testPort() {
        return this.testPort;
    }

    public int getTestPort() {
        return this.testPort();
    }

    private int findFreePort() {
        int candidatePort = RandomUtils.nextInt((int)1024, (int)65536);
        return Utils$.MODULE$.startServiceOnPort(candidatePort, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Null$, Object> apply(int trialPort) {
                ServerSocket socket = new ServerSocket(trialPort);
                socket.close();
                return new Tuple2(null, (Object)BoxesRunTime.boxToInteger((int)trialPort));
            }
        }, new SparkConf(), Utils$.MODULE$.startServiceOnPort$default$4())._2$mcI$sp();
    }

    public void writeInput(List<String> input, boolean enableCompression) {
        Status status;
        InetSocketAddress testAddress = new InetSocketAddress("localhost", this.testPort());
        Buffer inputEvents = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(input).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             */
            public final AvroFlumeEvent apply(String item) {
                void var2_2;
                AvroFlumeEvent event = new AvroFlumeEvent();
                event.setBody(ByteBuffer.wrap(item.getBytes(Charsets.UTF_8)));
                event.setHeaders(JavaConversions$.MODULE$.mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"test"), (Object)"header")}))));
                return var2_2;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        this.close();
        this.transceiver_$eq(enableCompression ? new NettyTransceiver(testAddress, (ChannelFactory)new CompressionChannelFactory(this, 6)) : new NettyTransceiver(testAddress));
        AvroSourceProtocol client = (AvroSourceProtocol)SpecificRequestor.getClient(AvroSourceProtocol.class, (Transceiver)this.transceiver());
        if (client == null) {
            throw new AssertionError((Object)"Cannot create client");
        }
        Status status2 = status = client.appendBatch(JavaConversions$.MODULE$.seqAsJavaList((Seq)inputEvents.toList()));
        Status status3 = Status.OK;
        if (!(status2 != null ? !status2.equals(status3) : status3 != null)) {
            return;
        }
        throw new AssertionError((Object)"Sent events unsuccessfully");
    }

    public void close() {
        if (this.transceiver() != null) {
            this.transceiver().close();
            this.transceiver_$eq(null);
        }
    }

    public class CompressionChannelFactory
    extends NioClientSocketChannelFactory {
        private final int compressionLevel;
        public final /* synthetic */ FlumeTestUtils $outer;

        public SocketChannel newChannel(ChannelPipeline pipeline) {
            ZlibEncoder encoder = new ZlibEncoder(this.compressionLevel);
            pipeline.addFirst("deflater", (ChannelHandler)encoder);
            pipeline.addFirst("inflater", (ChannelHandler)new ZlibDecoder());
            return super.newChannel(pipeline);
        }

        public /* synthetic */ FlumeTestUtils org$apache$spark$streaming$flume$FlumeTestUtils$CompressionChannelFactory$$$outer() {
            return this.$outer;
        }

        public CompressionChannelFactory(FlumeTestUtils $outer, int compressionLevel) {
            this.compressionLevel = compressionLevel;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }
    }
}

