/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords.impl.pb;

import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class GetApplicationsRequestPBImpl
extends GetApplicationsRequest {
    YarnServiceProtos.GetApplicationsRequestProto proto = YarnServiceProtos.GetApplicationsRequestProto.getDefaultInstance();
    YarnServiceProtos.GetApplicationsRequestProto.Builder builder = null;
    boolean viaProto = false;
    Set<String> applicationTypes = null;
    EnumSet<YarnApplicationState> applicationStates = null;

    public GetApplicationsRequestPBImpl() {
        this.builder = YarnServiceProtos.GetApplicationsRequestProto.newBuilder();
    }

    public GetApplicationsRequestPBImpl(YarnServiceProtos.GetApplicationsRequestProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnServiceProtos.GetApplicationsRequestProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void mergeLocalToBuilder() {
        if (this.applicationTypes != null) {
            this.addLocalApplicationTypesToProto();
        }
        if (this.applicationStates != null) {
            this.maybeInitBuilder();
            this.builder.clearApplicationStates();
            Iterable<YarnProtos.YarnApplicationStateProto> iterable = new Iterable<YarnProtos.YarnApplicationStateProto>(){

                @Override
                public Iterator<YarnProtos.YarnApplicationStateProto> iterator() {
                    return new Iterator<YarnProtos.YarnApplicationStateProto>(){
                        Iterator<YarnApplicationState> iter;
                        {
                            this.iter = GetApplicationsRequestPBImpl.this.applicationStates.iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.iter.hasNext();
                        }

                        @Override
                        public YarnProtos.YarnApplicationStateProto next() {
                            return ProtoUtils.convertToProtoFormat(this.iter.next());
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
            this.builder.addAllApplicationStates((Iterable<? extends YarnProtos.YarnApplicationStateProto>)iterable);
        }
    }

    private void addLocalApplicationTypesToProto() {
        this.maybeInitBuilder();
        this.builder.clearApplicationTypes();
        if (this.applicationTypes == null) {
            return;
        }
        this.builder.addAllApplicationTypes(this.applicationTypes);
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServiceProtos.GetApplicationsRequestProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    private void initApplicationTypes() {
        if (this.applicationTypes != null) {
            return;
        }
        YarnServiceProtos.GetApplicationsRequestProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<String> appTypeList = p.getApplicationTypesList();
        this.applicationTypes = new HashSet<String>();
        this.applicationTypes.addAll(appTypeList);
    }

    private void initApplicationStates() {
        if (this.applicationStates != null) {
            return;
        }
        YarnServiceProtos.GetApplicationsRequestProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.YarnApplicationStateProto> appStatesList = p.getApplicationStatesList();
        this.applicationStates = EnumSet.noneOf(YarnApplicationState.class);
        for (YarnProtos.YarnApplicationStateProto c : appStatesList) {
            this.applicationStates.add(ProtoUtils.convertFromProtoFormat(c));
        }
    }

    @Override
    public Set<String> getApplicationTypes() {
        this.initApplicationTypes();
        return this.applicationTypes;
    }

    @Override
    public void setApplicationTypes(Set<String> applicationTypes) {
        this.maybeInitBuilder();
        if (applicationTypes == null) {
            this.builder.clearApplicationTypes();
        }
        this.applicationTypes = applicationTypes;
    }

    @Override
    public EnumSet<YarnApplicationState> getApplicationStates() {
        this.initApplicationStates();
        return this.applicationStates;
    }

    @Override
    public void setApplicationStates(EnumSet<YarnApplicationState> applicationStates) {
        this.maybeInitBuilder();
        if (applicationStates == null) {
            this.builder.clearApplicationStates();
        }
        this.applicationStates = applicationStates;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((GetApplicationsRequestPBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString((MessageOrBuilder)this.getProto());
    }
}

