/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import kafka.common.KafkaException;
import kafka.message.ByteBufferBackedInputStream;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.CompressionCodec;
import kafka.message.CompressionFactory$;
import kafka.message.InvalidMessageException;
import kafka.message.MagicAndTimestamp;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet$;
import kafka.message.MessageWriter;
import kafka.message.NoCompressionCodec$;
import kafka.message.OffsetAssigner;
import kafka.utils.CoreUtils$;
import kafka.utils.IteratorTemplate;
import org.apache.kafka.common.record.TimestampType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

public final class ByteBufferMessageSet$ {
    public static final ByteBufferMessageSet$ MODULE$;

    static {
        new ByteBufferMessageSet$();
    }

    public ByteBuffer kafka$message$ByteBufferMessageSet$$create(OffsetAssigner offsetAssigner, CompressionCodec compressionCodec, Option<Object> wrapperMessageTimestamp, TimestampType timestampType2, Seq<Message> messages) {
        Option<Object> option;
        block7: {
            ByteBuffer byteBuffer;
            block3: {
                MagicAndTimestamp magicAndTimestamp;
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                if (!messages.isEmpty()) break block2;
                                byteBuffer = MessageSet$.MODULE$.Empty().buffer();
                                break block3;
                            }
                            CompressionCodec compressionCodec2 = compressionCodec;
                            NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
                            if (compressionCodec2 != null ? !compressionCodec2.equals(noCompressionCodec$) : noCompressionCodec$ != null) break block4;
                            ByteBuffer buffer = ByteBuffer.allocate(MessageSet$.MODULE$.messageSetSize((Iterable<Message>)messages));
                            messages.foreach((Function1)new Serializable(offsetAssigner, buffer){
                                public static final long serialVersionUID = 0L;
                                private final OffsetAssigner offsetAssigner$1;
                                private final ByteBuffer buffer$1;

                                public final void apply(Message message) {
                                    ByteBufferMessageSet$.MODULE$.writeMessage(this.buffer$1, message, this.offsetAssigner$1.nextAbsoluteOffset());
                                }
                                {
                                    this.offsetAssigner$1 = offsetAssigner$1;
                                    this.buffer$1 = buffer$1;
                                }
                            });
                            buffer.rewind();
                            byteBuffer = buffer;
                            break block3;
                        }
                        option = wrapperMessageTimestamp;
                        if (!(option instanceof Some)) break block5;
                        Some some = (Some)option;
                        long ts = BoxesRunTime.unboxToLong((Object)some.x());
                        magicAndTimestamp = new MagicAndTimestamp(((Message)messages.head()).magic(), ts);
                        break block6;
                    }
                    None$ none$ = None$.MODULE$;
                    Option<Object> option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block7;
                    magicAndTimestamp = MessageSet$.MODULE$.magicAndLargestTimestamp(messages);
                }
                MagicAndTimestamp magicAndTimestamp2 = magicAndTimestamp;
                LongRef offset = new LongRef(-1L);
                MessageWriter messageWriter = new MessageWriter(package$.MODULE$.min(package$.MODULE$.max(MessageSet$.MODULE$.messageSetSize((Iterable<Message>)messages) / 2, 1024), 65536));
                CompressionCodec x$3 = compressionCodec;
                long x$4 = magicAndTimestamp2.timestamp();
                TimestampType x$5 = timestampType2;
                byte x$6 = magicAndTimestamp2.magic();
                byte[] x$7 = messageWriter.write$default$1();
                Serializable x$8 = new Serializable(offsetAssigner, compressionCodec, messages, magicAndTimestamp2, offset){
                    public static final long serialVersionUID = 0L;
                    public final OffsetAssigner offsetAssigner$1;
                    private final CompressionCodec compressionCodec$1;
                    private final Seq messages$1;
                    public final MagicAndTimestamp magicAndTimestamp$1;
                    public final LongRef offset$1;

                    public final void apply(OutputStream outputStream) {
                        try (DataOutputStream output = new DataOutputStream(CompressionFactory$.MODULE$.apply(this.compressionCodec$1, this.magicAndTimestamp$1.magic(), outputStream));){
                            this.messages$1.foreach((Function1)new Serializable(this, output){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.1 $outer;
                                private final DataOutputStream output$1;

                                public final void apply(Message message) {
                                    this.$outer.offset$1.elem = this.$outer.offsetAssigner$1.nextAbsoluteOffset();
                                    if (message.magic() != this.$outer.magicAndTimestamp$1.magic()) {
                                        throw new IllegalArgumentException("Messages in the message set must have same magic value");
                                    }
                                    if (this.$outer.magicAndTimestamp$1.magic() > Message$.MODULE$.MagicValue_V0()) {
                                        this.output$1.writeLong(this.$outer.offsetAssigner$1.toInnerOffset(this.$outer.offset$1.elem));
                                    } else {
                                        this.output$1.writeLong(this.$outer.offset$1.elem);
                                    }
                                    this.output$1.writeInt(message.size());
                                    this.output$1.write(message.buffer().array(), message.buffer().arrayOffset(), message.buffer().limit());
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.output$1 = output$1;
                                }
                            });
                            return;
                        }
                    }
                    {
                        this.offsetAssigner$1 = offsetAssigner$1;
                        this.compressionCodec$1 = compressionCodec$1;
                        this.messages$1 = messages$1;
                        this.magicAndTimestamp$1 = magicAndTimestamp$1;
                        this.offset$1 = offset$1;
                    }
                };
                messageWriter.write(x$7, x$3, x$4, x$5, x$6, (Function1<OutputStream, BoxedUnit>)x$8);
                ByteBuffer buffer = ByteBuffer.allocate(messageWriter.size() + MessageSet$.MODULE$.LogOverhead());
                this.writeMessage(buffer, messageWriter, offset.elem);
                buffer.rewind();
                byteBuffer = buffer;
            }
            return byteBuffer;
        }
        throw new MatchError(option);
    }

    public Iterator<MessageAndOffset> deepIterator(MessageAndOffset wrapperMessageAndOffset) {
        return new IteratorTemplate<MessageAndOffset>(wrapperMessageAndOffset){
            private final Tuple2<Message, Object> x$1;
            private final Message wrapperMessage;
            private final long wrapperMessageOffset;
            private final Option<Object> wrapperMessageTimestampOpt;
            private final Option<TimestampType> wrapperMessageTimestampTypeOpt;
            private long lastInnerOffset;
            private final ArrayDeque<MessageAndOffset> messageAndOffsets;

            private Message wrapperMessage() {
                return this.wrapperMessage;
            }

            private long wrapperMessageOffset() {
                return this.wrapperMessageOffset;
            }

            private Option<Object> wrapperMessageTimestampOpt() {
                return this.wrapperMessageTimestampOpt;
            }

            private Option<TimestampType> wrapperMessageTimestampTypeOpt() {
                return this.wrapperMessageTimestampTypeOpt;
            }

            private long lastInnerOffset() {
                return this.lastInnerOffset;
            }

            private void lastInnerOffset_$eq(long x$1) {
                this.lastInnerOffset = x$1;
            }

            private ArrayDeque<MessageAndOffset> messageAndOffsets() {
                return this.messageAndOffsets;
            }

            private MessageAndOffset readMessageFromStream(DataInputStream compressed) {
                long innerOffset = compressed.readLong();
                int recordSize = compressed.readInt();
                if (recordSize < Message$.MODULE$.MinMessageOverhead()) {
                    throw new InvalidMessageException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Message found with corrupt size `", "` in deep iterator"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)recordSize)})));
                }
                byte[] bufferArray = new byte[recordSize];
                compressed.readFully(bufferArray, 0, recordSize);
                ByteBuffer buffer = ByteBuffer.wrap(bufferArray);
                Message newMessage = new Message(buffer, this.wrapperMessageTimestampOpt(), this.wrapperMessageTimestampTypeOpt());
                if (newMessage.magic() != this.wrapperMessage().magic()) {
                    throw new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compressed message has magic value ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)this.wrapperMessage().magic())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but inner message has magic value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)newMessage.magic())}))).toString());
                }
                this.lastInnerOffset_$eq(innerOffset);
                return new MessageAndOffset(newMessage, innerOffset);
            }

            public MessageAndOffset makeNext() {
                MessageAndOffset messageAndOffset;
                block7: {
                    MessageAndOffset messageAndOffset2;
                    block6: {
                        MessageAndOffset messageAndOffset3;
                        block5: {
                            messageAndOffset = this.messageAndOffsets().pollFirst();
                            if (messageAndOffset != null) break block5;
                            messageAndOffset2 = (MessageAndOffset)this.allDone();
                            break block6;
                        }
                        if (messageAndOffset == null) break block7;
                        Message message = messageAndOffset.message();
                        long offset = messageAndOffset.offset();
                        if (this.wrapperMessage().magic() > Message$.MODULE$.MagicValue_V0()) {
                            long relativeOffset = offset - this.lastInnerOffset();
                            long absoluteOffset = this.wrapperMessageOffset() + relativeOffset;
                            messageAndOffset3 = new MessageAndOffset(message, absoluteOffset);
                        } else {
                            messageAndOffset3 = messageAndOffset;
                        }
                        messageAndOffset2 = messageAndOffset3;
                    }
                    return messageAndOffset2;
                }
                throw new MatchError((Object)messageAndOffset);
            }

            private final DataInputStream liftedTree1$1(ByteBufferBackedInputStream inputStream$1) {
                try {
                    return new DataInputStream(CompressionFactory$.MODULE$.apply(this.wrapperMessage().compressionCodec(), this.wrapperMessage().magic(), inputStream$1));
                }
                catch (IOException iOException) {
                    throw new InvalidMessageException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to instantiate input stream compressed with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.wrapperMessage().compressionCodec()})), iOException);
                }
            }

            private final void liftedTree2$1(DataInputStream compressed$1, ArrayDeque innerMessageAndOffsets$1) {
                try {
                    try {
                        while (true) {
                            innerMessageAndOffsets$1.add(this.readMessageFromStream(compressed$1));
                        }
                    }
                    catch (IOException iOException) {
                        throw new InvalidMessageException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while reading message from stream compressed with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.wrapperMessage().compressionCodec()})), iOException);
                    }
                    catch (EOFException eOFException) {
                    }
                }
                catch (Throwable throwable) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this, compressed$1){
                        public static final long serialVersionUID = 0L;
                        private final DataInputStream compressed$1;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.compressed$1.close();
                        }
                        {
                            this.compressed$1 = compressed$1;
                        }
                    });
                    throw throwable;
                }
                CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new /* invalid duplicate definition of identical inner class */);
            }
            {
                MessageAndOffset messageAndOffset = wrapperMessageAndOffset$1;
                if (messageAndOffset != null) {
                    Tuple2 tuple2;
                    Message wrapperMessage = messageAndOffset.message();
                    long wrapperMessageOffset = messageAndOffset.offset();
                    this.x$1 = tuple2 = new Tuple2((Object)wrapperMessage, (Object)BoxesRunTime.boxToLong((long)wrapperMessageOffset));
                    this.wrapperMessage = (Message)this.x$1._1();
                    this.wrapperMessageOffset = this.x$1._2$mcJ$sp();
                    if (this.wrapperMessage().payload() == null) {
                        throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Message payload is null: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.wrapperMessage()})));
                    }
                    this.wrapperMessageTimestampOpt = this.wrapperMessage().magic() > Message$.MODULE$.MagicValue_V0() ? new Some((Object)BoxesRunTime.boxToLong((long)this.wrapperMessage().timestamp())) : None$.MODULE$;
                    this.wrapperMessageTimestampTypeOpt = this.wrapperMessage().magic() > Message$.MODULE$.MagicValue_V0() ? new Some((Object)((Object)this.wrapperMessage().timestampType())) : None$.MODULE$;
                    this.lastInnerOffset = -1L;
                    ByteBufferBackedInputStream inputStream = new ByteBufferBackedInputStream(this.wrapperMessage().payload());
                    DataInputStream compressed = this.liftedTree1$1(inputStream);
                    ArrayDeque<E> innerMessageAndOffsets = new ArrayDeque<E>();
                    this.liftedTree2$1(compressed, innerMessageAndOffsets);
                    this.messageAndOffsets = innerMessageAndOffsets;
                    return;
                }
                throw new MatchError((Object)messageAndOffset);
            }
        };
    }

    public void writeMessage(ByteBuffer buffer, Message message, long offset) {
        buffer.putLong(offset);
        buffer.putInt(message.size());
        buffer.put(message.buffer());
        message.buffer().rewind();
    }

    public void writeMessage(ByteBuffer buffer, MessageWriter messageWriter, long offset) {
        buffer.putLong(offset);
        buffer.putInt(messageWriter.size());
        messageWriter.writeTo(buffer);
    }

    private ByteBufferMessageSet$() {
        MODULE$ = this;
    }
}

