/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.factories.impl.pb;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RpcClientFactory;

@InterfaceAudience.Private
public class RpcClientFactoryPBImpl
implements RpcClientFactory {
    private static final Log LOG = LogFactory.getLog(RpcClientFactoryPBImpl.class);
    private static final String PB_IMPL_PACKAGE_SUFFIX = "impl.pb.client";
    private static final String PB_IMPL_CLASS_SUFFIX = "PBClientImpl";
    private static final RpcClientFactoryPBImpl self = new RpcClientFactoryPBImpl();
    private Configuration localConf = new Configuration();
    private ConcurrentMap<Class<?>, Constructor<?>> cache = new ConcurrentHashMap();

    public static RpcClientFactoryPBImpl get() {
        return self;
    }

    private RpcClientFactoryPBImpl() {
    }

    @Override
    public Object getClient(Class<?> protocol, long clientVersion, InetSocketAddress addr, Configuration conf) {
        Constructor constructor = (Constructor)this.cache.get(protocol);
        if (constructor == null) {
            Class pbClazz = null;
            try {
                pbClazz = this.localConf.getClassByName(this.getPBImplClassName(protocol));
            }
            catch (ClassNotFoundException e) {
                throw new YarnRuntimeException("Failed to load class: [" + this.getPBImplClassName(protocol) + "]", e);
            }
            try {
                constructor = pbClazz.getConstructor(Long.TYPE, InetSocketAddress.class, Configuration.class);
                constructor.setAccessible(true);
                this.cache.putIfAbsent(protocol, constructor);
            }
            catch (NoSuchMethodException e) {
                throw new YarnRuntimeException("Could not find constructor with params: " + Long.TYPE + ", " + InetSocketAddress.class + ", " + Configuration.class, e);
            }
        }
        try {
            Object retObject = constructor.newInstance(clientVersion, addr, conf);
            return retObject;
        }
        catch (InvocationTargetException e) {
            throw new YarnRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new YarnRuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new YarnRuntimeException(e);
        }
    }

    @Override
    public void stopClient(Object proxy) {
        try {
            Method closeMethod = proxy.getClass().getMethod("close", new Class[0]);
            closeMethod.invoke(proxy, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new YarnRuntimeException(e);
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot call close method due to Exception. Ignoring.", (Throwable)e);
            throw new YarnRuntimeException(e);
        }
    }

    private String getPBImplClassName(Class<?> clazz) {
        String srcPackagePart = this.getPackageName(clazz);
        String srcClassName = this.getClassName(clazz);
        String destPackagePart = srcPackagePart + "." + PB_IMPL_PACKAGE_SUFFIX;
        String destClassPart = srcClassName + PB_IMPL_CLASS_SUFFIX;
        return destPackagePart + "." + destClassPart;
    }

    private String getClassName(Class<?> clazz) {
        String fqName = clazz.getName();
        return fqName.substring(fqName.lastIndexOf(".") + 1, fqName.length());
    }

    private String getPackageName(Class<?> clazz) {
        return clazz.getPackage().getName();
    }
}

