/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.stats;

import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.avro.Protocol;
import org.apache.avro.ipc.RPCContext;
import org.apache.avro.ipc.stats.FloatHistogram;
import org.apache.avro.ipc.stats.Histogram;
import org.apache.avro.ipc.stats.IntegerHistogram;
import org.apache.avro.ipc.stats.StatsPlugin;
import org.apache.avro.ipc.stats.Stopwatch;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;

public class StatsServlet
extends HttpServlet {
    private final StatsPlugin statsPlugin;
    private VelocityEngine velocityEngine;
    private static final SimpleDateFormat FORMATTER = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");

    public StatsServlet(StatsPlugin statsPlugin) throws UnavailableException {
        this.statsPlugin = statsPlugin;
        this.velocityEngine = new VelocityEngine();
        this.velocityEngine.addProperty("resource.loader", (Object)"class");
        this.velocityEngine.addProperty("class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        this.velocityEngine.setProperty("runtime.references.strict", (Object)true);
        String logChuteName = "org.apache.velocity.runtime.log.NullLogChute";
        this.velocityEngine.setProperty("runtime.log.logsystem.class", (Object)logChuteName);
    }

    protected static List<String> escapeStringArray(List<String> input) {
        for (int i = 0; i < input.size(); ++i) {
            input.set(i, "\"" + input.get(i).replace("\"", "\\\"") + "\"");
        }
        return input;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/html");
        String url = req.getRequestURL().toString();
        String[] parts = url.split("//")[1].split("/");
        try {
            this.writeStats(resp.getWriter());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeStats(Writer w) throws IOException {
        Template template;
        VelocityContext context = new VelocityContext();
        context.put("title", (Object)"Avro RPC Stats");
        ArrayList<String> rpcs = new ArrayList<String>();
        ArrayList<RenderableMessage> messages = new ArrayList<RenderableMessage>();
        for (Map.Entry entry2 : this.statsPlugin.activeRpcs.entrySet()) {
            rpcs.add(this.renderActiveRpc((RPCContext)entry2.getKey(), (Stopwatch)entry2.getValue()));
        }
        Set<Protocol.Message> keys = null;
        Map<Protocol.Message, FloatHistogram<?>> map2 = this.statsPlugin.methodTimings;
        synchronized (map2) {
            keys = this.statsPlugin.methodTimings.keySet();
            for (Protocol.Message m : keys) {
                messages.add(this.renderMethod(m));
            }
        }
        context.put("inFlightRpcs", rpcs);
        context.put("messages", messages);
        context.put("currTime", (Object)FORMATTER.format(new Date()));
        context.put("startupTime", (Object)FORMATTER.format(this.statsPlugin.startupTime));
        try {
            template = this.velocityEngine.getTemplate("org/apache/avro/ipc/stats/templates/statsview.vm");
        }
        catch (ResourceNotFoundException e) {
            throw new IOException();
        }
        catch (ParseErrorException e) {
            throw new IOException();
        }
        catch (Exception e) {
            throw new IOException();
        }
        template.merge((Context)context, w);
    }

    private String renderActiveRpc(RPCContext rpc, Stopwatch stopwatch) throws IOException {
        String out = new String();
        out = out + rpc.getMessage().getName() + ": " + this.formatMillis(StatsPlugin.nanosToMillis(stopwatch.elapsedNanos()));
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RenderableMessage renderMethod(Protocol.Message message) {
        HashMap<String, String> latencyDot;
        HashMap<String, String> latencyBar;
        Histogram hist;
        RenderableMessage out = new RenderableMessage(message.getName());
        Map<Protocol.Message, Histogram> map2 = this.statsPlugin.methodTimings;
        synchronized (map2) {
            hist = this.statsPlugin.methodTimings.get(message);
            out.numCalls = hist.getCount();
            latencyBar = new HashMap<String, String>();
            latencyBar.put("type", "bar");
            latencyBar.put("title", "All-Time Latency");
            latencyBar.put("units", "ms");
            latencyBar.put("numCalls", Integer.toString(hist.getCount()));
            latencyBar.put("avg", Float.toString(((FloatHistogram)hist).getMean()));
            latencyBar.put("stdDev", Float.toString(((FloatHistogram)hist).getUnbiasedStdDev()));
            latencyBar.put("labelStr", Arrays.toString(hist.getSegmenter().getBoundaryLabels().toArray()));
            latencyBar.put("boundaryStr", Arrays.toString(StatsServlet.escapeStringArray(hist.getSegmenter().getBucketLabels()).toArray()));
            latencyBar.put("dataStr", Arrays.toString(hist.getHistogram()));
            out.charts.add(latencyBar);
            latencyDot = new HashMap<String, String>();
            latencyDot.put("title", "Latency");
            latencyDot.put("type", "dot");
            latencyDot.put("dataStr", Arrays.toString(hist.getRecentAdditions().toArray()));
            out.charts.add(latencyDot);
        }
        map2 = this.statsPlugin.sendPayloads;
        synchronized (map2) {
            hist = this.statsPlugin.sendPayloads.get(message);
            latencyBar = new HashMap();
            latencyBar.put("type", "bar");
            latencyBar.put("title", "All-Time Send Payload");
            latencyBar.put("units", "ms");
            latencyBar.put("numCalls", Integer.toString(hist.getCount()));
            latencyBar.put("avg", Float.toString(((IntegerHistogram)hist).getMean()));
            latencyBar.put("stdDev", Float.toString(((IntegerHistogram)hist).getUnbiasedStdDev()));
            latencyBar.put("labelStr", Arrays.toString(hist.getSegmenter().getBoundaryLabels().toArray()));
            latencyBar.put("boundaryStr", Arrays.toString(StatsServlet.escapeStringArray(hist.getSegmenter().getBucketLabels()).toArray()));
            latencyBar.put("dataStr", Arrays.toString(hist.getHistogram()));
            out.charts.add(latencyBar);
            latencyDot = new HashMap();
            latencyDot.put("title", "Send Payload");
            latencyDot.put("type", "dot");
            latencyDot.put("dataStr", Arrays.toString(hist.getRecentAdditions().toArray()));
            out.charts.add(latencyDot);
        }
        map2 = this.statsPlugin.receivePayloads;
        synchronized (map2) {
            hist = this.statsPlugin.receivePayloads.get(message);
            latencyBar = new HashMap();
            latencyBar.put("type", "bar");
            latencyBar.put("title", "All-Time Receive Payload");
            latencyBar.put("units", "ms");
            latencyBar.put("numCalls", Integer.toString(hist.getCount()));
            latencyBar.put("avg", Float.toString(((IntegerHistogram)hist).getMean()));
            latencyBar.put("stdDev", Float.toString(((IntegerHistogram)hist).getUnbiasedStdDev()));
            latencyBar.put("labelStr", Arrays.toString(hist.getSegmenter().getBoundaryLabels().toArray()));
            latencyBar.put("boundaryStr", Arrays.toString(StatsServlet.escapeStringArray(hist.getSegmenter().getBucketLabels()).toArray()));
            latencyBar.put("dataStr", Arrays.toString(hist.getHistogram()));
            out.charts.add(latencyBar);
            latencyDot = new HashMap();
            latencyDot.put("title", "Recv Payload");
            latencyDot.put("type", "dot");
            latencyDot.put("dataStr", Arrays.toString(hist.getRecentAdditions().toArray()));
            out.charts.add(latencyDot);
        }
        return out;
    }

    private CharSequence formatMillis(float millis) {
        return String.format("%.0fms", Float.valueOf(millis));
    }

    public class RenderableMessage {
        public String name;
        public int numCalls;
        public ArrayList<HashMap<String, String>> charts;

        public RenderableMessage(String name) {
            this.name = name;
            this.charts = new ArrayList();
        }

        public ArrayList<HashMap<String, String>> getCharts() {
            return this.charts;
        }

        public String getname() {
            return this.name;
        }

        public int getNumCalls() {
            return this.numCalls;
        }
    }
}

