/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.trace;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.avro.ipc.trace.Span;
import org.apache.avro.ipc.trace.SpanEvent;
import org.apache.avro.ipc.trace.TimestampedEvent;
import org.apache.avro.ipc.trace.TraceNode;
import org.apache.avro.ipc.trace.Util;

public class Trace {
    private TraceNode root;

    public Trace(TraceNode root2) {
        this.root = root2;
    }

    public TraceNode getRoot() {
        return this.root;
    }

    public int executionPathHash() {
        return this.printBrief().hashCode();
    }

    public String printBrief() {
        if (this.root == null) {
            return "Trace: <empty>";
        }
        String out = "Trace: (";
        out = out + this.root.span.messageName + " ";
        out = out + this.printBriefRecurse(this.root.children);
        out = out + ")";
        return out;
    }

    private String printBriefRecurse(List<TraceNode> children) {
        String out = "";
        Collections.sort(children, new NodeComparator());
        for (int i = 0; i < children.size(); ++i) {
            TraceNode tn = children.get(i);
            out = out + "(" + tn.span.messageName;
            if (tn.children.size() > 0) {
                out = out + " ";
                out = out + this.printBriefRecurse(tn.children);
            }
            out = out + ")";
            if (i == children.size() - 1) continue;
            out = out + " ";
        }
        return out;
    }

    public String printWithTiming() {
        if (this.root == null) {
            return "Trace: <empty>";
        }
        String out = "Trace: \n";
        LinkedList<TraceNode> rootList = new LinkedList<TraceNode>();
        rootList.add(this.root);
        out = out + this.printWithTimingRecurse(rootList, 0);
        return out;
    }

    private String printWithTimingRecurse(List<TraceNode> children, int depth) {
        String out = "";
        Collections.sort(children, new NodeComparator());
        for (TraceNode tn : children) {
            long clientSend = 0L;
            long clientReceive = 0L;
            for (TimestampedEvent te : tn.span.events) {
                if (!(te.event instanceof SpanEvent)) continue;
                SpanEvent ev = (SpanEvent)((Object)te.event);
                if (ev.equals((Object)SpanEvent.CLIENT_RECV)) {
                    clientReceive = te.timeStamp / 1000000L;
                    continue;
                }
                if (!ev.equals((Object)SpanEvent.CLIENT_SEND)) continue;
                clientSend = te.timeStamp / 1000000L;
            }
            for (int i = 0; i < depth; ++i) {
                out = out + "  ";
            }
            out = out + tn.span.messageName + " " + (clientReceive - clientSend) + "ms\n";
            if (tn.children.size() <= 0) continue;
            out = out + this.printWithTimingRecurse(tn.children, depth + 1);
        }
        return out;
    }

    public static Trace extractTrace(List<Span> spans) {
        HashMap<Long, List<Long>> children = new HashMap<Long, List<Long>>();
        HashMap<Long, Span> spanRef = new HashMap<Long, Span>();
        Span rootSpan = null;
        for (Span s : spans) {
            spanRef.put(Util.longValue(s.spanID), s);
            if (s.parentSpanID == null) {
                rootSpan = s;
                continue;
            }
            if (children.get(Util.longValue(s.parentSpanID)) == null) {
                LinkedList<Long> list2 = new LinkedList<Long>();
                list2.add(Util.longValue(s.spanID));
                children.put(Util.longValue(s.parentSpanID), list2);
                continue;
            }
            children.get(Util.longValue(s.parentSpanID)).add(Util.longValue(s.spanID));
        }
        if (rootSpan == null) {
            return null;
        }
        TraceNode rootNode = Trace.getNode(rootSpan, spanRef, children);
        return new Trace(rootNode);
    }

    private static TraceNode getNode(Span s, HashMap<Long, Span> spanRef, HashMap<Long, List<Long>> children) {
        TraceNode out = new TraceNode(s, new LinkedList<TraceNode>());
        List<Long> kids = children.get(Util.longValue(s.spanID));
        if (kids == null) {
            return out;
        }
        for (long childID : kids) {
            Span childSpan = spanRef.get(childID);
            if (childSpan == null) {
                return null;
            }
            out.children.add(Trace.getNode(childSpan, spanRef, children));
        }
        return out;
    }

    private class NodeComparator
    implements Comparator<TraceNode> {
        private NodeComparator() {
        }

        @Override
        public int compare(TraceNode tn0, TraceNode tn1) {
            int result = tn0.span.messageName.compareTo(tn1.span.messageName);
            if (result != 0) {
                return result;
            }
            Long tn0SendTime = tn0.extractEventTime(tn0, SpanEvent.CLIENT_SEND);
            Long tn1SendTime = tn1.extractEventTime(tn1, SpanEvent.CLIENT_SEND);
            return tn0SendTime.compareTo(tn1SendTime);
        }
    }
}

