/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.reflect;

import java.io.IOException;
import java.lang.constant.Constable;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.reflect.ArrayAccessor;
import org.apache.avro.reflect.FieldAccessor;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumReader;

public class ReflectDatumReader<T>
extends SpecificDatumReader<T> {
    public ReflectDatumReader() {
        this(null, null, ReflectData.get());
    }

    public ReflectDatumReader(Class<T> c) {
        this(new ReflectData(c.getClassLoader()));
        this.setSchema(this.getSpecificData().getSchema(c));
    }

    public ReflectDatumReader(Schema root2) {
        this(root2, root2, ReflectData.get());
    }

    public ReflectDatumReader(Schema writer, Schema reader) {
        this(writer, reader, ReflectData.get());
    }

    public ReflectDatumReader(Schema writer, Schema reader, ReflectData data) {
        super(writer, reader, data);
    }

    public ReflectDatumReader(ReflectData data) {
        super(data);
    }

    @Override
    protected Object newArray(Object old, int size2, Schema schema) {
        Class collectionClass = ReflectData.getClassProp(schema, "java-class");
        Class elementClass = ReflectData.getClassProp(schema, "java-element-class");
        if (collectionClass == null && elementClass == null) {
            return super.newArray(old, size2, schema);
        }
        if (collectionClass != null && !collectionClass.isArray()) {
            if (old instanceof Collection) {
                ((Collection)old).clear();
                return old;
            }
            if (collectionClass.isAssignableFrom(ArrayList.class)) {
                return new ArrayList();
            }
            return SpecificData.newInstance(collectionClass, schema);
        }
        if (elementClass == null) {
            elementClass = collectionClass.getComponentType();
        }
        if (elementClass == null) {
            ReflectData data = (ReflectData)this.getData();
            elementClass = data.getClass(schema.getElementType());
        }
        return Array.newInstance(elementClass, size2);
    }

    @Override
    protected Object peekArray(Object array) {
        return null;
    }

    @Override
    protected void addToArray(Object array, long pos, Object e) {
        throw new AvroRuntimeException("reflectDatumReader does not use addToArray");
    }

    @Override
    protected Object readArray(Object old, Schema expected, ResolvingDecoder in) throws IOException {
        Schema expectedType = expected.getElementType();
        long l = in.readArrayStart();
        if (l <= 0L) {
            return this.newArray(old, 0, expected);
        }
        Object array = this.newArray(old, (int)l, expected);
        if (array instanceof Collection) {
            Collection c = (Collection)array;
            return this.readCollection(c, expectedType, l, in);
        }
        return this.readJavaArray(array, expectedType, l, in);
    }

    private Object readJavaArray(Object array, Schema expectedType, long l, ResolvingDecoder in) throws IOException {
        Class<?> elementType = array.getClass().getComponentType();
        if (elementType.isPrimitive()) {
            return this.readPrimitiveArray(array, elementType, l, in);
        }
        return this.readObjectArray((Object[])array, expectedType, l, in);
    }

    private Object readPrimitiveArray(Object array, Class<?> c, long l, ResolvingDecoder in) throws IOException {
        return ArrayAccessor.readArray(array, c, l, in);
    }

    private Object readObjectArray(Object[] array, Schema expectedType, long l, ResolvingDecoder in) throws IOException {
        int index2 = 0;
        do {
            int limit = index2 + (int)l;
            while (index2 < limit) {
                Object element;
                array[index2] = element = this.read(null, expectedType, in);
                ++index2;
            }
        } while ((l = in.arrayNext()) > 0L);
        return array;
    }

    private Object readCollection(Collection<Object> c, Schema expectedType, long l, ResolvingDecoder in) throws IOException {
        do {
            int i = 0;
            while ((long)i < l) {
                Object element = this.read(null, expectedType, in);
                c.add(element);
                ++i;
            }
        } while ((l = in.arrayNext()) > 0L);
        return c;
    }

    @Override
    protected Object readString(Object old, Decoder in) throws IOException {
        return super.readString(null, in).toString();
    }

    @Override
    protected Object createString(String value2) {
        return value2;
    }

    @Override
    protected Object readBytes(Object old, Schema s, Decoder in) throws IOException {
        ByteBuffer bytes = in.readBytes(null);
        Class c = ReflectData.getClassProp(s, "java-class");
        if (c != null && c.isArray()) {
            byte[] result = new byte[bytes.remaining()];
            bytes.get(result);
            return result;
        }
        return bytes;
    }

    @Override
    protected Object readInt(Object old, Schema expected, Decoder in) throws IOException {
        Constable value2 = in.readInt();
        String intClass = expected.getProp("java-class");
        if (Byte.class.getName().equals(intClass)) {
            value2 = value2.byteValue();
        } else if (Short.class.getName().equals(intClass)) {
            value2 = value2.shortValue();
        } else if (Character.class.getName().equals(intClass)) {
            value2 = Character.valueOf((char)((Integer)value2).intValue());
        }
        return value2;
    }

    @Override
    protected void readField(Object record, Schema.Field f, Object oldDatum, ResolvingDecoder in, Object state) throws IOException {
        FieldAccessor accessor;
        if (state != null && (accessor = ((FieldAccessor[])state)[f.pos()]) != null) {
            if (accessor.supportsIO() && (!Schema.Type.UNION.equals((Object)f.schema().getType()) || accessor.isCustomEncoded())) {
                accessor.read(record, in);
                return;
            }
            if (accessor.isStringable()) {
                try {
                    String asString = (String)this.read(null, f.schema(), in);
                    accessor.set(record, asString == null ? null : this.newInstanceFromString(accessor.getField().getType(), asString));
                    return;
                }
                catch (Exception e) {
                    throw new AvroRuntimeException("Failed to read Stringable", e);
                }
            }
        }
        super.readField(record, f, oldDatum, in, state);
    }
}

