/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.ser.impl;

import java.util.Map;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.ser.impl.SerializerCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonSerializerMap {
    private final Bucket[] _buckets;
    private final int _size;

    public JsonSerializerMap(Map<SerializerCache.TypeKey, JsonSerializer<Object>> serializers) {
        int size2;
        this._size = size2 = JsonSerializerMap.findSize(serializers.size());
        int hashMask = size2 - 1;
        Bucket[] buckets = new Bucket[size2];
        for (Map.Entry<SerializerCache.TypeKey, JsonSerializer<Object>> entry2 : serializers.entrySet()) {
            SerializerCache.TypeKey key = entry2.getKey();
            int index2 = key.hashCode() & hashMask;
            buckets[index2] = new Bucket(buckets[index2], key, entry2.getValue());
        }
        this._buckets = buckets;
    }

    private static final int findSize(int size2) {
        int result;
        int needed = size2 <= 64 ? size2 + size2 : size2 + (size2 >> 2);
        for (result = 8; result < needed; result += result) {
        }
        return result;
    }

    public int size() {
        return this._size;
    }

    public JsonSerializer<Object> find(SerializerCache.TypeKey key) {
        int index2 = key.hashCode() & this._buckets.length - 1;
        Bucket bucket = this._buckets[index2];
        if (bucket == null) {
            return null;
        }
        if (key.equals(bucket.key)) {
            return bucket.value;
        }
        while ((bucket = bucket.next) != null) {
            if (!key.equals(bucket.key)) continue;
            return bucket.value;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Bucket {
        public final SerializerCache.TypeKey key;
        public final JsonSerializer<Object> value;
        public final Bucket next;

        public Bucket(Bucket next2, SerializerCache.TypeKey key, JsonSerializer<Object> value2) {
            this.next = next2;
            this.key = key;
            this.value = value2;
        }
    }
}

