/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.CommonFields;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.EndTxnResponse;
import org.apache.kafka.common.requests.TransactionResult;

public class EndTxnRequest
extends AbstractRequest {
    private static final String TRANSACTION_RESULT_KEY_NAME = "transaction_result";
    private static final Schema END_TXN_REQUEST_V0;
    private static final Schema END_TXN_REQUEST_V1;
    private final String transactionalId;
    private final long producerId;
    private final short producerEpoch;
    private final TransactionResult result;

    public static Schema[] schemaVersions() {
        return new Schema[]{END_TXN_REQUEST_V0, END_TXN_REQUEST_V1};
    }

    private EndTxnRequest(short version, String transactionalId, long producerId, short producerEpoch, TransactionResult result) {
        super(version);
        this.transactionalId = transactionalId;
        this.producerId = producerId;
        this.producerEpoch = producerEpoch;
        this.result = result;
    }

    public EndTxnRequest(Struct struct, short version) {
        super(version);
        this.transactionalId = struct.get(CommonFields.TRANSACTIONAL_ID);
        this.producerId = struct.get(CommonFields.PRODUCER_ID);
        this.producerEpoch = struct.get(CommonFields.PRODUCER_EPOCH);
        this.result = TransactionResult.forId(struct.getBoolean(TRANSACTION_RESULT_KEY_NAME));
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    public long producerId() {
        return this.producerId;
    }

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public TransactionResult command() {
        return this.result;
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.END_TXN.requestSchema(this.version()));
        struct.set(CommonFields.TRANSACTIONAL_ID, this.transactionalId);
        struct.set(CommonFields.PRODUCER_ID, this.producerId);
        struct.set(CommonFields.PRODUCER_EPOCH, this.producerEpoch);
        struct.set(TRANSACTION_RESULT_KEY_NAME, (Object)this.result.id);
        return struct;
    }

    @Override
    public EndTxnResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return new EndTxnResponse(throttleTimeMs, Errors.forException(e));
    }

    public static EndTxnRequest parse(ByteBuffer buffer, short version) {
        return new EndTxnRequest(ApiKeys.END_TXN.parseRequest(version, buffer), version);
    }

    static {
        END_TXN_REQUEST_V1 = END_TXN_REQUEST_V0 = new Schema(CommonFields.TRANSACTIONAL_ID, CommonFields.PRODUCER_ID, CommonFields.PRODUCER_EPOCH, new Field(TRANSACTION_RESULT_KEY_NAME, Type.BOOLEAN, "The result of the transaction (0 = ABORT, 1 = COMMIT)"));
    }

    public static class Builder
    extends AbstractRequest.Builder<EndTxnRequest> {
        private final String transactionalId;
        private final long producerId;
        private final short producerEpoch;
        private final TransactionResult result;

        public Builder(String transactionalId, long producerId, short producerEpoch, TransactionResult result) {
            super(ApiKeys.END_TXN);
            this.transactionalId = transactionalId;
            this.producerId = producerId;
            this.producerEpoch = producerEpoch;
            this.result = result;
        }

        public TransactionResult result() {
            return this.result;
        }

        @Override
        public EndTxnRequest build(short version) {
            return new EndTxnRequest(version, this.transactionalId, this.producerId, this.producerEpoch, this.result);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=EndTxnRequest").append(", transactionalId=").append(this.transactionalId).append(", producerId=").append(this.producerId).append(", producerEpoch=").append(this.producerEpoch).append(", result=").append((Object)this.result).append(")");
            return bld.toString();
        }
    }
}

