/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka010;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.Time$;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.DStreamCheckpointData;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.streaming.kafka010.CanCommitOffsets;
import org.apache.spark.streaming.kafka010.ConsumerStrategy;
import org.apache.spark.streaming.kafka010.KafkaRDD;
import org.apache.spark.streaming.kafka010.KafkaUtils$;
import org.apache.spark.streaming.kafka010.LocationStrategy;
import org.apache.spark.streaming.kafka010.OffsetRange;
import org.apache.spark.streaming.kafka010.OffsetRange$;
import org.apache.spark.streaming.kafka010.PerPartitionConfig;
import org.apache.spark.streaming.kafka010.PreferBrokers$;
import org.apache.spark.streaming.kafka010.PreferConsistent$;
import org.apache.spark.streaming.kafka010.PreferFixed;
import org.apache.spark.streaming.scheduler.RateController;
import org.apache.spark.streaming.scheduler.RateController$;
import org.apache.spark.streaming.scheduler.StreamInputInfo;
import org.apache.spark.streaming.scheduler.StreamInputInfo$;
import org.apache.spark.streaming.scheduler.rate.RateEstimator;
import org.apache.spark.streaming.scheduler.rate.RateEstimator$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\u001dg!B\u0001\u0003\u0001\u0019a!a\u0006#je\u0016\u001cGoS1gW\u0006Le\u000e];u\tN#(/Z1n\u0015\t\u0019A!\u0001\u0005lC\u001a\\\u0017\rM\u00191\u0015\t)a!A\u0005tiJ,\u0017-\\5oO*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014x-F\u0002\u000eA9\u001aB\u0001\u0001\b1mA\u0019qB\u0005\u000b\u000e\u0003AQ!!\u0005\u0003\u0002\u000f\u0011\u001cHO]3b[&\u00111\u0003\u0005\u0002\r\u0013:\u0004X\u000f\u001e#TiJ,\u0017-\u001c\t\u0005+qqR&D\u0001\u0017\u0015\t9\u0002$\u0001\u0005d_:\u001cX/\\3s\u0015\tI\"$A\u0004dY&,g\u000e^:\u000b\u0005mA\u0011!B6bM.\f\u0017BA\u000f\u0017\u00059\u0019uN\\:v[\u0016\u0014(+Z2pe\u0012\u0004\"a\b\u0011\r\u0001\u0011)\u0011\u0005\u0001b\u0001G\t\t1j\u0001\u0001\u0012\u0005\u0011R\u0003CA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2#a\u0002(pi\"Lgn\u001a\t\u0003K-J!\u0001\f\u0014\u0003\u0007\u0005s\u0017\u0010\u0005\u0002 ]\u0011)q\u0006\u0001b\u0001G\t\ta\u000b\u0005\u00022i5\t!G\u0003\u00024\r\u0005A\u0011N\u001c;fe:\fG.\u0003\u00026e\t9Aj\\4hS:<\u0007CA\u001c9\u001b\u0005\u0011\u0011BA\u001d\u0003\u0005A\u0019\u0015M\\\"p[6LGo\u00144gg\u0016$8\u000f\u0003\u0005<\u0001\t\u0005\t\u0015!\u0003=\u0003\u0011y6o]2\u0011\u0005urT\"\u0001\u0003\n\u0005}\"!\u0001E*ue\u0016\fW.\u001b8h\u0007>tG/\u001a=u\u0011!\t\u0005A!A!\u0002\u0013\u0011\u0015\u0001\u00057pG\u0006$\u0018n\u001c8TiJ\fG/Z4z!\t94)\u0003\u0002E\u0005\t\u0001Bj\\2bi&|gn\u0015;sCR,w-\u001f\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\u0006\u00012m\u001c8tk6,'o\u0015;sCR,w-\u001f\t\u0005o!sR&\u0003\u0002J\u0005\t\u00012i\u001c8tk6,'o\u0015;sCR,w-\u001f\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u0019\u0006\u0019\u0001\u000f]2\u0011\u0005]j\u0015B\u0001(\u0003\u0005I\u0001VM\u001d)beRLG/[8o\u0007>tg-[4\t\u000bA\u0003A\u0011A)\u0002\rqJg.\u001b;?)\u0015\u00116\u000bV+W!\u00119\u0004AH\u0017\t\u000bmz\u0005\u0019\u0001\u001f\t\u000b\u0005{\u0005\u0019\u0001\"\t\u000b\u0019{\u0005\u0019A$\t\u000b-{\u0005\u0019\u0001'\t\u000fa\u0003!\u0019!C\u00053\u0006Y\u0011N\\5uS\u0006d'+\u0019;f+\u0005Q\u0006CA\u0013\\\u0013\tafE\u0001\u0003M_:<\u0007B\u00020\u0001A\u0003%!,\u0001\u0007j]&$\u0018.\u00197SCR,\u0007\u0005C\u0004a\u0001\t\u0007I\u0011A1\u0002'\u0015DXmY;u_J\\\u0015MZ6b!\u0006\u0014\u0018-\\:\u0016\u0003\t\u0004Ba\u00195kk6\tAM\u0003\u0002fM\u0006!Q\u000f^5m\u0015\u00059\u0017\u0001\u00026bm\u0006L!!\u001b3\u0003\u000f!\u000b7\u000f['baB\u00111N\u001d\b\u0003YB\u0004\"!\u001c\u0014\u000e\u00039T!a\u001c\u0012\u0002\rq\u0012xn\u001c;?\u0013\t\th%\u0001\u0004Qe\u0016$WMZ\u0005\u0003gR\u0014aa\u0015;sS:<'BA9'!\t1\u00180D\u0001x\u0015\tAh-\u0001\u0003mC:<\u0017B\u0001>x\u0005\u0019y%M[3di\"1A\u0010\u0001Q\u0001\n\t\fA#\u001a=fGV$xN]&bM.\f\u0007+\u0019:b[N\u0004\u0003b\u0002@\u0001\u0001\u0004%\tb`\u0001\u000fGV\u0014(/\u001a8u\u001f\u001a47/\u001a;t+\t\t\t\u0001E\u0004\u0002\u0004\u00055\u0011\u0011\u0003.\u000e\u0005\u0005\u0015!\u0002BA\u0004\u0003\u0013\t\u0011\"[7nkR\f'\r\\3\u000b\u0007\u0005-a%\u0001\u0006d_2dWm\u0019;j_:LA!a\u0004\u0002\u0006\t\u0019Q*\u00199\u0011\t\u0005M\u0011\u0011D\u0007\u0003\u0003+Q1!a\u0006\u001b\u0003\u0019\u0019w.\\7p]&!\u00111DA\u000b\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:D\u0011\"a\b\u0001\u0001\u0004%\t\"!\t\u0002%\r,(O]3oi>3gm]3ug~#S-\u001d\u000b\u0005\u0003G\tI\u0003E\u0002&\u0003KI1!a\n'\u0005\u0011)f.\u001b;\t\u0015\u0005-\u0012QDA\u0001\u0002\u0004\t\t!A\u0002yIEB\u0001\"a\f\u0001A\u0003&\u0011\u0011A\u0001\u0010GV\u0014(/\u001a8u\u001f\u001a47/\u001a;tA!I\u00111\u0007\u0001A\u0002\u0013%\u0011QG\u0001\u0003W\u000e,\"!a\u000e\u0011\u000bU\tIDH\u0017\n\u0007\u0005mbC\u0001\u0005D_:\u001cX/\\3s\u0011%\ty\u0004\u0001a\u0001\n\u0013\t\t%\u0001\u0004lG~#S-\u001d\u000b\u0005\u0003G\t\u0019\u0005\u0003\u0006\u0002,\u0005u\u0012\u0011!a\u0001\u0003oA\u0001\"a\u0012\u0001A\u0003&\u0011qG\u0001\u0004W\u000e\u0004\u0003\u0006BA#\u0003\u0017\u00022!JA'\u0013\r\tyE\n\u0002\niJ\fgn]5f]RDaa\u0006\u0001\u0005\u0002\u0005MCCAA\u001c\u0011\u001d\t9\u0006\u0001C!\u00033\nq\u0001]3sg&\u001cH\u000f\u0006\u0003\u0002\\\u0005\u0005\u0004\u0003B\b\u0002^QI1!a\u0018\u0011\u0005\u001d!5\u000b\u001e:fC6D\u0001\"a\u0019\u0002V\u0001\u0007\u0011QM\u0001\t]\u0016<H*\u001a<fYB!\u0011qMA7\u001b\t\tIGC\u0002\u0002l\u0019\tqa\u001d;pe\u0006<W-\u0003\u0003\u0002p\u0005%$\u0001D*u_J\fw-\u001a'fm\u0016d\u0007bBA:\u0001\u0011E\u0011QO\u0001\u000bO\u0016$(I]8lKJ\u001cXCAA<!\u0015\u0019\u0007.!\u0005k\u0011\u001d\tY\b\u0001C\t\u0003{\n\u0011cZ3u!J,g-\u001a:sK\u0012Dun\u001d;t+\t\ty\b\u0005\u0004d\u0003\u0003\u000b\tB[\u0005\u0004\u0003\u001f!\u0007\u0002CAC\u0001\u0011\u0005C!a\"\u0002\t9\fW.Z\u000b\u0002U\"Q\u00111\u0012\u0001C\u0002\u0013EC!!$\u0002\u001d\rDWmY6q_&tG\u000fR1uCV\u0011\u0011q\u0012\t\u0005\u0003#\u000b\u0019*D\u0001\u0001\r\u001d\t)\n\u0001\u0001\u0005\u0003/\u0013Q\u0005R5sK\u000e$8*\u00194lC&s\u0007/\u001e;E'R\u0014X-Y7DQ\u0016\u001c7\u000e]8j]R$\u0015\r^1\u0014\t\u0005M\u0015\u0011\u0014\t\u0005\u001f\u0005mE#C\u0002\u0002\u001eB\u0011Q\u0003R*ue\u0016\fWn\u00115fG.\u0004x.\u001b8u\t\u0006$\u0018\rC\u0004Q\u0003'#\t!!)\u0015\u0005\u0005=\u0005\u0002CAS\u0003'#\t!a*\u0002\u0019\t\fGo\u00195G_J$\u0016.\\3\u0016\u0005\u0005%\u0006\u0003CAV\u0003c\u000b\u0019,!/\u000e\u0005\u00055&\u0002BAX\u0003\u0013\tq!\\;uC\ndW-C\u0002j\u0003[\u00032!PA[\u0013\r\t9\f\u0002\u0002\u0005)&lW\rE\u0003&\u0003w\u000by,C\u0002\u0002>\u001a\u0012Q!\u0011:sCf\u0004\u0002\"JAaU\u0006\u0015'LW\u0005\u0004\u0003\u00074#A\u0002+va2,G\u0007E\u0002&\u0003\u000fL1!!3'\u0005\rIe\u000e\u001e\u0005\t\u0003\u001b\f\u0019\n\"\u0011\u0002P\u00061Q\u000f\u001d3bi\u0016$B!a\t\u0002R\"A\u00111[Af\u0001\u0004\t\u0019,\u0001\u0003uS6,\u0007\u0002CAl\u0003'#\t%!7\u0002\u000f\rdW-\u00198vaR!\u00111EAn\u0011!\t\u0019.!6A\u0002\u0005M\u0006\u0002CAp\u0003'#\t%!9\u0002\u000fI,7\u000f^8sKR\u0011\u00111\u0005\u0005\t\u0003K\u0004\u0001\u0015!\u0003\u0002\u0010\u0006y1\r[3dWB|\u0017N\u001c;ECR\f\u0007\u0005\u0003\u0006\u0002j\u0002\u0011\r\u0011\"\u0015\u0005\u0003W\faB]1uK\u000e{g\u000e\u001e:pY2,'/\u0006\u0002\u0002nB)Q%a<\u0002t&\u0019\u0011\u0011\u001f\u0014\u0003\r=\u0003H/[8o!\u0011\t)0a?\u000e\u0005\u0005](bAA}\t\u0005I1o\u00195fIVdWM]\u0005\u0005\u0003{\f9P\u0001\bSCR,7i\u001c8ue>dG.\u001a:\t\u0011\t\u0005\u0001\u0001)A\u0005\u0003[\fqB]1uK\u000e{g\u000e\u001e:pY2,'\u000f\t\u0005\t\u0005\u000b\u0001A\u0011\u0003\u0003\u0003\b\u00059R.\u0019=NKN\u001c\u0018mZ3t!\u0016\u0014\b+\u0019:uSRLwN\u001c\u000b\u0005\u0005\u0013\u0011y\u0001E\u0003&\u0003_\u0014Y\u0001\u0005\u0004l\u0005\u001b\t\tBW\u0005\u0004\u0003\u001f!\b\u0002\u0003B\t\u0005\u0007\u0001\rAa\u0003\u0002\u000f=4gm]3ug\"9!Q\u0003\u0001\u0005\n\t]\u0011\u0001\u00049be\u0006tw.\u001b3Q_2dG\u0003BA\u0012\u00053A\u0001Ba\u0007\u0003\u0014\u0001\u0007\u0011qG\u0001\u0002G\"9!q\u0004\u0001\u0005\u0012\t\u0005\u0012!\u00047bi\u0016\u001cHo\u00144gg\u0016$8\u000f\u0006\u0002\u0003\f!9!Q\u0005\u0001\u0005\u0012\t\u001d\u0012!B2mC6\u0004H\u0003\u0002B\u0006\u0005SA\u0001B!\u0005\u0003$\u0001\u0007!1\u0002\u0005\b\u0005[\u0001A\u0011\tB\u0018\u0003\u001d\u0019w.\u001c9vi\u0016$BA!\r\u0003:A)Q%a<\u00034A)qG!\u000e\u001f[%\u0019!q\u0007\u0002\u0003\u0011-\u000bgm[1S\t\u0012C\u0001Ba\u000f\u0003,\u0001\u0007\u00111W\u0001\nm\u0006d\u0017\u000e\u001a+j[\u0016DqAa\u0010\u0001\t\u0003\n\t/A\u0003ti\u0006\u0014H\u000fC\u0004\u0003D\u0001!\t%!9\u0002\tM$x\u000e\u001d\u0005\n\u0005\u000f\u0002!\u0019!C\t\u0005\u0013\n1bY8n[&$\u0018+^3vKV\u0011!1\n\t\u0007\u0005\u001b\u0012\u0019Fa\u0016\u000e\u0005\t=#b\u0001B)I\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\tU#q\n\u0002\u0016\u0007>t7-\u001e:sK:$H*\u001b8lK\u0012\fV/Z;f!\r9$\u0011L\u0005\u0004\u00057\u0012!aC(gMN,GOU1oO\u0016D\u0001Ba\u0018\u0001A\u0003%!1J\u0001\rG>lW.\u001b;Rk\u0016,X\r\t\u0005\n\u0005G\u0002!\u0019!C\t\u0005K\nabY8n[&$8)\u00197mE\u0006\u001c7.\u0006\u0002\u0003hA1!\u0011\u000eB8\u0005gj!Aa\u001b\u000b\t\t5$qJ\u0001\u0007CR|W.[2\n\t\tE$1\u000e\u0002\u0010\u0003R|W.[2SK\u001a,'/\u001a8dKB\u0019QC!\u001e\n\u0007\t]dC\u0001\u000bPM\u001a\u001cX\r^\"p[6LGoQ1mY\n\f7m\u001b\u0005\t\u0005w\u0002\u0001\u0015!\u0003\u0003h\u0005y1m\\7nSR\u001c\u0015\r\u001c7cC\u000e\\\u0007\u0005C\u0004\u0003\u0000\u0001!\tA!!\u0002\u0017\r|W.\\5u\u0003NLhn\u0019\u000b\u0005\u0003G\u0011\u0019\t\u0003\u0005\u0003\u0006\nu\u0004\u0019\u0001BD\u00031ygMZ:fiJ\u000bgnZ3t!\u0015)\u00131\u0018B,\u0011\u001d\u0011y\b\u0001C\u0001\u0005\u0017#b!a\t\u0003\u000e\n=\u0005\u0002\u0003BC\u0005\u0013\u0003\rAa\"\t\u0011\tE%\u0011\u0012a\u0001\u0005g\n\u0001bY1mY\n\f7m\u001b\u0005\b\u0005+\u0003A\u0011CAq\u0003%\u0019w.\\7ji\u0006cGNB\u0004\u0003\u001a\u0002\u0001AAa'\u00033\u0011K'/Z2u\u0017\u000647.\u0019*bi\u0016\u001cuN\u001c;s_2dWM]\n\u0005\u0005/\u000b\u0019\u0010C\u0007\u0003 \n]%\u0011!Q\u0001\n\u0005\u0015'\u0011U\u0001\u0003S\u0012LAAa)\u0002|\u0006I1\u000f\u001e:fC6,\u0016\n\u0012\u0005\f\u0005O\u00139J!A!\u0002\u0013\u0011I+A\u0005fgRLW.\u0019;peB!!1\u0016BY\u001b\t\u0011iK\u0003\u0003\u00030\u0006]\u0018\u0001\u0002:bi\u0016LAAa-\u0003.\ni!+\u0019;f\u000bN$\u0018.\\1u_JDq\u0001\u0015BL\t\u0003\u00119\f\u0006\u0004\u0003:\nm&Q\u0018\t\u0005\u0003#\u00139\n\u0003\u0005\u0003 \nU\u0006\u0019AAc\u0011!\u00119K!.A\u0002\t%\u0006\u0002\u0003Ba\u0005/#\tEa1\u0002\u000fA,(\r\\5tQR!\u00111\u0005Bc\u0011\u001d\u0011yKa0A\u0002i\u0003")
public class DirectKafkaInputDStream<K, V>
extends InputDStream<ConsumerRecord<K, V>>
implements CanCommitOffsets {
    private final LocationStrategy locationStrategy;
    private final ConsumerStrategy<K, V> consumerStrategy;
    private final PerPartitionConfig ppc;
    private final long initialRate;
    private final HashMap<String, Object> executorKafkaParams;
    private scala.collection.immutable.Map<TopicPartition, Object> currentOffsets;
    private transient Consumer<K, V> kc;
    private final DirectKafkaInputDStreamCheckpointData checkpointData;
    private final Option<RateController> rateController;
    private final ConcurrentLinkedQueue<OffsetRange> commitQueue;
    private final AtomicReference<OffsetCommitCallback> commitCallback;

    private long initialRate() {
        return this.initialRate;
    }

    public HashMap<String, Object> executorKafkaParams() {
        return this.executorKafkaParams;
    }

    public scala.collection.immutable.Map<TopicPartition, Object> currentOffsets() {
        return this.currentOffsets;
    }

    public void currentOffsets_$eq(scala.collection.immutable.Map<TopicPartition, Object> x$1) {
        this.currentOffsets = x$1;
    }

    private Consumer<K, V> kc() {
        return this.kc;
    }

    private void kc_$eq(Consumer<K, V> x$1) {
        this.kc = x$1;
    }

    public synchronized Consumer<K, V> consumer() {
        block0: {
            if (this.kc() != null) break block0;
            this.kc_$eq(this.consumerStrategy.onStart((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.currentOffsets().mapValues((Function1 & Serializable & scala.Serializable)l -> DirectKafkaInputDStream.$anonfun$consumer$1(BoxesRunTime.unboxToLong((Object)l)))).asJava()));
        }
        return this.kc();
    }

    public DStream<ConsumerRecord<K, V>> persist(StorageLevel newLevel) {
        this.logError((Function0 & Serializable & scala.Serializable)() -> "Kafka ConsumerRecord is not serializable. Use .map to extract fields before calling .persist or .window");
        return super.persist(newLevel);
    }

    /*
     * WARNING - void declaration
     */
    public HashMap<TopicPartition, String> getBrokers() {
        void var2_2;
        Consumer<K, V> c = this.consumer();
        HashMap result = new HashMap();
        HashMap<TopicPartition, String> hosts = new HashMap<TopicPartition, String>();
        for (TopicPartition tp : c.assignment()) {
            if (hosts.get(tp) == null) {
                for (PartitionInfo i : c.partitionsFor(tp.topic())) {
                    hosts.put(new TopicPartition(i.topic(), i.partition()), i.leader().host());
                }
            }
            result.put(tp, hosts.get(tp));
        }
        return var2_2;
    }

    public java.util.Map<TopicPartition, String> getPreferredHosts() {
        java.util.Map<TopicPartition, String> map;
        LocationStrategy locationStrategy = this.locationStrategy;
        if (PreferBrokers$.MODULE$.equals(locationStrategy)) {
            map = this.getBrokers();
        } else if (PreferConsistent$.MODULE$.equals(locationStrategy)) {
            map = Collections.emptyMap();
        } else if (locationStrategy instanceof PreferFixed) {
            PreferFixed preferFixed = (PreferFixed)locationStrategy;
            java.util.Map<TopicPartition, String> hostMap = preferFixed.hostMap();
            map = hostMap;
        } else {
            throw new MatchError((Object)locationStrategy);
        }
        return map;
    }

    public String name() {
        return new StringBuilder(27).append("Kafka 0.10 direct stream [").append(this.id()).append("]").toString();
    }

    public DirectKafkaInputDStreamCheckpointData checkpointData() {
        return this.checkpointData;
    }

    public Option<RateController> rateController() {
        return this.rateController;
    }

    public Option<scala.collection.immutable.Map<TopicPartition, Object>> maxMessagesPerPartition(scala.collection.immutable.Map<TopicPartition, Object> offsets) {
        None$ none$;
        scala.collection.immutable.Map map;
        Option estimatedRateLimit = this.rateController().map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToLong((long)DirectKafkaInputDStream.$anonfun$maxMessagesPerPartition$1(this, x)));
        Option option = estimatedRateLimit.filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$1 -> x$1 > 0L);
        if (option instanceof Some) {
            Some some = (Some)option;
            long rate = BoxesRunTime.unboxToLong((Object)some.value());
            scala.collection.immutable.Map lagPerPartition = (scala.collection.immutable.Map)offsets.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition tp = (TopicPartition)tuple2._1();
                long offset = tuple2._2$mcJ$sp();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)Math.max(offset - BoxesRunTime.unboxToLong((Object)this.currentOffsets().apply((Object)tp)), 0L)));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
            long totalLag = BoxesRunTime.unboxToLong((Object)lagPerPartition.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            map = (scala.collection.immutable.Map)lagPerPartition.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition tp = (TopicPartition)tuple2._1();
                long lag = tuple2._2$mcJ$sp();
                long maxRateLimitPerPartition = $this.ppc.maxRatePerPartition(tp);
                double backpressureRate = (double)lag / (double)totalLag * (double)rate;
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)(maxRateLimitPerPartition > 0L ? BoxesRunTime.boxToDouble((double)Math.min(backpressureRate, (double)maxRateLimitPerPartition)) : BoxesRunTime.boxToDouble((double)backpressureRate)));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
        } else if (None$.MODULE$.equals(option)) {
            map = (scala.collection.immutable.Map)offsets.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition tp = (TopicPartition)tuple2._1();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToDouble((double)$this.ppc.maxRatePerPartition(tp)));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
        } else {
            throw new MatchError((Object)option);
        }
        scala.collection.immutable.Map effectiveRateLimitPerPartition = map;
        if (BoxesRunTime.unboxToDouble((Object)effectiveRateLimitPerPartition.values().sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) > 0.0) {
            double secsPerBatch = (double)this.context().graph().batchDuration().milliseconds() / (double)1000;
            none$ = new Some(effectiveRateLimitPerPartition.map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition tp = (TopicPartition)tuple2._1();
                double limit = tuple2._2$mcD$sp();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)Math.max((long)(secsPerBatch * limit), $this.ppc.minRatePerPartition(tp))));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom()));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private void paranoidPoll(Consumer<K, V> c) {
        block0: {
            c.pause(c.assignment());
            ConsumerRecords<K, V> msgs = c.poll(0L);
            if (msgs.isEmpty()) break block0;
            ((IterableLike)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(msgs).asScala()).foldLeft((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(acc, m) -> {
                TopicPartition tp = new TopicPartition(m.topic(), m.partition());
                long off = BoxesRunTime.unboxToLong((Object)acc.get((Object)tp).map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)o -> Math.min(o, m.offset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> m.offset()));
                return acc.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)off)));
            })).foreach((Function1 & Serializable & scala.Serializable)x0$5 -> {
                DirectKafkaInputDStream.$anonfun$paranoidPoll$4(this, c, x0$5);
                return BoxedUnit.UNIT;
            });
        }
    }

    public scala.collection.immutable.Map<TopicPartition, Object> latestOffsets() {
        Consumer c = this.consumer();
        this.paranoidPoll(c);
        scala.collection.mutable.Set parts = (scala.collection.mutable.Set)JavaConverters$.MODULE$.asScalaSetConverter(c.assignment()).asScala();
        scala.collection.mutable.Set newPartitions = (scala.collection.mutable.Set)parts.diff((GenSet)this.currentOffsets().keySet());
        scala.collection.immutable.Set revokedPartitions = (scala.collection.immutable.Set)this.currentOffsets().keySet().diff((GenSet)parts);
        if (revokedPartitions.nonEmpty()) {
            throw new IllegalStateException(new StringBuilder(257).append("Previously tracked partitions ").append(new StringBuilder(43).append(revokedPartitions.mkString("[", ",", "]")).append(" been revoked by Kafka because of consumer ").toString()).append("rebalance. This is mostly due to another stream with same group id joined, ").append("please check if there're different streaming application misconfigure to use same ").append("group id. Fundamentally different stream should use different group id").toString());
        }
        this.currentOffsets_$eq((scala.collection.immutable.Map<TopicPartition, Object>)this.currentOffsets().$plus$plus((GenTraversableOnce)((TraversableOnce)newPartitions.map((Function1 & Serializable & scala.Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)BoxesRunTime.boxToLong((long)c.position((TopicPartition)tp))), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())));
        c.seekToEnd((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.currentOffsets().keySet()).asJava());
        return ((TraversableOnce)parts.map((Function1 & Serializable & scala.Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)BoxesRunTime.boxToLong((long)c.position((TopicPartition)tp))), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<TopicPartition, Object> clamp(scala.collection.immutable.Map<TopicPartition, Object> offsets) {
        return (scala.collection.immutable.Map)this.maxMessagesPerPartition(offsets).map((Function1 & Serializable & scala.Serializable)mmp -> (scala.collection.immutable.Map)mmp.map((Function1 & Serializable & scala.Serializable)x0$6 -> {
            Tuple2 tuple2 = x0$6;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            long messages = tuple2._2$mcJ$sp();
            long uo = BoxesRunTime.unboxToLong((Object)offsets.apply((Object)tp));
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)Math.min(BoxesRunTime.unboxToLong((Object)this.currentOffsets().apply((Object)tp)) + messages, uo)));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> offsets);
    }

    public Option<KafkaRDD<K, V>> compute(Time validTime) {
        scala.collection.immutable.Map<TopicPartition, Object> untilOffsets = this.clamp(this.latestOffsets());
        Iterable offsetRanges = (Iterable)untilOffsets.map((Function1 & Serializable & scala.Serializable)x0$7 -> {
            Tuple2 tuple2 = x0$7;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            long uo = tuple2._2$mcJ$sp();
            long fo = BoxesRunTime.unboxToLong((Object)this.currentOffsets().apply((Object)tp));
            OffsetRange offsetRange = OffsetRange$.MODULE$.apply(tp.topic(), tp.partition(), fo, uo);
            return offsetRange;
        }, Iterable$.MODULE$.canBuildFrom());
        boolean useConsumerCache = this.context().conf().getBoolean("spark.streaming.kafka.consumer.cache.enabled", true);
        KafkaRDD rdd = new KafkaRDD(this.context().sparkContext(), this.executorKafkaParams(), (OffsetRange[])offsetRanges.toArray(ClassTag$.MODULE$.apply(OffsetRange.class)), this.getPreferredHosts(), useConsumerCache);
        String description = ((TraversableOnce)((TraversableLike)offsetRanges.filter((Function1 & Serializable & scala.Serializable)offsetRange -> BoxesRunTime.boxToBoolean((boolean)DirectKafkaInputDStream.$anonfun$compute$2(offsetRange)))).map((Function1 & Serializable & scala.Serializable)offsetRange -> new StringBuilder(20).append("topic: ").append(offsetRange.topic()).append("\tpartition: ").append(offsetRange.partition()).append("\t").append(new StringBuilder(13).append("offsets: ").append(offsetRange.fromOffset()).append(" to ").append(offsetRange.untilOffset()).toString()).toString(), Iterable$.MODULE$.canBuildFrom())).mkString("\n");
        scala.collection.immutable.Map metadata = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"offsets"), (Object)offsetRanges.toList()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StreamInputInfo$.MODULE$.METADATA_KEY_DESCRIPTION()), (Object)description)}));
        StreamInputInfo inputInfo = new StreamInputInfo(this.id(), rdd.count(), metadata);
        this.ssc().scheduler().inputInfoTracker().reportInfo(validTime, inputInfo);
        this.currentOffsets_$eq(untilOffsets);
        this.commitAll();
        return new Some(rdd);
    }

    public void start() {
        block0: {
            Consumer c = this.consumer();
            this.paranoidPoll(c);
            if (!this.currentOffsets().isEmpty()) break block0;
            this.currentOffsets_$eq((scala.collection.immutable.Map<TopicPartition, Object>)((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(c.assignment()).asScala()).map((Function1 & Serializable & scala.Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)BoxesRunTime.boxToLong((long)c.position((TopicPartition)tp))), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        }
    }

    public synchronized void stop() {
        block0: {
            if (this.kc() == null) break block0;
            this.kc().close();
        }
    }

    public ConcurrentLinkedQueue<OffsetRange> commitQueue() {
        return this.commitQueue;
    }

    public AtomicReference<OffsetCommitCallback> commitCallback() {
        return this.commitCallback;
    }

    @Override
    public void commitAsync(OffsetRange[] offsetRanges) {
        this.commitAsync(offsetRanges, null);
    }

    @Override
    public void commitAsync(OffsetRange[] offsetRanges, OffsetCommitCallback callback) {
        this.commitCallback().set(callback);
        this.commitQueue().addAll(Arrays.asList((Object[])offsetRanges));
    }

    public void commitAll() {
        block1: {
            HashMap<TopicPartition, OffsetAndMetadata> m = new HashMap<TopicPartition, OffsetAndMetadata>();
            OffsetRange osr = this.commitQueue().poll();
            while (osr != null) {
                TopicPartition tp = osr.topicPartition();
                OffsetAndMetadata x = (OffsetAndMetadata)m.get(tp);
                long offset = x == null ? osr.untilOffset() : Math.max(x.offset(), osr.untilOffset());
                m.put(tp, new OffsetAndMetadata(offset));
                osr = this.commitQueue().poll();
            }
            if (m.isEmpty()) break block1;
            this.consumer().commitAsync(m, this.commitCallback().get());
        }
    }

    public static final /* synthetic */ Long $anonfun$consumer$1(long l) {
        return new Long(l);
    }

    public static final /* synthetic */ long $anonfun$maxMessagesPerPartition$1(DirectKafkaInputDStream $this, RateController x) {
        long lr = x.getLatestRate();
        return lr > 0L ? lr : $this.initialRate();
    }

    public static final /* synthetic */ void $anonfun$paranoidPoll$4(DirectKafkaInputDStream $this, Consumer c$1, Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        long off = tuple2._2$mcJ$sp();
        $this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("poll(0) returned messages, seeking ").append(tp).append(" to ").append(off).append(" to compensate").toString());
        c$1.seek(tp, off);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$compute$2(OffsetRange offsetRange) {
        return offsetRange.fromOffset() != offsetRange.untilOffset();
    }

    public DirectKafkaInputDStream(StreamingContext _ssc, LocationStrategy locationStrategy, ConsumerStrategy<K, V> consumerStrategy, PerPartitionConfig ppc) {
        this.locationStrategy = locationStrategy;
        this.consumerStrategy = consumerStrategy;
        this.ppc = ppc;
        super(_ssc, ClassTag$.MODULE$.apply(ConsumerRecord.class));
        this.initialRate = this.context().sparkContext().getConf().getLong("spark.streaming.backpressure.initialRate", 0L);
        HashMap<String, Object> ekp = new HashMap<String, Object>(consumerStrategy.executorKafkaParams());
        KafkaUtils$.MODULE$.fixKafkaParams(ekp);
        this.executorKafkaParams = ekp;
        this.currentOffsets = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        this.kc = null;
        this.checkpointData = new DirectKafkaInputDStreamCheckpointData();
        this.rateController = RateController$.MODULE$.isBackPressureEnabled(this.ssc().conf()) ? new Some((Object)new DirectKafkaRateController(this.id(), RateEstimator$.MODULE$.create(this.ssc().conf(), this.context().graph().batchDuration()))) : None$.MODULE$;
        this.commitQueue = new ConcurrentLinkedQueue();
        this.commitCallback = new AtomicReference();
    }

    public class DirectKafkaInputDStreamCheckpointData
    extends DStreamCheckpointData<ConsumerRecord<K, V>> {
        public scala.collection.mutable.HashMap<Time, Tuple4<String, Object, Object, Object>[]> batchForTime() {
            return this.data();
        }

        public void update(Time time) {
            this.batchForTime().clear();
            this.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().generatedRDDs().foreach((Function1 & Serializable & scala.Serializable)kv -> {
                Tuple4[] a = (Tuple4[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((KafkaRDD)kv._2()).offsetRanges())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toTuple(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple4.class))))).toArray(ClassTag$.MODULE$.apply(Tuple4.class));
                return this.batchForTime().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(kv._1()), (Object)a));
            });
        }

        public void cleanup(Time time) {
        }

        public void restore() {
            ((IterableLike)this.batchForTime().toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$3 -> (Time)x$3._1(), Time$.MODULE$.ordering())).foreach((Function1 & Serializable & scala.Serializable)x0$8 -> {
                Tuple2 tuple2 = x0$8;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Time t = (Time)tuple2._1();
                Tuple4[] b = (Tuple4[])tuple2._2();
                this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Restoring KafkaRDD for time ").append(t).append(" ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])b)).mkString("[", ", ", "]")).toString());
                scala.collection.mutable.HashMap hashMap = this.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().generatedRDDs().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t), new KafkaRDD(this.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().context().sparkContext(), this.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().executorKafkaParams(), (OffsetRange[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])b)).map((Function1 & Serializable & scala.Serializable)x$4 -> OffsetRange$.MODULE$.apply((Tuple4<String, Object, Object, Object>)x$4), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(OffsetRange.class))), this.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().getPreferredHosts(), false)));
                return hashMap;
            });
        }

        public /* synthetic */ DirectKafkaInputDStream org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer() {
            return DirectKafkaInputDStream.this;
        }

        public DirectKafkaInputDStreamCheckpointData() {
            if (DirectKafkaInputDStream.this == null) {
                throw null;
            }
            super(DirectKafkaInputDStream.this, ClassTag$.MODULE$.apply(ConsumerRecord.class));
        }
    }

    public class DirectKafkaRateController
    extends RateController {
        public void publish(long rate) {
        }

        public /* synthetic */ DirectKafkaInputDStream org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaRateController$$$outer() {
            return DirectKafkaInputDStream.this;
        }

        public DirectKafkaRateController(int id, RateEstimator estimator) {
            if (DirectKafkaInputDStream.this == null) {
                throw null;
            }
            super(id, estimator);
        }
    }
}

