/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.impl.pb.PriorityPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ResourceRequestPBImpl
extends ResourceRequest {
    YarnProtos.ResourceRequestProto proto = YarnProtos.ResourceRequestProto.getDefaultInstance();
    YarnProtos.ResourceRequestProto.Builder builder = null;
    boolean viaProto = false;
    private Priority priority = null;
    private Resource capability = null;

    public ResourceRequestPBImpl() {
        this.builder = YarnProtos.ResourceRequestProto.newBuilder();
    }

    public ResourceRequestPBImpl(YarnProtos.ResourceRequestProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnProtos.ResourceRequestProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void mergeLocalToBuilder() {
        if (this.priority != null) {
            this.builder.setPriority(this.convertToProtoFormat(this.priority));
        }
        if (this.capability != null) {
            this.builder.setCapability(this.convertToProtoFormat(this.capability));
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.ResourceRequestProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    @Override
    public Priority getPriority() {
        YarnProtos.ResourceRequestProtoOrBuilder p;
        YarnProtos.ResourceRequestProtoOrBuilder resourceRequestProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.priority != null) {
            return this.priority;
        }
        if (!p.hasPriority()) {
            return null;
        }
        this.priority = this.convertFromProtoFormat(p.getPriority());
        return this.priority;
    }

    @Override
    public void setPriority(Priority priority) {
        this.maybeInitBuilder();
        if (priority == null) {
            this.builder.clearPriority();
        }
        this.priority = priority;
    }

    @Override
    public String getResourceName() {
        YarnProtos.ResourceRequestProtoOrBuilder p;
        YarnProtos.ResourceRequestProtoOrBuilder resourceRequestProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasResourceName()) {
            return null;
        }
        return p.getResourceName();
    }

    @Override
    public void setResourceName(String resourceName) {
        this.maybeInitBuilder();
        if (resourceName == null) {
            this.builder.clearResourceName();
            return;
        }
        this.builder.setResourceName(resourceName);
    }

    @Override
    public Resource getCapability() {
        YarnProtos.ResourceRequestProtoOrBuilder p;
        YarnProtos.ResourceRequestProtoOrBuilder resourceRequestProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.capability != null) {
            return this.capability;
        }
        if (!p.hasCapability()) {
            return null;
        }
        this.capability = this.convertFromProtoFormat(p.getCapability());
        return this.capability;
    }

    @Override
    public void setCapability(Resource capability) {
        this.maybeInitBuilder();
        if (capability == null) {
            this.builder.clearCapability();
        }
        this.capability = capability;
    }

    @Override
    public int getNumContainers() {
        YarnProtos.ResourceRequestProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getNumContainers();
    }

    @Override
    public void setNumContainers(int numContainers) {
        this.maybeInitBuilder();
        this.builder.setNumContainers(numContainers);
    }

    @Override
    public boolean getRelaxLocality() {
        YarnProtos.ResourceRequestProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getRelaxLocality();
    }

    @Override
    public void setRelaxLocality(boolean relaxLocality) {
        this.maybeInitBuilder();
        this.builder.setRelaxLocality(relaxLocality);
    }

    private PriorityPBImpl convertFromProtoFormat(YarnProtos.PriorityProto p) {
        return new PriorityPBImpl(p);
    }

    private YarnProtos.PriorityProto convertToProtoFormat(Priority t) {
        return ((PriorityPBImpl)t).getProto();
    }

    private ResourcePBImpl convertFromProtoFormat(YarnProtos.ResourceProto p) {
        return new ResourcePBImpl(p);
    }

    private YarnProtos.ResourceProto convertToProtoFormat(Resource t) {
        return ((ResourcePBImpl)t).getProto();
    }

    public String toString() {
        return "{Priority: " + this.getPriority() + ", Capability: " + this.getCapability() + ", # Containers: " + this.getNumContainers() + ", Location: " + this.getResourceName() + ", Relax Locality: " + this.getRelaxLocality() + "}";
    }

    @Override
    public String getNodeLabelExpression() {
        YarnProtos.ResourceRequestProtoOrBuilder p;
        YarnProtos.ResourceRequestProtoOrBuilder resourceRequestProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasNodeLabelExpression()) {
            return null;
        }
        return p.getNodeLabelExpression();
    }

    @Override
    public void setNodeLabelExpression(String nodeLabelExpression) {
        this.maybeInitBuilder();
        if (nodeLabelExpression == null) {
            this.builder.clearNodeLabelExpression();
            return;
        }
        this.builder.setNodeLabelExpression(nodeLabelExpression);
    }
}

