/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka010;

import java.io.Serializable;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.partial.BoundedDouble;
import org.apache.spark.partial.PartialResult;
import org.apache.spark.rdd.RDD;
import org.apache.spark.scheduler.ExecutorCacheTaskLocation;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.kafka010.CompactedKafkaRDDIterator;
import org.apache.spark.streaming.kafka010.HasOffsetRanges;
import org.apache.spark.streaming.kafka010.KafkaRDDIterator;
import org.apache.spark.streaming.kafka010.KafkaRDDPartition;
import org.apache.spark.streaming.kafka010.OffsetRange;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t5b!\u0002\u0011\"\u0001\u0015Z\u0003\u0002C-\u0001\u0005\u0003\u0005\u000b\u0011\u0002.\t\u0011y\u0003!Q1A\u0005\u0002}C\u0001\"\u001f\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\tu\u0002\u0011)\u0019!C\u0001w\"I\u0011Q\u0001\u0001\u0003\u0002\u0003\u0006I\u0001 \u0005\u000b\u0003\u000f\u0001!Q1A\u0005\u0002\u0005%\u0001BCA\r\u0001\t\u0005\t\u0015!\u0003\u0002\f!Q\u00111\u0004\u0001\u0003\u0002\u0003\u0006I!!\b\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&!I\u00111\u0007\u0001C\u0002\u0013%\u0011Q\u0007\u0005\t\u0003{\u0001\u0001\u0015!\u0003\u00028!I\u0011q\b\u0001C\u0002\u0013%\u0011\u0011\t\u0005\t\u0003\u0013\u0002\u0001\u0015!\u0003\u0002D!I\u00111\n\u0001C\u0002\u0013%\u0011\u0011\t\u0005\t\u0003\u001b\u0002\u0001\u0015!\u0003\u0002D!I\u0011q\n\u0001C\u0002\u0013%\u0011\u0011\u000b\u0005\t\u00033\u0002\u0001\u0015!\u0003\u0002T!I\u00111\f\u0001C\u0002\u0013%\u0011Q\f\u0005\t\u0003?\u0002\u0001\u0015!\u0003\u0002\u001e!9\u0011\u0011\r\u0001\u0005B\u0005\r\u0004bBA<\u0001\u0011\u0005\u0013\u0011\u0010\u0005\b\u0003\u0007\u0003A\u0011IAC\u0011\u001d\t9\t\u0001C!\u0003\u0013C\u0011\"a+\u0001#\u0003%\t!!,\t\u000f\u0005\r\u0007\u0001\"\u0011\u0002F\"9\u0011q\u0019\u0001\u0005B\u0005%\u0007bBAi\u0001\u0011%\u00111\u001b\u0005\t\u0003G\u0004A\u0011C\u0011\u0002f\"9\u0011q\u001e\u0001\u0005B\u0005E\bb\u0002B\u0005\u0001\u0011%!1\u0002\u0005\b\u0005/\u0001A\u0011\tB\r\u0005!Y\u0015MZ6b%\u0012#%B\u0001\u0012$\u0003!Y\u0017MZ6baE\u0002$B\u0001\u0013&\u0003%\u0019HO]3b[&twM\u0003\u0002'O\u0005)1\u000f]1sW*\u0011\u0001&K\u0001\u0007CB\f7\r[3\u000b\u0003)\n1a\u001c:h+\ras(T\n\u0005\u00015zU\u000bE\u0002/cMj\u0011a\f\u0006\u0003a\u0015\n1A\u001d3e\u0013\t\u0011tFA\u0002S\t\u0012\u0003B\u0001N\u001e>\u00196\tQG\u0003\u00027o\u0005A1m\u001c8tk6,'O\u0003\u00029s\u000591\r\\5f]R\u001c(B\u0001\u001e(\u0003\u0015Y\u0017MZ6b\u0013\taTG\u0001\bD_:\u001cX/\\3s%\u0016\u001cwN\u001d3\u0011\u0005yzD\u0002\u0001\u0003\u0006\u0001\u0002\u0011\rA\u0011\u0002\u0002\u0017\u000e\u0001\u0011CA\"J!\t!u)D\u0001F\u0015\u00051\u0015!B:dC2\f\u0017B\u0001%F\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001\u0012&\n\u0005-+%aA!osB\u0011a(\u0014\u0003\u0006\u001d\u0002\u0011\rA\u0011\u0002\u0002-B\u0011\u0001kU\u0007\u0002#*\u0011!+J\u0001\tS:$XM\u001d8bY&\u0011A+\u0015\u0002\b\u0019><w-\u001b8h!\t1v+D\u0001\"\u0013\tA\u0016EA\bICN|eMZ:fiJ\u000bgnZ3t\u0003\t\u00198\r\u0005\u0002\\96\tQ%\u0003\u0002^K\ta1\u000b]1sW\u000e{g\u000e^3yi\u0006Y1.\u00194lCB\u000b'/Y7t+\u0005\u0001\u0007\u0003B1gQNl\u0011A\u0019\u0006\u0003G\u0012\fA!\u001e;jY*\tQ-\u0001\u0003kCZ\f\u0017BA4c\u0005\ri\u0015\r\u001d\t\u0003SBt!A\u001b8\u0011\u0005-,U\"\u00017\u000b\u00055\f\u0015A\u0002\u001fs_>$h(\u0003\u0002p\u000b\u00061\u0001K]3eK\u001aL!!\u001d:\u0003\rM#(/\u001b8h\u0015\tyW\t\u0005\u0002uo6\tQO\u0003\u0002wI\u0006!A.\u00198h\u0013\tAXO\u0001\u0004PE*,7\r^\u0001\rW\u000647.\u0019)be\u0006l7\u000fI\u0001\r_\u001a47/\u001a;SC:<Wm]\u000b\u0002yB\u0019A)`@\n\u0005y,%!B!se\u0006L\bc\u0001,\u0002\u0002%\u0019\u00111A\u0011\u0003\u0017=3gm]3u%\u0006tw-Z\u0001\u000e_\u001a47/\u001a;SC:<Wm\u001d\u0011\u0002\u001dA\u0014XMZ3se\u0016$\u0007j\\:ugV\u0011\u00111\u0002\t\u0006C\u001a\fi\u0001\u001b\t\u0005\u0003\u001f\t)\"\u0004\u0002\u0002\u0012)\u0019\u00111C\u001d\u0002\r\r|W.\\8o\u0013\u0011\t9\"!\u0005\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006y\u0001O]3gKJ\u0014X\r\u001a%pgR\u001c\b%\u0001\tvg\u0016\u001cuN\\:v[\u0016\u00148)Y2iKB\u0019A)a\b\n\u0007\u0005\u0005RIA\u0004C_>dW-\u00198\u0002\rqJg.\u001b;?)1\t9#!\u000b\u0002,\u00055\u0012qFA\u0019!\u00111\u0006!\u0010'\t\u000beK\u0001\u0019\u0001.\t\u000byK\u0001\u0019\u00011\t\u000biL\u0001\u0019\u0001?\t\u000f\u0005\u001d\u0011\u00021\u0001\u0002\f!9\u00111D\u0005A\u0002\u0005u\u0011a\u00039pY2$\u0016.\\3pkR,\"!a\u000e\u0011\u0007\u0011\u000bI$C\u0002\u0002<\u0015\u0013A\u0001T8oO\u0006a\u0001o\u001c7m)&lWm\\;uA\u0005!2-Y2iK&s\u0017\u000e^5bY\u000e\u000b\u0007/Y2jif,\"!a\u0011\u0011\u0007\u0011\u000b)%C\u0002\u0002H\u0015\u00131!\u00138u\u0003U\u0019\u0017m\u00195f\u0013:LG/[1m\u0007\u0006\u0004\u0018mY5us\u0002\n\u0001cY1dQ\u0016l\u0015\r_\"ba\u0006\u001c\u0017\u000e^=\u0002#\r\f7\r[3NCb\u001c\u0015\r]1dSRL\b%A\bdC\u000eDW\rT8bI\u001a\u000b7\r^8s+\t\t\u0019\u0006E\u0002E\u0003+J1!a\u0016F\u0005\u00151En\\1u\u0003A\u0019\u0017m\u00195f\u0019>\fGMR1di>\u0014\b%A\u0005d_6\u0004\u0018m\u0019;fIV\u0011\u0011QD\u0001\u000bG>l\u0007/Y2uK\u0012\u0004\u0013a\u00029feNL7\u000f\u001e\u000b\u0005\u0003K\n9'D\u0001\u0001\u0011\u001d\tI\u0007\u0006a\u0001\u0003W\n\u0001B\\3x\u0019\u00164X\r\u001c\t\u0005\u0003[\n\u0019(\u0004\u0002\u0002p)\u0019\u0011\u0011O\u0013\u0002\u000fM$xN]1hK&!\u0011QOA8\u00051\u0019Fo\u001c:bO\u0016dUM^3m\u000359W\r\u001e)beRLG/[8ogV\u0011\u00111\u0010\t\u0005\tv\fi\bE\u0002\\\u0003\u007fJ1!!!&\u0005%\u0001\u0016M\u001d;ji&|g.A\u0003d_VtG\u000f\u0006\u0002\u00028\u0005Y1m\\;oi\u0006\u0003\bO]8y)\u0019\tY)!(\u0002\"B1\u0011QRAJ\u0003/k!!a$\u000b\u0007\u0005EU%A\u0004qCJ$\u0018.\u00197\n\t\u0005U\u0015q\u0012\u0002\u000e!\u0006\u0014H/[1m%\u0016\u001cX\u000f\u001c;\u0011\t\u00055\u0015\u0011T\u0005\u0005\u00037\u000byIA\u0007C_VtG-\u001a3E_V\u0014G.\u001a\u0005\b\u0003?;\u0002\u0019AA\u001c\u0003\u001d!\u0018.\\3pkRD\u0011\"a)\u0018!\u0003\u0005\r!!*\u0002\u0015\r|gNZ5eK:\u001cW\rE\u0002E\u0003OK1!!+F\u0005\u0019!u.\u001e2mK\u0006)2m\\;oi\u0006\u0003\bO]8yI\u0011,g-Y;mi\u0012\u0012TCAAXU\u0011\t)+!-,\u0005\u0005M\u0006\u0003BA[\u0003\u007fk!!a.\u000b\t\u0005e\u00161X\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!0F\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0003\f9LA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fq![:F[B$\u0018\u0010\u0006\u0002\u0002\u001e\u0005!A/Y6f)\u0011\tY-!4\u0011\u0007\u0011k8\u0007C\u0004\u0002Pj\u0001\r!a\u0011\u0002\u00079,X.A\u0005fq\u0016\u001cW\u000f^8sgR\u0011\u0011Q\u001b\t\u0005\tv\f9\u000e\u0005\u0003\u0002Z\u0006}WBAAn\u0015\r\ti.J\u0001\ng\u000eDW\rZ;mKJLA!!9\u0002\\\nIR\t_3dkR|'oQ1dQ\u0016$\u0016m]6M_\u000e\fG/[8o\u0003A\u0019w.\u001c9be\u0016,\u00050Z2vi>\u00148\u000f\u0006\u0004\u0002\u001e\u0005\u001d\u00181\u001e\u0005\b\u0003Sd\u0002\u0019AAl\u0003\u0005\t\u0007bBAw9\u0001\u0007\u0011q[\u0001\u0002E\u0006)r-\u001a;Qe\u00164WM\u001d:fI2{7-\u0019;j_:\u001cH\u0003BAz\u0005\u000b\u0001R!!>\u0002\u0000\"tA!a>\u0002|:\u00191.!?\n\u0003\u0019K1!!@F\u0003\u001d\u0001\u0018mY6bO\u0016LAA!\u0001\u0003\u0004\t\u00191+Z9\u000b\u0007\u0005uX\tC\u0004\u0003\bu\u0001\r!! \u0002\u000fQDW\rU1si\u0006\u0001RM\u001d:CK\u001eLg.\u00114uKJ,e\u000e\u001a\u000b\u0004Q\n5\u0001b\u0002B\b=\u0001\u0007!\u0011C\u0001\u0005a\u0006\u0014H\u000fE\u0002W\u0005'I1A!\u0006\"\u0005EY\u0015MZ6b%\u0012#\u0005+\u0019:uSRLwN\\\u0001\bG>l\u0007/\u001e;f)\u0019\u0011YB!\t\u0003$A)\u0011Q\u001fB\u000fg%!!q\u0004B\u0002\u0005!IE/\u001a:bi>\u0014\bb\u0002B\u0004?\u0001\u0007\u0011Q\u0010\u0005\b\u0005Ky\u0002\u0019\u0001B\u0014\u0003\u001d\u0019wN\u001c;fqR\u00042a\u0017B\u0015\u0013\r\u0011Y#\n\u0002\f)\u0006\u001c8nQ8oi\u0016DH\u000f")
public class KafkaRDD<K, V>
extends RDD<ConsumerRecord<K, V>>
implements HasOffsetRanges {
    private final Map<String, Object> kafkaParams;
    private final OffsetRange[] offsetRanges;
    private final Map<TopicPartition, String> preferredHosts;
    private final boolean useConsumerCache;
    private final long pollTimeout;
    private final int cacheInitialCapacity;
    private final int cacheMaxCapacity;
    private final float cacheLoadFactor;
    private final boolean compacted;

    public Map<String, Object> kafkaParams() {
        return this.kafkaParams;
    }

    @Override
    public OffsetRange[] offsetRanges() {
        return this.offsetRanges;
    }

    public Map<TopicPartition, String> preferredHosts() {
        return this.preferredHosts;
    }

    private long pollTimeout() {
        return this.pollTimeout;
    }

    private int cacheInitialCapacity() {
        return this.cacheInitialCapacity;
    }

    private int cacheMaxCapacity() {
        return this.cacheMaxCapacity;
    }

    private float cacheLoadFactor() {
        return this.cacheLoadFactor;
    }

    private boolean compacted() {
        return this.compacted;
    }

    public KafkaRDD<K, V> persist(StorageLevel newLevel) {
        this.logError((Function0 & Serializable & scala.Serializable)() -> "Kafka ConsumerRecord is not serializable. Use .map to extract fields before calling .persist or .window");
        return (KafkaRDD)super.persist(newLevel);
    }

    public Partition[] getPartitions() {
        return (Partition[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.offsetRanges())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            OffsetRange o = (OffsetRange)tuple2._1();
            int i = tuple2._2$mcI$sp();
            KafkaRDDPartition kafkaRDDPartition = new KafkaRDDPartition(i, o.topic(), o.partition(), o.fromOffset(), o.untilOffset());
            return kafkaRDDPartition;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(KafkaRDDPartition.class))))).toArray(ClassTag$.MODULE$.apply(Partition.class));
    }

    public long count() {
        return this.compacted() ? super.count() : BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.offsetRanges())).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.count()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public PartialResult<BoundedDouble> countApprox(long timeout, double confidence) {
        PartialResult partialResult;
        if (this.compacted()) {
            partialResult = super.countApprox(timeout, confidence);
        } else {
            long c = this.count();
            partialResult = new PartialResult((Object)new BoundedDouble((double)c, 1.0, (double)c, (double)c), true);
        }
        return partialResult;
    }

    public double countApprox$default$2() {
        return 0.95;
    }

    public boolean isEmpty() {
        return this.compacted() ? super.isEmpty() : this.count() == 0L;
    }

    public ConsumerRecord<K, V>[] take(int num) {
        ConsumerRecord[] consumerRecordArray;
        if (this.compacted()) {
            consumerRecordArray = (ConsumerRecord[])super.take(num);
        } else if (num < 1) {
            consumerRecordArray = (ConsumerRecord[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ConsumerRecord.class));
        } else {
            KafkaRDDPartition[] nonEmptyPartitions = (KafkaRDDPartition[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.partitions())).map((Function1 & Serializable & scala.Serializable)x$2 -> (KafkaRDDPartition)x$2, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(KafkaRDDPartition.class))))).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)KafkaRDD.$anonfun$take$2(x$3)));
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nonEmptyPartitions)).isEmpty()) {
                consumerRecordArray = (ConsumerRecord[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ConsumerRecord.class));
            } else {
                scala.collection.immutable.Map parts = (scala.collection.immutable.Map)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nonEmptyPartitions)).foldLeft((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(result, part) -> {
                    scala.collection.immutable.Map map;
                    int remain = num - BoxesRunTime.unboxToInt((Object)result.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                    if (remain > 0) {
                        long taken = Math.min((long)remain, part.count());
                        map = result.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)part.index())), (Object)BoxesRunTime.boxToInteger((int)((int)taken))));
                    } else {
                        map = result;
                    }
                    return map;
                });
                consumerRecordArray = (ConsumerRecord[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.context().runJob((RDD)this, (Function2 & Serializable & scala.Serializable)(tc, it) -> (ConsumerRecord[])it.take(BoxesRunTime.unboxToInt((Object)parts.apply((Object)BoxesRunTime.boxToInteger((int)tc.partitionId())))).toArray(ClassTag$.MODULE$.apply(ConsumerRecord.class)), (Seq)Predef$.MODULE$.wrapIntArray((int[])parts.keys().toArray(ClassTag$.MODULE$.Int())), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ConsumerRecord.class))))).flatten((Function1 & Serializable & scala.Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(ConsumerRecord.class));
            }
        }
        return consumerRecordArray;
    }

    private ExecutorCacheTaskLocation[] executors() {
        BlockManager bm = this.sparkContext().env().blockManager();
        return (ExecutorCacheTaskLocation[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])bm.master().getPeers(bm.blockManagerId()).toArray(ClassTag$.MODULE$.apply(BlockManagerId.class)))).map((Function1 & Serializable & scala.Serializable)x -> new ExecutorCacheTaskLocation(x.host(), x.executorId()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ExecutorCacheTaskLocation.class))))).sortWith((Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)this.compareExecutors(a, b)));
    }

    public boolean compareExecutors(ExecutorCacheTaskLocation a, ExecutorCacheTaskLocation b) {
        String string = a.host();
        String string2 = b.host();
        return !(string != null ? !string.equals(string2) : string2 != null) ? new StringOps(Predef$.MODULE$.augmentString(a.executorId())).$greater((Object)b.executorId()) : new StringOps(Predef$.MODULE$.augmentString(a.host())).$greater((Object)b.host());
    }

    public Seq<String> getPreferredLocations(Partition thePart) {
        Seq seq;
        ExecutorCacheTaskLocation[] execs;
        KafkaRDDPartition part = (KafkaRDDPartition)thePart;
        ExecutorCacheTaskLocation[] allExecs = this.executors();
        TopicPartition tp = part.topicPartition();
        String prefHost = this.preferredHosts().get(tp);
        ExecutorCacheTaskLocation[] prefExecs = prefHost == null ? allExecs : (ExecutorCacheTaskLocation[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allExecs)).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)KafkaRDD.$anonfun$getPreferredLocations$1(prefHost, x$4)));
        ExecutorCacheTaskLocation[] executorCacheTaskLocationArray = execs = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])prefExecs)).isEmpty() ? allExecs : prefExecs;
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])execs)).isEmpty()) {
            seq = (Seq)Seq$.MODULE$.empty();
        } else {
            int index = Math.floorMod(tp.hashCode(), execs.length);
            ExecutorCacheTaskLocation chosen = execs[index];
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{chosen.toString()}));
        }
        return seq;
    }

    private String errBeginAfterEnd(KafkaRDDPartition part) {
        return new StringBuilder(147).append("Beginning offset ").append(part.fromOffset()).append(" is after the ending offset ").append(part.untilOffset()).append(" ").append("for topic ").append(part.topic()).append(" partition ").append(part.partition()).append(". ").append("You either provided an invalid fromOffset, or the Kafka topic has been damaged").toString();
    }

    public Iterator<ConsumerRecord<K, V>> compute(Partition thePart, TaskContext context) {
        Iterator iterator;
        KafkaRDDPartition part = (KafkaRDDPartition)thePart;
        Predef$.MODULE$.require(part.fromOffset() <= part.untilOffset(), (Function0 & Serializable & scala.Serializable)() -> this.errBeginAfterEnd(part));
        if (part.fromOffset() == part.untilOffset()) {
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Beginning offset ").append(part.fromOffset()).append(" is the same as ending offset ").append("skipping ").append(part.topic()).append(" ").append(part.partition()).toString());
            iterator = package$.MODULE$.Iterator().empty();
        } else {
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Computing topic ").append(part.topic()).append(", partition ").append(part.partition()).append(" ").append("offsets ").append(part.fromOffset()).append(" -> ").append(part.untilOffset()).toString());
            iterator = this.compacted() ? new CompactedKafkaRDDIterator(part, context, this.kafkaParams(), this.useConsumerCache, this.pollTimeout(), this.cacheInitialCapacity(), this.cacheMaxCapacity(), this.cacheLoadFactor()) : new KafkaRDDIterator(part, context, this.kafkaParams(), this.useConsumerCache, this.pollTimeout(), this.cacheInitialCapacity(), this.cacheMaxCapacity(), this.cacheLoadFactor());
        }
        return iterator;
    }

    public static final /* synthetic */ boolean $anonfun$take$2(KafkaRDDPartition x$3) {
        return x$3.count() > 0L;
    }

    public static final /* synthetic */ boolean $anonfun$getPreferredLocations$1(String prefHost$1, ExecutorCacheTaskLocation x$4) {
        String string = x$4.host();
        String string2 = prefHost$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public KafkaRDD(SparkContext sc, Map<String, Object> kafkaParams, OffsetRange[] offsetRanges, Map<TopicPartition, String> preferredHosts, boolean useConsumerCache) {
        this.kafkaParams = kafkaParams;
        this.offsetRanges = offsetRanges;
        this.preferredHosts = preferredHosts;
        this.useConsumerCache = useConsumerCache;
        super(sc, (Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ConsumerRecord.class));
        Predef$.MODULE$.require("none".equals((String)kafkaParams.get("auto.offset.reset")), (Function0 & Serializable & scala.Serializable)() -> "auto.offset.reset must be set to none for executor kafka params, else messages may not match offsetRange");
        Predef$.MODULE$.require(false == BoxesRunTime.unboxToBoolean((Object)kafkaParams.get("enable.auto.commit")), (Function0 & Serializable & scala.Serializable)() -> "enable.auto.commit must be set to false for executor kafka params, else offsets may commit before processing");
        this.pollTimeout = this.conf().getLong("spark.streaming.kafka.consumer.poll.ms", this.conf().getTimeAsSeconds("spark.network.timeout", "120s") * 1000L);
        this.cacheInitialCapacity = this.conf().getInt("spark.streaming.kafka.consumer.cache.initialCapacity", 16);
        this.cacheMaxCapacity = this.conf().getInt("spark.streaming.kafka.consumer.cache.maxCapacity", 64);
        this.cacheLoadFactor = (float)this.conf().getDouble("spark.streaming.kafka.consumer.cache.loadFactor", 0.75);
        this.compacted = this.conf().getBoolean("spark.streaming.kafka.allowNonConsecutiveOffsets", false);
    }
}

