/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka010;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.api.java.JavaInputDStream;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.streaming.kafka010.ConsumerStrategy;
import org.apache.spark.streaming.kafka010.DefaultPerPartitionConfig;
import org.apache.spark.streaming.kafka010.DirectKafkaInputDStream;
import org.apache.spark.streaming.kafka010.KafkaRDD;
import org.apache.spark.streaming.kafka010.LocationStrategy;
import org.apache.spark.streaming.kafka010.OffsetRange;
import org.apache.spark.streaming.kafka010.PerPartitionConfig;
import org.apache.spark.streaming.kafka010.PreferBrokers$;
import org.apache.spark.streaming.kafka010.PreferConsistent$;
import org.apache.spark.streaming.kafka010.PreferFixed;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.reflect.ClassTag$;

public final class KafkaUtils$
implements Logging {
    public static KafkaUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new KafkaUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public <K, V> RDD<ConsumerRecord<K, V>> createRDD(SparkContext sc, Map<String, Object> kafkaParams, OffsetRange[] offsetRanges, LocationStrategy locationStrategy) {
        Map<TopicPartition, String> map;
        LocationStrategy locationStrategy2 = locationStrategy;
        if (PreferBrokers$.MODULE$.equals(locationStrategy2)) {
            throw new IllegalArgumentException("If you want to prefer brokers, you must provide a mapping using PreferFixed A single KafkaRDD does not have a driver consumer and cannot look up brokers for you.");
        }
        if (PreferConsistent$.MODULE$.equals(locationStrategy2)) {
            map = Collections.emptyMap();
        } else if (locationStrategy2 instanceof PreferFixed) {
            PreferFixed preferFixed = (PreferFixed)locationStrategy2;
            Map<TopicPartition, String> hostMap = preferFixed.hostMap();
            map = hostMap;
        } else {
            throw new MatchError((Object)locationStrategy2);
        }
        Map<TopicPartition, String> preferredHosts = map;
        HashMap<String, Object> kp = new HashMap<String, Object>(kafkaParams);
        this.fixKafkaParams(kp);
        OffsetRange[] osr = (OffsetRange[])offsetRanges.clone();
        return new KafkaRDD(sc, kp, osr, preferredHosts, true);
    }

    public <K, V> JavaRDD<ConsumerRecord<K, V>> createRDD(JavaSparkContext jsc, Map<String, Object> kafkaParams, OffsetRange[] offsetRanges, LocationStrategy locationStrategy) {
        return new JavaRDD(this.createRDD(jsc.sc(), kafkaParams, offsetRanges, locationStrategy), ClassTag$.MODULE$.apply(ConsumerRecord.class));
    }

    public <K, V> InputDStream<ConsumerRecord<K, V>> createDirectStream(StreamingContext ssc, LocationStrategy locationStrategy, ConsumerStrategy<K, V> consumerStrategy) {
        DefaultPerPartitionConfig ppc = new DefaultPerPartitionConfig(ssc.sparkContext().getConf());
        return this.createDirectStream(ssc, locationStrategy, consumerStrategy, (PerPartitionConfig)ppc);
    }

    public <K, V> InputDStream<ConsumerRecord<K, V>> createDirectStream(StreamingContext ssc, LocationStrategy locationStrategy, ConsumerStrategy<K, V> consumerStrategy, PerPartitionConfig perPartitionConfig) {
        return new DirectKafkaInputDStream<K, V>(ssc, locationStrategy, consumerStrategy, perPartitionConfig);
    }

    public <K, V> JavaInputDStream<ConsumerRecord<K, V>> createDirectStream(JavaStreamingContext jssc, LocationStrategy locationStrategy, ConsumerStrategy<K, V> consumerStrategy) {
        return new JavaInputDStream(this.createDirectStream(jssc.ssc(), locationStrategy, consumerStrategy), ClassTag$.MODULE$.apply(ConsumerRecord.class));
    }

    public <K, V> JavaInputDStream<ConsumerRecord<K, V>> createDirectStream(JavaStreamingContext jssc, LocationStrategy locationStrategy, ConsumerStrategy<K, V> consumerStrategy, PerPartitionConfig perPartitionConfig) {
        return new JavaInputDStream(this.createDirectStream(jssc.ssc(), locationStrategy, consumerStrategy, perPartitionConfig), ClassTag$.MODULE$.apply(ConsumerRecord.class));
    }

    public void fixKafkaParams(HashMap<String, Object> kafkaParams) {
        block1: {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("overriding ").append("enable.auto.commit").append(" to false for executor").toString());
            kafkaParams.put("enable.auto.commit", Predef$.MODULE$.boolean2Boolean(false));
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("overriding ").append("auto.offset.reset").append(" to none for executor").toString());
            kafkaParams.put("auto.offset.reset", "none");
            Object originalGroupId = kafkaParams.get("group.id");
            if (originalGroupId == null) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("group.id").append(" is null, you should probably set it").toString());
            }
            String groupId = new StringBuilder(15).append("spark-executor-").append(originalGroupId).toString();
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("overriding executor ").append("group.id").append(" to ").append(groupId).toString());
            kafkaParams.put("group.id", groupId);
            Object rbb = kafkaParams.get("receive.buffer.bytes");
            if (rbb != null && Predef$.MODULE$.Integer2int((Integer)rbb) >= 65536) break block1;
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("overriding ").append("receive.buffer.bytes").append(" to 65536 see KAFKA-3135").toString());
            kafkaParams.put("receive.buffer.bytes", Predef$.MODULE$.int2Integer(65536));
        }
    }

    private KafkaUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

