/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.jwk;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.jwk.KeyOperation;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.util.Base64;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jose.util.JSONObjectUtils;
import com.nimbusds.jose.util.X509CertChainUtils;
import java.net.URI;
import java.text.ParseException;
import java.util.List;
import java.util.Set;
import net.minidev.json.JSONObject;

final class JWKMetadata {
    JWKMetadata() {
    }

    static KeyType parseKeyType(JSONObject o) throws ParseException {
        return KeyType.parse(JSONObjectUtils.getString(o, "kty"));
    }

    static KeyUse parseKeyUse(JSONObject o) throws ParseException {
        if (o.containsKey("use")) {
            return KeyUse.parse(JSONObjectUtils.getString(o, "use"));
        }
        return null;
    }

    static Set<KeyOperation> parseKeyOperations(JSONObject o) throws ParseException {
        if (o.containsKey("key_ops")) {
            return KeyOperation.parse(JSONObjectUtils.getStringList(o, "key_ops"));
        }
        return null;
    }

    static Algorithm parseAlgorithm(JSONObject o) throws ParseException {
        if (o.containsKey("alg")) {
            return new Algorithm(JSONObjectUtils.getString(o, "alg"));
        }
        return null;
    }

    static String parseKeyID(JSONObject o) throws ParseException {
        if (o.containsKey("kid")) {
            return JSONObjectUtils.getString(o, "kid");
        }
        return null;
    }

    static URI parseX509CertURL(JSONObject o) throws ParseException {
        if (o.containsKey("x5u")) {
            return JSONObjectUtils.getURI(o, "x5u");
        }
        return null;
    }

    static Base64URL parseX509CertThumbprint(JSONObject o) throws ParseException {
        if (o.containsKey("x5t")) {
            return new Base64URL(JSONObjectUtils.getString(o, "x5t"));
        }
        return null;
    }

    static Base64URL parseX509CertSHA256Thumbprint(JSONObject o) throws ParseException {
        if (o.containsKey("x5t#S256")) {
            return new Base64URL(JSONObjectUtils.getString(o, "x5t#S256"));
        }
        return null;
    }

    static List<Base64> parseX509CertChain(JSONObject o) throws ParseException {
        if (o.containsKey("x5c")) {
            return X509CertChainUtils.parseX509CertChain(JSONObjectUtils.getJSONArray(o, "x5c"));
        }
        return null;
    }
}

