/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;

public class JSONObjectUtils {
    public static JSONObject parse(String s) throws java.text.ParseException {
        Object o;
        try {
            o = new JSONParser(640).parse(s);
        }
        catch (ParseException e) {
            throw new java.text.ParseException("Invalid JSON: " + e.getMessage(), 0);
        }
        if (o instanceof JSONObject) {
            return (JSONObject)o;
        }
        throw new java.text.ParseException("JSON entity is not an object", 0);
    }

    @Deprecated
    public static JSONObject parseJSONObject(String s) throws java.text.ParseException {
        return JSONObjectUtils.parse(s);
    }

    private static <T> T getGeneric(JSONObject o, String key, Class<T> clazz) throws java.text.ParseException {
        if (!o.containsKey(key)) {
            throw new java.text.ParseException("Missing JSON object member with key \"" + key + "\"", 0);
        }
        if (o.get(key) == null) {
            throw new java.text.ParseException("JSON object member with key \"" + key + "\" has null value", 0);
        }
        Object value = o.get(key);
        if (!clazz.isAssignableFrom(value.getClass())) {
            throw new java.text.ParseException("Unexpected type of JSON object member with key \"" + key + "\"", 0);
        }
        return (T)value;
    }

    public static boolean getBoolean(JSONObject o, String key) throws java.text.ParseException {
        return JSONObjectUtils.getGeneric(o, key, Boolean.class);
    }

    public static int getInt(JSONObject o, String key) throws java.text.ParseException {
        return JSONObjectUtils.getGeneric(o, key, Number.class).intValue();
    }

    public static long getLong(JSONObject o, String key) throws java.text.ParseException {
        return JSONObjectUtils.getGeneric(o, key, Number.class).longValue();
    }

    public static float getFloat(JSONObject o, String key) throws java.text.ParseException {
        return JSONObjectUtils.getGeneric(o, key, Number.class).floatValue();
    }

    public static double getDouble(JSONObject o, String key) throws java.text.ParseException {
        return JSONObjectUtils.getGeneric(o, key, Number.class).doubleValue();
    }

    public static String getString(JSONObject o, String key) throws java.text.ParseException {
        return JSONObjectUtils.getGeneric(o, key, String.class);
    }

    public static URI getURI(JSONObject o, String key) throws java.text.ParseException {
        try {
            return new URI(JSONObjectUtils.getGeneric(o, key, String.class));
        }
        catch (URISyntaxException e) {
            throw new java.text.ParseException(e.getMessage(), 0);
        }
    }

    public static JSONArray getJSONArray(JSONObject o, String key) throws java.text.ParseException {
        return JSONObjectUtils.getGeneric(o, key, JSONArray.class);
    }

    public static String[] getStringArray(JSONObject o, String key) throws java.text.ParseException {
        JSONArray jsonArray = JSONObjectUtils.getJSONArray(o, key);
        try {
            return jsonArray.toArray(new String[0]);
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new java.text.ParseException("JSON object member with key \"" + key + "\" is not an array of strings", 0);
        }
    }

    public static List<String> getStringList(JSONObject o, String key) throws java.text.ParseException {
        String[] array = JSONObjectUtils.getStringArray(o, key);
        return Arrays.asList(array);
    }

    public static JSONObject getJSONObject(JSONObject o, String key) throws java.text.ParseException {
        return JSONObjectUtils.getGeneric(o, key, JSONObject.class);
    }

    private JSONObjectUtils() {
    }
}

