/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.sparkproject.guava.annotations.VisibleForTesting;

public abstract class ByteRangeInputStream
extends FSInputStream {
    protected InputStream in;
    protected final URLOpener originalURL;
    protected final URLOpener resolvedURL;
    protected long startPos = 0L;
    protected long currentPos = 0L;
    protected Long fileLength = null;
    StreamStatus status = StreamStatus.SEEK;

    public ByteRangeInputStream(URLOpener o, URLOpener r) throws IOException {
        this.originalURL = o;
        this.resolvedURL = r;
        this.getInputStream();
    }

    protected abstract URL getResolvedUrl(HttpURLConnection var1) throws IOException;

    @VisibleForTesting
    protected InputStream getInputStream() throws IOException {
        switch (this.status) {
            case NORMAL: {
                break;
            }
            case SEEK: {
                if (this.in != null) {
                    this.in.close();
                }
                InputStreamAndFileLength fin = this.openInputStream(this.startPos);
                this.in = fin.in;
                this.fileLength = fin.length;
                this.status = StreamStatus.NORMAL;
                break;
            }
            case CLOSED: {
                throw new IOException("Stream closed");
            }
        }
        return this.in;
    }

    @VisibleForTesting
    protected InputStreamAndFileLength openInputStream(long startOffset) throws IOException {
        Long length;
        if (startOffset < 0L) {
            throw new EOFException("Negative Position");
        }
        boolean resolved = this.resolvedURL.getURL() != null;
        URLOpener opener = resolved ? this.resolvedURL : this.originalURL;
        HttpURLConnection connection = opener.connect(startOffset, resolved);
        this.resolvedURL.setURL(this.getResolvedUrl(connection));
        InputStream in = connection.getInputStream();
        Map<String, List<String>> headers = connection.getHeaderFields();
        if (ByteRangeInputStream.isChunkedTransferEncoding(headers)) {
            length = null;
        } else {
            String cl = connection.getHeaderField("Content-Length");
            if (cl == null) {
                throw new IOException("Content-Length is missing: " + headers);
            }
            long streamlength = Long.parseLong(cl);
            length = startOffset + streamlength;
            in = new BoundedInputStream(in, streamlength);
        }
        return new InputStreamAndFileLength(length, in);
    }

    private static boolean isChunkedTransferEncoding(Map<String, List<String>> headers) {
        return ByteRangeInputStream.contains(headers, "Transfer-Encoding", "chunked") || ByteRangeInputStream.contains(headers, "TE", "chunked");
    }

    private static boolean contains(Map<String, List<String>> headers, String key, String value) {
        List<String> values = headers.get(key);
        if (values != null) {
            for (String v : values) {
                StringTokenizer t = new StringTokenizer(v, ",");
                while (t.hasMoreTokens()) {
                    if (!value.equalsIgnoreCase(t.nextToken())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private int update(int n) throws IOException {
        if (n != -1) {
            this.currentPos += (long)n;
        } else if (this.fileLength != null && this.currentPos < this.fileLength) {
            throw new IOException("Got EOF but currentPos = " + this.currentPos + " < filelength = " + this.fileLength);
        }
        return n;
    }

    public int read() throws IOException {
        int b = this.getInputStream().read();
        this.update(b == -1 ? -1 : 1);
        return b;
    }

    public int read(@Nonnull byte[] b, int off, int len) throws IOException {
        return this.update(this.getInputStream().read(b, off, len));
    }

    public void seek(long pos) throws IOException {
        if (pos != this.currentPos) {
            this.startPos = pos;
            this.currentPos = pos;
            if (this.status != StreamStatus.CLOSED) {
                this.status = StreamStatus.SEEK;
            }
        }
    }

    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        this.validatePositionedReadArgs(position, buffer, offset, length);
        if (length == 0) {
            return 0;
        }
        try (InputStream in = this.openInputStream((long)position).in;){
            int n = in.read(buffer, offset, length);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        this.validatePositionedReadArgs(position, buffer, offset, length);
        if (length == 0) {
            return;
        }
        InputStreamAndFileLength fin = this.openInputStream(position);
        try {
            int nbytes;
            if (fin.length != null && (long)length + position > fin.length) {
                throw new EOFException("The length to read " + length + " exceeds the file length " + fin.length);
            }
            for (int nread = 0; nread < length; nread += nbytes) {
                nbytes = fin.in.read(buffer, offset + nread, length - nread);
                if (nbytes >= 0) continue;
                throw new EOFException("End of file reached before reading fully.");
            }
        }
        finally {
            fin.in.close();
        }
    }

    public long getPos() throws IOException {
        return this.currentPos;
    }

    public boolean seekToNewSource(long targetPos) throws IOException {
        return false;
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
            this.in = null;
        }
        this.status = StreamStatus.CLOSED;
    }

    public synchronized int available() throws IOException {
        this.getInputStream();
        if (this.fileLength != null) {
            long remaining = this.fileLength - this.currentPos;
            return remaining <= Integer.MAX_VALUE ? (int)remaining : Integer.MAX_VALUE;
        }
        return Integer.MAX_VALUE;
    }

    static enum StreamStatus {
        NORMAL,
        SEEK,
        CLOSED;

    }

    static class InputStreamAndFileLength {
        final Long length;
        final InputStream in;

        InputStreamAndFileLength(Long length, InputStream in) {
            this.length = length;
            this.in = in;
        }
    }

    public static abstract class URLOpener {
        protected URL url;

        public URLOpener(URL u) {
            this.url = u;
        }

        public void setURL(URL u) {
            this.url = u;
        }

        public URL getURL() {
            return this.url;
        }

        protected abstract HttpURLConnection connect(long var1, boolean var3) throws IOException;
    }
}

