/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.web.KerberosUgiAuthenticator;
import org.apache.hadoop.hdfs.web.oauth2.OAuth2ConnectionConfigurator;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.client.ConnectionConfigurator;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sparkproject.guava.annotations.VisibleForTesting;

@InterfaceAudience.LimitedPrivate(value={"HDFS"})
@InterfaceStability.Unstable
public class URLConnectionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(URLConnectionFactory.class);
    public static final int DEFAULT_SOCKET_TIMEOUT = 60000;
    private final ConnectionConfigurator connConfigurator;
    private static final ConnectionConfigurator DEFAULT_TIMEOUT_CONN_CONFIGURATOR = new ConnectionConfigurator(){

        @Override
        public HttpURLConnection configure(HttpURLConnection conn) throws IOException {
            URLConnectionFactory.setTimeouts(conn, 60000, 60000);
            return conn;
        }
    };
    public static final URLConnectionFactory DEFAULT_SYSTEM_CONNECTION_FACTORY = new URLConnectionFactory(DEFAULT_TIMEOUT_CONN_CONFIGURATOR);

    public static URLConnectionFactory newDefaultURLConnectionFactory(Configuration conf) {
        ConnectionConfigurator conn = URLConnectionFactory.getSSLConnectionConfiguration(60000, 60000, conf);
        return new URLConnectionFactory(conn);
    }

    public static URLConnectionFactory newDefaultURLConnectionFactory(int connectTimeout, int readTimeout, Configuration conf) {
        ConnectionConfigurator conn = URLConnectionFactory.getSSLConnectionConfiguration(connectTimeout, readTimeout, conf);
        return new URLConnectionFactory(conn);
    }

    private static ConnectionConfigurator getSSLConnectionConfiguration(final int connectTimeout, final int readTimeout, Configuration conf) {
        ConnectionConfigurator conn;
        try {
            conn = URLConnectionFactory.newSslConnConfigurator(connectTimeout, readTimeout, conf);
        }
        catch (Exception e) {
            LOG.warn("Cannot load customized ssl related configuration. Fallback to system-generic settings.", (Throwable)e);
            conn = connectTimeout == 60000 && readTimeout == 60000 ? DEFAULT_TIMEOUT_CONN_CONFIGURATOR : new ConnectionConfigurator(){

                @Override
                public HttpURLConnection configure(HttpURLConnection connection) throws IOException {
                    URLConnectionFactory.setTimeouts(connection, connectTimeout, readTimeout);
                    return connection;
                }
            };
        }
        return conn;
    }

    public static URLConnectionFactory newOAuth2URLConnectionFactory(int connectTimeout, int readTimeout, Configuration conf) throws IOException {
        OAuth2ConnectionConfigurator conn;
        try {
            ConnectionConfigurator sslConnConfigurator = URLConnectionFactory.newSslConnConfigurator(connectTimeout, readTimeout, conf);
            conn = new OAuth2ConnectionConfigurator(conf, sslConnConfigurator);
        }
        catch (Exception e) {
            throw new IOException("Unable to load OAuth2 connection factory.", e);
        }
        return new URLConnectionFactory(conn);
    }

    @VisibleForTesting
    URLConnectionFactory(ConnectionConfigurator connConfigurator) {
        this.connConfigurator = connConfigurator;
    }

    private static ConnectionConfigurator newSslConnConfigurator(final int connectTimeout, final int readTimeout, Configuration conf) throws IOException, GeneralSecurityException {
        SSLFactory factory = new SSLFactory(SSLFactory.Mode.CLIENT, conf);
        factory.init();
        final SSLSocketFactory sf = factory.createSSLSocketFactory();
        final HostnameVerifier hv = factory.getHostnameVerifier();
        return new ConnectionConfigurator(){

            @Override
            public HttpURLConnection configure(HttpURLConnection conn) throws IOException {
                if (conn instanceof HttpsURLConnection) {
                    HttpsURLConnection c = (HttpsURLConnection)conn;
                    c.setSSLSocketFactory(sf);
                    c.setHostnameVerifier(hv);
                }
                URLConnectionFactory.setTimeouts(conn, connectTimeout, readTimeout);
                return conn;
            }
        };
    }

    public URLConnection openConnection(URL url) throws IOException {
        try {
            return this.openConnection(url, false);
        }
        catch (AuthenticationException e) {
            LOG.error("Open connection {} failed", (Object)url, (Object)e);
            return null;
        }
    }

    public URLConnection openConnection(URL url, boolean isSpnego) throws IOException, AuthenticationException {
        if (isSpnego) {
            LOG.debug("open AuthenticatedURL connection {}", (Object)url);
            UserGroupInformation.getCurrentUser().checkTGTAndReloginFromKeytab();
            AuthenticatedURL.Token authToken = new AuthenticatedURL.Token();
            return new AuthenticatedURL(new KerberosUgiAuthenticator(), this.connConfigurator).openConnection(url, authToken);
        }
        LOG.debug("open URL connection");
        URLConnection connection = url.openConnection();
        if (connection instanceof HttpURLConnection) {
            this.connConfigurator.configure((HttpURLConnection)connection);
        }
        return connection;
    }

    private static void setTimeouts(URLConnection connection, int connectTimeout, int readTimeout) {
        connection.setConnectTimeout(connectTimeout);
        connection.setReadTimeout(readTimeout);
    }
}

