/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class DescribeLogDirsResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private List<DescribeLogDirsResult> results;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema[] SCHEMAS;

    public DescribeLogDirsResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public DescribeLogDirsResponseData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public DescribeLogDirsResponseData(JsonNode _node, short _version) {
        this.fromJson(_node, _version);
    }

    public DescribeLogDirsResponseData() {
        this.throttleTimeMs = 0;
        this.results = new ArrayList<DescribeLogDirsResult>(0);
    }

    @Override
    public short apiKey() {
        return 35;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 2;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int i;
        ArrayList<DescribeLogDirsResult> newCollection;
        int arrayLength;
        this.throttleTimeMs = _readable.readInt();
        if (_version >= 2) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field results was serialized as null");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new DescribeLogDirsResult(_readable, _version));
            }
            this.results = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field results was serialized as null");
            }
            newCollection = new ArrayList<DescribeLogDirsResult>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new DescribeLogDirsResult(_readable, _version));
            }
            this.results = newCollection;
        }
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        if (_version >= 2) {
            _writable.writeUnsignedVarint(this.results.size() + 1);
            for (DescribeLogDirsResult resultsElement : this.results) {
                resultsElement.write(_writable, _cache, _version);
            }
        } else {
            _writable.writeInt(this.results.size());
            for (DescribeLogDirsResult resultsElement : this.results) {
                resultsElement.write(_writable, _cache, _version);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 2) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        }
        this.throttleTimeMs = struct.getInt("throttle_time_ms");
        Object[] _nestedObjects = struct.getArray("results");
        this.results = new ArrayList<DescribeLogDirsResult>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.results.add(new DescribeLogDirsResult((Struct)nestedObject, _version));
        }
        if (_version >= 2 && !_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    @Override
    public Struct toStruct(short _version) {
        TreeMap _taggedFields = null;
        if (_version >= 2) {
            _taggedFields = new TreeMap();
        }
        Struct struct = new Struct(SCHEMAS[_version]);
        struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        Struct[] _nestedObjects = new Struct[this.results.size()];
        int i = 0;
        for (DescribeLogDirsResult element : this.results) {
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("results", (Object)_nestedObjects);
        if (_version >= 2) {
            struct.set("_tagged_fields", _taggedFields);
        }
        return struct;
    }

    @Override
    public void fromJson(JsonNode _node, short _version) {
        JsonNode _throttleTimeMsNode = _node.get("throttleTimeMs");
        if (_throttleTimeMsNode == null) {
            throw new RuntimeException("DescribeLogDirsResponseData: unable to locate field 'throttleTimeMs', which is mandatory in version " + _version);
        }
        this.throttleTimeMs = MessageUtil.jsonNodeToInt(_throttleTimeMsNode, "DescribeLogDirsResponseData");
        JsonNode _resultsNode = _node.get("results");
        if (_resultsNode == null) {
            throw new RuntimeException("DescribeLogDirsResponseData: unable to locate field 'results', which is mandatory in version " + _version);
        }
        if (!_resultsNode.isArray()) {
            throw new RuntimeException("DescribeLogDirsResponseData expected a JSON array, but got " + (Object)((Object)_node.getNodeType()));
        }
        this.results = new ArrayList<DescribeLogDirsResult>();
        for (JsonNode _element : _resultsNode) {
            this.results.add(new DescribeLogDirsResult(_element, _version));
        }
    }

    @Override
    public JsonNode toJson(short _version) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("throttleTimeMs", new IntNode(this.throttleTimeMs));
        ArrayNode _resultsArray = new ArrayNode(JsonNodeFactory.instance);
        for (DescribeLogDirsResult _element : this.results) {
            _resultsArray.add(_element.toJson(_version));
        }
        _node.set("results", _resultsArray);
        return _node;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        _size += 4;
        int _arraySize = 0;
        _arraySize = _version >= 2 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.results.size() + 1)) : (_arraySize += 4);
        for (DescribeLogDirsResult resultsElement : this.results) {
            _arraySize += resultsElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_version >= 2) {
            _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeLogDirsResponseData)) {
            return false;
        }
        DescribeLogDirsResponseData other = (DescribeLogDirsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        return !(this.results == null ? other.results != null : !this.results.equals(other.results));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.results == null ? 0 : this.results.hashCode());
        return hashCode;
    }

    @Override
    public DescribeLogDirsResponseData duplicate() {
        DescribeLogDirsResponseData _duplicate = new DescribeLogDirsResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        ArrayList<DescribeLogDirsResult> newResults = new ArrayList<DescribeLogDirsResult>(this.results.size());
        for (DescribeLogDirsResult _element : this.results) {
            newResults.add(_element.duplicate());
        }
        _duplicate.results = newResults;
        return _duplicate;
    }

    public String toString() {
        return "DescribeLogDirsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", results=" + MessageUtil.deepToString(this.results.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public List<DescribeLogDirsResult> results() {
        return this.results;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DescribeLogDirsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public DescribeLogDirsResponseData setResults(List<DescribeLogDirsResult> v) {
        this.results = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("results", new ArrayOf(DescribeLogDirsResult.SCHEMA_0), "The log directories."));
        SCHEMA_2 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("results", new CompactArrayOf(DescribeLogDirsResult.SCHEMA_2), "The log directories."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    }

    public static class DescribeLogDirsPartition
    implements Message {
        private int partitionIndex;
        private long partitionSize;
        private long offsetLag;
        private boolean isFutureKey;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema[] SCHEMAS;

        public DescribeLogDirsPartition(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public DescribeLogDirsPartition(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public DescribeLogDirsPartition(JsonNode _node, short _version) {
            this.fromJson(_node, _version);
        }

        public DescribeLogDirsPartition() {
            this.partitionIndex = 0;
            this.partitionSize = 0L;
            this.offsetLag = 0L;
            this.isFutureKey = false;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DescribeLogDirsPartition");
            }
            this.partitionIndex = _readable.readInt();
            this.partitionSize = _readable.readLong();
            this.offsetLag = _readable.readLong();
            this.isFutureKey = _readable.readByte() != 0;
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionIndex);
            _writable.writeLong(this.partitionSize);
            _writable.writeLong(this.offsetLag);
            _writable.writeByte(this.isFutureKey ? (byte)1 : 0);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DescribeLogDirsPartition");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.partitionIndex = struct.getInt("partition_index");
            this.partitionSize = struct.getLong("partition_size");
            this.offsetLag = struct.getLong("offset_lag");
            this.isFutureKey = struct.getBoolean("is_future_key");
            if (_version >= 2 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of DescribeLogDirsPartition");
            }
            TreeMap _taggedFields = null;
            if (_version >= 2) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("partition_index", (Object)this.partitionIndex);
            struct.set("partition_size", (Object)this.partitionSize);
            struct.set("offset_lag", (Object)this.offsetLag);
            struct.set("is_future_key", (Object)this.isFutureKey);
            if (_version >= 2) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        @Override
        public void fromJson(JsonNode _node, short _version) {
            JsonNode _partitionIndexNode = _node.get("partitionIndex");
            if (_partitionIndexNode == null) {
                throw new RuntimeException("DescribeLogDirsPartition: unable to locate field 'partitionIndex', which is mandatory in version " + _version);
            }
            this.partitionIndex = MessageUtil.jsonNodeToInt(_partitionIndexNode, "DescribeLogDirsPartition");
            JsonNode _partitionSizeNode = _node.get("partitionSize");
            if (_partitionSizeNode == null) {
                throw new RuntimeException("DescribeLogDirsPartition: unable to locate field 'partitionSize', which is mandatory in version " + _version);
            }
            this.partitionSize = MessageUtil.jsonNodeToLong(_partitionSizeNode, "DescribeLogDirsPartition");
            JsonNode _offsetLagNode = _node.get("offsetLag");
            if (_offsetLagNode == null) {
                throw new RuntimeException("DescribeLogDirsPartition: unable to locate field 'offsetLag', which is mandatory in version " + _version);
            }
            this.offsetLag = MessageUtil.jsonNodeToLong(_offsetLagNode, "DescribeLogDirsPartition");
            JsonNode _isFutureKeyNode = _node.get("isFutureKey");
            if (_isFutureKeyNode == null) {
                throw new RuntimeException("DescribeLogDirsPartition: unable to locate field 'isFutureKey', which is mandatory in version " + _version);
            }
            if (!_isFutureKeyNode.isBoolean()) {
                throw new RuntimeException("DescribeLogDirsPartition expected Boolean type, but got " + (Object)((Object)_node.getNodeType()));
            }
            this.isFutureKey = _isFutureKeyNode.asBoolean();
        }

        @Override
        public JsonNode toJson(short _version) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("partitionIndex", new IntNode(this.partitionIndex));
            _node.set("partitionSize", new LongNode(this.partitionSize));
            _node.set("offsetLag", new LongNode(this.offsetLag));
            _node.set("isFutureKey", BooleanNode.valueOf(this.isFutureKey));
            return _node;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DescribeLogDirsPartition");
            }
            _size += 4;
            _size += 8;
            _size += 8;
            ++_size;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 2) {
                _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescribeLogDirsPartition)) {
                return false;
            }
            DescribeLogDirsPartition other = (DescribeLogDirsPartition)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.partitionSize != other.partitionSize) {
                return false;
            }
            if (this.offsetLag != other.offsetLag) {
                return false;
            }
            return this.isFutureKey == other.isFutureKey;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + ((int)(this.partitionSize >> 32) ^ (int)this.partitionSize);
            hashCode = 31 * hashCode + ((int)(this.offsetLag >> 32) ^ (int)this.offsetLag);
            hashCode = 31 * hashCode + (this.isFutureKey ? 1231 : 1237);
            return hashCode;
        }

        @Override
        public DescribeLogDirsPartition duplicate() {
            DescribeLogDirsPartition _duplicate = new DescribeLogDirsPartition();
            _duplicate.partitionIndex = this.partitionIndex;
            _duplicate.partitionSize = this.partitionSize;
            _duplicate.offsetLag = this.offsetLag;
            _duplicate.isFutureKey = this.isFutureKey;
            return _duplicate;
        }

        public String toString() {
            return "DescribeLogDirsPartition(partitionIndex=" + this.partitionIndex + ", partitionSize=" + this.partitionSize + ", offsetLag=" + this.offsetLag + ", isFutureKey=" + (this.isFutureKey ? "true" : "false") + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public long partitionSize() {
            return this.partitionSize;
        }

        public long offsetLag() {
            return this.offsetLag;
        }

        public boolean isFutureKey() {
            return this.isFutureKey;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DescribeLogDirsPartition setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public DescribeLogDirsPartition setPartitionSize(long v) {
            this.partitionSize = v;
            return this;
        }

        public DescribeLogDirsPartition setOffsetLag(long v) {
            this.offsetLag = v;
            return this;
        }

        public DescribeLogDirsPartition setIsFutureKey(boolean v) {
            this.isFutureKey = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("partition_size", Type.INT64, "The size of the log segments in this partition in bytes."), new Field("offset_lag", Type.INT64, "The lag of the log's LEO w.r.t. partition's HW (if it is the current log for the partition) or current replica's LEO (if it is the future log for the partition)"), new Field("is_future_key", Type.BOOLEAN, "True if this log is created by AlterReplicaLogDirsRequest and will replace the current log of the replica in the future."));
            SCHEMA_2 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("partition_size", Type.INT64, "The size of the log segments in this partition in bytes."), new Field("offset_lag", Type.INT64, "The lag of the log's LEO w.r.t. partition's HW (if it is the current log for the partition) or current replica's LEO (if it is the future log for the partition)"), new Field("is_future_key", Type.BOOLEAN, "True if this log is created by AlterReplicaLogDirsRequest and will replace the current log of the replica in the future."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        }
    }

    public static class DescribeLogDirsTopic
    implements Message {
        private String name;
        private List<DescribeLogDirsPartition> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema[] SCHEMAS;

        public DescribeLogDirsTopic(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public DescribeLogDirsTopic(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public DescribeLogDirsTopic(JsonNode _node, short _version) {
            this.fromJson(_node, _version);
        }

        public DescribeLogDirsTopic() {
            this.name = "";
            this.partitions = new ArrayList<DescribeLogDirsPartition>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public void read(Readable _readable, short _version) {
            int i;
            ArrayList<DescribeLogDirsPartition> newCollection;
            int arrayLength;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DescribeLogDirsTopic");
            }
            int length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            if (_version >= 2) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitions was serialized as null");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new DescribeLogDirsPartition(_readable, _version));
                }
                this.partitions = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitions was serialized as null");
                }
                newCollection = new ArrayList<DescribeLogDirsPartition>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new DescribeLogDirsPartition(_readable, _version));
                }
                this.partitions = newCollection;
            }
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.name);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(this.partitions.size() + 1);
                _stringBytes = this.partitions.iterator();
                while (_stringBytes.hasNext()) {
                    DescribeLogDirsPartition partitionsElement = (DescribeLogDirsPartition)_stringBytes.next();
                    partitionsElement.write(_writable, _cache, _version);
                }
            } else {
                _writable.writeInt(this.partitions.size());
                _stringBytes = this.partitions.iterator();
                while (_stringBytes.hasNext()) {
                    DescribeLogDirsPartition partitionsElement = (DescribeLogDirsPartition)_stringBytes.next();
                    partitionsElement.write(_writable, _cache, _version);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DescribeLogDirsTopic");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.name = struct.getString("name");
            Object[] _nestedObjects = struct.getArray("partitions");
            this.partitions = new ArrayList<DescribeLogDirsPartition>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.partitions.add(new DescribeLogDirsPartition((Struct)nestedObject, _version));
            }
            if (_version >= 2 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of DescribeLogDirsTopic");
            }
            TreeMap _taggedFields = null;
            if (_version >= 2) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("name", (Object)this.name);
            Struct[] _nestedObjects = new Struct[this.partitions.size()];
            int i = 0;
            for (DescribeLogDirsPartition element : this.partitions) {
                _nestedObjects[i++] = element.toStruct(_version);
            }
            struct.set("partitions", (Object)_nestedObjects);
            if (_version >= 2) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        @Override
        public void fromJson(JsonNode _node, short _version) {
            JsonNode _nameNode = _node.get("name");
            if (_nameNode == null) {
                throw new RuntimeException("DescribeLogDirsTopic: unable to locate field 'name', which is mandatory in version " + _version);
            }
            if (!_nameNode.isTextual()) {
                throw new RuntimeException("DescribeLogDirsTopic expected a string type, but got " + (Object)((Object)_node.getNodeType()));
            }
            this.name = _nameNode.asText();
            JsonNode _partitionsNode = _node.get("partitions");
            if (_partitionsNode == null) {
                throw new RuntimeException("DescribeLogDirsTopic: unable to locate field 'partitions', which is mandatory in version " + _version);
            }
            if (!_partitionsNode.isArray()) {
                throw new RuntimeException("DescribeLogDirsTopic expected a JSON array, but got " + (Object)((Object)_node.getNodeType()));
            }
            this.partitions = new ArrayList<DescribeLogDirsPartition>();
            for (JsonNode _element : _partitionsNode) {
                this.partitions.add(new DescribeLogDirsPartition(_element, _version));
            }
        }

        @Override
        public JsonNode toJson(short _version) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("name", new TextNode(this.name));
            ArrayNode _partitionsArray = new ArrayNode(JsonNodeFactory.instance);
            for (DescribeLogDirsPartition _element : this.partitions) {
                _partitionsArray.add(_element.toJson(_version));
            }
            _node.set("partitions", _partitionsArray);
            return _node;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DescribeLogDirsTopic");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size = _version >= 2 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            int _arraySize = 0;
            _arraySize = _version >= 2 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.partitions.size() + 1)) : (_arraySize += 4);
            for (DescribeLogDirsPartition partitionsElement : this.partitions) {
                _arraySize += partitionsElement.size(_cache, _version);
            }
            _size += _arraySize;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 2) {
                _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescribeLogDirsTopic)) {
                return false;
            }
            DescribeLogDirsTopic other = (DescribeLogDirsTopic)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        @Override
        public DescribeLogDirsTopic duplicate() {
            DescribeLogDirsTopic _duplicate = new DescribeLogDirsTopic();
            _duplicate.name = this.name;
            ArrayList<DescribeLogDirsPartition> newPartitions = new ArrayList<DescribeLogDirsPartition>(this.partitions.size());
            for (DescribeLogDirsPartition _element : this.partitions) {
                newPartitions.add(_element.duplicate());
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "DescribeLogDirsTopic(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<DescribeLogDirsPartition> partitions() {
            return this.partitions;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DescribeLogDirsTopic setName(String v) {
            this.name = v;
            return this;
        }

        public DescribeLogDirsTopic setPartitions(List<DescribeLogDirsPartition> v) {
            this.partitions = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(DescribeLogDirsPartition.SCHEMA_0), ""));
            SCHEMA_2 = new Schema(new Field("name", Type.COMPACT_STRING, "The topic name."), new Field("partitions", new CompactArrayOf(DescribeLogDirsPartition.SCHEMA_2), ""), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        }
    }

    public static class DescribeLogDirsResult
    implements Message {
        private short errorCode;
        private String logDir;
        private List<DescribeLogDirsTopic> topics;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema[] SCHEMAS;

        public DescribeLogDirsResult(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public DescribeLogDirsResult(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public DescribeLogDirsResult(JsonNode _node, short _version) {
            this.fromJson(_node, _version);
        }

        public DescribeLogDirsResult() {
            this.errorCode = 0;
            this.logDir = "";
            this.topics = new ArrayList<DescribeLogDirsTopic>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public void read(Readable _readable, short _version) {
            int i;
            ArrayList<DescribeLogDirsTopic> newCollection;
            int arrayLength;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DescribeLogDirsResult");
            }
            this.errorCode = _readable.readShort();
            int length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field logDir was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field logDir had invalid length " + length);
            }
            this.logDir = _readable.readString(length);
            if (_version >= 2) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field topics was serialized as null");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new DescribeLogDirsTopic(_readable, _version));
                }
                this.topics = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field topics was serialized as null");
                }
                newCollection = new ArrayList<DescribeLogDirsTopic>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new DescribeLogDirsTopic(_readable, _version));
                }
                this.topics = newCollection;
            }
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeShort(this.errorCode);
            Object _stringBytes = _cache.getSerializedValue(this.logDir);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(this.topics.size() + 1);
                _stringBytes = this.topics.iterator();
                while (_stringBytes.hasNext()) {
                    DescribeLogDirsTopic topicsElement = (DescribeLogDirsTopic)_stringBytes.next();
                    topicsElement.write(_writable, _cache, _version);
                }
            } else {
                _writable.writeInt(this.topics.size());
                _stringBytes = this.topics.iterator();
                while (_stringBytes.hasNext()) {
                    DescribeLogDirsTopic topicsElement = (DescribeLogDirsTopic)_stringBytes.next();
                    topicsElement.write(_writable, _cache, _version);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DescribeLogDirsResult");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.errorCode = struct.getShort("error_code");
            this.logDir = struct.getString("log_dir");
            Object[] _nestedObjects = struct.getArray("topics");
            this.topics = new ArrayList<DescribeLogDirsTopic>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.topics.add(new DescribeLogDirsTopic((Struct)nestedObject, _version));
            }
            if (_version >= 2 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of DescribeLogDirsResult");
            }
            TreeMap _taggedFields = null;
            if (_version >= 2) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("error_code", (Object)this.errorCode);
            struct.set("log_dir", (Object)this.logDir);
            Struct[] _nestedObjects = new Struct[this.topics.size()];
            int i = 0;
            for (DescribeLogDirsTopic element : this.topics) {
                _nestedObjects[i++] = element.toStruct(_version);
            }
            struct.set("topics", (Object)_nestedObjects);
            if (_version >= 2) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        @Override
        public void fromJson(JsonNode _node, short _version) {
            JsonNode _errorCodeNode = _node.get("errorCode");
            if (_errorCodeNode == null) {
                throw new RuntimeException("DescribeLogDirsResult: unable to locate field 'errorCode', which is mandatory in version " + _version);
            }
            this.errorCode = MessageUtil.jsonNodeToShort(_errorCodeNode, "DescribeLogDirsResult");
            JsonNode _logDirNode = _node.get("logDir");
            if (_logDirNode == null) {
                throw new RuntimeException("DescribeLogDirsResult: unable to locate field 'logDir', which is mandatory in version " + _version);
            }
            if (!_logDirNode.isTextual()) {
                throw new RuntimeException("DescribeLogDirsResult expected a string type, but got " + (Object)((Object)_node.getNodeType()));
            }
            this.logDir = _logDirNode.asText();
            JsonNode _topicsNode = _node.get("topics");
            if (_topicsNode == null) {
                throw new RuntimeException("DescribeLogDirsResult: unable to locate field 'topics', which is mandatory in version " + _version);
            }
            if (!_topicsNode.isArray()) {
                throw new RuntimeException("DescribeLogDirsResult expected a JSON array, but got " + (Object)((Object)_node.getNodeType()));
            }
            this.topics = new ArrayList<DescribeLogDirsTopic>();
            for (JsonNode _element : _topicsNode) {
                this.topics.add(new DescribeLogDirsTopic(_element, _version));
            }
        }

        @Override
        public JsonNode toJson(short _version) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("errorCode", new ShortNode(this.errorCode));
            _node.set("logDir", new TextNode(this.logDir));
            ArrayNode _topicsArray = new ArrayNode(JsonNodeFactory.instance);
            for (DescribeLogDirsTopic _element : this.topics) {
                _topicsArray.add(_element.toJson(_version));
            }
            _node.set("topics", _topicsArray);
            return _node;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DescribeLogDirsResult");
            }
            _size += 2;
            byte[] _stringBytes = this.logDir.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'logDir' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.logDir, _stringBytes);
            _size = _version >= 2 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            int _arraySize = 0;
            _arraySize = _version >= 2 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1)) : (_arraySize += 4);
            for (DescribeLogDirsTopic topicsElement : this.topics) {
                _arraySize += topicsElement.size(_cache, _version);
            }
            _size += _arraySize;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 2) {
                _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescribeLogDirsResult)) {
                return false;
            }
            DescribeLogDirsResult other = (DescribeLogDirsResult)obj;
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.logDir == null ? other.logDir != null : !this.logDir.equals(other.logDir)) {
                return false;
            }
            return !(this.topics == null ? other.topics != null : !this.topics.equals(other.topics));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.logDir == null ? 0 : this.logDir.hashCode());
            hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
            return hashCode;
        }

        @Override
        public DescribeLogDirsResult duplicate() {
            DescribeLogDirsResult _duplicate = new DescribeLogDirsResult();
            _duplicate.errorCode = this.errorCode;
            _duplicate.logDir = this.logDir;
            ArrayList<DescribeLogDirsTopic> newTopics = new ArrayList<DescribeLogDirsTopic>(this.topics.size());
            for (DescribeLogDirsTopic _element : this.topics) {
                newTopics.add(_element.duplicate());
            }
            _duplicate.topics = newTopics;
            return _duplicate;
        }

        public String toString() {
            return "DescribeLogDirsResult(errorCode=" + this.errorCode + ", logDir=" + (this.logDir == null ? "null" : "'" + this.logDir.toString() + "'") + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String logDir() {
            return this.logDir;
        }

        public List<DescribeLogDirsTopic> topics() {
            return this.topics;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DescribeLogDirsResult setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public DescribeLogDirsResult setLogDir(String v) {
            this.logDir = v;
            return this;
        }

        public DescribeLogDirsResult setTopics(List<DescribeLogDirsTopic> v) {
            this.topics = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("log_dir", Type.STRING, "The absolute log directory path."), new Field("topics", new ArrayOf(DescribeLogDirsTopic.SCHEMA_0), "Each topic."));
            SCHEMA_2 = new Schema(new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("log_dir", Type.COMPACT_STRING, "The absolute log directory path."), new Field("topics", new CompactArrayOf(DescribeLogDirsTopic.SCHEMA_2), "Each topic."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        }
    }
}

