/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka010;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.Time$;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.DStreamCheckpointData;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.streaming.kafka010.CanCommitOffsets;
import org.apache.spark.streaming.kafka010.ConsumerStrategy;
import org.apache.spark.streaming.kafka010.KafkaRDD;
import org.apache.spark.streaming.kafka010.KafkaUtils$;
import org.apache.spark.streaming.kafka010.LocationStrategy;
import org.apache.spark.streaming.kafka010.OffsetRange;
import org.apache.spark.streaming.kafka010.OffsetRange$;
import org.apache.spark.streaming.kafka010.PerPartitionConfig;
import org.apache.spark.streaming.kafka010.PreferBrokers$;
import org.apache.spark.streaming.kafka010.PreferConsistent$;
import org.apache.spark.streaming.kafka010.PreferFixed;
import org.apache.spark.streaming.kafka010.package$;
import org.apache.spark.streaming.scheduler.RateController;
import org.apache.spark.streaming.scheduler.RateController$;
import org.apache.spark.streaming.scheduler.StreamInputInfo;
import org.apache.spark.streaming.scheduler.StreamInputInfo$;
import org.apache.spark.streaming.scheduler.rate.RateEstimator;
import org.apache.spark.streaming.scheduler.rate.RateEstimator$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\u001dg!\u0002\u001a4\u0001]j\u0004\u0002C6\u0001\u0005\u0003\u0005\u000b\u0011\u00027\t\u0011A\u0004!\u0011!Q\u0001\nED\u0001\u0002\u001e\u0001\u0003\u0002\u0003\u0006I!\u001e\u0005\tq\u0002\u0011\t\u0011)A\u0005s\")A\u0010\u0001C\u0001{\"I\u0011q\u0001\u0001C\u0002\u0013%\u0011\u0011\u0002\u0005\t\u0003#\u0001\u0001\u0015!\u0003\u0002\f!I\u00111\u0003\u0001C\u0002\u0013\u0005\u0011Q\u0003\u0005\t\u0003\u0013\u0002\u0001\u0015!\u0003\u0002\u0018!I\u00111\n\u0001A\u0002\u0013E\u0011Q\n\u0005\n\u0003W\u0002\u0001\u0019!C\t\u0003[B\u0001\"!\u001f\u0001A\u0003&\u0011q\n\u0005\n\u0003w\u0002\u0001\u0019!C\u0005\u0003{B\u0011\"!\"\u0001\u0001\u0004%I!a\"\t\u0011\u0005-\u0005\u0001)Q\u0005\u0003\u007fBa\u0001\u0013\u0001\u0005\u0002\u0005U\u0005bBAL\u0001\u0011\u0005\u0013\u0011\u0014\u0005\b\u0003c\u0003A\u0011CAZ\u0011\u001d\t9\f\u0001C\t\u0003sC\u0001\"a0\u0001\t\u0003*\u0014\u0011\u0019\u0005\u000b\u0003\u0007\u0004!\u0019!C)k\u0005\u0015\u0007\u0002\u0003B\b\u0001\u0001\u0006I!a2\t\u0015\tE\u0001A1A\u0005RU\u0012\u0019\u0002\u0003\u0005\u0003(\u0001\u0001\u000b\u0011\u0002B\u000b\u0011!\u0011I\u0003\u0001C\tk\t-\u0002b\u0002B\u001c\u0001\u0011%!\u0011\b\u0005\b\u0005\u007f\u0001A\u0011\u0003B!\u0011\u001d\u0011\u0019\u0005\u0001C\t\u0005\u000bBqA!\u0013\u0001\t\u0003\u0012Y\u0005C\u0004\u0003Z\u0001!\tE!\u0004\t\u000f\tm\u0003\u0001\"\u0011\u0003\u000e!I!Q\f\u0001C\u0002\u0013E!q\f\u0005\t\u0005g\u0002\u0001\u0015!\u0003\u0003b!I!Q\u000f\u0001C\u0002\u0013E!q\u000f\u0005\t\u0005\u0017\u0003\u0001\u0015!\u0003\u0003z!9!Q\u0012\u0001\u0005\u0002\t=\u0005b\u0002BG\u0001\u0011\u0005!q\u0013\u0005\b\u0005?\u0003A\u0011\u0003B\u0007\r\u001d\tY\r\u0001\u00016\u0003\u001bDa\u0001`\u0014\u0005\u0002\u0005U\u0007bBAlO\u0011\u0005\u0011\u0011\u001c\u0005\b\u0003{<C\u0011IA\u0000\u0011\u001d\u0011)a\nC!\u0005\u000fAqAa\u0003(\t\u0003\u0012iAB\u0004\u0003\"\u0002\u0001QGa)\t\u0019\t\u0015VF!A!\u0002\u0013\t9Pa*\t\u0015\t-VF!A!\u0002\u0013\u0011i\u000b\u0003\u0004}[\u0011\u0005!\u0011\u0018\u0005\b\u0005\u0003lC\u0011\tBb\u0005]!\u0015N]3di.\u000bgm[1J]B,H\u000fR*ue\u0016\fWN\u0003\u00025k\u0005A1.\u00194lCB\n\u0004G\u0003\u00027o\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003qe\nQa\u001d9be.T!AO\u001e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0014aA8sOV\u0019a(U0\u0014\t\u0001y\u0014m\u001a\t\u0004\u0001\u000e+U\"A!\u000b\u0005\t+\u0014a\u00023tiJ,\u0017-\\\u0005\u0003\t\u0006\u0013A\"\u00138qkR$5\u000b\u001e:fC6\u0004BAR'P=6\tqI\u0003\u0002I\u0013\u0006A1m\u001c8tk6,'O\u0003\u0002K\u0017\u000691\r\\5f]R\u001c(B\u0001':\u0003\u0015Y\u0017MZ6b\u0013\tquI\u0001\bD_:\u001cX/\\3s%\u0016\u001cwN\u001d3\u0011\u0005A\u000bF\u0002\u0001\u0003\u0006%\u0002\u0011\r\u0001\u0016\u0002\u0002\u0017\u000e\u0001\u0011CA+\\!\t1\u0016,D\u0001X\u0015\u0005A\u0016!B:dC2\f\u0017B\u0001.X\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"A\u0016/\n\u0005u;&aA!osB\u0011\u0001k\u0018\u0003\u0006A\u0002\u0011\r\u0001\u0016\u0002\u0002-B\u0011!-Z\u0007\u0002G*\u0011AmN\u0001\tS:$XM\u001d8bY&\u0011am\u0019\u0002\b\u0019><w-\u001b8h!\tA\u0017.D\u00014\u0013\tQ7G\u0001\tDC:\u001cu.\\7ji>3gm]3ug\u0006!ql]:d!\tig.D\u00016\u0013\tyWG\u0001\tTiJ,\u0017-\\5oO\u000e{g\u000e^3yi\u0006\u0001Bn\\2bi&|gn\u0015;sCR,w-\u001f\t\u0003QJL!a]\u001a\u0003!1{7-\u0019;j_:\u001cFO]1uK\u001eL\u0018\u0001E2p]N,X.\u001a:TiJ\fG/Z4z!\u0011Ago\u00140\n\u0005]\u001c$\u0001E\"p]N,X.\u001a:TiJ\fG/Z4z\u0003\r\u0001\bo\u0019\t\u0003QjL!a_\u001a\u0003%A+'\u000fU1si&$\u0018n\u001c8D_:4\u0017nZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011y|\u0018\u0011AA\u0002\u0003\u000b\u0001B\u0001\u001b\u0001P=\")1.\u0002a\u0001Y\")\u0001/\u0002a\u0001c\")A/\u0002a\u0001k\")\u00010\u0002a\u0001s\u0006Y\u0011N\\5uS\u0006d'+\u0019;f+\t\tY\u0001E\u0002W\u0003\u001bI1!a\u0004X\u0005\u0011auN\\4\u0002\u0019%t\u0017\u000e^5bYJ\u000bG/\u001a\u0011\u0002'\u0015DXmY;u_J\\\u0015MZ6b!\u0006\u0014\u0018-\\:\u0016\u0005\u0005]\u0001\u0003CA\r\u0003G\t9#!\u0010\u000e\u0005\u0005m!\u0002BA\u000f\u0003?\tA!\u001e;jY*\u0011\u0011\u0011E\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002&\u0005m!a\u0002%bg\"l\u0015\r\u001d\t\u0005\u0003S\t9D\u0004\u0003\u0002,\u0005M\u0002cAA\u0017/6\u0011\u0011q\u0006\u0006\u0004\u0003c\u0019\u0016A\u0002\u001fs_>$h(C\u0002\u00026]\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u001d\u0003w\u0011aa\u0015;sS:<'bAA\u001b/B!\u0011qHA#\u001b\t\t\tE\u0003\u0003\u0002D\u0005}\u0011\u0001\u00027b]\u001eLA!a\u0012\u0002B\t1qJ\u00196fGR\fA#\u001a=fGV$xN]&bM.\f\u0007+\u0019:b[N\u0004\u0013AD2veJ,g\u000e^(gMN,Go]\u000b\u0003\u0003\u001f\u0002\u0002\"!\u0015\u0002\\\u0005}\u00131B\u0007\u0003\u0003'RA!!\u0016\u0002X\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u00033:\u0016AC2pY2,7\r^5p]&!\u0011QLA*\u0005\ri\u0015\r\u001d\t\u0005\u0003C\n9'\u0004\u0002\u0002d)\u0019\u0011QM&\u0002\r\r|W.\\8o\u0013\u0011\tI'a\u0019\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006\u00112-\u001e:sK:$xJ\u001a4tKR\u001cx\fJ3r)\u0011\ty'!\u001e\u0011\u0007Y\u000b\t(C\u0002\u0002t]\u0013A!\u00168ji\"I\u0011qO\u0006\u0002\u0002\u0003\u0007\u0011qJ\u0001\u0004q\u0012\n\u0014aD2veJ,g\u000e^(gMN,Go\u001d\u0011\u0002\u0005-\u001cWCAA@!\u00151\u0015\u0011Q(_\u0013\r\t\u0019i\u0012\u0002\t\u0007>t7/^7fe\u000611nY0%KF$B!a\u001c\u0002\n\"I\u0011q\u000f\b\u0002\u0002\u0003\u0007\u0011qP\u0001\u0004W\u000e\u0004\u0003fA\b\u0002\u0010B\u0019a+!%\n\u0007\u0005MuKA\u0005ue\u0006t7/[3oiR\u0011\u0011qP\u0001\ba\u0016\u00148/[:u)\u0011\tY*!)\u0011\t\u0001\u000bi*R\u0005\u0004\u0003?\u000b%a\u0002#TiJ,\u0017-\u001c\u0005\b\u0003G\u000b\u0002\u0019AAS\u0003!qWm\u001e'fm\u0016d\u0007\u0003BAT\u0003[k!!!+\u000b\u0007\u0005-v'A\u0004ti>\u0014\u0018mZ3\n\t\u0005=\u0016\u0011\u0016\u0002\r'R|'/Y4f\u0019\u00164X\r\\\u0001\u000bO\u0016$(I]8lKJ\u001cXCAA[!!\tI\"a\t\u0002`\u0005\u001d\u0012!E4fiB\u0013XMZ3se\u0016$\u0007j\\:ugV\u0011\u00111\u0018\t\t\u00033\ti,a\u0018\u0002(%!\u0011QLA\u000e\u0003\u0011q\u0017-\\3\u0016\u0005\u0005\u001d\u0012AD2iK\u000e\\\u0007o\\5oi\u0012\u000bG/Y\u000b\u0003\u0003\u000f\u00042!!3(\u001b\u0005\u0001!!\n#je\u0016\u001cGoS1gW\u0006Le\u000e];u\tN#(/Z1n\u0007\",7m\u001b9pS:$H)\u0019;b'\r9\u0013q\u001a\t\u0005\u0001\u0006EW)C\u0002\u0002T\u0006\u0013Q\u0003R*ue\u0016\fWn\u00115fG.\u0004x.\u001b8u\t\u0006$\u0018\r\u0006\u0002\u0002H\u0006a!-\u0019;dQ\u001a{'\u000fV5nKV\u0011\u00111\u001c\t\t\u0003;\f\u0019/!:\u0002l6\u0011\u0011q\u001c\u0006\u0005\u0003C\f9&A\u0004nkR\f'\r\\3\n\t\u0005\u0015\u0012q\u001c\t\u0004[\u0006\u001d\u0018bAAuk\t!A+[7f!\u00151\u0016Q^Ay\u0013\r\tyo\u0016\u0002\u0006\u0003J\u0014\u0018-\u001f\t\f-\u0006M\u0018qEA|\u0003\u0017\tY!C\u0002\u0002v^\u0013a\u0001V;qY\u0016$\u0004c\u0001,\u0002z&\u0019\u00111`,\u0003\u0007%sG/\u0001\u0004va\u0012\fG/\u001a\u000b\u0005\u0003_\u0012\t\u0001C\u0004\u0003\u0004)\u0002\r!!:\u0002\tQLW.Z\u0001\bG2,\u0017M\\;q)\u0011\tyG!\u0003\t\u000f\t\r1\u00061\u0001\u0002f\u00069!/Z:u_J,GCAA8\u0003=\u0019\u0007.Z2la>Lg\u000e\u001e#bi\u0006\u0004\u0013A\u0004:bi\u0016\u001cuN\u001c;s_2dWM]\u000b\u0003\u0005+\u0001RA\u0016B\f\u00057I1A!\u0007X\u0005\u0019y\u0005\u000f^5p]B!!Q\u0004B\u0012\u001b\t\u0011yBC\u0002\u0003\"U\n\u0011b]2iK\u0012,H.\u001a:\n\t\t\u0015\"q\u0004\u0002\u000f%\u0006$XmQ8oiJ|G\u000e\\3s\u0003=\u0011\u0018\r^3D_:$(o\u001c7mKJ\u0004\u0013aF7bq6+7o]1hKN\u0004VM\u001d)beRLG/[8o)\u0011\u0011iCa\r\u0011\u000bY\u00139Ba\f\u0011\u0011\u0005%\"\u0011GA0\u0003\u0017IA!!\u0018\u0002<!9!QG\rA\u0002\t=\u0012aB8gMN,Go]\u0001\ra\u0006\u0014\u0018M\\8jIB{G\u000e\u001c\u000b\u0005\u0003_\u0012Y\u0004C\u0004\u0003>i\u0001\r!a \u0002\u0003\r\fQ\u0002\\1uKN$xJ\u001a4tKR\u001cHC\u0001B\u0018\u0003\u0015\u0019G.Y7q)\u0011\u0011yCa\u0012\t\u000f\tUB\u00041\u0001\u00030\u000591m\\7qkR,G\u0003\u0002B'\u0005+\u0002RA\u0016B\f\u0005\u001f\u0002R\u0001\u001bB)\u001fzK1Aa\u00154\u0005!Y\u0015MZ6b%\u0012#\u0005b\u0002B,;\u0001\u0007\u0011Q]\u0001\nm\u0006d\u0017\u000e\u001a+j[\u0016\fQa\u001d;beR\fAa\u001d;pa\u0006Y1m\\7nSR\fV/Z;f+\t\u0011\t\u0007\u0005\u0004\u0003d\t%$QN\u0007\u0003\u0005KRAAa\u001a\u0002\u001c\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\t-$Q\r\u0002\u0016\u0007>t7-\u001e:sK:$H*\u001b8lK\u0012\fV/Z;f!\rA'qN\u0005\u0004\u0005c\u001a$aC(gMN,GOU1oO\u0016\fAbY8n[&$\u0018+^3vK\u0002\nabY8n[&$8)\u00197mE\u0006\u001c7.\u0006\u0002\u0003zA1!1\u0010BA\u0005\u000bk!A! \u000b\t\t}$QM\u0001\u0007CR|W.[2\n\t\t\r%Q\u0010\u0002\u0010\u0003R|W.[2SK\u001a,'/\u001a8dKB\u0019aIa\"\n\u0007\t%uI\u0001\u000bPM\u001a\u001cX\r^\"p[6LGoQ1mY\n\f7m[\u0001\u0010G>lW.\u001b;DC2d'-Y2lA\u0005Y1m\\7nSR\f5/\u001f8d)\u0011\tyG!%\t\u000f\tME\u00051\u0001\u0003\u0016\u0006aqN\u001a4tKR\u0014\u0016M\\4fgB)a+!<\u0003nQ1\u0011q\u000eBM\u00057CqAa%&\u0001\u0004\u0011)\nC\u0004\u0003\u001e\u0016\u0002\rA!\"\u0002\u0011\r\fG\u000e\u001c2bG.\f\u0011bY8n[&$\u0018\t\u001c7\u00033\u0011K'/Z2u\u0017\u000647.\u0019*bi\u0016\u001cuN\u001c;s_2dWM]\n\u0004[\tm\u0011AA5e\u0013\u0011\u0011IKa\t\u0002\u0013M$(/Z1n+&#\u0015!C3ti&l\u0017\r^8s!\u0011\u0011yK!.\u000e\u0005\tE&\u0002\u0002BZ\u0005?\tAA]1uK&!!q\u0017BY\u00055\u0011\u0016\r^3FgRLW.\u0019;peR1!1\u0018B_\u0005\u007f\u00032!!3.\u0011\u001d\u0011)\u000b\ra\u0001\u0003oDqAa+1\u0001\u0004\u0011i+A\u0004qk\nd\u0017n\u001d5\u0015\t\u0005=$Q\u0019\u0005\b\u0005g\u000b\u0004\u0019AA\u0006\u0001")
public class DirectKafkaInputDStream<K, V>
extends InputDStream<ConsumerRecord<K, V>>
implements CanCommitOffsets {
    private final LocationStrategy locationStrategy;
    private final ConsumerStrategy<K, V> consumerStrategy;
    private final PerPartitionConfig ppc;
    private final long initialRate;
    private final HashMap<String, Object> executorKafkaParams;
    private scala.collection.immutable.Map<TopicPartition, Object> currentOffsets;
    private transient Consumer<K, V> kc;
    private final DirectKafkaInputDStreamCheckpointData checkpointData;
    private final Option<RateController> rateController;
    private final ConcurrentLinkedQueue<OffsetRange> commitQueue;
    private final AtomicReference<OffsetCommitCallback> commitCallback;

    private long initialRate() {
        return this.initialRate;
    }

    public HashMap<String, Object> executorKafkaParams() {
        return this.executorKafkaParams;
    }

    public scala.collection.immutable.Map<TopicPartition, Object> currentOffsets() {
        return this.currentOffsets;
    }

    public void currentOffsets_$eq(scala.collection.immutable.Map<TopicPartition, Object> x$1) {
        this.currentOffsets = x$1;
    }

    private Consumer<K, V> kc() {
        return this.kc;
    }

    private void kc_$eq(Consumer<K, V> x$1) {
        this.kc = x$1;
    }

    public synchronized Consumer<K, V> consumer() {
        block0: {
            if (this.kc() != null) break block0;
            this.kc_$eq(this.consumerStrategy.onStart((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.currentOffsets().mapValues((Function1 & Serializable & scala.Serializable)l -> BoxesRunTime.unboxToLong((Object)l))).asJava()));
        }
        return this.kc();
    }

    public DStream<ConsumerRecord<K, V>> persist(StorageLevel newLevel) {
        this.logError((Function0 & Serializable & scala.Serializable)() -> "Kafka ConsumerRecord is not serializable. Use .map to extract fields before calling .persist or .window");
        return super.persist(newLevel);
    }

    /*
     * WARNING - void declaration
     */
    public HashMap<TopicPartition, String> getBrokers() {
        void var2_2;
        Consumer<K, V> c = this.consumer();
        HashMap result = new HashMap();
        HashMap<TopicPartition, String> hosts = new HashMap<TopicPartition, String>();
        for (TopicPartition tp : c.assignment()) {
            if (hosts.get(tp) == null) {
                for (PartitionInfo i : c.partitionsFor(tp.topic())) {
                    hosts.put(new TopicPartition(i.topic(), i.partition()), i.leader().host());
                }
            }
            result.put(tp, hosts.get(tp));
        }
        return var2_2;
    }

    public java.util.Map<TopicPartition, String> getPreferredHosts() {
        java.util.Map<Object, String> map;
        LocationStrategy locationStrategy = this.locationStrategy;
        if (PreferBrokers$.MODULE$.equals(locationStrategy)) {
            map = this.getBrokers();
        } else if (PreferConsistent$.MODULE$.equals(locationStrategy)) {
            map = Collections.emptyMap();
        } else if (locationStrategy instanceof PreferFixed) {
            PreferFixed preferFixed = (PreferFixed)locationStrategy;
            java.util.Map<TopicPartition, String> hostMap = preferFixed.hostMap();
            map = hostMap;
        } else {
            throw new MatchError((Object)locationStrategy);
        }
        return map;
    }

    public String name() {
        return new StringBuilder(27).append("Kafka 0.10 direct stream [").append(this.id()).append("]").toString();
    }

    public DirectKafkaInputDStreamCheckpointData checkpointData() {
        return this.checkpointData;
    }

    public Option<RateController> rateController() {
        return this.rateController;
    }

    public Option<scala.collection.immutable.Map<TopicPartition, Object>> maxMessagesPerPartition(scala.collection.immutable.Map<TopicPartition, Object> offsets) {
        None$ none$;
        scala.collection.immutable.Map map;
        Option estimatedRateLimit = this.rateController().map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToLong((long)DirectKafkaInputDStream.$anonfun$maxMessagesPerPartition$1(this, x)));
        Option option = estimatedRateLimit.filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$1 -> x$1 > 0L);
        if (option instanceof Some) {
            Some some = (Some)option;
            long rate = BoxesRunTime.unboxToLong((Object)some.value());
            scala.collection.immutable.Map lagPerPartition = (scala.collection.immutable.Map)offsets.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition tp = (TopicPartition)tuple2._1();
                long offset = tuple2._2$mcJ$sp();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)Math.max(offset - BoxesRunTime.unboxToLong((Object)this.currentOffsets().apply((Object)tp)), 0L)));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
            long totalLag = BoxesRunTime.unboxToLong((Object)lagPerPartition.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            map = (scala.collection.immutable.Map)lagPerPartition.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition tp = (TopicPartition)tuple2._1();
                long lag = tuple2._2$mcJ$sp();
                long maxRateLimitPerPartition = $this.ppc.maxRatePerPartition(tp);
                double backpressureRate = (double)lag / (double)totalLag * (double)rate;
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)(maxRateLimitPerPartition > 0L ? BoxesRunTime.boxToDouble((double)Math.min(backpressureRate, (double)maxRateLimitPerPartition)) : BoxesRunTime.boxToDouble((double)backpressureRate)));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
        } else if (None$.MODULE$.equals(option)) {
            map = (scala.collection.immutable.Map)offsets.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition tp = (TopicPartition)tuple2._1();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToDouble((double)$this.ppc.maxRatePerPartition(tp)));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
        } else {
            throw new MatchError((Object)option);
        }
        scala.collection.immutable.Map effectiveRateLimitPerPartition = map;
        if (BoxesRunTime.unboxToDouble((Object)effectiveRateLimitPerPartition.values().sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) > 0.0) {
            double secsPerBatch = (double)this.context().graph().batchDuration().milliseconds() / (double)1000;
            none$ = new Some(effectiveRateLimitPerPartition.map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition tp = (TopicPartition)tuple2._1();
                double limit = tuple2._2$mcD$sp();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)Math.max((long)(secsPerBatch * limit), $this.ppc.minRatePerPartition(tp))));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom()));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private void paranoidPoll(Consumer<K, V> c) {
        block0: {
            c.pause((Collection)c.assignment());
            ConsumerRecords msgs = c.poll(0L);
            if (msgs.isEmpty()) break block0;
            ((IterableLike)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)msgs).asScala()).foldLeft((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(acc, m) -> {
                TopicPartition tp = new TopicPartition(m.topic(), m.partition());
                long off = BoxesRunTime.unboxToLong((Object)acc.get((Object)tp).map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)o -> Math.min(o, m.offset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> m.offset()));
                return acc.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)off)));
            })).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DirectKafkaInputDStream.$anonfun$paranoidPoll$4(this, c, x0$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    public scala.collection.immutable.Map<TopicPartition, Object> latestOffsets() {
        Consumer c = this.consumer();
        this.paranoidPoll(c);
        scala.collection.mutable.Set parts = (scala.collection.mutable.Set)JavaConverters$.MODULE$.asScalaSetConverter(c.assignment()).asScala();
        scala.collection.mutable.Set newPartitions = (scala.collection.mutable.Set)parts.diff((GenSet)this.currentOffsets().keySet());
        scala.collection.immutable.Set revokedPartitions = (scala.collection.immutable.Set)this.currentOffsets().keySet().diff((GenSet)parts);
        if (revokedPartitions.nonEmpty()) {
            throw new IllegalStateException(new StringBuilder(300).append("Previously tracked partitions ").append(revokedPartitions.mkString("[", ",", "]")).append(" been revoked by Kafka because of consumer ").append("rebalance. This is mostly due to another stream with same group id joined, ").append("please check if there're different streaming application misconfigure to use same ").append("group id. Fundamentally different stream should use different group id").toString());
        }
        this.currentOffsets_$eq((scala.collection.immutable.Map<TopicPartition, Object>)this.currentOffsets().$plus$plus((GenTraversableOnce)((TraversableOnce)newPartitions.map((Function1 & Serializable & scala.Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)BoxesRunTime.boxToLong((long)c.position(tp))), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())));
        c.seekToEnd((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.currentOffsets().keySet()).asJava());
        return ((TraversableOnce)parts.map((Function1 & Serializable & scala.Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)BoxesRunTime.boxToLong((long)c.position(tp))), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<TopicPartition, Object> clamp(scala.collection.immutable.Map<TopicPartition, Object> offsets) {
        return (scala.collection.immutable.Map)this.maxMessagesPerPartition(offsets).map((Function1 & Serializable & scala.Serializable)mmp -> (scala.collection.immutable.Map)mmp.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            long messages = tuple2._2$mcJ$sp();
            long uo = BoxesRunTime.unboxToLong((Object)offsets.apply((Object)tp));
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)Math.min(BoxesRunTime.unboxToLong((Object)this.currentOffsets().apply((Object)tp)) + messages, uo)));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> offsets);
    }

    public Option<KafkaRDD<K, V>> compute(Time validTime) {
        scala.collection.immutable.Map<TopicPartition, Object> untilOffsets = this.clamp(this.latestOffsets());
        Iterable offsetRanges = (Iterable)untilOffsets.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            long uo = tuple2._2$mcJ$sp();
            long fo = BoxesRunTime.unboxToLong((Object)this.currentOffsets().apply((Object)tp));
            OffsetRange offsetRange = OffsetRange$.MODULE$.apply(tp.topic(), tp.partition(), fo, uo);
            return offsetRange;
        }, Iterable$.MODULE$.canBuildFrom());
        boolean useConsumerCache = BoxesRunTime.unboxToBoolean((Object)this.context().conf().get(package$.MODULE$.CONSUMER_CACHE_ENABLED()));
        KafkaRDD rdd = new KafkaRDD(this.context().sparkContext(), this.executorKafkaParams(), (OffsetRange[])offsetRanges.toArray(ClassTag$.MODULE$.apply(OffsetRange.class)), this.getPreferredHosts(), useConsumerCache);
        String description = ((TraversableOnce)((TraversableLike)offsetRanges.filter((Function1 & Serializable & scala.Serializable)offsetRange -> BoxesRunTime.boxToBoolean((boolean)DirectKafkaInputDStream.$anonfun$compute$2(offsetRange)))).map((Function1 & Serializable & scala.Serializable)offsetRange -> new StringBuilder(33).append("topic: ").append(offsetRange.topic()).append("\tpartition: ").append(offsetRange.partition()).append("\t").append("offsets: ").append(offsetRange.fromOffset()).append(" to ").append(offsetRange.untilOffset()).toString(), Iterable$.MODULE$.canBuildFrom())).mkString("\n");
        scala.collection.immutable.Map metadata = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"offsets"), (Object)offsetRanges.toList()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StreamInputInfo$.MODULE$.METADATA_KEY_DESCRIPTION()), (Object)description)}));
        StreamInputInfo inputInfo = new StreamInputInfo(this.id(), rdd.count(), metadata);
        this.ssc().scheduler().inputInfoTracker().reportInfo(validTime, inputInfo);
        this.currentOffsets_$eq(untilOffsets);
        this.commitAll();
        return new Some(rdd);
    }

    public void start() {
        block0: {
            Consumer c = this.consumer();
            this.paranoidPoll(c);
            if (!this.currentOffsets().isEmpty()) break block0;
            this.currentOffsets_$eq((scala.collection.immutable.Map<TopicPartition, Object>)((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(c.assignment()).asScala()).map((Function1 & Serializable & scala.Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)BoxesRunTime.boxToLong((long)c.position(tp))), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        }
    }

    public synchronized void stop() {
        block0: {
            if (this.kc() == null) break block0;
            this.kc().close();
        }
    }

    public ConcurrentLinkedQueue<OffsetRange> commitQueue() {
        return this.commitQueue;
    }

    public AtomicReference<OffsetCommitCallback> commitCallback() {
        return this.commitCallback;
    }

    @Override
    public void commitAsync(OffsetRange[] offsetRanges) {
        this.commitAsync(offsetRanges, null);
    }

    @Override
    public void commitAsync(OffsetRange[] offsetRanges, OffsetCommitCallback callback) {
        this.commitCallback().set(callback);
        this.commitQueue().addAll(Arrays.asList((Object[])offsetRanges));
    }

    public void commitAll() {
        block1: {
            HashMap<TopicPartition, OffsetAndMetadata> m = new HashMap<TopicPartition, OffsetAndMetadata>();
            OffsetRange osr = this.commitQueue().poll();
            while (osr != null) {
                TopicPartition tp = osr.topicPartition();
                OffsetAndMetadata x = (OffsetAndMetadata)m.get(tp);
                long offset = x == null ? osr.untilOffset() : Math.max(x.offset(), osr.untilOffset());
                m.put(tp, new OffsetAndMetadata(offset));
                osr = this.commitQueue().poll();
            }
            if (m.isEmpty()) break block1;
            this.consumer().commitAsync(m, this.commitCallback().get());
        }
    }

    public static final /* synthetic */ long $anonfun$maxMessagesPerPartition$1(DirectKafkaInputDStream $this, RateController x) {
        long lr = x.getLatestRate();
        return lr > 0L ? lr : $this.initialRate();
    }

    public static final /* synthetic */ void $anonfun$paranoidPoll$4(DirectKafkaInputDStream $this, Consumer c$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        long off = tuple2._2$mcJ$sp();
        $this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("poll(0) returned messages, seeking ").append(tp).append(" to ").append(off).append(" to compensate").toString());
        c$1.seek(tp, off);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$compute$2(OffsetRange offsetRange) {
        return offsetRange.fromOffset() != offsetRange.untilOffset();
    }

    public DirectKafkaInputDStream(StreamingContext _ssc, LocationStrategy locationStrategy, ConsumerStrategy<K, V> consumerStrategy, PerPartitionConfig ppc) {
        this.locationStrategy = locationStrategy;
        this.consumerStrategy = consumerStrategy;
        this.ppc = ppc;
        super(_ssc, ClassTag$.MODULE$.apply(ConsumerRecord.class));
        this.initialRate = this.context().sparkContext().getConf().getLong("spark.streaming.backpressure.initialRate", 0L);
        HashMap<String, Object> ekp = new HashMap<String, Object>(consumerStrategy.executorKafkaParams());
        KafkaUtils$.MODULE$.fixKafkaParams(ekp);
        this.executorKafkaParams = ekp;
        this.currentOffsets = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        this.kc = null;
        this.checkpointData = new DirectKafkaInputDStreamCheckpointData();
        this.rateController = RateController$.MODULE$.isBackPressureEnabled(this.ssc().conf()) ? new Some((Object)new DirectKafkaRateController(this.id(), RateEstimator$.MODULE$.create(this.ssc().conf(), this.context().graph().batchDuration()))) : None$.MODULE$;
        this.commitQueue = new ConcurrentLinkedQueue();
        this.commitCallback = new AtomicReference();
    }

    public class DirectKafkaInputDStreamCheckpointData
    extends DStreamCheckpointData<ConsumerRecord<K, V>> {
        public scala.collection.mutable.HashMap<Time, Tuple4<String, Object, Object, Object>[]> batchForTime() {
            return this.data();
        }

        public void update(Time time) {
            this.batchForTime().clear();
            this.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().generatedRDDs().foreach((Function1 & Serializable & scala.Serializable)kv -> {
                Tuple4[] a = (Tuple4[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((KafkaRDD)kv._2()).offsetRanges())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toTuple(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple4.class))))).toArray(ClassTag$.MODULE$.apply(Tuple4.class));
                return this.batchForTime().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(kv._1()), (Object)a));
            });
        }

        public void cleanup(Time time) {
        }

        public void restore() {
            ((IterableLike)this.batchForTime().toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$3 -> (Time)x$3._1(), Time$.MODULE$.ordering())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Time t = (Time)tuple2._1();
                Tuple4[] b = (Tuple4[])tuple2._2();
                this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Restoring KafkaRDD for time ").append(t).append(" ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])b)).mkString("[", ", ", "]")).toString());
                scala.collection.mutable.HashMap hashMap = this.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().generatedRDDs().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t), new KafkaRDD(this.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().context().sparkContext(), this.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().executorKafkaParams(), (OffsetRange[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])b)).map((Function1 & Serializable & scala.Serializable)x$4 -> OffsetRange$.MODULE$.apply((Tuple4<String, Object, Object, Object>)x$4), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(OffsetRange.class))), this.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().getPreferredHosts(), false)));
                return hashMap;
            });
        }

        public /* synthetic */ DirectKafkaInputDStream org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer() {
            return DirectKafkaInputDStream.this;
        }

        public DirectKafkaInputDStreamCheckpointData() {
            if (DirectKafkaInputDStream.this == null) {
                throw null;
            }
            super((DStream)DirectKafkaInputDStream.this, ClassTag$.MODULE$.apply(ConsumerRecord.class));
        }
    }

    public class DirectKafkaRateController
    extends RateController {
        public void publish(long rate) {
        }

        public /* synthetic */ DirectKafkaInputDStream org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaRateController$$$outer() {
            return DirectKafkaInputDStream.this;
        }

        public DirectKafkaRateController(int id, RateEstimator estimator) {
            if (DirectKafkaInputDStream.this == null) {
                throw null;
            }
            super(id, estimator);
        }
    }
}

