/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.reflect;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.ipc.specific.SpecificRequestor;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.avro.specific.SpecificData;

public class ReflectRequestor
extends SpecificRequestor {
    public ReflectRequestor(Class<?> iface, Transceiver transceiver) throws IOException {
        this(iface, transceiver, new ReflectData(iface.getClassLoader()));
    }

    protected ReflectRequestor(Protocol protocol, Transceiver transceiver) throws IOException {
        this(protocol, transceiver, ReflectData.get());
    }

    public ReflectRequestor(Class<?> iface, Transceiver transceiver, ReflectData data) throws IOException {
        this(data.getProtocol(iface), transceiver, data);
    }

    public ReflectRequestor(Protocol protocol, Transceiver transceiver, ReflectData data) throws IOException {
        super(protocol, transceiver, (SpecificData)data);
    }

    public ReflectData getReflectData() {
        return (ReflectData)this.getSpecificData();
    }

    @Override
    protected DatumWriter<Object> getDatumWriter(Schema schema) {
        return new ReflectDatumWriter<Object>(schema, this.getReflectData());
    }

    @Override
    protected DatumReader<Object> getDatumReader(Schema writer, Schema reader) {
        return new ReflectDatumReader<Object>(writer, reader, this.getReflectData());
    }

    public static <T> T getClient(Class<T> iface, Transceiver transciever) throws IOException {
        return ReflectRequestor.getClient(iface, transciever, new ReflectData(iface.getClassLoader()));
    }

    public static <T> T getClient(Class<T> iface, Transceiver transciever, ReflectData reflectData) throws IOException {
        Protocol protocol = reflectData.getProtocol(iface);
        return (T)Proxy.newProxyInstance(reflectData.getClassLoader(), new Class[]{iface}, (InvocationHandler)new ReflectRequestor(protocol, transciever, reflectData));
    }

    public static <T> T getClient(Class<T> iface, ReflectRequestor rreq) throws IOException {
        return (T)Proxy.newProxyInstance(rreq.getReflectData().getClassLoader(), new Class[]{iface}, (InvocationHandler)rreq);
    }
}

