/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka;

import java.io.File;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import kafka.admin.AdminUtils$;
import kafka.api.LeaderAndIsr;
import kafka.api.PartitionStateInfo;
import kafka.api.Request$;
import kafka.producer.KeyedMessage;
import kafka.producer.Producer;
import kafka.producer.ProducerConfig;
import kafka.serializer.StringEncoder;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.commons.lang3.RandomUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.kafka.KafkaTestUtils$$anonfun$org$apache$spark$streaming$kafka$KafkaTestUtils$;
import org.apache.spark.util.Utils$;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tue!B\u0001\u0003\u0001\ta!AD&bM.\fG+Z:u+RLGn\u001d\u0006\u0003\u0007\u0011\tQa[1gW\u0006T!!\u0002\u0004\u0002\u0013M$(/Z1nS:<'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0014\u0007\u0001i1\u0003\u0005\u0002\u000f#5\tqBC\u0001\u0011\u0003\u0015\u00198-\u00197b\u0013\t\u0011rB\u0001\u0004B]f\u0014VM\u001a\t\u0003)]i\u0011!\u0006\u0006\u0003-\u0019\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u00031U\u0011q\u0001T8hO&tw\rC\u0003\u001b\u0001\u0011\u0005A$\u0001\u0004=S:LGOP\u0002\u0001)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005\u0011\u0001b\u0002\u0011\u0001\u0005\u0004%I!I\u0001\u0007u.Dun\u001d;\u0016\u0003\t\u0002\"a\t\u0015\u000e\u0003\u0011R!!\n\u0014\u0002\t1\fgn\u001a\u0006\u0002O\u0005!!.\u0019<b\u0013\tICE\u0001\u0004TiJLgn\u001a\u0005\u0007W\u0001\u0001\u000b\u0011\u0002\u0012\u0002\u000fi\\\u0007j\\:uA!9Q\u0006\u0001a\u0001\n\u0013q\u0013A\u0002>l!>\u0014H/F\u00010!\tq\u0001'\u0003\u00022\u001f\t\u0019\u0011J\u001c;\t\u000fM\u0002\u0001\u0019!C\u0005i\u0005Q!p\u001b)peR|F%Z9\u0015\u0005UB\u0004C\u0001\b7\u0013\t9tB\u0001\u0003V]&$\bbB\u001d3\u0003\u0003\u0005\raL\u0001\u0004q\u0012\n\u0004BB\u001e\u0001A\u0003&q&A\u0004{WB{'\u000f\u001e\u0011\t\u000fu\u0002!\u0019!C\u0005]\u0005\u0019\"p[\"p]:,7\r^5p]RKW.Z8vi\"1q\b\u0001Q\u0001\n=\nAC_6D_:tWm\u0019;j_:$\u0016.\\3pkR\u0004\u0003bB!\u0001\u0005\u0004%IAL\u0001\u0011u.\u001cVm]:j_:$\u0016.\\3pkRDaa\u0011\u0001!\u0002\u0013y\u0013!\u0005>l'\u0016\u001c8/[8o)&lWm\\;uA!IQ\t\u0001a\u0001\u0002\u0004%IAR\u0001\nu>|7.Z3qKJ,\u0012a\u0012\t\u0003\u0011&k\u0011\u0001\u0001\u0004\u0005\u0015\u0002!1JA\tF[\n,G\rZ3e5>|7.Z3qKJ\u001c\"!S\u0007\t\u00115K%Q1A\u0005\u00029\u000b\u0011B_6D_:tWm\u0019;\u0016\u0003=\u0003\"\u0001U*\u000f\u00059\t\u0016B\u0001*\u0010\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011\u0006\u0016\u0006\u0003%>A\u0001BV%\u0003\u0002\u0003\u0006IaT\u0001\u000bu.\u001cuN\u001c8fGR\u0004\u0003\"\u0002\u000eJ\t\u0003AFCA$Z\u0011\u0015iu\u000b1\u0001P\u0011\u001dY\u0016J1A\u0005\u0002q\u000b1b\u001d8baNDw\u000e\u001e#jeV\tQ\f\u0005\u0002_C6\tqL\u0003\u0002aM\u0005\u0011\u0011n\\\u0005\u0003E~\u0013AAR5mK\"1A-\u0013Q\u0001\nu\u000bAb\u001d8baNDw\u000e\u001e#je\u0002BqAZ%C\u0002\u0013\u0005A,\u0001\u0004m_\u001e$\u0015N\u001d\u0005\u0007Q&\u0003\u000b\u0011B/\u0002\u000f1|w\rR5sA!9Q)\u0013b\u0001\n\u0003QW#A6\u0011\u00051\u0004X\"A7\u000b\u00059|\u0017AB:feZ,'O\u0003\u0002F\u0011%\u0011\u0011/\u001c\u0002\u00105>|7*Z3qKJ\u001cVM\u001d<fe\"11/\u0013Q\u0001\n-\f!B_8pW\u0016,\u0007/\u001a:!\u0011\u001d)\u0018*!Q\u0001\nY\f1\u0001\u001f\u00134!\u0011qqOI\u0018\n\u0005a|!A\u0002+va2,'\u0007C\u0004{\u0013\n\u0007I\u0011A\u0011\u0002\u0005%\u0004\bB\u0002?JA\u0003%!%A\u0002ja\u0002BqA`%C\u0002\u0013\u0005a&\u0001\u0003q_J$\bbBA\u0001\u0013\u0002\u0006IaL\u0001\u0006a>\u0014H\u000f\t\u0005\n\u0003\u000bI%\u0019!C\u0001\u0003\u000f\tqAZ1di>\u0014\u00180\u0006\u0002\u0002\nA\u0019A.a\u0003\n\u0007\u00055QN\u0001\u000bO\u0013>\u001bVM\u001d<fe\u000es\u0007P\u001c$bGR|'/\u001f\u0005\t\u0003#I\u0005\u0015!\u0003\u0002\n\u0005Aa-Y2u_JL\b\u0005\u0003\u0005\u0002\u0016%\u0013\r\u0011\"\u0001/\u0003)\t7\r^;bYB{'\u000f\u001e\u0005\b\u00033I\u0005\u0015!\u00030\u0003-\t7\r^;bYB{'\u000f\u001e\u0011\t\u000f\u0005u\u0011\n\"\u0001\u0002 \u0005A1\u000f[;uI><h\u000eF\u00016\u0011-\t\u0019\u0003\u0001a\u0001\u0002\u0004%I!!\n\u0002\u001bi|wn[3fa\u0016\u0014x\fJ3r)\r)\u0014q\u0005\u0005\ts\u0005\u0005\u0012\u0011!a\u0001\u000f\"11\u000f\u0001Q!\n\u001dC1\"!\f\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00020\u0005A!p[\"mS\u0016tG/\u0006\u0002\u00022A!\u00111GA\u001f\u001b\t\t)D\u0003\u0003\u00028\u0005e\u0012\u0001\u0003>lG2LWM\u001c;\u000b\u0007\u0005m\"\"\u0001\u0004Ja%#XmY\u0005\u0005\u0003\u007f\t)D\u0001\u0005[W\u000ec\u0017.\u001a8u\u0011-\t\u0019\u0005\u0001a\u0001\u0002\u0004%I!!\u0012\u0002\u0019i\\7\t\\5f]R|F%Z9\u0015\u0007U\n9\u0005C\u0005:\u0003\u0003\n\t\u00111\u0001\u00022!A\u00111\n\u0001!B\u0013\t\t$A\u0005{W\u000ec\u0017.\u001a8uA!A\u0011q\n\u0001C\u0002\u0013%\u0011%\u0001\u0006ce>\\WM\u001d%pgRDq!a\u0015\u0001A\u0003%!%A\u0006ce>\\WM\u001d%pgR\u0004\u0003\u0002CA,\u0001\u0001\u0007I\u0011\u0002\u0018\u0002\u0015\t\u0014xn[3s!>\u0014H\u000fC\u0005\u0002\\\u0001\u0001\r\u0011\"\u0003\u0002^\u0005q!M]8lKJ\u0004vN\u001d;`I\u0015\fHcA\u001b\u0002`!A\u0011(!\u0017\u0002\u0002\u0003\u0007q\u0006C\u0004\u0002d\u0001\u0001\u000b\u0015B\u0018\u0002\u0017\t\u0014xn[3s!>\u0014H\u000f\t\u0005\f\u0003O\u0002\u0001\u0019!a\u0001\n\u0013\tI'\u0001\u0006ce>\\WM]\"p]\u001a,\"!a\u001b\u0011\t\u00055\u00141O\u0007\u0003\u0003_R1A\\A9\u0015\u0005\u0019\u0011\u0002BA;\u0003_\u00121bS1gW\u0006\u001cuN\u001c4jO\"Y\u0011\u0011\u0010\u0001A\u0002\u0003\u0007I\u0011BA>\u00039\u0011'o\\6fe\u000e{gNZ0%KF$2!NA?\u0011%I\u0014qOA\u0001\u0002\u0004\tY\u0007\u0003\u0005\u0002\u0002\u0002\u0001\u000b\u0015BA6\u0003-\u0011'o\\6fe\u000e{gN\u001a\u0011\t\u00159\u0004\u0001\u0019!a\u0001\n\u0013\t))\u0006\u0002\u0002\bB!\u0011QNAE\u0013\u0011\tY)a\u001c\u0003\u0017-\u000bgm[1TKJ4XM\u001d\u0005\f\u0003\u001f\u0003\u0001\u0019!a\u0001\n\u0013\t\t*\u0001\u0006tKJ4XM]0%KF$2!NAJ\u0011%I\u0014QRA\u0001\u0002\u0004\t9\t\u0003\u0005\u0002\u0018\u0002\u0001\u000b\u0015BAD\u0003\u001d\u0019XM\u001d<fe\u0002B1\"a'\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u001e\u0006A\u0001O]8ek\u000e,'/\u0006\u0002\u0002 B1\u0011\u0011UAS\u001f>k!!a)\u000b\t\u0005m\u0015\u0011O\u0005\u0005\u0003O\u000b\u0019K\u0001\u0005Qe>$WoY3s\u0011-\tY\u000b\u0001a\u0001\u0002\u0004%I!!,\u0002\u0019A\u0014x\u000eZ;dKJ|F%Z9\u0015\u0007U\ny\u000bC\u0005:\u0003S\u000b\t\u00111\u0001\u0002 \"A\u00111\u0017\u0001!B\u0013\ty*A\u0005qe>$WoY3sA!I\u0011q\u0017\u0001A\u0002\u0013%\u0011\u0011X\u0001\bu.\u0014V-\u00193z+\t\tY\fE\u0002\u000f\u0003{K1!a0\u0010\u0005\u001d\u0011un\u001c7fC:D\u0011\"a1\u0001\u0001\u0004%I!!2\u0002\u0017i\\'+Z1es~#S-\u001d\u000b\u0004k\u0005\u001d\u0007\"C\u001d\u0002B\u0006\u0005\t\u0019AA^\u0011!\tY\r\u0001Q!\n\u0005m\u0016\u0001\u0003>l%\u0016\fG-\u001f\u0011\t\u0013\u0005=\u0007\u00011A\u0005\n\u0005e\u0016a\u00032s_.,'OU3bIfD\u0011\"a5\u0001\u0001\u0004%I!!6\u0002\u001f\t\u0014xn[3s%\u0016\fG-_0%KF$2!NAl\u0011%I\u0014\u0011[A\u0001\u0002\u0004\tY\f\u0003\u0005\u0002\\\u0002\u0001\u000b\u0015BA^\u00031\u0011'o\\6feJ+\u0017\rZ=!\u0011\u0019\ty\u000e\u0001C\u0001\u001d\u0006I!p[!eIJ,7o\u001d\u0005\u0007\u0003G\u0004A\u0011\u0001(\u0002\u001b\t\u0014xn[3s\u0003\u0012$'/Z:t\u0011\u001d\t9\u000f\u0001C\u0001\u0003_\tqB_8pW\u0016,\u0007/\u001a:DY&,g\u000e\u001e\u0005\b\u0003W\u0004A\u0011BA\u0010\u0003Y\u0019X\r^;q\u000b6\u0014W\r\u001a3fIj{wn[3fa\u0016\u0014\bbBAx\u0001\u0011%\u0011qD\u0001\u0019g\u0016$X\u000f]#nE\u0016$G-\u001a3LC\u001a\\\u0017mU3sm\u0016\u0014\bbBAz\u0001\u0011\u0005\u0011qD\u0001\u0006g\u0016$X\u000f\u001d\u0005\b\u0003o\u0004A\u0011AA\u0010\u0003!!X-\u0019:e_^t\u0007bBA~\u0001\u0011\u0005\u0011Q`\u0001\fGJ,\u0017\r^3U_BL7\rF\u00036\u0003\u007f\u0014\u0019\u0001C\u0004\u0003\u0002\u0005e\b\u0019A(\u0002\u000bQ|\u0007/[2\t\u000f\t\u0015\u0011\u0011 a\u0001_\u0005Q\u0001/\u0019:uSRLwN\\:\t\u000f\u0005m\b\u0001\"\u0001\u0003\nQ\u0019QGa\u0003\t\u000f\t\u0005!q\u0001a\u0001\u001f\"9!q\u0002\u0001\u0005\u0002\tE\u0011\u0001D:f]\u0012lUm]:bO\u0016\u001cH#B\u001b\u0003\u0014\tU\u0001b\u0002B\u0001\u0005\u001b\u0001\ra\u0014\u0005\t\u0005/\u0011i\u00011\u0001\u0003\u001a\u0005iQ.Z:tC\u001e,Gk\u001c$sKF\u0004rAa\u0007\u0003\"=\u0013)#\u0004\u0002\u0003\u001e)\u0019!q\u0004\u0014\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005G\u0011iBA\u0002NCB\u00042a\tB\u0014\u0013\r\u0011I\u0003\n\u0002\b\u0013:$XmZ3s\u0011\u001d\u0011y\u0001\u0001C\u0001\u0005[!R!\u000eB\u0018\u0005cAqA!\u0001\u0003,\u0001\u0007q\n\u0003\u0005\u0003\u0018\t-\u0002\u0019\u0001B\u001a!\u0015\u0001&QG(0\u0013\r\u0011\u0019\u0003\u0016\u0005\b\u0005\u001f\u0001A\u0011\u0001B\u001d)\u0015)$1\bB\u001f\u0011\u001d\u0011\tAa\u000eA\u0002=C\u0001Ba\u0010\u00038\u0001\u0007!\u0011I\u0001\t[\u0016\u001c8/Y4fgB!aBa\u0011P\u0013\r\u0011)e\u0004\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\b\u0005\u0013\u0002A\u0011\u0002B&\u0003M\u0011'o\\6fe\u000e{gNZ5hkJ\fG/[8o+\t\u0011i\u0005\u0005\u0003\u0003\u001c\t=\u0013\u0002\u0002B)\u0005;\u0011!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u001d\u0011)\u0006\u0001C\u0005\u0005\u0017\nQ\u0003\u001d:pIV\u001cWM]\"p]\u001aLw-\u001e:bi&|g\u000eC\u0004\u0003Z\u0001!\tAa\u0017\u0002\u0015\u00154XM\u001c;vC2d\u00170\u0006\u0003\u0003^\t\u0015DC\u0002B0\u0005\u0003\u0013i\t\u0006\u0003\u0003b\t]\u0004\u0003\u0002B2\u0005Kb\u0001\u0001\u0002\u0005\u0003h\t]#\u0019\u0001B5\u0005\u0005!\u0016\u0003\u0002B6\u0005c\u00022A\u0004B7\u0013\r\u0011yg\u0004\u0002\b\u001d>$\b.\u001b8h!\rq!1O\u0005\u0004\u0005kz!aA!os\"I!\u0011\u0010B,\t\u0003\u0007!1P\u0001\u0005MVt7\rE\u0003\u000f\u0005{\u0012\t'C\u0002\u0003\u0000=\u0011\u0001\u0002\u00102z]\u0006lWM\u0010\u0005\t\u0005\u0007\u00139\u00061\u0001\u0003\u0006\u00069A/[7f_V$\b\u0003\u0002BD\u0005\u0013k\u0011\u0001B\u0005\u0004\u0005\u0017#!\u0001\u0002+j[\u0016D\u0001Ba$\u0003X\u0001\u0007!QQ\u0001\tS:$XM\u001d<bY\"9!1\u0013\u0001\u0005\n\tU\u0015!H<bSR,f\u000e^5m\u001b\u0016$\u0018\rZ1uC&\u001b\bK]8qC\u001e\fG/\u001a3\u0015\u000bU\u00129J!'\t\u000f\t\u0005!\u0011\u0013a\u0001\u001f\"9!1\u0014BI\u0001\u0004y\u0013!\u00039beRLG/[8o\u0001")
public class KafkaTestUtils
implements Logging {
    private final String zkHost;
    private int zkPort;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private EmbeddedZookeeper zookeeper;
    private ZkClient zkClient;
    private final String brokerHost;
    private int org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort;
    private KafkaConfig org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConf;
    private KafkaServer org$apache$spark$streaming$kafka$KafkaTestUtils$$server;
    private Producer<String, String> producer;
    private boolean zkReady;
    private boolean brokerReady;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    private String zkHost() {
        return this.zkHost;
    }

    private int zkPort() {
        return this.zkPort;
    }

    private void zkPort_$eq(int x$1) {
        this.zkPort = x$1;
    }

    private int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    private int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    private EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    private void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    private ZkClient zkClient() {
        return this.zkClient;
    }

    private void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    private String brokerHost() {
        return this.brokerHost;
    }

    public int org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort() {
        return this.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort;
    }

    public void org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort_$eq(int x$1) {
        this.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort = x$1;
    }

    public KafkaConfig org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConf() {
        return this.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConf;
    }

    public void org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConf_$eq(KafkaConfig x$1) {
        this.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConf = x$1;
    }

    public KafkaServer org$apache$spark$streaming$kafka$KafkaTestUtils$$server() {
        return this.org$apache$spark$streaming$kafka$KafkaTestUtils$$server;
    }

    public void org$apache$spark$streaming$kafka$KafkaTestUtils$$server_$eq(KafkaServer x$1) {
        this.org$apache$spark$streaming$kafka$KafkaTestUtils$$server = x$1;
    }

    private Producer<String, String> producer() {
        return this.producer;
    }

    private void producer_$eq(Producer<String, String> x$1) {
        this.producer = x$1;
    }

    private boolean zkReady() {
        return this.zkReady;
    }

    private void zkReady_$eq(boolean x$1) {
        this.zkReady = x$1;
    }

    private boolean brokerReady() {
        return this.brokerReady;
    }

    private void brokerReady_$eq(boolean x$1) {
        this.brokerReady = x$1;
    }

    public String zkAddress() {
        Predef$.MODULE$.assert(this.zkReady(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Zookeeper not setup yet or already torn down, cannot get zookeeper address";
            }
        });
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkHost(), BoxesRunTime.boxToInteger((int)this.zkPort())}));
    }

    public String brokerAddress() {
        Predef$.MODULE$.assert(this.brokerReady(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Kafka not setup yet or already torn down, cannot get broker address";
            }
        });
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.brokerHost(), BoxesRunTime.boxToInteger((int)this.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort())}));
    }

    public ZkClient zookeeperClient() {
        Predef$.MODULE$.assert(this.zkReady(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Zookeeper not setup yet or already torn down, cannot get zookeeper client";
            }
        });
        return (ZkClient)Option$.MODULE$.apply((Object)this.zkClient()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalStateException("Zookeeper client is not yet initialized");
            }
        });
    }

    private void setupEmbeddedZookeeper() {
        this.zookeeper_$eq(new EmbeddedZookeeper(this, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkHost(), BoxesRunTime.boxToInteger((int)this.zkPort())}))));
        this.zkPort_$eq(this.zookeeper().actualPort());
        this.zkClient_$eq(new ZkClient(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkHost(), BoxesRunTime.boxToInteger((int)this.zkPort())})), this.zkSessionTimeout(), this.zkConnectionTimeout(), ZKStringSerializer$.MODULE$));
        this.zkReady_$eq(true);
    }

    private void setupEmbeddedKafkaServer() {
        Predef$.MODULE$.assert(this.zkReady(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Zookeeper should be set up beforehand";
            }
        });
        Utils$.MODULE$.startServiceOnPort(this.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaTestUtils $outer;

            public final Tuple2<KafkaServer, Object> apply(int port) {
                this.$outer.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort_$eq(port);
                this.$outer.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConf_$eq(new KafkaConfig(this.$outer.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConfiguration()));
                this.$outer.org$apache$spark$streaming$kafka$KafkaTestUtils$$server_$eq(new KafkaServer(this.$outer.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConf(), KafkaServer$.MODULE$.$lessinit$greater$default$2()));
                this.$outer.org$apache$spark$streaming$kafka$KafkaTestUtils$$server().startup();
                return new Tuple2((Object)this.$outer.org$apache$spark$streaming$kafka$KafkaTestUtils$$server(), (Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, new SparkConf(), "KafkaBroker");
        this.brokerReady_$eq(true);
    }

    public void setup() {
        this.setupEmbeddedZookeeper();
        this.setupEmbeddedKafkaServer();
    }

    public void teardown() {
        this.brokerReady_$eq(false);
        this.zkReady_$eq(false);
        if (this.producer() != null) {
            this.producer().close();
            this.producer_$eq(null);
        }
        if (this.org$apache$spark$streaming$kafka$KafkaTestUtils$$server() != null) {
            this.org$apache$spark$streaming$kafka$KafkaTestUtils$$server().shutdown();
            this.org$apache$spark$streaming$kafka$KafkaTestUtils$$server_$eq(null);
        }
        this.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConf().logDirs().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(String f) {
                Utils$.MODULE$.deleteRecursively(new File(f));
            }
        });
        if (this.zkClient() != null) {
            this.zkClient().close();
            this.zkClient_$eq(null);
        }
        if (this.zookeeper() != null) {
            this.zookeeper().shutdown();
            this.zookeeper_$eq(null);
        }
    }

    public void createTopic(String topic, int partitions) {
        AdminUtils$.MODULE$.createTopic(this.zkClient(), topic, partitions, 1, AdminUtils$.MODULE$.createTopic$default$5());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitions).foreach$mVc$sp((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaTestUtils $outer;
            private final String topic$1;

            public final void apply(int p) {
                this.apply$mcVI$sp(p);
            }

            public void apply$mcVI$sp(int p) {
                this.$outer.org$apache$spark$streaming$kafka$KafkaTestUtils$$waitUntilMetadataIsPropagated(this.topic$1, p);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
            }
        });
    }

    public void createTopic(String topic) {
        this.createTopic(topic, 1);
    }

    public void sendMessages(String topic, Map<String, Integer> messageToFreq) {
        this.sendMessages(topic, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(messageToFreq).asScala()).mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Integer x$1) {
                return x$1;
            }
        }).toSeq())));
    }

    public void sendMessages(String topic, scala.collection.immutable.Map<String, Object> messageToFreq) {
        String[] messages = (String[])((TraversableOnce)messageToFreq.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    String s = (String)tuple2._1();
                    int freq = tuple2._2$mcI$sp();
                    Seq seq = (Seq)Seq$.MODULE$.fill(freq, (Function0)new Serializable(this, s){
                        public static final long serialVersionUID = 0L;
                        private final String s$1;

                        public final String apply() {
                            return this.s$1;
                        }
                        {
                            this.s$1 = s$1;
                        }
                    });
                    return seq;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
        this.sendMessages(topic, messages);
    }

    public void sendMessages(String topic, String[] messages) {
        this.producer_$eq(new Producer<String, String>(new ProducerConfig(this.producerConfiguration())));
        this.producer().send((Seq<KeyedMessage<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])messages).map((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$3;

            public final KeyedMessage<String, String> apply(String x$2) {
                return new KeyedMessage<String, String>(this.topic$3, x$2);
            }
            {
                this.topic$3 = topic$3;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(KeyedMessage.class)))));
        this.producer().close();
        this.producer_$eq(null);
    }

    /*
     * WARNING - void declaration
     */
    public Properties org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConfiguration() {
        void var1_1;
        Properties props = new Properties();
        props.put("broker.id", "0");
        props.put("host.name", "localhost");
        props.put("port", ((Object)BoxesRunTime.boxToInteger((int)this.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort())).toString());
        props.put("log.dir", Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getAbsolutePath());
        props.put("zookeeper.connect", this.zkAddress());
        props.put("log.flush.interval.messages", "1");
        props.put("replica.socket.timeout.ms", "1500");
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Properties producerConfiguration() {
        void var1_1;
        Properties props = new Properties();
        props.put("metadata.broker.list", this.brokerAddress());
        props.put("serializer.class", StringEncoder.class.getName());
        props.put("request.required.acks", "-1");
        return var1_1;
    }

    public <T> T eventually(Time timeout, Time interval, Function0<T> func) {
        long startTime = System.currentTimeMillis();
        return (T)this.tryAgain$1(1, timeout, interval, func, startTime);
    }

    public void org$apache$spark$streaming$kafka$KafkaTestUtils$$waitUntilMetadataIsPropagated(String topic, int partition) {
        this.eventually(new Time(10000L), new Time(100L), (Function0)new Serializable(this, topic, partition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaTestUtils $outer;
            public final String topic$2;
            public final int partition$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Predef$.MODULE$.assert(this.$outer.org$apache$spark$streaming$kafka$KafkaTestUtils$$isPropagated$1(this.topic$2, this.partition$1), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$org$apache$spark$streaming$kafka$KafkaTestUtils$$waitUntilMetadataIsPropagated$1 $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition [", ", ", "] metadata not propagated after timeout"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic$2, BoxesRunTime.boxToInteger((int)this.$outer.partition$1)}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topic$2 = topic$2;
                this.partition$1 = partition$1;
            }
        });
    }

    private final Either makeAttempt$1(Function0 func$1) {
        Throwable throwable2;
        block2: {
            Right right;
            try {
                right = package$.MODULE$.Right().apply(func$1.apply());
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                if (!NonFatal$.MODULE$.apply(throwable3)) break block2;
                Left left = package$.MODULE$.Left().apply((Object)throwable3);
                right = left;
            }
            return right;
        }
        throw throwable2;
    }

    private final Object tryAgain$1(int attempt, Time timeout$1, Time interval$1, Function0 func$1, long startTime$1) {
        Either either;
        block2: {
            Throwable e;
            while (true) {
                if ((either = this.makeAttempt$1(func$1)) instanceof Right) {
                    Object result;
                    Right right = (Right)either;
                    Object object = result = right.b();
                    return object;
                }
                if (!(either instanceof Left)) break block2;
                Left left = (Left)either;
                e = (Throwable)left.a();
                long duration = System.currentTimeMillis() - startTime$1;
                if (duration >= timeout$1.milliseconds()) break;
                Thread.sleep(interval$1.milliseconds());
                ++attempt;
            }
            throw new TimeoutException(e.getMessage());
        }
        throw new MatchError((Object)either);
    }

    public final boolean org$apache$spark$streaming$kafka$KafkaTestUtils$$isPropagated$1(String topic$2, int partition$1) {
        boolean bl;
        Option<PartitionStateInfo> option = this.org$apache$spark$streaming$kafka$KafkaTestUtils$$server().apis().metadataCache().getPartitionInfo(topic$2, partition$1);
        if (option instanceof Some) {
            Some some = (Some)option;
            PartitionStateInfo partitionState = (PartitionStateInfo)some.x();
            LeaderAndIsr leaderAndInSyncReplicas = partitionState.leaderIsrAndControllerEpoch().leaderAndIsr();
            bl = ZkUtils$.MODULE$.getLeaderForPartition(this.zkClient(), topic$2, partition$1).isDefined() && Request$.MODULE$.isValidBrokerId(leaderAndInSyncReplicas.leader()) && leaderAndInSyncReplicas.isr().size() >= 1;
        } else {
            bl = false;
        }
        return bl;
    }

    public KafkaTestUtils() {
        Logging.class.$init$((Logging)this);
        this.zkHost = "localhost";
        this.zkPort = 0;
        this.zkConnectionTimeout = 60000;
        this.zkSessionTimeout = 6000;
        this.brokerHost = "localhost";
        this.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort = RandomUtils.nextInt((int)1024, (int)65536);
        this.zkReady = false;
        this.brokerReady = false;
    }

    public class EmbeddedZookeeper {
        private final String zkConnect;
        private final File snapshotDir;
        private final File logDir;
        private final ZooKeeperServer zookeeper;
        private final Tuple2<String, Object> x$3;
        private final String ip;
        private final int port;
        private final NIOServerCnxnFactory factory;
        private final int actualPort;
        public final /* synthetic */ KafkaTestUtils $outer;

        public String zkConnect() {
            return this.zkConnect;
        }

        public File snapshotDir() {
            return this.snapshotDir;
        }

        public File logDir() {
            return this.logDir;
        }

        public ZooKeeperServer zookeeper() {
            return this.zookeeper;
        }

        public String ip() {
            return this.ip;
        }

        public int port() {
            return this.port;
        }

        public NIOServerCnxnFactory factory() {
            return this.factory;
        }

        public int actualPort() {
            return this.actualPort;
        }

        public void shutdown() {
            this.factory().shutdown();
            Utils$.MODULE$.deleteRecursively(this.snapshotDir());
            Utils$.MODULE$.deleteRecursively(this.logDir());
        }

        public /* synthetic */ KafkaTestUtils org$apache$spark$streaming$kafka$KafkaTestUtils$EmbeddedZookeeper$$$outer() {
            return this.$outer;
        }

        public EmbeddedZookeeper(KafkaTestUtils $outer, String zkConnect) {
            this.zkConnect = zkConnect;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.snapshotDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            this.logDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            this.zookeeper = new ZooKeeperServer(this.snapshotDir(), this.logDir(), 500);
            String[] splits = zkConnect.split(":");
            Tuple2 tuple2 = new Tuple2((Object)splits[0], (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(splits[1])).toInt()));
            if (tuple2 != null) {
                Tuple2 tuple22;
                String ip = (String)tuple2._1();
                int port = tuple2._2$mcI$sp();
                this.x$3 = tuple22 = new Tuple2((Object)ip, (Object)BoxesRunTime.boxToInteger((int)port));
                this.ip = (String)this.x$3._1();
                this.port = this.x$3._2$mcI$sp();
                this.factory = new NIOServerCnxnFactory();
                this.factory().configure(new InetSocketAddress(this.ip(), this.port()), 16);
                this.factory().startup(this.zookeeper());
                this.actualPort = this.factory().getLocalPort();
                return;
            }
            throw new MatchError((Object)tuple2);
        }
    }
}

