/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.ar;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.utils.ArchiveUtils;

public class ArArchiveInputStream
extends ArchiveInputStream {
    private final InputStream input;
    private long offset = 0L;
    private boolean closed;
    private ArArchiveEntry currentEntry = null;
    private byte[] namebuffer = null;
    private long entryOffset = -1L;
    static final String BSD_LONGNAME_PREFIX = "#1/";
    private static final int BSD_LONGNAME_PREFIX_LEN = "#1/".length();
    private static final String BSD_LONGNAME_PATTERN = "^#1/\\d+";
    private static final String GNU_STRING_TABLE_NAME = "//";
    private static final String GNU_LONGNAME_PATTERN = "^/\\d+";

    public ArArchiveInputStream(InputStream pInput) {
        this.input = pInput;
        this.closed = false;
    }

    public ArArchiveEntry getNextArEntry() throws IOException {
        if (this.currentEntry != null) {
            long entryEnd = this.entryOffset + this.currentEntry.getLength();
            while (this.offset < entryEnd) {
                int x = this.read();
                if (x != -1) continue;
                return null;
            }
            this.currentEntry = null;
        }
        if (this.offset == 0L) {
            byte[] expected = ArchiveUtils.toAsciiBytes("!<arch>\n");
            byte[] realized = new byte[expected.length];
            int read2 = this.read(realized);
            if (read2 != expected.length) {
                throw new IOException("failed to read header. Occured at byte: " + this.getBytesRead());
            }
            for (int i = 0; i < expected.length; ++i) {
                if (expected[i] == realized[i]) continue;
                throw new IOException("invalid header " + ArchiveUtils.toAsciiString(realized));
            }
        }
        if (this.offset % 2L != 0L && this.read() < 0) {
            return null;
        }
        if (this.input.available() == 0) {
            return null;
        }
        byte[] name = new byte[16];
        byte[] lastmodified = new byte[12];
        byte[] userid = new byte[6];
        byte[] groupid = new byte[6];
        byte[] filemode = new byte[8];
        byte[] length = new byte[10];
        this.read(name);
        this.read(lastmodified);
        this.read(userid);
        this.read(groupid);
        this.read(filemode);
        this.read(length);
        byte[] expected = ArchiveUtils.toAsciiBytes("`\n");
        byte[] realized = new byte[expected.length];
        int read3 = this.read(realized);
        if (read3 != expected.length) {
            throw new IOException("failed to read entry trailer. Occured at byte: " + this.getBytesRead());
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == realized[i]) continue;
            throw new IOException("invalid entry trailer. not read the content? Occured at byte: " + this.getBytesRead());
        }
        this.entryOffset = this.offset;
        String temp = ArchiveUtils.toAsciiString(name).trim();
        long len = this.asLong(length);
        if (ArArchiveInputStream.isGNUStringTable(temp)) {
            this.currentEntry = this.readGNUStringTable(length);
            return this.getNextArEntry();
        }
        if (temp.endsWith("/")) {
            temp = temp.substring(0, temp.length() - 1);
        } else if (this.isGNULongName(temp)) {
            int offset = Integer.parseInt(temp.substring(1));
            temp = this.getExtendedName(offset);
        } else if (ArArchiveInputStream.isBSDLongName(temp)) {
            temp = this.getBSDLongName(temp);
            int nameLen = temp.length();
            len -= (long)nameLen;
            this.entryOffset += (long)nameLen;
        }
        this.currentEntry = new ArArchiveEntry(temp, len, this.asInt(userid, true), this.asInt(groupid, true), this.asInt(filemode, 8), this.asLong(lastmodified));
        return this.currentEntry;
    }

    private String getExtendedName(int offset) throws IOException {
        if (this.namebuffer == null) {
            throw new IOException("Cannot process GNU long filename as no // record was found");
        }
        for (int i = offset; i < this.namebuffer.length; ++i) {
            if (this.namebuffer[i] != 10) continue;
            if (this.namebuffer[i - 1] == 47) {
                --i;
            }
            return ArchiveUtils.toAsciiString(this.namebuffer, offset, i - offset);
        }
        throw new IOException("Failed to read entry: " + offset);
    }

    private long asLong(byte[] input) {
        return Long.parseLong(ArchiveUtils.toAsciiString(input).trim());
    }

    private int asInt(byte[] input) {
        return this.asInt(input, 10, false);
    }

    private int asInt(byte[] input, boolean treatBlankAsZero) {
        return this.asInt(input, 10, treatBlankAsZero);
    }

    private int asInt(byte[] input, int base) {
        return this.asInt(input, base, false);
    }

    private int asInt(byte[] input, int base, boolean treatBlankAsZero) {
        String string = ArchiveUtils.toAsciiString(input).trim();
        if (string.length() == 0 && treatBlankAsZero) {
            return 0;
        }
        return Integer.parseInt(string, base);
    }

    public ArchiveEntry getNextEntry() throws IOException {
        return this.getNextArEntry();
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.input.close();
        }
        this.currentEntry = null;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int toRead = len;
        if (this.currentEntry != null) {
            long entryEnd = this.entryOffset + this.currentEntry.getLength();
            if (len > 0 && entryEnd > this.offset) {
                toRead = (int)Math.min((long)len, entryEnd - this.offset);
            } else {
                return -1;
            }
        }
        int ret = this.input.read(b, off, toRead);
        this.count(ret);
        this.offset += (long)(ret > 0 ? ret : 0);
        return ret;
    }

    public static boolean matches(byte[] signature, int length) {
        if (length < 8) {
            return false;
        }
        if (signature[0] != 33) {
            return false;
        }
        if (signature[1] != 60) {
            return false;
        }
        if (signature[2] != 97) {
            return false;
        }
        if (signature[3] != 114) {
            return false;
        }
        if (signature[4] != 99) {
            return false;
        }
        if (signature[5] != 104) {
            return false;
        }
        if (signature[6] != 62) {
            return false;
        }
        return signature[7] == 10;
    }

    private static boolean isBSDLongName(String name) {
        return name != null && name.matches(BSD_LONGNAME_PATTERN);
    }

    private String getBSDLongName(String bsdLongName) throws IOException {
        int nameLen = Integer.parseInt(bsdLongName.substring(BSD_LONGNAME_PREFIX_LEN));
        byte[] name = new byte[nameLen];
        int read2 = 0;
        int readNow = 0;
        while ((readNow = this.input.read(name, read2, nameLen - read2)) >= 0) {
            this.count(readNow);
            if ((read2 += readNow) != nameLen) continue;
        }
        if (read2 != nameLen) {
            throw new EOFException();
        }
        return ArchiveUtils.toAsciiString(name);
    }

    private static boolean isGNUStringTable(String name) {
        return GNU_STRING_TABLE_NAME.equals(name);
    }

    private ArArchiveEntry readGNUStringTable(byte[] length) throws IOException {
        int bufflen = this.asInt(length);
        this.namebuffer = new byte[bufflen];
        int read2 = this.read(this.namebuffer, 0, bufflen);
        if (read2 != bufflen) {
            throw new IOException("Failed to read complete // record: expected=" + bufflen + " read=" + read2);
        }
        return new ArArchiveEntry(GNU_STRING_TABLE_NAME, bufflen);
    }

    private boolean isGNULongName(String name) {
        return name != null && name.matches(GNU_LONGNAME_PATTERN);
    }
}

