/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.api.FetchRequest;
import kafka.api.FetchResponse;
import kafka.api.FetchResponsePartitionData;
import kafka.cluster.Replica;
import kafka.common.NotLeaderForPartitionException;
import kafka.common.TopicAndPartition;
import kafka.common.UnknownTopicOrPartitionException;
import kafka.network.RequestChannel;
import kafka.server.DelayedFetch$;
import kafka.server.DelayedRequest;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.PartitionDataAndOffset;
import kafka.server.ReplicaManager;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u000154A!\u0001\u0002\u0001\u000f\taA)\u001a7bs\u0016$g)\u001a;dQ*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011BC\u0007\u0002\u0005%\u00111B\u0001\u0002\u000f\t\u0016d\u0017-_3e%\u0016\fX/Z:u\u0011!i\u0001A!b\u0001\n\u0003r\u0011\u0001B6fsN,\u0012a\u0004\t\u0004!U9R\"A\t\u000b\u0005I\u0019\u0012AC2pY2,7\r^5p]*\tA#A\u0003tG\u0006d\u0017-\u0003\u0002\u0017#\t\u00191+Z9\u0011\u0005aYR\"A\r\u000b\u0005i!\u0011AB2p[6|g.\u0003\u0002\u001d3\t\tBk\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8\t\u0013y\u0001!\u0011!Q\u0001\n=y\u0012!B6fsN\u0004\u0013BA\u0007\u000b\u0011!\t\u0003A!b\u0001\n\u0003\u0012\u0013a\u0002:fcV,7\u000f^\u000b\u0002GA\u0011AE\u000b\b\u0003K!j\u0011A\n\u0006\u0003O\u0011\tqA\\3uo>\u00148.\u0003\u0002*M\u0005q!+Z9vKN$8\t[1o]\u0016d\u0017BA\u0016-\u0005\u001d\u0011V-];fgRT!!\u000b\u0014\t\u00139\u0002!\u0011!Q\u0001\n\rz\u0013\u0001\u0003:fcV,7\u000f\u001e\u0011\n\u0005\u0005R\u0001\u0002C\u0019\u0001\u0005\u000b\u0007I\u0011\t\u001a\u0002\u000f\u0011,G.Y=NgV\t1\u0007\u0005\u00025k5\t1#\u0003\u00027'\t!Aj\u001c8h\u0011!A\u0004A!A!\u0002\u0013\u0019\u0014\u0001\u00033fY\u0006LXj\u001d\u0011\t\u0011i\u0002!Q1A\u0005\u0002m\nQAZ3uG\",\u0012\u0001\u0010\t\u0003{\u0001k\u0011A\u0010\u0006\u0003\u007f\u0011\t1!\u00199j\u0013\t\teH\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cH\u000f\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003=\u0003\u00191W\r^2iA!AQ\t\u0001BC\u0002\u0013%a)A\u000bqCJ$\u0018\u000e^5p]\u001a+Go\u00195PM\u001a\u001cX\r^:\u0016\u0003\u001d\u0003B\u0001S&\u0018\u001b6\t\u0011J\u0003\u0002K#\u0005I\u0011.\\7vi\u0006\u0014G.Z\u0005\u0003\u0019&\u00131!T1q!\tIa*\u0003\u0002P\u0005\t\tBj\\4PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1\t\u0011E\u0003!\u0011!Q\u0001\n\u001d\u000ba\u0003]1si&$\u0018n\u001c8GKR\u001c\u0007n\u00144gg\u0016$8\u000f\t\u0005\u0006'\u0002!\t\u0001V\u0001\u0007y%t\u0017\u000e\u001e \u0015\rU3v\u000bW-[!\tI\u0001\u0001C\u0003\u000e%\u0002\u0007q\u0002C\u0003\"%\u0002\u00071\u0005C\u00032%\u0002\u00071\u0007C\u0003;%\u0002\u0007A\bC\u0003F%\u0002\u0007q\tC\u0003]\u0001\u0011\u0005Q,A\u0006jgN\u000bG/[:gS\u0016$GC\u00010b!\t!t,\u0003\u0002a'\t9!i\\8mK\u0006t\u0007\"\u00022\\\u0001\u0004\u0019\u0017A\u0004:fa2L7-Y'b]\u0006<WM\u001d\t\u0003\u0013\u0011L!!\u001a\u0002\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\")q\r\u0001C\u0001Q\u00069!/Z:q_:$GCA5m!\ti$.\u0003\u0002l}\tia)\u001a;dQJ+7\u000f]8og\u0016DQA\u00194A\u0002\r\u0004")
public class DelayedFetch
extends DelayedRequest {
    private final long delayMs;
    private final FetchRequest fetch;
    private final Map<TopicAndPartition, LogOffsetMetadata> partitionFetchOffsets;

    public Seq<TopicAndPartition> keys() {
        return super.keys();
    }

    @Override
    public RequestChannel.Request request() {
        return super.request();
    }

    @Override
    public long delayMs() {
        return this.delayMs;
    }

    public FetchRequest fetch() {
        return this.fetch;
    }

    private Map<TopicAndPartition, LogOffsetMetadata> partitionFetchOffsets() {
        return this.partitionFetchOffsets;
    }

    public boolean isSatisfied(ReplicaManager replicaManager) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            boolean bl;
            Object object = new Object();
            try {
                IntRef accumulatedSize = new IntRef(0);
                boolean fromFollower = this.fetch().isFromFollower();
                this.partitionFetchOffsets().foreach((Function1)new Serializable(this, replicaManager, accumulatedSize, fromFollower, object){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ DelayedFetch $outer;
                    private final ReplicaManager replicaManager$1;
                    private final IntRef accumulatedSize$1;
                    private final boolean fromFollower$1;
                    private final Object nonLocalReturnKey1$1;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final void apply(Tuple2<TopicAndPartition, LogOffsetMetadata> x0$1) {
                        BoxedUnit boxedUnit;
                        block7: {
                            Tuple2<TopicAndPartition, LogOffsetMetadata> tuple2 = x0$1;
                            if (tuple2 == null) throw new MatchError(tuple2);
                            TopicAndPartition topicAndPartition = (TopicAndPartition)tuple2._1();
                            LogOffsetMetadata fetchOffset = (LogOffsetMetadata)tuple2._2();
                            try {
                                LogOffsetMetadata endOffset;
                                LogOffsetMetadata logOffsetMetadata = fetchOffset;
                                LogOffsetMetadata logOffsetMetadata2 = LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata();
                                if (!(logOffsetMetadata != null ? !((Object)logOffsetMetadata).equals(logOffsetMetadata2) : logOffsetMetadata2 != null)) {
                                    boxedUnit = BoxedUnit.UNIT;
                                    break block7;
                                }
                                Replica replica = this.replicaManager$1.getLeaderReplicaIfLocal(topicAndPartition.topic(), topicAndPartition.partition());
                                LogOffsetMetadata logOffsetMetadata3 = endOffset = this.fromFollower$1 ? replica.logEndOffset() : replica.highWatermark();
                                if (endOffset.offsetOnOlderSegment(fetchOffset)) {
                                    this.$outer.debug((Function0<String>)new Serializable(this, topicAndPartition){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$isSatisfied$1 $outer;
                                        private final TopicAndPartition topicAndPartition$1;

                                        public final String apply() {
                                            return new StringOps(Predef$.MODULE$.augmentString("Satisfying fetch request %s since it is fetching later segments of partition %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$server$DelayedFetch$$anonfun$$$outer().fetch(), this.topicAndPartition$1}));
                                        }
                                        {
                                            if ($outer == null) {
                                                throw new NullPointerException();
                                            }
                                            this.$outer = $outer;
                                            this.topicAndPartition$1 = topicAndPartition$1;
                                        }
                                    });
                                    throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, true);
                                }
                                if (fetchOffset.offsetOnOlderSegment(endOffset)) {
                                    this.$outer.debug((Function0<String>)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$isSatisfied$1 $outer;

                                        public final String apply() {
                                            return new StringOps(Predef$.MODULE$.augmentString("Satisfying fetch request %s immediately since it is fetching older segments.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$server$DelayedFetch$$anonfun$$$outer().fetch()}));
                                        }
                                        {
                                            if ($outer == null) {
                                                throw new NullPointerException();
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                    throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, true);
                                }
                                if (fetchOffset.precedes(endOffset)) {
                                    this.accumulatedSize$1.elem += endOffset.positionDiff(fetchOffset);
                                    boxedUnit = BoxedUnit.UNIT;
                                    break block7;
                                }
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            catch (NotLeaderForPartitionException notLeaderForPartitionException) {
                                this.$outer.debug((Function0<String>)new Serializable(this, topicAndPartition){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$isSatisfied$1 $outer;
                                    private final TopicAndPartition topicAndPartition$1;

                                    public final String apply() {
                                        return new StringOps(Predef$.MODULE$.augmentString("Broker is no longer the leader of %s, satisfy %s immediately")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicAndPartition$1, this.$outer.kafka$server$DelayedFetch$$anonfun$$$outer().fetch()}));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.topicAndPartition$1 = topicAndPartition$1;
                                    }
                                });
                                throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, true);
                            }
                            catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
                                this.$outer.debug((Function0<String>)new Serializable(this, topicAndPartition){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$isSatisfied$1 $outer;
                                    private final TopicAndPartition topicAndPartition$1;

                                    public final String apply() {
                                        return new StringOps(Predef$.MODULE$.augmentString("Broker no longer know of %s, satisfy %s immediately")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicAndPartition$1, this.$outer.kafka$server$DelayedFetch$$anonfun$$$outer().fetch()}));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.topicAndPartition$1 = topicAndPartition$1;
                                    }
                                });
                                throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, true);
                            }
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                        return;
                    }

                    public /* synthetic */ DelayedFetch kafka$server$DelayedFetch$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.replicaManager$1 = replicaManager$1;
                        this.accumulatedSize$1 = accumulatedSize$1;
                        this.fromFollower$1 = fromFollower$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                bl = accumulatedSize.elem >= this.fetch().minBytes();
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                bl = nonLocalReturnControl2.value$mcZ$sp();
            }
            return bl;
        }
        throw nonLocalReturnControl2;
    }

    public FetchResponse respond(ReplicaManager replicaManager) {
        Map<TopicAndPartition, PartitionDataAndOffset> topicData = replicaManager.readMessageSets(this.fetch());
        return new FetchResponse(this.fetch().correlationId(), (Map<TopicAndPartition, FetchResponsePartitionData>)topicData.mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final FetchResponsePartitionData apply(PartitionDataAndOffset x$1) {
                return x$1.data();
            }
        }));
    }

    public DelayedFetch(Seq<TopicAndPartition> keys, RequestChannel.Request request, long delayMs, FetchRequest fetch2, Map<TopicAndPartition, LogOffsetMetadata> partitionFetchOffsets) {
        this.delayMs = delayMs;
        this.fetch = fetch2;
        this.partitionFetchOffsets = partitionFetchOffsets;
        super(keys, request, delayMs);
    }
}

