/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import kafka.api.LeaderAndIsr;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.utils.Json$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import org.apache.zookeeper.data.Stat;
import scala.Function0;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ReplicationUtils$
implements Logging {
    public static final ReplicationUtils$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new ReplicationUtils$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ReplicationUtils$ replicationUtils$ = this;
        synchronized (replicationUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    @TraitSetter
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public Tuple2<Object, Object> updateLeaderAndIsr(ZkClient zkClient, String topic, int partitionId, LeaderAndIsr newLeaderAndIsr, int controllerEpoch, int zkVersion) {
        this.debug((Function0<String>)new Serializable(topic, partitionId, newLeaderAndIsr){
            public static final long serialVersionUID = 0L;
            private final String topic$1;
            private final int partitionId$1;
            private final LeaderAndIsr newLeaderAndIsr$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Updated ISR for partition [%s,%d] to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, BoxesRunTime.boxToInteger((int)this.partitionId$1), this.newLeaderAndIsr$1.isr().mkString(",")}));
            }
            {
                this.topic$1 = topic$1;
                this.partitionId$1 = partitionId$1;
                this.newLeaderAndIsr$1 = newLeaderAndIsr$1;
            }
        });
        String path = ZkUtils$.MODULE$.getTopicPartitionLeaderAndIsrPath(topic, partitionId);
        String newLeaderData = ZkUtils$.MODULE$.leaderAndIsrZkData(newLeaderAndIsr, controllerEpoch);
        return ZkUtils$.MODULE$.conditionalUpdatePersistentPath(zkClient, path, newLeaderData, zkVersion, (Option<Function3<ZkClient, String, String, Tuple2<Object, Object>>>)new Some((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(ZkClient zkClient, String path, String expectedLeaderAndIsrInfo) {
                return ReplicationUtils$.MODULE$.checkLeaderAndIsrZkData(zkClient, path, expectedLeaderAndIsrInfo);
            }
        }));
    }

    /*
     * Unable to fully structure code
     */
    public Tuple2<Object, Object> checkLeaderAndIsrZkData(ZkClient zkClient, String path, String expectedLeaderAndIsrInfo) {
        block6: {
            try {
                block7: {
                    writtenLeaderAndIsrInfo = ZkUtils$.MODULE$.readDataMaybeNull(zkClient, path);
                    writtenLeaderOpt = (Option)writtenLeaderAndIsrInfo._1();
                    writtenStat = (Stat)writtenLeaderAndIsrInfo._2();
                    expectedLeader = this.parseLeaderAndIsr(expectedLeaderAndIsrInfo, path, writtenStat);
                    var8_8 = writtenLeaderOpt;
                    if (!(var8_8 instanceof Some)) break block7;
                    var9_9 = (Some)var8_8;
                    writtenData = (String)var9_9.x();
                    writtenLeader = this.parseLeaderAndIsr(writtenData, path, writtenStat);
                    var12_12 = new Tuple2(expectedLeader, writtenLeader);
                    if (var12_12 == null) ** GOTO lbl-1000
                    var13_13 = (Option)var12_12._1();
                    var14_14 = (Option)var12_12._2();
                    if (!(var13_13 instanceof Some)) ** GOTO lbl-1000
                    var15_15 = (Some)var13_13;
                    expectedLeader = (LeaderIsrAndControllerEpoch)var15_15.x();
                    if (var14_14 instanceof Some) {
                        var17_17 = (Some)var14_14;
                        writtenLeader = (LeaderIsrAndControllerEpoch)var17_17.x();
                        v0 = expectedLeader;
                        var19_19 = writtenLeader;
                        if (!(v0 != null ? v0.equals(var19_19) == false : var19_19 != null)) {
                            return new Tuple2.mcZI.sp(true, writtenStat.getVersion());
                        }
                        var20_20 = BoxedUnit.UNIT;
                    } else lbl-1000:
                    // 3 sources

                    {
                        var20_21 = BoxedUnit.UNIT;
                    }
                    var21_22 = BoxedUnit.UNIT;
                    break block6;
                }
                v1 = None$.MODULE$;
                var22_24 = var8_8;
                if (!(v1 != null ? v1.equals(var22_24) == false : var22_24 != null)) {
                    var21_23 = BoxedUnit.UNIT;
                    break block6;
                }
                throw new MatchError((Object)var8_8);
            }
            catch (Exception var23_25) {
                // empty catch block
            }
        }
        return new Tuple2.mcZI.sp(false, -1);
    }

    public Option<LeaderIsrAndControllerEpoch> getLeaderIsrAndEpochForPartition(ZkClient zkClient, String topic, int partition) {
        Option option;
        block4: {
            Option<LeaderIsrAndControllerEpoch> option2;
            block3: {
                block2: {
                    String leaderAndIsrPath = ZkUtils$.MODULE$.getTopicPartitionLeaderAndIsrPath(topic, partition);
                    Tuple2<Option<String>, Stat> leaderAndIsrInfo = ZkUtils$.MODULE$.readDataMaybeNull(zkClient, leaderAndIsrPath);
                    Option leaderAndIsrOpt = (Option)leaderAndIsrInfo._1();
                    Stat stat = (Stat)leaderAndIsrInfo._2();
                    option = leaderAndIsrOpt;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String leaderAndIsrStr = (String)some.x();
                    option2 = this.parseLeaderAndIsr(leaderAndIsrStr, leaderAndIsrPath, stat);
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option3 = option;
                if (none$ != null ? !none$.equals(option3) : option3 != null) break block4;
                option2 = None$.MODULE$;
            }
            return option2;
        }
        throw new MatchError((Object)option);
    }

    private Option<LeaderIsrAndControllerEpoch> parseLeaderAndIsr(String leaderAndIsrStr, String path, Stat stat) {
        Option<Object> option;
        block4: {
            None$ none$;
            block3: {
                block2: {
                    option = Json$.MODULE$.parseFull(leaderAndIsrStr);
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Object m = some.x();
                    Map leaderIsrAndEpochInfo = (Map)m;
                    int leader = BoxesRunTime.unboxToInt((Object)leaderIsrAndEpochInfo.get((Object)"leader").get());
                    int epoch = BoxesRunTime.unboxToInt((Object)leaderIsrAndEpochInfo.get((Object)"leader_epoch").get());
                    List isr = (List)leaderIsrAndEpochInfo.get((Object)"isr").get();
                    int controllerEpoch = BoxesRunTime.unboxToInt((Object)leaderIsrAndEpochInfo.get((Object)"controller_epoch").get());
                    int zkPathVersion = stat.getVersion();
                    this.debug((Function0<String>)new Serializable(path, leader, epoch, isr, zkPathVersion){
                        public static final long serialVersionUID = 0L;
                        private final String path$1;
                        private final int leader$1;
                        private final int epoch$1;
                        private final List isr$1;
                        private final int zkPathVersion$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Leader %d, Epoch %d, Isr %s, Zk path version %d for leaderAndIsrPath %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.leader$1), BoxesRunTime.boxToInteger((int)this.epoch$1), this.isr$1.toString(), BoxesRunTime.boxToInteger((int)this.zkPathVersion$1), this.path$1}));
                        }
                        {
                            this.path$1 = path$1;
                            this.leader$1 = leader$1;
                            this.epoch$1 = epoch$1;
                            this.isr$1 = isr$1;
                            this.zkPathVersion$1 = zkPathVersion$1;
                        }
                    });
                    none$ = new Some((Object)new LeaderIsrAndControllerEpoch(new LeaderAndIsr(leader, epoch, (List<Object>)isr, zkPathVersion), controllerEpoch));
                    break block3;
                }
                None$ none$2 = None$.MODULE$;
                Option<Object> option2 = option;
                if (none$2 != null ? !none$2.equals(option2) : option2 != null) break block4;
                none$ = None$.MODULE$;
            }
            return none$;
        }
        throw new MatchError(option);
    }

    private ReplicationUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

