/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.nodelabels;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.nodelabels.FileSystemNodeLabelsStore;
import org.apache.hadoop.yarn.nodelabels.NodeLabelsStore;
import org.apache.hadoop.yarn.nodelabels.event.NodeLabelsStoreEvent;
import org.apache.hadoop.yarn.nodelabels.event.NodeLabelsStoreEventType;
import org.apache.hadoop.yarn.nodelabels.event.RemoveClusterNodeLabels;
import org.apache.hadoop.yarn.nodelabels.event.StoreNewClusterNodeLabels;
import org.apache.hadoop.yarn.nodelabels.event.UpdateNodeToLabelsMappingsEvent;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.spark_project.guava.collect.ImmutableSet;

public class CommonNodeLabelsManager
extends AbstractService {
    protected static final Log LOG = LogFactory.getLog(CommonNodeLabelsManager.class);
    private static final int MAX_LABEL_LENGTH = 255;
    public static final Set<String> EMPTY_STRING_SET = Collections.unmodifiableSet(new HashSet(0));
    public static final String ANY = "*";
    public static final Set<String> ACCESS_ANY_LABEL_SET = ImmutableSet.of((Object)"*");
    private static final Pattern LABEL_PATTERN = Pattern.compile("^[0-9a-zA-Z][0-9a-zA-Z-_]*");
    public static final int WILDCARD_PORT = 0;
    public static final String NO_LABEL = "";
    protected Dispatcher dispatcher;
    protected ConcurrentMap<String, Label> labelCollections = new ConcurrentHashMap<String, Label>();
    protected ConcurrentMap<String, Host> nodeCollections = new ConcurrentHashMap<String, Host>();
    protected final ReentrantReadWriteLock.ReadLock readLock;
    protected final ReentrantReadWriteLock.WriteLock writeLock;
    protected NodeLabelsStore store;

    protected void handleStoreEvent(NodeLabelsStoreEvent event) {
        try {
            switch ((NodeLabelsStoreEventType)((Object)event.getType())) {
                case ADD_LABELS: {
                    StoreNewClusterNodeLabels storeNewClusterNodeLabelsEvent = (StoreNewClusterNodeLabels)event;
                    this.store.storeNewClusterNodeLabels(storeNewClusterNodeLabelsEvent.getLabels());
                    break;
                }
                case REMOVE_LABELS: {
                    RemoveClusterNodeLabels removeClusterNodeLabelsEvent = (RemoveClusterNodeLabels)event;
                    this.store.removeClusterNodeLabels(removeClusterNodeLabelsEvent.getLabels());
                    break;
                }
                case STORE_NODE_TO_LABELS: {
                    UpdateNodeToLabelsMappingsEvent updateNodeToLabelsMappingsEvent = (UpdateNodeToLabelsMappingsEvent)event;
                    this.store.updateNodeToLabelsMappings(updateNodeToLabelsMappingsEvent.getNodeToLabels());
                }
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to store label modification to storage");
            throw new YarnRuntimeException(e);
        }
    }

    public CommonNodeLabelsManager() {
        super(CommonNodeLabelsManager.class.getName());
        ReentrantReadWriteLock lock2 = new ReentrantReadWriteLock();
        this.readLock = lock2.readLock();
        this.writeLock = lock2.writeLock();
    }

    protected void initDispatcher(Configuration conf) {
        this.dispatcher = new AsyncDispatcher();
        AsyncDispatcher asyncDispatcher = (AsyncDispatcher)this.dispatcher;
        asyncDispatcher.init(conf);
        asyncDispatcher.setDrainEventsOnStop();
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.initNodeLabelStore(conf);
        this.labelCollections.put(NO_LABEL, new Label());
    }

    protected void initNodeLabelStore(Configuration conf) throws Exception {
        this.store = new FileSystemNodeLabelsStore(this);
        this.store.init(conf);
        this.store.recover();
    }

    protected void startDispatcher() {
        AsyncDispatcher asyncDispatcher = (AsyncDispatcher)this.dispatcher;
        asyncDispatcher.start();
    }

    protected void serviceStart() throws Exception {
        this.initDispatcher(this.getConfig());
        if (null != this.dispatcher) {
            this.dispatcher.register(NodeLabelsStoreEventType.class, new ForwardingEventHandler());
        }
        this.startDispatcher();
    }

    protected void stopDispatcher() {
        AsyncDispatcher asyncDispatcher = (AsyncDispatcher)this.dispatcher;
        asyncDispatcher.stop();
    }

    protected void serviceStop() throws Exception {
        this.stopDispatcher();
        if (null != this.store) {
            this.store.close();
        }
    }

    public void addToCluserNodeLabels(Set<String> labels) throws IOException {
        if (null == labels || labels.isEmpty()) {
            return;
        }
        HashSet<String> newLabels = new HashSet<String>();
        labels = this.normalizeLabels(labels);
        for (String label : labels) {
            this.checkAndThrowLabelName(label);
        }
        for (String label : labels) {
            if (this.labelCollections.get(label) != null) continue;
            this.labelCollections.put(label, new Label());
            newLabels.add(label);
        }
        if (null != this.dispatcher && !newLabels.isEmpty()) {
            this.dispatcher.getEventHandler().handle(new StoreNewClusterNodeLabels((Set<String>)newLabels));
        }
        LOG.info((Object)("Add labels: [" + StringUtils.join(labels.iterator(), (String)",") + "]"));
    }

    protected void checkAddLabelsToNode(Map<NodeId, Set<String>> addedLabelsToNode) throws IOException {
        if (null == addedLabelsToNode || addedLabelsToNode.isEmpty()) {
            return;
        }
        Set knownLabels = this.labelCollections.keySet();
        for (Map.Entry<NodeId, Set<String>> entry2 : addedLabelsToNode.entrySet()) {
            NodeId nodeId = entry2.getKey();
            Set<String> labels = entry2.getValue();
            if (!knownLabels.containsAll(labels)) {
                String msg = "Not all labels being added contained by known label collections, please check, added labels=[" + StringUtils.join(labels, (String)",") + "]";
                LOG.error((Object)msg);
                throw new IOException(msg);
            }
            if (labels.isEmpty()) continue;
            HashSet<String> newLabels = new HashSet<String>(this.getLabelsByNode(nodeId));
            newLabels.addAll(labels);
            if (newLabels.size() <= 1) continue;
            String msg = String.format("%d labels specified on host=%s after add labels to node, please note that we do not support specifying multiple labels on a single host for now.", newLabels.size(), nodeId.getHost());
            LOG.error((Object)msg);
            throw new IOException(msg);
        }
    }

    protected void internalAddLabelsToNode(Map<NodeId, Set<String>> addedLabelsToNode) throws IOException {
        HashMap<NodeId, Set<String>> newNMToLabels = new HashMap<NodeId, Set<String>>();
        for (Map.Entry<NodeId, Set<String>> entry2 : addedLabelsToNode.entrySet()) {
            NodeId nodeId = entry2.getKey();
            Set<String> labels = entry2.getValue();
            this.createHostIfNonExisted(nodeId.getHost());
            if (nodeId.getPort() == 0) {
                Host host = (Host)this.nodeCollections.get(nodeId.getHost());
                host.labels.addAll(labels);
                newNMToLabels.put(nodeId, host.labels);
                continue;
            }
            this.createNodeIfNonExisted(nodeId);
            Node nm = this.getNMInNodeSet(nodeId);
            if (nm.labels == null) {
                nm.labels = new HashSet<String>();
            }
            nm.labels.addAll(labels);
            newNMToLabels.put(nodeId, nm.labels);
        }
        if (null != this.dispatcher) {
            this.dispatcher.getEventHandler().handle(new UpdateNodeToLabelsMappingsEvent((Map<NodeId, Set<String>>)newNMToLabels));
        }
        LOG.info((Object)"addLabelsToNode:");
        for (Map.Entry<NodeId, Set<String>> entry3 : newNMToLabels.entrySet()) {
            LOG.info((Object)("  NM=" + entry3.getKey() + ", labels=[" + StringUtils.join(entry3.getValue().iterator(), (String)",") + "]"));
        }
    }

    public void addLabelsToNode(Map<NodeId, Set<String>> addedLabelsToNode) throws IOException {
        addedLabelsToNode = this.normalizeNodeIdToLabels(addedLabelsToNode);
        this.checkAddLabelsToNode(addedLabelsToNode);
        this.internalAddLabelsToNode(addedLabelsToNode);
    }

    protected void checkRemoveFromClusterNodeLabels(Collection<String> labelsToRemove) throws IOException {
        if (null == labelsToRemove || labelsToRemove.isEmpty()) {
            return;
        }
        for (String label : labelsToRemove) {
            if ((label = this.normalizeLabel(label)) == null || label.isEmpty()) {
                throw new IOException("Label to be removed is null or empty");
            }
            if (this.labelCollections.containsKey(label)) continue;
            throw new IOException("Node label=" + label + " to be removed doesn't existed in cluster " + "node labels collection.");
        }
    }

    protected void internalRemoveFromClusterNodeLabels(Collection<String> labelsToRemove) {
        for (String nodeName : this.nodeCollections.keySet()) {
            Host host = (Host)this.nodeCollections.get(nodeName);
            if (null == host) continue;
            host.labels.removeAll(labelsToRemove);
            for (Node nm : host.nms.values()) {
                if (nm.labels == null) continue;
                nm.labels.removeAll(labelsToRemove);
            }
        }
        for (String label : labelsToRemove) {
            this.labelCollections.remove(label);
        }
        if (null != this.dispatcher) {
            this.dispatcher.getEventHandler().handle(new RemoveClusterNodeLabels(labelsToRemove));
        }
        LOG.info((Object)("Remove labels: [" + StringUtils.join(labelsToRemove.iterator(), (String)",") + "]"));
    }

    public void removeFromClusterNodeLabels(Collection<String> labelsToRemove) throws IOException {
        labelsToRemove = this.normalizeLabels(labelsToRemove);
        this.checkRemoveFromClusterNodeLabels(labelsToRemove);
        this.internalRemoveFromClusterNodeLabels(labelsToRemove);
    }

    protected void checkRemoveLabelsFromNode(Map<NodeId, Set<String>> removeLabelsFromNode) throws IOException {
        Set knownLabels = this.labelCollections.keySet();
        for (Map.Entry<NodeId, Set<String>> entry2 : removeLabelsFromNode.entrySet()) {
            String msg;
            NodeId nodeId = entry2.getKey();
            Set<String> labels = entry2.getValue();
            if (!knownLabels.containsAll(labels)) {
                String msg2 = "Not all labels being removed contained by known label collections, please check, removed labels=[" + StringUtils.join(labels, (String)",") + "]";
                LOG.error((Object)msg2);
                throw new IOException(msg2);
            }
            Set<String> originalLabels = null;
            boolean nodeExisted = false;
            if (0 != nodeId.getPort()) {
                Node nm = this.getNMInNodeSet(nodeId);
                if (nm != null) {
                    originalLabels = nm.labels;
                    nodeExisted = true;
                }
            } else {
                Host host = (Host)this.nodeCollections.get(nodeId.getHost());
                if (null != host) {
                    originalLabels = host.labels;
                    nodeExisted = true;
                }
            }
            if (!nodeExisted) {
                msg = "Try to remove labels from NM=" + nodeId + ", but the NM doesn't existed";
                LOG.error((Object)msg);
                throw new IOException(msg);
            }
            if (labels.isEmpty() || originalLabels != null && originalLabels.containsAll(labels)) continue;
            msg = "Try to remove labels = [" + StringUtils.join(labels, (String)",") + "], but not all labels contained by NM=" + nodeId;
            LOG.error((Object)msg);
            throw new IOException(msg);
        }
    }

    protected void internalRemoveLabelsFromNode(Map<NodeId, Set<String>> removeLabelsFromNode) {
        HashMap<NodeId, Set<String>> newNMToLabels = new HashMap<NodeId, Set<String>>();
        for (Map.Entry<NodeId, Set<String>> entry2 : removeLabelsFromNode.entrySet()) {
            NodeId nodeId = entry2.getKey();
            Set<String> labels = entry2.getValue();
            if (nodeId.getPort() == 0) {
                Host host = (Host)this.nodeCollections.get(nodeId.getHost());
                host.labels.removeAll(labels);
                newNMToLabels.put(nodeId, host.labels);
                continue;
            }
            Node nm = this.getNMInNodeSet(nodeId);
            if (nm.labels == null) continue;
            nm.labels.removeAll(labels);
            newNMToLabels.put(nodeId, nm.labels);
        }
        if (null != this.dispatcher) {
            this.dispatcher.getEventHandler().handle(new UpdateNodeToLabelsMappingsEvent((Map<NodeId, Set<String>>)newNMToLabels));
        }
        LOG.info((Object)"removeLabelsFromNode:");
        for (Map.Entry<NodeId, Set<String>> entry3 : newNMToLabels.entrySet()) {
            LOG.info((Object)("  NM=" + entry3.getKey() + ", labels=[" + StringUtils.join(entry3.getValue().iterator(), (String)",") + "]"));
        }
    }

    public void removeLabelsFromNode(Map<NodeId, Set<String>> removeLabelsFromNode) throws IOException {
        removeLabelsFromNode = this.normalizeNodeIdToLabels(removeLabelsFromNode);
        this.checkRemoveLabelsFromNode(removeLabelsFromNode);
        this.internalRemoveLabelsFromNode(removeLabelsFromNode);
    }

    protected void checkReplaceLabelsOnNode(Map<NodeId, Set<String>> replaceLabelsToNode) throws IOException {
        if (null == replaceLabelsToNode || replaceLabelsToNode.isEmpty()) {
            return;
        }
        Set knownLabels = this.labelCollections.keySet();
        for (Map.Entry<NodeId, Set<String>> entry2 : replaceLabelsToNode.entrySet()) {
            NodeId nodeId = entry2.getKey();
            Set<String> labels = entry2.getValue();
            if (labels.size() > 1) {
                String msg = String.format("%d labels specified on host=%s, please note that we do not support specifying multiple labels on a single host for now.", labels.size(), nodeId.getHost());
                LOG.error((Object)msg);
                throw new IOException(msg);
            }
            if (knownLabels.containsAll(labels)) continue;
            String msg = "Not all labels being replaced contained by known label collections, please check, new labels=[" + StringUtils.join(labels, (String)",") + "]";
            LOG.error((Object)msg);
            throw new IOException(msg);
        }
    }

    protected void internalReplaceLabelsOnNode(Map<NodeId, Set<String>> replaceLabelsToNode) throws IOException {
        HashMap<NodeId, Set<String>> newNMToLabels = new HashMap<NodeId, Set<String>>();
        for (Map.Entry<NodeId, Set<String>> entry2 : replaceLabelsToNode.entrySet()) {
            NodeId nodeId = entry2.getKey();
            Set<String> labels = entry2.getValue();
            this.createHostIfNonExisted(nodeId.getHost());
            if (nodeId.getPort() == 0) {
                Host host = (Host)this.nodeCollections.get(nodeId.getHost());
                host.labels.clear();
                host.labels.addAll(labels);
                newNMToLabels.put(nodeId, host.labels);
                continue;
            }
            this.createNodeIfNonExisted(nodeId);
            Node nm = this.getNMInNodeSet(nodeId);
            if (nm.labels == null) {
                nm.labels = new HashSet<String>();
            }
            nm.labels.clear();
            nm.labels.addAll(labels);
            newNMToLabels.put(nodeId, nm.labels);
        }
        if (null != this.dispatcher) {
            this.dispatcher.getEventHandler().handle(new UpdateNodeToLabelsMappingsEvent((Map<NodeId, Set<String>>)newNMToLabels));
        }
        LOG.info((Object)"setLabelsToNode:");
        for (Map.Entry<NodeId, Set<String>> entry3 : newNMToLabels.entrySet()) {
            LOG.info((Object)("  NM=" + entry3.getKey() + ", labels=[" + StringUtils.join(entry3.getValue().iterator(), (String)",") + "]"));
        }
    }

    public void replaceLabelsOnNode(Map<NodeId, Set<String>> replaceLabelsToNode) throws IOException {
        replaceLabelsToNode = this.normalizeNodeIdToLabels(replaceLabelsToNode);
        this.checkReplaceLabelsOnNode(replaceLabelsToNode);
        this.internalReplaceLabelsOnNode(replaceLabelsToNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<NodeId, Set<String>> getNodeLabels() {
        try {
            this.readLock.lock();
            HashMap<NodeId, Set<String>> nodeToLabels = new HashMap<NodeId, Set<String>>();
            for (Map.Entry entry2 : this.nodeCollections.entrySet()) {
                String hostName = (String)entry2.getKey();
                Host host = (Host)entry2.getValue();
                for (NodeId nodeId : host.nms.keySet()) {
                    Set<String> nodeLabels = this.getLabelsByNode(nodeId);
                    if (nodeLabels == null || nodeLabels.isEmpty()) continue;
                    nodeToLabels.put(nodeId, nodeLabels);
                }
                if (host.labels.isEmpty()) continue;
                nodeToLabels.put(NodeId.newInstance(hostName, 0), host.labels);
            }
            Map<NodeId, Set<String>> map = Collections.unmodifiableMap(nodeToLabels);
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getClusterNodeLabels() {
        try {
            this.readLock.lock();
            HashSet labels = new HashSet(this.labelCollections.keySet());
            labels.remove(NO_LABEL);
            Set<String> set = Collections.unmodifiableSet(labels);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void checkAndThrowLabelName(String label) throws IOException {
        if (label == null || label.isEmpty() || label.length() > 255) {
            throw new IOException("label added is empty or exceeds 255 character(s)");
        }
        boolean match = LABEL_PATTERN.matcher(label = label.trim()).matches();
        if (!match) {
            throw new IOException("label name should only contains {0-9, a-z, A-Z, -, _} and should not started with {-,_}, now it is=" + label);
        }
    }

    protected String normalizeLabel(String label) {
        if (label != null) {
            return label.trim();
        }
        return NO_LABEL;
    }

    private Set<String> normalizeLabels(Collection<String> labels) {
        HashSet<String> newLabels = new HashSet<String>();
        for (String label : labels) {
            newLabels.add(this.normalizeLabel(label));
        }
        return newLabels;
    }

    protected Node getNMInNodeSet(NodeId nodeId) {
        return this.getNMInNodeSet(nodeId, this.nodeCollections);
    }

    protected Node getNMInNodeSet(NodeId nodeId, Map<String, Host> map) {
        return this.getNMInNodeSet(nodeId, map, false);
    }

    protected Node getNMInNodeSet(NodeId nodeId, Map<String, Host> map, boolean checkRunning) {
        Host host = map.get(nodeId.getHost());
        if (null == host) {
            return null;
        }
        Node nm = host.nms.get(nodeId);
        if (null == nm) {
            return null;
        }
        if (checkRunning) {
            return nm.running ? nm : null;
        }
        return nm;
    }

    protected Set<String> getLabelsByNode(NodeId nodeId) {
        return this.getLabelsByNode(nodeId, this.nodeCollections);
    }

    protected Set<String> getLabelsByNode(NodeId nodeId, Map<String, Host> map) {
        Host host = map.get(nodeId.getHost());
        if (null == host) {
            return EMPTY_STRING_SET;
        }
        Node nm = host.nms.get(nodeId);
        if (null != nm && null != nm.labels) {
            return nm.labels;
        }
        return host.labels;
    }

    protected void createNodeIfNonExisted(NodeId nodeId) throws IOException {
        Host host = (Host)this.nodeCollections.get(nodeId.getHost());
        if (null == host) {
            throw new IOException("Should create host before creating node.");
        }
        Node nm = host.nms.get(nodeId);
        if (null == nm) {
            host.nms.put(nodeId, new Node());
        }
    }

    protected void createHostIfNonExisted(String hostName) {
        Host host = (Host)this.nodeCollections.get(hostName);
        if (null == host) {
            host = new Host();
            this.nodeCollections.put(hostName, host);
        }
    }

    protected Map<NodeId, Set<String>> normalizeNodeIdToLabels(Map<NodeId, Set<String>> nodeIdToLabels) {
        HashMap<NodeId, Set<String>> newMap = new HashMap<NodeId, Set<String>>();
        for (Map.Entry<NodeId, Set<String>> entry2 : nodeIdToLabels.entrySet()) {
            NodeId id = entry2.getKey();
            Set<String> labels = entry2.getValue();
            newMap.put(id, this.normalizeLabels(labels));
        }
        return newMap;
    }

    private final class ForwardingEventHandler
    implements EventHandler<NodeLabelsStoreEvent> {
        private ForwardingEventHandler() {
        }

        @Override
        public void handle(NodeLabelsStoreEvent event) {
            CommonNodeLabelsManager.this.handleStoreEvent(event);
        }
    }

    protected static class Node {
        public Set<String> labels = null;
        public Resource resource = Resource.newInstance(0, 0);
        public boolean running = false;

        protected Node() {
        }

        public Node copy() {
            Node c = new Node();
            if (this.labels != null) {
                c.labels = Collections.newSetFromMap(new ConcurrentHashMap());
                c.labels.addAll(this.labels);
            } else {
                c.labels = null;
            }
            c.resource = Resources.clone(this.resource);
            c.running = this.running;
            return c;
        }
    }

    protected static class Host {
        public Set<String> labels = Collections.newSetFromMap(new ConcurrentHashMap());
        public Map<NodeId, Node> nms = new ConcurrentHashMap<NodeId, Node>();

        protected Host() {
        }

        public Host copy() {
            Host c = new Host();
            c.labels = new HashSet<String>(this.labels);
            for (Map.Entry<NodeId, Node> entry2 : this.nms.entrySet()) {
                c.nms.put(entry2.getKey(), entry2.getValue().copy());
            }
            return c;
        }
    }

    protected static class Label {
        public Resource resource = Resource.newInstance(0, 0);

        protected Label() {
        }
    }
}

