/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer.internals;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.internals.FutureRecordMetadata;
import org.apache.kafka.clients.producer.internals.ProduceRequestResult;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RecordBatch {
    private static final Logger log = LoggerFactory.getLogger(RecordBatch.class);
    public int recordCount = 0;
    public int maxRecordSize = 0;
    public volatile int attempts = 0;
    public final long createdMs;
    public long drainedMs;
    public long lastAttemptMs;
    public final MemoryRecords records;
    public final TopicPartition topicPartition;
    private final ProduceRequestResult produceFuture;
    private final List<Thunk> thunks;

    public RecordBatch(TopicPartition tp, MemoryRecords records, long now) {
        this.createdMs = now;
        this.lastAttemptMs = now;
        this.records = records;
        this.topicPartition = tp;
        this.produceFuture = new ProduceRequestResult();
        this.thunks = new ArrayList<Thunk>();
    }

    public FutureRecordMetadata tryAppend(byte[] key, byte[] value2, Callback callback) {
        if (!this.records.hasRoomFor(key, value2)) {
            return null;
        }
        this.records.append(0L, key, value2);
        this.maxRecordSize = Math.max(this.maxRecordSize, Record.recordSize(key, value2));
        FutureRecordMetadata future = new FutureRecordMetadata(this.produceFuture, this.recordCount);
        if (callback != null) {
            this.thunks.add(new Thunk(callback, future));
        }
        ++this.recordCount;
        return future;
    }

    public void done(long baseOffset, RuntimeException exception) {
        this.produceFuture.done(this.topicPartition, baseOffset, exception);
        log.trace("Produced messages to topic-partition {} with base offset offset {} and error: {}.", new Object[]{this.topicPartition, baseOffset, exception});
        for (int i = 0; i < this.thunks.size(); ++i) {
            try {
                Thunk thunk = this.thunks.get(i);
                if (exception == null) {
                    thunk.callback.onCompletion(thunk.future.get(), null);
                    continue;
                }
                thunk.callback.onCompletion(null, exception);
                continue;
            }
            catch (Exception e) {
                log.error("Error executing user-provided callback on message for topic-partition {}:", (Object)this.topicPartition, (Object)e);
            }
        }
    }

    public String toString() {
        return "RecordBatch(topicPartition=" + this.topicPartition + ", recordCount=" + this.recordCount + ")";
    }

    private static final class Thunk {
        final Callback callback;
        final FutureRecordMetadata future;

        public Thunk(Callback callback, FutureRecordMetadata future) {
            this.callback = callback;
            this.future = future;
        }
    }
}

