/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.servlet;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class UserAgentFilter
implements Filter {
    private Pattern _pattern;
    private Map _agentCache = new HashMap();
    private int _agentCacheSize = 1024;
    private String _attribute;

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this._attribute != null && this._pattern != null) {
            String ua = this.getUserAgent(request);
            request.setAttribute(this._attribute, (Object)ua);
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String size2;
        this._attribute = filterConfig.getInitParameter("attribute");
        String p = filterConfig.getInitParameter("userAgent");
        if (p != null) {
            this._pattern = Pattern.compile(p);
        }
        if ((size2 = filterConfig.getInitParameter("cacheSize")) != null) {
            this._agentCacheSize = Integer.parseInt(size2);
        }
    }

    public String getUserAgent(ServletRequest request) {
        String ua = ((HttpServletRequest)request).getHeader("User-Agent");
        return this.getUserAgent(ua);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserAgent(String ua) {
        String tag;
        if (ua == null) {
            return null;
        }
        Map map = this._agentCache;
        synchronized (map) {
            tag = (String)this._agentCache.get(ua);
        }
        if (tag == null) {
            Matcher matcher = this._pattern.matcher(ua);
            if (matcher.matches()) {
                if (matcher.groupCount() > 0) {
                    for (int g = 1; g <= matcher.groupCount(); ++g) {
                        String group = matcher.group(g);
                        if (group == null) continue;
                        tag = tag == null ? group : tag + group;
                    }
                } else {
                    tag = matcher.group();
                }
            } else {
                tag = ua;
            }
            Map map2 = this._agentCache;
            synchronized (map2) {
                if (this._agentCache.size() >= this._agentCacheSize) {
                    this._agentCache.clear();
                }
                this._agentCache.put(ua, tag);
            }
        }
        return tag;
    }
}

