/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer.internals;

import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorLoggingCallback
implements Callback {
    private static final Logger log = LoggerFactory.getLogger(ErrorLoggingCallback.class);
    private String topic;
    private byte[] key;
    private byte[] value;
    private boolean logAsString;

    public ErrorLoggingCallback(String topic, byte[] key, byte[] value2, boolean logAsString) {
        this.topic = topic;
        this.key = key;
        this.value = value2;
        this.logAsString = logAsString;
    }

    @Override
    public void onCompletion(RecordMetadata metadata, Exception e) {
        if (e != null) {
            String keyString;
            String string = this.key == null ? "null" : (keyString = this.logAsString ? new String(this.key) : this.key.length + " bytes");
            String valueString = this.value == null ? "null" : (this.logAsString ? new String(this.value) : this.value.length + " bytes");
            log.error("Error when sending message to topic {} with key: {}, value: {} with error: {}", new Object[]{this.topic, keyString, valueString, e.getMessage()});
        }
    }
}

